/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.mapping.providers.role;

import java.io.IOException;
import java.security.Principal;
import java.util.Map;
import java.util.Properties;
import org.jboss.security.PicketBoxMessages;
import org.jboss.security.identity.RoleGroup;
import org.jboss.security.mapping.providers.role.AbstractRolesMappingProvider;
import org.jboss.security.mapping.providers.role.Util;
import org.jboss.security.util.StringPropertyReplacer;

public class PropertiesRolesMappingProvider
extends AbstractRolesMappingProvider {
    protected String rolesRsrcName = "roles.properties";
    protected Properties roles;

    public void init(Map<String, Object> options) {
        if (options != null) {
            String option = (String)options.get("rolesProperties");
            if (option != null) {
                this.rolesRsrcName = StringPropertyReplacer.replaceProperties(option);
            }
            try {
                this.roles = this.loadRoles();
            }
            catch (IOException ioe) {
                throw new IllegalStateException(ioe);
            }
        }
    }

    public void performMapping(Map<String, Object> contextMap, RoleGroup mappedObject) {
        if (contextMap == null || contextMap.isEmpty()) {
            throw PicketBoxMessages.MESSAGES.invalidNullArgument("contextMap");
        }
        Principal principal = this.getCallerPrincipal(contextMap);
        if (principal != null) {
            String username = principal.getName();
            Util.addRolesToGroup(username, mappedObject, this.roles);
            this.result.setMappedObject((Object)mappedObject);
        }
    }

    protected Properties loadRoles() throws IOException {
        return Util.loadProperties(this.rolesRsrcName);
    }
}

