/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.authorization.modules.ejb;

import java.lang.reflect.Method;
import java.security.Principal;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import org.jboss.security.PicketBoxLogger;
import org.jboss.security.PicketBoxMessages;
import org.jboss.security.RunAs;
import org.jboss.security.RunAsIdentity;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.authorization.PolicyRegistration;
import org.jboss.security.authorization.Resource;
import org.jboss.security.authorization.modules.AuthorizationModuleDelegate;
import org.jboss.security.authorization.resources.EJBResource;
import org.jboss.security.identity.Role;
import org.jboss.security.identity.RoleGroup;
import org.jboss.security.identity.plugins.SimpleRole;
import org.jboss.security.identity.plugins.SimpleRoleGroup;
import org.jboss.security.javaee.SecurityRoleRef;

public class EJBPolicyModuleDelegate
extends AuthorizationModuleDelegate {
    protected String ejbName = null;
    protected Method ejbMethod = null;
    protected Principal ejbPrincipal = null;
    private RoleGroup methodRoles = null;
    private String methodInterface = null;
    protected RunAs callerRunAs = null;
    protected String roleName = null;
    private Boolean roleRefCheck = Boolean.FALSE;
    protected Set<SecurityRoleRef> securityRoleReferences = null;
    private final Role ANYBODY_ROLE = new SimpleRole("<ANYBODY>");
    private final Role STAR_ROLE = new SimpleRole("**");
    private final Principal UNAUTHENTICATED_PRINCIPAL = new SimplePrincipal("anonymous");
    protected boolean ejbRestrictions = false;

    public int authorize(Resource resource, Subject callerSubject, RoleGroup role) {
        if (!(resource instanceof EJBResource)) {
            throw PicketBoxMessages.MESSAGES.invalidType(EJBResource.class.getName());
        }
        EJBResource ejbResource = (EJBResource)resource;
        Map map = resource.getMap();
        if (map == null) {
            throw PicketBoxMessages.MESSAGES.invalidNullProperty("resourceMap");
        }
        this.policyRegistration = (PolicyRegistration)map.get("policyRegistration");
        this.roleName = (String)map.get("roleName");
        this.roleRefCheck = (Boolean)map.get("roleRefPermissionCheck");
        this.callerRunAs = ejbResource.getCallerRunAsIdentity();
        this.ejbMethod = ejbResource.getEjbMethod();
        this.ejbName = ejbResource.getEjbName();
        this.ejbPrincipal = ejbResource.getPrincipal();
        this.methodInterface = ejbResource.getEjbMethodInterface();
        this.methodRoles = ejbResource.getEjbMethodRoles();
        this.securityRoleReferences = ejbResource.getSecurityRoleReferences();
        this.ejbRestrictions = ejbResource.isEnforceEJBRestrictions();
        if (this.roleRefCheck == Boolean.TRUE) {
            return this.checkRoleRef(role);
        }
        return this.process(role);
    }

    private int process(RoleGroup principalRole) {
        boolean allowed = true;
        if (this.ejbMethod == null) {
            throw PicketBoxMessages.MESSAGES.invalidNullProperty("ejbMethod");
        }
        if (this.methodRoles == null) {
            String method = this.ejbMethod.getName();
            PicketBoxLogger.LOGGER.traceNoMethodPermissions(method, this.methodInterface);
            return -1;
        }
        PicketBoxLogger.LOGGER.debugEJBPolicyModuleDelegateState(this.ejbMethod.getName(), this.methodInterface, this.methodRoles.toString());
        if (!this.methodRoles.containsAll(this.ANYBODY_ROLE)) {
            if (this.callerRunAs == null) {
                if (this.ejbPrincipal != null && !this.ejbPrincipal.equals(this.UNAUTHENTICATED_PRINCIPAL)) {
                    if (principalRole == null) {
                        principalRole = new SimpleRoleGroup(this.STAR_ROLE.getRoleName());
                    } else {
                        principalRole.addRole(this.STAR_ROLE);
                    }
                }
                if (principalRole == null) {
                    throw PicketBoxMessages.MESSAGES.invalidNullProperty("principalRole");
                }
                if (!this.methodRoles.containsAtleastOneRole(principalRole)) {
                    String method = this.ejbMethod.getName();
                    PicketBoxLogger.LOGGER.debugInsufficientMethodPermissions(this.ejbPrincipal, this.ejbName, method, this.methodInterface, this.methodRoles.toString(), principalRole.toString(), null);
                    allowed = false;
                }
            } else if (this.callerRunAs instanceof RunAsIdentity) {
                RunAsIdentity callerRunAsIdentity = (RunAsIdentity)this.callerRunAs;
                SimpleRoleGroup srg = new SimpleRoleGroup(callerRunAsIdentity.getRunAsRoles());
                srg.addRole(this.STAR_ROLE);
                if (!srg.containsAtleastOneRole(this.methodRoles)) {
                    String method = this.ejbMethod.getName();
                    PicketBoxLogger.LOGGER.debugInsufficientMethodPermissions(this.ejbPrincipal, this.ejbName, method, this.methodInterface, this.methodRoles.toString(), null, callerRunAsIdentity.getRunAsRoles().toString());
                    allowed = false;
                }
            }
        }
        return allowed ? 1 : -1;
    }

    protected int checkRoleRef(RoleGroup principalRole) {
        if (this.ejbPrincipal == null && this.callerRunAs == null) {
            return -1;
        }
        boolean matchFound = false;
        for (SecurityRoleRef meta : this.securityRoleReferences) {
            if (!meta.getName().equals(this.roleName)) continue;
            this.roleName = meta.getLink();
            matchFound = true;
            break;
        }
        if (!matchFound && this.ejbRestrictions) {
            throw PicketBoxMessages.MESSAGES.noMatchingRoleFoundInDescriptor(this.roleName);
        }
        SimpleRole deploymentrole = new SimpleRole(this.roleName);
        boolean allowed = false;
        if (this.callerRunAs == null) {
            allowed = principalRole.containsRole((Role)deploymentrole);
        } else if (this.callerRunAs instanceof RunAsIdentity) {
            RunAsIdentity callerRunAsIdentity = (RunAsIdentity)this.callerRunAs;
            SimpleRoleGroup srg = new SimpleRoleGroup(callerRunAsIdentity.getRunAsRoles());
            allowed = srg.containsRole(deploymentrole);
        }
        return allowed ? 1 : -1;
    }
}

