/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.spi;

import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Principal;
import java.security.acl.Group;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import org.jboss.security.JSSESecurityDomain;
import org.jboss.security.PicketBoxLogger;
import org.jboss.security.PicketBoxMessages;
import org.jboss.security.SecurityDomain;
import org.jboss.security.SecurityUtil;
import org.jboss.security.auth.callback.ObjectCallback;
import org.jboss.security.auth.certs.X509CertificateVerifier;
import org.jboss.security.auth.spi.AbstractServerLoginModule;
import org.jboss.security.auth.spi.SecurityActions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseCertLoginModule
extends AbstractServerLoginModule {
    private static final String SECURITY_DOMAIN = "securityDomain";
    private static final String VERIFIER = "verifier";
    private static final String[] ALL_VALID_OPTIONS = new String[]{"securityDomain", "verifier"};
    private Principal identity;
    private X509Certificate credential;
    private Object domain = null;
    private X509CertificateVerifier verifier;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.addValidOptions(ALL_VALID_OPTIONS);
        super.initialize(subject, callbackHandler, sharedState, options);
        String sd = (String)options.get(SECURITY_DOMAIN);
        sd = SecurityUtil.unprefixSecurityDomain(sd);
        if (sd == null) {
            sd = "other";
        }
        try {
            Object tempDomain = new InitialContext().lookup("java:jboss/jaas/" + sd);
            if (tempDomain instanceof SecurityDomain) {
                this.domain = tempDomain;
                PicketBoxLogger.LOGGER.traceSecurityDomainFound(this.domain.getClass().getName());
            } else {
                tempDomain = new InitialContext().lookup("java:jboss/jaas/" + sd + "/jsse");
                if (tempDomain instanceof JSSESecurityDomain) {
                    this.domain = tempDomain;
                    PicketBoxLogger.LOGGER.traceSecurityDomainFound(this.domain.getClass().getName());
                } else {
                    PicketBoxLogger.LOGGER.errorGettingJSSESecurityDomain(sd);
                }
            }
        }
        catch (NamingException e) {
            PicketBoxLogger.LOGGER.errorFindingSecurityDomain(sd, (Throwable)e);
        }
        String option = (String)options.get(VERIFIER);
        if (option != null) {
            try {
                ClassLoader loader = SecurityActions.getContextClassLoader();
                Class<?> verifierClass = loader.loadClass(option);
                this.verifier = (X509CertificateVerifier)verifierClass.newInstance();
            }
            catch (Throwable e) {
                PicketBoxLogger.LOGGER.errorCreatingCertificateVerifier(e);
            }
        }
        PicketBoxLogger.LOGGER.traceEndInitialize();
    }

    @Override
    public boolean login() throws LoginException {
        PicketBoxLogger.LOGGER.traceBeginLogin();
        if (super.login()) {
            Object username = this.sharedState.get("javax.security.auth.login.name");
            if (username instanceof Principal) {
                this.identity = (Principal)username;
            } else {
                String name = username.toString();
                try {
                    this.identity = this.createIdentity(name);
                }
                catch (Exception e) {
                    throw PicketBoxMessages.MESSAGES.failedToCreatePrincipal(e.getLocalizedMessage());
                }
            }
            Object password = this.sharedState.get("javax.security.auth.login.password");
            if (password instanceof X509Certificate) {
                this.credential = (X509Certificate)password;
            } else if (password != null) {
                PicketBoxLogger.LOGGER.debugPasswordNotACertificate();
                this.loginOk = false;
                return false;
            }
            return true;
        }
        this.loginOk = false;
        Object[] info = this.getAliasAndCert();
        String alias = (String)info[0];
        this.credential = (X509Certificate)info[1];
        if (alias == null && this.credential == null) {
            this.identity = this.unauthenticatedIdentity;
            PicketBoxLogger.LOGGER.traceUsingUnauthIdentity(this.identity.toString());
        }
        if (this.identity == null) {
            try {
                this.identity = this.createIdentity(alias);
            }
            catch (Exception e) {
                PicketBoxLogger.LOGGER.debugFailureToCreateIdentityForAlias(alias, (Throwable)e);
            }
            if (!this.validateCredential(alias, this.credential)) {
                throw PicketBoxMessages.MESSAGES.failedToMatchCredential(alias);
            }
        }
        if (this.getUseFirstPass()) {
            this.sharedState.put("javax.security.auth.login.name", alias);
            this.sharedState.put("javax.security.auth.login.password", this.credential);
        }
        this.loginOk = true;
        PicketBoxLogger.LOGGER.traceEndLogin(this.loginOk);
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        boolean ok = super.commit();
        if (ok && this.credential != null) {
            this.subject.getPublicCredentials().add(this.credential);
        }
        return ok;
    }

    @Override
    protected Group[] getRoleSets() throws LoginException {
        return new Group[0];
    }

    @Override
    protected Principal getIdentity() {
        return this.identity;
    }

    protected Object getCredentials() {
        return this.credential;
    }

    protected String getUsername() {
        String username = null;
        if (this.getIdentity() != null) {
            username = this.getIdentity().getName();
        }
        return username;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object[] getAliasAndCert() throws LoginException {
        PicketBoxLogger.LOGGER.traceBeginGetAliasAndCert();
        Object[] info = new Object[]{null, null};
        if (this.callbackHandler == null) {
            throw PicketBoxMessages.MESSAGES.noCallbackHandlerAvailable();
        }
        NameCallback nc = new NameCallback("Alias: ");
        ObjectCallback oc = new ObjectCallback("Certificate: ");
        Callback[] callbacks = new Callback[]{nc, oc};
        String alias = null;
        X509Certificate cert = null;
        try {
            this.callbackHandler.handle(callbacks);
            alias = nc.getName();
            Object tmpCert = oc.getCredential();
            if (tmpCert != null) {
                if (tmpCert instanceof X509Certificate) {
                    cert = (X509Certificate)tmpCert;
                    PicketBoxLogger.LOGGER.traceCertificateFound(cert.getSerialNumber().toString(16), cert.getSubjectDN().getName());
                } else {
                    if (!(tmpCert instanceof X509Certificate[])) throw PicketBoxMessages.MESSAGES.unableToGetCertificateFromClass(tmpCert != null ? tmpCert.getClass() : null);
                    X509Certificate[] certChain = (X509Certificate[])tmpCert;
                    if (certChain.length > 0) {
                        cert = certChain[0];
                    }
                }
            } else {
                PicketBoxLogger.LOGGER.warnNullCredentialFromCallbackHandler();
            }
        }
        catch (IOException e) {
            LoginException le = PicketBoxMessages.MESSAGES.failedToInvokeCallbackHandler();
            le.initCause(e);
            throw le;
        }
        catch (UnsupportedCallbackException uce) {
            LoginException le = new LoginException();
            le.initCause(uce);
            throw le;
        }
        info[0] = alias;
        info[1] = cert;
        PicketBoxLogger.LOGGER.traceEndGetAliasAndCert();
        return info;
    }

    protected boolean validateCredential(String alias, X509Certificate cert) {
        PicketBoxLogger.LOGGER.traceBeginValidateCredential();
        boolean isValid = false;
        KeyStore keyStore = null;
        KeyStore trustStore = null;
        if (this.domain != null) {
            if (this.domain instanceof SecurityDomain) {
                keyStore = ((SecurityDomain)this.domain).getKeyStore();
                trustStore = ((SecurityDomain)this.domain).getTrustStore();
            } else if (this.domain instanceof JSSESecurityDomain) {
                keyStore = ((JSSESecurityDomain)this.domain).getKeyStore();
                trustStore = ((JSSESecurityDomain)this.domain).getTrustStore();
            }
        }
        if (trustStore == null) {
            trustStore = keyStore;
        }
        if (this.verifier != null) {
            PicketBoxLogger.LOGGER.traceValidatingUsingVerifier(this.verifier.getClass());
            isValid = this.verifier.verify(cert, alias, keyStore, trustStore);
        } else if (trustStore != null && cert != null) {
            X509Certificate storeCert = null;
            try {
                storeCert = (X509Certificate)trustStore.getCertificate(alias);
                if (PicketBoxLogger.LOGGER.isTraceEnabled()) {
                    StringBuffer buf = new StringBuffer("\n\t");
                    buf.append(PicketBoxMessages.MESSAGES.suppliedCredentialMessage());
                    buf.append(cert.getSerialNumber().toString(16));
                    buf.append("\n\t\t");
                    buf.append(cert.getSubjectDN().getName());
                    buf.append("\n\n\t");
                    buf.append(PicketBoxMessages.MESSAGES.existingCredentialMessage());
                    if (storeCert != null) {
                        buf.append(storeCert.getSerialNumber().toString(16));
                        buf.append("\n\t\t");
                        buf.append(storeCert.getSubjectDN().getName());
                        buf.append("\n");
                    } else {
                        ArrayList<String> aliases = new ArrayList<String>();
                        Enumeration<String> en = trustStore.aliases();
                        while (en.hasMoreElements()) {
                            aliases.add(en.nextElement());
                        }
                        buf.append(PicketBoxMessages.MESSAGES.noMatchForAliasMessage(alias, aliases));
                    }
                    PicketBoxLogger.LOGGER.trace((Object)buf.toString());
                }
            }
            catch (KeyStoreException e) {
                PicketBoxLogger.LOGGER.warnFailureToFindCertForAlias(alias, (Throwable)e);
            }
            if (cert.equals(storeCert)) {
                isValid = true;
            }
        } else {
            PicketBoxLogger.LOGGER.warnFailureToValidateCertificate();
        }
        PicketBoxLogger.LOGGER.traceEndValidateCredential(isValid);
        return isValid;
    }
}

