/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.plugins;

import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import org.jboss.logging.Logger;

public class TmpFilePassword {
    private static Logger log = Logger.getLogger(TmpFilePassword.class);
    private File passwordFile;

    public TmpFilePassword(String file) {
        this.passwordFile = new File(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char[] toCharArray() throws IOException {
        int b;
        while (!this.passwordFile.exists()) {
            log.info((Object)("Waiting for password file: " + this.passwordFile.getAbsolutePath()));
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                log.info((Object)"Exiting wait on InterruptedException");
                break;
            }
        }
        FileInputStream fis = null;
        CharArrayWriter writer = null;
        try {
            fis = new FileInputStream(this.passwordFile);
            writer = new CharArrayWriter();
            while ((b = fis.read()) >= 0) {
                if (b == 13 || b == 10) continue;
                writer.write(b);
            }
            Object var5_6 = null;
            this.safeClose(fis);
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.safeClose(fis);
            throw throwable;
        }
        try {
            fis = new FileInputStream(this.passwordFile);
            writer = new CharArrayWriter();
            while ((b = fis.read()) >= 0) {
                if (b == 13 || b == 10) continue;
                writer.write(b);
            }
            Object var7_13 = null;
            this.safeClose(fis);
        }
        catch (Throwable throwable) {
            Object var7_14 = null;
            this.safeClose(fis);
            throw throwable;
        }
        char[] password = writer.toCharArray();
        writer.reset();
        for (int n = 0; n < password.length; ++n) {
            writer.write(0);
        }
        RandomAccessFile raf = null;
        try {
            block16: {
                try {
                    raf = new RandomAccessFile(this.passwordFile, "rws");
                    for (int i = 0; i < 10; ++i) {
                        raf.seek(0L);
                        for (int j = 0; j < password.length; ++j) {
                            raf.write(j);
                        }
                    }
                    raf.close();
                    if (this.passwordFile.delete()) break block16;
                    log.warn((Object)"Was not able to delete the password file");
                }
                catch (Exception e) {
                    log.warn((Object)"Failed to zero the password file", (Throwable)e);
                    Object var9_18 = null;
                    this.safeClose(raf);
                }
            }
            Object var9_17 = null;
            this.safeClose(raf);
        }
        catch (Throwable throwable) {
            Object var9_19 = null;
            this.safeClose(raf);
            throw throwable;
        }
        return password;
    }

    private void safeClose(InputStream is) {
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void safeClose(RandomAccessFile f) {
        try {
            if (f != null) {
                f.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

