/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.acl;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.security.acl.ACL;
import org.jboss.security.acl.ACLEntry;
import org.jboss.security.acl.ACLPermission;
import org.jboss.security.acl.ACLPersistenceStrategy;
import org.jboss.security.acl.ACLProvider;
import org.jboss.security.acl.BasicACLPermission;
import org.jboss.security.acl.CompositeACLPermission;
import org.jboss.security.acl.EntitlementEntry;
import org.jboss.security.authorization.AuthorizationException;
import org.jboss.security.authorization.Resource;
import org.jboss.security.identity.Identity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ACLProviderImpl
implements ACLProvider {
    private static final String PERSISTENCE_STRATEGY_OPTION = "persistenceStrategy";
    private static final String CHECK_PARENT_ACL_OPTION = "checkParentACL";
    protected ACLPersistenceStrategy strategy;
    private boolean checkParentACL;

    public void initialize(Map<String, Object> sharedState, Map<String, Object> options) {
        String strategyClassName = (String)options.get(PERSISTENCE_STRATEGY_OPTION);
        if (strategyClassName == null) {
            strategyClassName = "org.jboss.security.acl.JPAPersistenceStrategy";
        }
        this.checkParentACL = Boolean.valueOf((String)options.get(CHECK_PARENT_ACL_OPTION));
        try {
            Class<?> strategyClass = this.loadClass(strategyClassName);
            this.strategy = (ACLPersistenceStrategy)strategyClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("PB00019: Processing Failed:Failed to instantiate persistence strategy class", e);
        }
    }

    public <T> Set<T> getEntitlements(Class<T> clazz, Resource resource, Identity identity) throws AuthorizationException {
        if (!EntitlementEntry.class.equals(clazz)) {
            return null;
        }
        HashSet<EntitlementEntry> entitlements = new HashSet<EntitlementEntry>();
        ACLPermission permission = this.getInitialPermissions(resource, identity.getName());
        if (permission != null) {
            this.fillEntitlements(entitlements, resource, identity.getName(), permission);
        }
        return entitlements;
    }

    protected void fillEntitlements(Set<EntitlementEntry> entitlements, Resource resource, String identityName, ACLPermission permission) {
        ACLPermission currentPermission = permission;
        ACL acl = this.strategy.getACL(resource);
        if (acl != null) {
            ACLEntry entry = acl.getEntry(identityName);
            if (entry == null) {
                return;
            }
            currentPermission = entry.getPermission();
            entitlements.add(new EntitlementEntry(resource, currentPermission, identityName));
        } else {
            entitlements.add(new EntitlementEntry(resource, currentPermission, identityName));
        }
        Collection childResources = (Collection)resource.getMap().get("childResources");
        if (childResources != null) {
            for (Resource childResource : childResources) {
                this.fillEntitlements(entitlements, childResource, identityName, currentPermission);
            }
        }
    }

    protected ACLPermission getInitialPermissions(Resource resource, String identityName) {
        ACL acl = this.strategy.getACL(resource);
        if (acl == null) {
            Resource parent = (Resource)resource.getMap().get("parentResource");
            if (parent != null) {
                return this.getInitialPermissions(parent, identityName);
            }
            return new CompositeACLPermission(BasicACLPermission.values());
        }
        ACLEntry entry = acl.getEntry(identityName);
        if (entry != null) {
            return entry.getPermission();
        }
        return null;
    }

    public ACLPersistenceStrategy getPersistenceStrategy() {
        return this.strategy;
    }

    public void setPersistenceStrategy(ACLPersistenceStrategy strategy) {
        if (strategy == null) {
            throw new IllegalArgumentException("PB00014: Null Argument:PersistenceStrategy cannot be null");
        }
        this.strategy = strategy;
    }

    public boolean isAccessGranted(Resource resource, Identity identity, ACLPermission permission) throws AuthorizationException {
        ACL acl = this.retrieveACL(resource);
        if (acl != null) {
            ACLEntry entry = acl.getEntry(identity);
            if (entry != null) {
                return entry.checkPermission(permission);
            }
            return false;
        }
        throw new AuthorizationException("PB00019: Processing Failed:Unable to locate an ACL for the resource " + resource);
    }

    private ACL retrieveACL(Resource resource) {
        Resource parent;
        ACL acl = this.strategy.getACL(resource);
        if (acl == null && this.checkParentACL && (parent = (Resource)resource.getMap().get("parentResource")) != null) {
            acl = this.retrieveACL(parent);
        }
        return acl;
    }

    public boolean tearDown() {
        return true;
    }

    protected Class<?> loadClass(final String name) throws PrivilegedActionException {
        return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){

            @Override
            public Class<?> run() throws PrivilegedActionException {
                try {
                    ClassLoader loader = Thread.currentThread().getContextClassLoader();
                    return loader.loadClass(name);
                }
                catch (Exception e) {
                    throw new PrivilegedActionException(e);
                }
            }
        });
    }
}

