/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.callback;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.CredentialException;
import javax.sql.DataSource;
import org.jboss.logging.Logger;
import org.jboss.security.auth.callback.AbstractCallbackHandler;
import org.jboss.security.auth.callback.VerifyPasswordCallback;
import org.jboss.security.vault.SecurityVaultException;
import org.jboss.security.vault.SecurityVaultUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseCallbackHandler
extends AbstractCallbackHandler
implements CallbackHandler {
    protected static Logger log = Logger.getLogger(DatabaseCallbackHandler.class);
    protected boolean trace = log.isTraceEnabled();
    public static final String CONNECTION_URL = "connectionURL";
    public static final String DS_JNDI_NAME = "dsJndiName";
    public static final String DB_DRIVERNAME = "dbDriverName";
    public static final String DB_USERNAME = "dbUserName";
    public static final String DB_USERPASS = "dbUserPass";
    public static final String PRINCIPALS_QUERY = "principalsQuery";
    protected String connectionUrl;
    protected String dsJndiName;
    protected String dsUserName;
    protected String dsUserPass;
    protected String dbDriverName;
    protected String principalsQuery = "select Password from Principals where PrincipalID=?";

    public String getConnectionUrl() {
        return this.connectionUrl;
    }

    public void setConnectionUrl(String connectionUrl) {
        this.connectionUrl = connectionUrl;
    }

    public String getDsJndiName() {
        return this.dsJndiName;
    }

    public void setDsJndiName(String dsJndiName) {
        this.dsJndiName = dsJndiName;
    }

    public String getDsUserName() {
        return this.dsUserName;
    }

    public void setDsUserName(String dsUserName) {
        this.dsUserName = dsUserName;
    }

    public String getDsUserPass() {
        return this.dsUserPass;
    }

    public void setDsUserPass(String dsUserPass) {
        this.dsUserPass = dsUserPass;
    }

    public String getDbDriverName() {
        return this.dbDriverName;
    }

    public void setDbDriverName(String dbDriverName) {
        this.dbDriverName = dbDriverName;
    }

    public String getPrincipalsQuery() {
        return this.principalsQuery;
    }

    public void setPrincipalsQuery(String principalsQuery) {
        this.principalsQuery = principalsQuery;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String theUserName) {
        if (theUserName == null) {
            throw new IllegalArgumentException("PB00014: Null Argument:un");
        }
        this.userName = theUserName;
    }

    public void setConfiguration(Map<String, String> config) {
        String tmp = null;
        this.dbDriverName = config.get(DB_DRIVERNAME);
        this.connectionUrl = config.get(CONNECTION_URL);
        if (this.connectionUrl == null || this.connectionUrl.length() == 0) {
            this.dsJndiName = config.get(DS_JNDI_NAME);
        }
        this.dsUserName = config.get(DB_USERNAME);
        this.dsUserPass = config.get(DB_USERPASS);
        if (this.dsUserPass != null && SecurityVaultUtil.isVaultFormat((String)this.dsUserPass)) {
            try {
                this.dsUserPass = SecurityVaultUtil.getValueAsString((String)this.dsUserPass);
            }
            catch (SecurityVaultException e) {
                throw new RuntimeException(e);
            }
        }
        if ((tmp = config.get(PRINCIPALS_QUERY)) != null) {
            this.principalsQuery = tmp;
        }
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (this.userName == null) {
            this.userName = this.getUserName(callbacks);
        }
        for (int i = 0; i < callbacks.length; ++i) {
            Callback callback = callbacks[i];
            this.handleCallBack(callback);
        }
    }

    protected void handleCallBack(Callback c) throws UnsupportedCallbackException, IOException {
        if (c instanceof VerifyPasswordCallback) {
            VerifyPasswordCallback vpc = (VerifyPasswordCallback)c;
            try {
                this.handleVerification(vpc);
            }
            catch (CredentialException e) {
                throw new IOException(e);
            }
        }
        if (!(c instanceof PasswordCallback)) {
            return;
        }
        PasswordCallback passwdCallback = (PasswordCallback)c;
        passwdCallback.setPassword(this.getPassword().toCharArray());
    }

    protected void handleVerification(VerifyPasswordCallback vpc) throws CredentialException {
        String passwordFromDB;
        String userPass = vpc.getValue();
        if (!userPass.equals(passwordFromDB = this.getPassword())) {
            throw new CredentialException("PB00024: Access Denied:Passwords don't match");
        }
        vpc.setVerified(true);
    }

    private String getPassword() {
        String password = null;
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection();
            ps = conn.prepareStatement(this.principalsQuery);
            ps.setString(1, this.userName);
            rs = ps.executeQuery();
            if (!rs.next()) {
                if (this.trace) {
                    log.trace((Object)"Query returned no matches from db");
                }
                throw new RuntimeException("PB00019: Processing Failed:No matching username found in Principals:" + this.userName);
            }
            password = rs.getString(1);
            this.safeClose(rs);
            this.safeClose(ps);
            this.safeClose(conn);
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.safeClose(rs);
                this.safeClose(ps);
                this.safeClose(conn);
                throw throwable;
            }
        }
        return password;
    }

    private Connection getConnection() throws SQLException, NamingException {
        Connection conn = null;
        if (this.dbDriverName != null) {
            try {
                Class.forName(this.dbDriverName);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("PB00019: Processing Failed:", e);
            }
        }
        if (this.connectionUrl != null) {
            conn = this.dsUserName != null ? DriverManager.getConnection(this.connectionUrl, this.dsUserName, this.dsUserPass) : DriverManager.getConnection(this.connectionUrl);
        } else {
            InitialContext ic = new InitialContext();
            if (this.dsJndiName == null) {
                throw new RuntimeException("PB00015: Null Value:dsJndiName is null");
            }
            DataSource ds = (DataSource)ic.lookup(this.dsJndiName);
            if (ds != null) {
                conn = ds.getConnection();
            }
        }
        return conn;
    }

    protected void safeClose(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    protected void safeClose(Connection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    protected void safeClose(Statement stat) {
        if (stat != null) {
            try {
                stat.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }
}

