/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.plugins.auth;

import java.util.Map;
import java.util.Properties;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.AuthStatus;
import javax.security.auth.message.MessageInfo;
import javax.security.auth.message.config.AuthConfigFactory;
import javax.security.auth.message.config.AuthConfigProvider;
import javax.security.auth.message.config.ServerAuthConfig;
import javax.security.auth.message.config.ServerAuthContext;
import javax.security.jacc.PolicyContext;
import org.jboss.security.PicketBoxLogger;
import org.jboss.security.PicketBoxMessages;
import org.jboss.security.ServerAuthenticationManager;
import org.jboss.security.plugins.auth.JaasSecurityManagerBase;

public class JASPIServerAuthenticationManager
extends JaasSecurityManagerBase
implements ServerAuthenticationManager {
    public JASPIServerAuthenticationManager() {
    }

    public JASPIServerAuthenticationManager(String securityDomain, CallbackHandler handler) {
        super(securityDomain, handler);
    }

    public boolean isValid(MessageInfo requestMessage, Subject clientSubject, String layer, CallbackHandler handler) {
        return this.isValid(requestMessage, clientSubject, layer, PolicyContext.getContextID(), handler);
    }

    public boolean isValid(MessageInfo messageInfo, Subject clientSubject, String layer, String appContext, CallbackHandler callbackHandler) {
        AuthStatus status = AuthStatus.FAILURE;
        try {
            AuthConfigFactory factory = AuthConfigFactory.getFactory();
            AuthConfigProvider provider = factory.getConfigProvider(layer, appContext, null);
            if (provider == null) {
                throw PicketBoxMessages.MESSAGES.invalidNullAuthConfigProviderForLayer(layer, appContext);
            }
            ServerAuthConfig serverConfig = provider.getServerAuthConfig(layer, appContext, callbackHandler);
            String authContextId = serverConfig.getAuthContextID(messageInfo);
            Properties properties = new Properties();
            properties.setProperty("security-domain", super.getSecurityDomain());
            ServerAuthContext sctx = serverConfig.getAuthContext(authContextId, new Subject(), (Map)properties);
            if (clientSubject == null) {
                clientSubject = new Subject();
            }
            Subject serviceSubject = new Subject();
            status = sctx.validateRequest(messageInfo, clientSubject, serviceSubject);
        }
        catch (AuthException ae) {
            PicketBoxLogger.LOGGER.debugIgnoredException((Throwable)ae);
        }
        return AuthStatus.SUCCESS == status;
    }

    public void secureResponse(MessageInfo messageInfo, Subject serviceSubject, String layer, String appContext, CallbackHandler handler) {
        try {
            AuthConfigFactory factory = AuthConfigFactory.getFactory();
            AuthConfigProvider provider = factory.getConfigProvider(layer, appContext, null);
            if (provider == null) {
                throw PicketBoxMessages.MESSAGES.invalidNullAuthConfigProviderForLayer(layer, appContext);
            }
            ServerAuthConfig serverConfig = provider.getServerAuthConfig(layer, appContext, handler);
            String authContextId = serverConfig.getAuthContextID(messageInfo);
            Properties properties = new Properties();
            properties.setProperty("security-domain", super.getSecurityDomain());
            if (serviceSubject == null) {
                serviceSubject = new Subject();
            }
            ServerAuthContext sctx = serverConfig.getAuthContext(authContextId, serviceSubject, (Map)properties);
            sctx.secureResponse(messageInfo, serviceSubject);
        }
        catch (AuthException ae) {
            PicketBoxLogger.LOGGER.debugIgnoredException((Throwable)ae);
        }
    }
}

