/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.spi;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.jboss.logging.Logger;
import org.jboss.security.PicketBoxLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisabledLoginModule
implements LoginModule {
    private static final String[] ALL_VALID_OPTIONS = new String[]{"jboss.security.security_domain"};
    private static Logger log = Logger.getLogger(DisabledLoginModule.class);
    protected String securityDomain;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        HashSet<String> validOptions = new HashSet<String>(Arrays.asList(ALL_VALID_OPTIONS));
        for (String key : options.keySet()) {
            if (validOptions.contains(key)) continue;
            PicketBoxLogger.LOGGER.warnInvalidModuleOption(key);
        }
        this.securityDomain = (String)options.get("jboss.security.security_domain");
    }

    @Override
    public boolean login() throws LoginException {
        PicketBoxLogger.LOGGER.errorUsingDisabledDomain(this.securityDomain != null ? this.securityDomain : "");
        return false;
    }

    @Override
    public boolean commit() throws LoginException {
        return false;
    }

    @Override
    public boolean abort() throws LoginException {
        return false;
    }

    @Override
    public boolean logout() throws LoginException {
        return false;
    }
}

