/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.identity.plugins;

import org.jboss.security.identity.Role;
import org.jboss.security.identity.RoleType;

public class SimpleRole
implements Role,
Cloneable {
    private static final long serialVersionUID = 1L;
    private final String roleName;
    private final Role parent;
    public static final String ANYBODY = "<ANYBODY>";
    public static final Role ANYBODY_ROLE = new SimpleRole("<ANYBODY>");

    public SimpleRole(String roleName) {
        this(roleName, null);
    }

    public SimpleRole(String roleName, Role parent) {
        this.roleName = roleName;
        this.parent = parent;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public RoleType getType() {
        return RoleType.simple;
    }

    public boolean containsAll(Role anotherRole) {
        if (anotherRole.getType() == RoleType.simple) {
            if (ANYBODY.equals(this.roleName)) {
                return true;
            }
            return this.roleName.equals(anotherRole.getRoleName());
        }
        return false;
    }

    public Role getParent() {
        return this.parent;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String toString() {
        return this.roleName;
    }
}

