/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security;

import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.security.SecurityContextFactory;

class SecurityAssociationActions {
    SecurityAssociationActions() {
    }

    static void clearSecurityContext(SecurityContext sc) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                SecurityContextAssociation.clearSecurityContext();
                return null;
            }
        });
    }

    static void setSecurityContext(final SecurityContext sc) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                SecurityContextAssociation.setSecurityContext((SecurityContext)sc);
                return null;
            }
        });
    }

    static SecurityContext getSecurityContext() {
        return AccessController.doPrivileged(new PrivilegedAction<SecurityContext>(){

            @Override
            public SecurityContext run() {
                return SecurityContextAssociation.getSecurityContext();
            }
        });
    }

    static void pushSecurityContext(final Principal p, final Object cred, final Subject subject, final String securityDomain) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                SecurityContext sc;
                try {
                    sc = SecurityContextFactory.createSecurityContext((Principal)p, (Object)cred, (Subject)subject, (String)securityDomain);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                SecurityAssociationActions.setSecurityContext(sc);
                return null;
            }
        });
    }

    static void popSecurityContext() {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                SecurityContext sc = SecurityAssociationActions.getSecurityContext();
                if (sc != null) {
                    sc.getUtil().createSubjectInfo(null, null, null);
                }
                return null;
            }
        });
    }

    static void setPrincipalInfo(Principal principal, Object credential, Subject subject) {
        SetPrincipalInfoAction action = new SetPrincipalInfoAction(principal, credential, subject);
        AccessController.doPrivileged(action);
    }

    static void popPrincipalInfo() {
        PopPrincipalInfoAction action = new PopPrincipalInfoAction();
        AccessController.doPrivileged(action);
    }

    static Boolean getServer() {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return !SecurityContextAssociation.isClient();
            }
        });
    }

    static void setClient() {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                SecurityContextAssociation.setClient();
                return null;
            }
        });
    }

    static void clear() {
        AccessController.doPrivileged(ClearAction.ACTION);
    }

    static Subject getSubject() {
        Subject subject = AccessController.doPrivileged(GetSubjectAction.ACTION);
        return subject;
    }

    static Principal getPrincipal() {
        Principal principal = AccessController.doPrivileged(GetPrincipalAction.ACTION);
        return principal;
    }

    static Object getCredential() {
        Object credential = AccessController.doPrivileged(GetCredentialAction.ACTION);
        return credential;
    }

    static SecurityContext createSecurityContext(final String securityDomain) throws PrivilegedActionException {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<SecurityContext>(){

            @Override
            public SecurityContext run() throws Exception {
                return SecurityContextFactory.createSecurityContext((String)securityDomain);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GetCredentialAction
    implements PrivilegedAction<Object> {
        static PrivilegedAction<Object> ACTION = new GetCredentialAction();

        private GetCredentialAction() {
        }

        @Override
        public Object run() {
            Object credential = SecurityContextAssociation.getCredential();
            return credential;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GetPrincipalAction
    implements PrivilegedAction<Principal> {
        static PrivilegedAction<Principal> ACTION = new GetPrincipalAction();

        private GetPrincipalAction() {
        }

        @Override
        public Principal run() {
            Principal principal = SecurityContextAssociation.getPrincipal();
            return principal;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GetSubjectAction
    implements PrivilegedAction<Subject> {
        static PrivilegedAction<Subject> ACTION = new GetSubjectAction();

        private GetSubjectAction() {
        }

        @Override
        public Subject run() {
            Subject subject = SecurityContextAssociation.getSubject();
            return subject;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClearAction
    implements PrivilegedAction<Object> {
        static PrivilegedAction<Object> ACTION = new ClearAction();

        private ClearAction() {
        }

        @Override
        public Object run() {
            if (!SecurityAssociationActions.getServer().booleanValue()) {
                SecurityContextAssociation.clearSecurityContext();
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PopPrincipalInfoAction
    implements PrivilegedAction<Object> {
        private PopPrincipalInfoAction() {
        }

        @Override
        public Object run() {
            if (!SecurityAssociationActions.getServer().booleanValue()) {
                SecurityAssociationActions.popSecurityContext();
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SetPrincipalInfoAction
    implements PrivilegedAction<Object> {
        Principal principal;
        Object credential;
        Subject subject;

        SetPrincipalInfoAction(Principal principal, Object credential, Subject subject) {
            this.principal = principal;
            this.credential = credential;
            this.subject = subject;
        }

        @Override
        public Object run() {
            SecurityContext sc = null;
            try {
                sc = SecurityContextFactory.createSecurityContext((Principal)this.principal, (Object)this.credential, (Subject)this.subject, (String)"CLIENT_LOGIN_MODULE");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            SecurityAssociationActions.setSecurityContext(sc);
            this.credential = null;
            this.principal = null;
            this.subject = null;
            return null;
        }
    }
}

