/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.security;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.jboss.logging.Logger;
import org.jboss.resource.security.AbstractPasswordCredentialLoginModule;
import org.jboss.resource.security.SubjectActions;
import org.jboss.security.SimplePrincipal;

public class SecureIdentityLoginModule
extends AbstractPasswordCredentialLoginModule {
    private static final Logger log = Logger.getLogger(SecureIdentityLoginModule.class);
    private boolean trace = log.isTraceEnabled();
    private String username;
    private String password;

    public void initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options) {
        super.initialize(subject, handler, sharedState, options);
        this.username = (String)options.get("username");
        if (this.username == null) {
            this.username = (String)options.get("userName");
            if (this.username == null) {
                throw new IllegalArgumentException("The user name is a required option");
            }
        }
        this.password = (String)options.get("password");
        if (this.password == null) {
            throw new IllegalArgumentException("The password is a required option");
        }
    }

    public boolean login() throws LoginException {
        if (this.trace) {
            log.trace((Object)"login called");
        }
        if (super.login()) {
            return true;
        }
        this.loginOk = true;
        return true;
    }

    public boolean commit() throws LoginException {
        SimplePrincipal principal = new SimplePrincipal(this.username);
        SubjectActions.addPrincipals(this.subject, principal);
        this.sharedState.put("javax.security.auth.login.name", this.username);
        try {
            char[] decodedPassword = SecureIdentityLoginModule.decode(this.password);
            PasswordCredential cred = new PasswordCredential(this.username, decodedPassword);
            cred.setManagedConnectionFactory(this.getMcf());
            SubjectActions.addCredentials(this.subject, cred);
        }
        catch (Exception e) {
            if (this.trace) {
                log.trace((Object)"Failed to decode password", (Throwable)e);
            }
            throw new LoginException("Failed to decode password: " + e.getMessage());
        }
        return true;
    }

    public boolean abort() {
        this.username = null;
        this.password = null;
        return true;
    }

    protected Principal getIdentity() {
        if (this.trace) {
            log.trace((Object)("getIdentity called, username=" + this.username));
        }
        SimplePrincipal principal = new SimplePrincipal(this.username);
        return principal;
    }

    protected Group[] getRoleSets() throws LoginException {
        Group[] empty = new Group[]{};
        return empty;
    }

    private static String encode(String secret) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        byte[] kbytes = "jaas is the way".getBytes();
        SecretKeySpec key = new SecretKeySpec(kbytes, "Blowfish");
        Cipher cipher = Cipher.getInstance("Blowfish");
        cipher.init(1, key);
        byte[] encoding = cipher.doFinal(secret.getBytes());
        BigInteger n = new BigInteger(encoding);
        return n.toString(16);
    }

    private static char[] decode(String secret) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        byte[] kbytes = "jaas is the way".getBytes();
        SecretKeySpec key = new SecretKeySpec(kbytes, "Blowfish");
        BigInteger n = new BigInteger(secret, 16);
        byte[] encoding = n.toByteArray();
        if (encoding.length % 8 != 0) {
            int i;
            int length = encoding.length;
            int newLength = (length / 8 + 1) * 8;
            int pad = newLength - length;
            byte[] old = encoding;
            encoding = new byte[newLength];
            for (i = old.length - 1; i >= 0; --i) {
                encoding[i + pad] = old[i];
            }
            if (n.signum() == -1) {
                for (i = 0; i < newLength - length; ++i) {
                    encoding[i] = -1;
                }
            }
        }
        Cipher cipher = Cipher.getInstance("Blowfish");
        cipher.init(2, key);
        byte[] decode = cipher.doFinal(encoding);
        return new String(decode).toCharArray();
    }

    public static void main(String[] args) throws Exception {
        String encode = SecureIdentityLoginModule.encode(args[0]);
        System.out.println("Encoded password: " + encode);
    }
}

