/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.client;

import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.security.SecurityContextFactory;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.client.SecurityClient;

public class JBossSecurityClient
extends SecurityClient {
    protected LoginContext lc = null;
    private SecurityContext previousSecurityContext = null;

    protected void peformSASLLogin() {
        throw new UnsupportedOperationException();
    }

    protected void performJAASLogin() throws LoginException {
        this.lc = new LoginContext(this.loginConfigName, this.callbackHandler);
        this.lc.login();
    }

    protected void performSimpleLogin() {
        Principal up = null;
        up = this.userPrincipal instanceof String ? new SimplePrincipal((String)this.userPrincipal) : (Principal)this.userPrincipal;
        SecurityManager sm = System.getSecurityManager();
        this.previousSecurityContext = sm != null ? RuntimeActions.PRIVILEGED.getSecurityContext() : RuntimeActions.NON_PRIVILEGED.getSecurityContext();
        SecurityContext sc = null;
        try {
            sc = sm != null ? RuntimeActions.PRIVILEGED.createClientSecurityContext() : RuntimeActions.NON_PRIVILEGED.createClientSecurityContext();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (sm != null) {
            RuntimeActions.PRIVILEGED.createSubjectInfo(sc, up, this.credential, null);
            RuntimeActions.PRIVILEGED.setSecurityContext(sc);
        } else {
            RuntimeActions.NON_PRIVILEGED.createSubjectInfo(sc, up, this.credential, null);
            RuntimeActions.NON_PRIVILEGED.setSecurityContext(sc);
        }
    }

    protected void cleanUp() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            RuntimeActions.PRIVILEGED.setSecurityContext(this.previousSecurityContext);
        } else {
            RuntimeActions.NON_PRIVILEGED.setSecurityContext(this.previousSecurityContext);
        }
        if (this.lc != null) {
            try {
                this.lc.logout();
            }
            catch (LoginException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static interface RuntimeActions {
        public static final RuntimeActions NON_PRIVILEGED = new RuntimeActions(){

            @Override
            public SecurityContext getSecurityContext() {
                return SecurityContextAssociation.getSecurityContext();
            }

            @Override
            public SecurityContext createClientSecurityContext() throws Exception {
                return SecurityContextFactory.createSecurityContext((String)"CLIENT");
            }

            @Override
            public void setSecurityContext(SecurityContext securityContext) {
                SecurityContextAssociation.setSecurityContext((SecurityContext)securityContext);
            }

            @Override
            public void createSubjectInfo(SecurityContext securityContext, Principal principal, Object credential, Subject subject) {
                securityContext.getUtil().createSubjectInfo(principal, credential, subject);
            }
        };
        public static final RuntimeActions PRIVILEGED = new RuntimeActions(){

            @Override
            public SecurityContext getSecurityContext() {
                return AccessController.doPrivileged(new PrivilegedAction<SecurityContext>(){

                    @Override
                    public SecurityContext run() {
                        return NON_PRIVILEGED.getSecurityContext();
                    }
                });
            }

            @Override
            public SecurityContext createClientSecurityContext() throws Exception {
                try {
                    return AccessController.doPrivileged(new PrivilegedExceptionAction<SecurityContext>(){

                        @Override
                        public SecurityContext run() throws Exception {
                            return NON_PRIVILEGED.createClientSecurityContext();
                        }
                    });
                }
                catch (PrivilegedActionException pae) {
                    throw pae.getException();
                }
            }

            @Override
            public void setSecurityContext(final SecurityContext securityContext) {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        NON_PRIVILEGED.setSecurityContext(securityContext);
                        return null;
                    }
                });
            }

            @Override
            public void createSubjectInfo(final SecurityContext securityContext, final Principal principal, final Object credential, final Subject subject) {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        NON_PRIVILEGED.createSubjectInfo(securityContext, principal, credential, subject);
                        return null;
                    }
                });
            }
        };

        public SecurityContext getSecurityContext();

        public SecurityContext createClientSecurityContext() throws Exception;

        public void setSecurityContext(SecurityContext var1);

        public void createSubjectInfo(SecurityContext var1, Principal var2, Object var3, Subject var4);
    }
}

