/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.plugins;

import java.security.Principal;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.ISecurityManagement;
import org.jboss.security.PicketBoxLogger;
import org.jboss.security.PicketBoxMessages;
import org.jboss.security.SubjectFactory;
import org.jboss.security.auth.callback.JBossCallbackHandler;
import org.jboss.security.plugins.DefaultSecurityManagement;
import org.jboss.security.plugins.SubjectActions;

public class JBossSecuritySubjectFactory
implements SubjectFactory {
    private ISecurityManagement securityManagement;

    public Subject createSubject() {
        return this.createSubject("other");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Subject createSubject(String securityDomainName) {
        if (this.securityManagement == null) {
            PicketBoxLogger.LOGGER.warnSecurityMagementNotSet();
            this.securityManagement = new DefaultSecurityManagement(new JBossCallbackHandler());
        }
        Subject subject = new Subject();
        Principal principal = SubjectActions.getPrincipal();
        AuthenticationManager authenticationManager = this.securityManagement.getAuthenticationManager(securityDomainName);
        if (authenticationManager == null) {
            String defaultSecurityDomain = "other";
            PicketBoxLogger.LOGGER.debugNullAuthenticationManager(securityDomainName);
            authenticationManager = this.securityManagement.getAuthenticationManager(defaultSecurityDomain);
        }
        ClassLoader tccl = SubjectActions.getContextClassLoader();
        try {
            SubjectActions.setContextClassLoader(this.getClass().getClassLoader());
            if (!authenticationManager.isValid(principal, SubjectActions.getCredential(), subject)) {
                LoginException loginException = SubjectActions.getContextLoginException();
                if (loginException == null) {
                    throw new SecurityException(PicketBoxMessages.MESSAGES.authenticationFailedMessage());
                }
                throw new SecurityException(PicketBoxMessages.MESSAGES.authenticationFailedMessage(), loginException);
            }
        }
        finally {
            SubjectActions.setContextClassLoader(tccl);
        }
        return subject;
    }

    public void setSecurityManagement(ISecurityManagement securityManagement) {
        this.securityManagement = securityManagement;
    }
}

