/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.mapping.providers.principal;

import java.security.Principal;
import java.util.Map;
import java.util.Properties;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.mapping.MappingResult;
import org.jboss.security.mapping.providers.principal.AbstractPrincipalMappingProvider;

public class SimplePrincipalMappingProvider
extends AbstractPrincipalMappingProvider {
    private static final String PRINCIPALS_MAP = "principalsMap";
    private MappingResult<Principal> result;
    Properties principalMapProperties = null;

    public void init(Map<String, Object> options) {
        if (options != null && options.containsKey(PRINCIPALS_MAP)) {
            this.principalMapProperties = (Properties)options.get(PRINCIPALS_MAP);
        }
    }

    public void performMapping(Map<String, Object> map, Principal mappedObject) {
        String newPrincipalName;
        if (!(mappedObject instanceof SimplePrincipal)) {
            return;
        }
        SimplePrincipal simplePrincipal = (SimplePrincipal)mappedObject;
        if (this.principalMapProperties != null && (newPrincipalName = this.principalMapProperties.getProperty(simplePrincipal.getName())) != null && newPrincipalName.length() > 0) {
            this.result.setMappedObject((Object)new SimplePrincipal(newPrincipalName));
        }
    }

    public void setMappingResult(MappingResult<Principal> result) {
        this.result = result;
    }
}

