/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.authorization.modules.ejb;

import java.lang.reflect.Method;
import java.security.CodeSource;
import java.security.Permission;
import java.security.Policy;
import java.security.Principal;
import java.security.ProtectionDomain;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.jacc.EJBMethodPermission;
import javax.security.jacc.EJBRoleRefPermission;
import org.jboss.security.PicketBoxLogger;
import org.jboss.security.PicketBoxMessages;
import org.jboss.security.RunAs;
import org.jboss.security.RunAsIdentity;
import org.jboss.security.authorization.PolicyRegistration;
import org.jboss.security.authorization.Resource;
import org.jboss.security.authorization.modules.AbstractJACCModuleDelegate;
import org.jboss.security.authorization.resources.EJBResource;
import org.jboss.security.identity.Role;
import org.jboss.security.identity.RoleGroup;

public class EJBJACCPolicyModuleDelegate
extends AbstractJACCModuleDelegate {
    private String ejbName = null;
    private Method ejbMethod = null;
    private String methodInterface = null;
    private CodeSource ejbCS = null;
    private String roleName = null;
    private Boolean roleRefCheck = Boolean.FALSE;
    private RunAsIdentity callerRunAs;

    public int authorize(Resource resource, Subject callerSubject, RoleGroup role) {
        if (!(resource instanceof EJBResource)) {
            throw PicketBoxMessages.MESSAGES.invalidType(EJBResource.class.getName());
        }
        EJBResource ejbResource = (EJBResource)resource;
        Map map = resource.getMap();
        if (map == null) {
            throw PicketBoxMessages.MESSAGES.invalidNullProperty("resourceMap");
        }
        this.policyRegistration = (PolicyRegistration)map.get("policyRegistration");
        this.ejbCS = ejbResource.getCodeSource();
        this.ejbMethod = ejbResource.getEjbMethod();
        this.ejbName = ejbResource.getEjbName();
        this.methodInterface = ejbResource.getEjbMethodInterface();
        RunAs runAs = ejbResource.getCallerRunAsIdentity();
        if (runAs instanceof RunAsIdentity) {
            this.callerRunAs = (RunAsIdentity)RunAsIdentity.class.cast(runAs);
        }
        this.roleName = (String)map.get("roleName");
        this.roleRefCheck = (Boolean)map.get("roleRefPermissionCheck");
        if (this.roleRefCheck == Boolean.TRUE) {
            return this.checkRoleRef(callerSubject, role);
        }
        return this.process(callerSubject, (Role)role);
    }

    private int process(Subject callerSubject, Role role) {
        EJBMethodPermission methodPerm = new EJBMethodPermission(this.ejbName, this.methodInterface, this.ejbMethod);
        boolean policyDecision = this.checkWithPolicy((Permission)methodPerm, callerSubject, role);
        if (!policyDecision && PicketBoxLogger.LOGGER.isDebugEnabled()) {
            PicketBoxLogger.LOGGER.debugJACCDeniedAccess(methodPerm.toString(), callerSubject, role != null ? role.toString() : null);
        }
        return policyDecision ? 1 : -1;
    }

    private int checkRoleRef(Subject callerSubject, RoleGroup callerRoles) {
        EJBRoleRefPermission ejbRoleRefPerm = new EJBRoleRefPermission(this.ejbName, this.roleName);
        boolean policyDecision = this.checkWithPolicy((Permission)ejbRoleRefPerm, callerSubject, (Role)callerRoles);
        if (!policyDecision && PicketBoxLogger.LOGGER.isDebugEnabled()) {
            PicketBoxLogger.LOGGER.debugJACCDeniedAccess(ejbRoleRefPerm.toString(), callerSubject, callerRoles != null ? callerRoles.toString() : null);
        }
        return policyDecision ? 1 : -1;
    }

    private boolean checkWithPolicy(Permission ejbPerm, Subject subject, Role role) {
        if (this.callerRunAs == null) {
            Principal[] principals = this.getPrincipals(subject, role);
            ProtectionDomain pd = new ProtectionDomain(this.ejbCS, null, null, principals);
            return Policy.getPolicy().implies(pd, ejbPerm);
        }
        Set<Principal> principals = this.callerRunAs.getRunAsRoles();
        ProtectionDomain pd = new ProtectionDomain(this.ejbCS, null, null, principals.toArray(new Principal[principals.size()]));
        return Policy.getPolicy().implies(pd, ejbPerm);
    }
}

