/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security;

import java.io.IOException;
import java.security.Principal;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.jboss.security.PicketBoxLogger;
import org.jboss.security.PicketBoxMessages;
import org.jboss.security.SecurityAssociationActions;
import org.jboss.security.SecurityContext;
import org.jboss.security.SimplePrincipal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientLoginModule
implements LoginModule {
    private static final String MULTI_TREADED = "multi-threaded";
    private static final String RESTORE_LOGIN_IDENTITY = "restore-login-identity";
    private static final String PASSWORD_STACKING = "password-stacking";
    private static final String USE_FIRST_PASSWORD = "useFirstPass";
    private static final String PRINCIPAL_CLASS = "principalClass";
    private static final String[] ALL_VALID_OPTIONS = new String[]{"multi-threaded", "restore-login-identity", "password-stacking", "principalClass", "jboss.security.security_domain"};
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Principal loginPrincipal;
    private Object loginCredential;
    private Map<String, ?> sharedState;
    private boolean useFirstPass;
    private boolean restoreLoginIdentity;
    private SecurityContext cachedSecurityContext;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        HashSet<String> validOptions = new HashSet<String>(Arrays.asList(ALL_VALID_OPTIONS));
        for (String key : options.keySet()) {
            if (validOptions.contains(key)) continue;
            PicketBoxLogger.LOGGER.warnInvalidModuleOption(key);
        }
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        PicketBoxLogger.LOGGER.debugModuleOption("jboss.security.security_domain", options.get("jboss.security.security_domain"));
        String flag = (String)options.get(MULTI_TREADED);
        if (Boolean.valueOf(flag).booleanValue()) {
            PicketBoxLogger.LOGGER.debugModuleOption(MULTI_TREADED, (Object)flag);
        }
        if (flag != null && flag.length() > 0 && "false".equalsIgnoreCase(flag)) {
            SecurityAssociationActions.setClient();
        }
        flag = (String)options.get(RESTORE_LOGIN_IDENTITY);
        this.restoreLoginIdentity = Boolean.valueOf(flag);
        PicketBoxLogger.LOGGER.debugModuleOption(RESTORE_LOGIN_IDENTITY, (Object)flag);
        String passwordStacking = (String)options.get(PASSWORD_STACKING);
        if (passwordStacking != null && passwordStacking.equalsIgnoreCase(USE_FIRST_PASSWORD)) {
            this.useFirstPass = true;
        }
        PicketBoxLogger.LOGGER.debugModuleOption(PASSWORD_STACKING, (Object)passwordStacking);
        this.cachedSecurityContext = SecurityAssociationActions.getSecurityContext();
    }

    @Override
    public boolean login() throws LoginException {
        PicketBoxLogger.LOGGER.traceBeginLogin();
        if (this.useFirstPass) {
            try {
                Object name = this.sharedState.get("javax.security.auth.login.name");
                if (!(name instanceof Principal)) {
                    String username = name != null ? name.toString() : "";
                    this.loginPrincipal = new SimplePrincipal(username);
                } else {
                    this.loginPrincipal = (Principal)name;
                }
                this.loginCredential = this.sharedState.get("javax.security.auth.login.password");
                return true;
            }
            catch (Exception e) {
                PicketBoxLogger.LOGGER.debugIgnoredException((Throwable)e);
            }
        }
        if (this.callbackHandler == null) {
            throw PicketBoxMessages.MESSAGES.noCallbackHandlerAvailable();
        }
        PasswordCallback pc = new PasswordCallback(PicketBoxMessages.MESSAGES.enterPasswordMessage(), false);
        NameCallback nc = new NameCallback(PicketBoxMessages.MESSAGES.enterUsernameMessage(), "guest");
        Callback[] callbacks = new Callback[]{nc, pc};
        try {
            char[] password = null;
            this.callbackHandler.handle(callbacks);
            String username = nc.getName();
            this.loginPrincipal = new SimplePrincipal(username);
            char[] tmpPassword = pc.getPassword();
            if (tmpPassword != null) {
                password = new char[tmpPassword.length];
                System.arraycopy(tmpPassword, 0, password, 0, tmpPassword.length);
                pc.clearPassword();
            }
            this.loginCredential = password;
            PicketBoxLogger.LOGGER.traceObtainedAuthInfoFromHandler(this.loginPrincipal, this.loginCredential != null ? this.loginCredential.getClass() : null);
        }
        catch (IOException ioe) {
            LoginException ex = new LoginException(ioe.getLocalizedMessage());
            ex.initCause(ioe);
            throw ex;
        }
        catch (UnsupportedCallbackException uce) {
            LoginException ex = new LoginException(uce.getLocalizedMessage());
            ex.initCause(uce);
            throw ex;
        }
        PicketBoxLogger.LOGGER.traceEndLogin(true);
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        PicketBoxLogger.LOGGER.traceBeginCommit(true);
        SecurityAssociationActions.setPrincipalInfo(this.loginPrincipal, this.loginCredential, this.subject);
        Set<Principal> principals = this.subject.getPrincipals();
        if (!principals.contains(this.loginPrincipal)) {
            principals.add(this.loginPrincipal);
        }
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        PicketBoxLogger.LOGGER.traceBeginAbort();
        if (this.restoreLoginIdentity) {
            SecurityAssociationActions.setSecurityContext(this.cachedSecurityContext);
        } else {
            SecurityAssociationActions.clear();
        }
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        PicketBoxLogger.LOGGER.traceBeginLogout();
        if (this.restoreLoginIdentity) {
            SecurityAssociationActions.setSecurityContext(this.cachedSecurityContext);
        } else {
            SecurityAssociationActions.clear();
        }
        Set<Principal> principals = this.subject.getPrincipals();
        principals.remove(this.loginPrincipal);
        return true;
    }
}

