/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.plugins.authorization;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.logging.Logger;
import org.jboss.security.authorization.AuthorizationContext;
import org.jboss.security.authorization.AuthorizationException;
import org.jboss.security.authorization.AuthorizationModule;
import org.jboss.security.authorization.Resource;
import org.jboss.security.authorization.ResourceType;
import org.jboss.security.authorization.config.AuthorizationModuleEntry;
import org.jboss.security.authorization.modules.DelegatingAuthorizationModule;
import org.jboss.security.config.ApplicationPolicy;
import org.jboss.security.config.AuthorizationInfo;
import org.jboss.security.config.ControlFlag;
import org.jboss.security.config.SecurityConfiguration;
import org.jboss.security.identity.RoleGroup;
import org.jboss.security.plugins.ClassLoaderLocator;
import org.jboss.security.plugins.ClassLoaderLocatorFactory;
import org.jboss.security.plugins.authorization.SecurityActions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossAuthorizationContext
extends AuthorizationContext {
    private static Logger log = Logger.getLogger(JBossAuthorizationContext.class);
    private boolean trace = log.isTraceEnabled();
    private final String EJB = "jboss-ejb-policy";
    private final String WEB = "jboss-web-policy";
    private Subject authenticatedSubject = null;
    private ApplicationPolicy applicationPolicy = null;
    private static Map<String, Class<?>> clazzMap = new WeakHashMap();

    public JBossAuthorizationContext(String name) {
        this.securityDomainName = name;
    }

    public JBossAuthorizationContext(String name, CallbackHandler handler) {
        this(name);
        this.callbackHandler = handler;
    }

    public JBossAuthorizationContext(String name, Subject subject, CallbackHandler handler) {
        this(name, handler);
        this.authenticatedSubject = subject;
    }

    public void setApplicationPolicy(ApplicationPolicy aPolicy) {
        if (aPolicy == null) {
            throw new IllegalArgumentException("PB00014: Null Argument:Application Policy is null:domain=" + this.securityDomainName);
        }
        AuthorizationInfo authzInfo = aPolicy.getAuthorizationInfo();
        if (authzInfo == null) {
            throw new IllegalArgumentException("PB00015: Null Value:Application Policy has no AuthorizationInfo");
        }
        if (!authzInfo.getName().equals(this.securityDomainName)) {
            throw new IllegalArgumentException("PB00016: Wrong Type:Application Policy ->AuthorizationInfo:" + authzInfo.getName() + " does not match required domain name=" + this.securityDomainName);
        }
        this.applicationPolicy = aPolicy;
    }

    public int authorize(Resource resource) throws AuthorizationException {
        return this.authorize(resource, this.authenticatedSubject, (RoleGroup)resource.getMap().get("securityContextRoles"));
    }

    public int authorize(final Resource resource, Subject subject, RoleGroup callerRoles) throws AuthorizationException {
        final ArrayList<AuthorizationModule> modules = new ArrayList<AuthorizationModule>();
        final ArrayList<ControlFlag> controlFlags = new ArrayList<ControlFlag>();
        try {
            try {
                this.authenticatedSubject = subject;
                this.initializeModules(resource, callerRoles, modules, controlFlags);
                AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws AuthorizationException {
                        int result = JBossAuthorizationContext.this.invokeAuthorize(resource, modules, controlFlags);
                        if (result == 1) {
                            JBossAuthorizationContext.this.invokeCommit(modules, controlFlags);
                        }
                        if (result == -1) {
                            JBossAuthorizationContext.this.invokeAbort(modules, controlFlags);
                            throw new AuthorizationException("PB00024: Access Denied:Denied");
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Exception exc = e.getException();
                if (this.trace) {
                    log.trace((Object)"Error in authorize:", (Throwable)exc);
                }
                this.invokeAbort(modules, controlFlags);
                throw (AuthorizationException)((Object)exc);
            }
            Object var9_6 = null;
            if (modules != null) {
                modules.clear();
            }
            if (controlFlags != null) {
                controlFlags.clear();
            }
        }
        catch (Throwable throwable) {
            Object var9_7 = null;
            if (modules != null) {
                modules.clear();
            }
            if (controlFlags != null) {
                controlFlags.clear();
            }
            throw throwable;
        }
        return 1;
    }

    private void initializeModules(Resource resource, RoleGroup role, List<AuthorizationModule> modules, List<ControlFlag> controlFlags) throws PrivilegedActionException {
        AuthorizationModuleEntry[] entries;
        ClassLoaderLocator cll;
        AuthorizationInfo authzInfo = this.getAuthorizationInfo(this.securityDomainName, resource);
        if (authzInfo == null) {
            throw new IllegalStateException("PB00015: Null Value:Authorization Info is null");
        }
        ClassLoader moduleCL = null;
        String jbossModuleName = authzInfo.getJBossModuleName();
        if (jbossModuleName != null && (cll = ClassLoaderLocatorFactory.get()) != null) {
            moduleCL = cll.get(jbossModuleName);
        }
        int len = (entries = authzInfo.getAuthorizationModuleEntry()) != null ? entries.length : 0;
        for (int i = 0; i < len; ++i) {
            AuthorizationModuleEntry entry = entries[i];
            ControlFlag flag = entry.getControlFlag();
            if (flag == null) {
                if (this.trace) {
                    log.trace((Object)("Null Control flag for entry:" + entry + ". Defaults to REQUIRED!"));
                }
                flag = ControlFlag.REQUIRED;
            } else if (this.trace) {
                log.trace((Object)("Control flag for entry:" + entry + "is:[" + flag + "]"));
            }
            controlFlags.add(flag);
            AuthorizationModule module = this.instantiateModule(moduleCL, entry.getPolicyModuleName(), entry.getOptions(), role);
            modules.add(module);
        }
    }

    private int invokeAuthorize(Resource resource, List<AuthorizationModule> modules, List<ControlFlag> controlFlags) throws AuthorizationException {
        boolean encounteredRequiredError = false;
        boolean encounteredOptionalError = false;
        AuthorizationException moduleException = null;
        int overallDecision = -1;
        int length = modules.size();
        for (int i = 0; i < length; ++i) {
            int decision;
            ControlFlag flag;
            AuthorizationModule module;
            block14: {
                module = modules.get(i);
                flag = controlFlags.get(i);
                decision = -1;
                try {
                    decision = module.authorize(resource);
                }
                catch (Exception ae) {
                    decision = -1;
                    if (moduleException != null) break block14;
                    moduleException = new AuthorizationException(ae.getMessage());
                }
            }
            if (decision == 1) {
                overallDecision = 1;
                if (flag != ControlFlag.SUFFICIENT || encounteredRequiredError) continue;
                return 1;
            }
            if (flag == ControlFlag.REQUISITE) {
                if (this.trace) {
                    log.trace((Object)("REQUISITE failed for " + module));
                }
                if (moduleException == null) {
                    moduleException = new AuthorizationException("Authorization failed");
                } else {
                    throw moduleException;
                }
            }
            if (flag == ControlFlag.REQUIRED) {
                if (this.trace) {
                    log.trace((Object)("REQUIRED failed for " + module));
                }
                if (!encounteredRequiredError) {
                    encounteredRequiredError = true;
                }
            }
            if (flag != ControlFlag.OPTIONAL) continue;
            encounteredOptionalError = true;
        }
        String msg = this.getAdditionalErrorMessage((Exception)((Object)moduleException));
        if (encounteredRequiredError) {
            throw new AuthorizationException("PB00024: Access Denied:Authorization Failed:" + msg);
        }
        if (overallDecision == -1 && encounteredOptionalError) {
            throw new AuthorizationException("PB00024: Access Denied:Authorization Failed:" + msg);
        }
        if (overallDecision == -1) {
            throw new AuthorizationException("PB00024: Access Denied:Authorization Failed:Denied.");
        }
        return 1;
    }

    private void invokeCommit(List<AuthorizationModule> modules, List<ControlFlag> controlFlags) throws AuthorizationException {
        int length = modules.size();
        for (int i = 0; i < length; ++i) {
            AuthorizationModule module = modules.get(i);
            boolean bool = module.commit();
            if (bool) continue;
            throw new AuthorizationException("PB00024: Access Denied:commit on modules failed:" + module.getClass());
        }
    }

    private void invokeAbort(List<AuthorizationModule> modules, List<ControlFlag> controlFlags) throws AuthorizationException {
        int length = modules.size();
        for (int i = 0; i < length; ++i) {
            AuthorizationModule module = modules.get(i);
            boolean bool = module.abort();
            if (bool) continue;
            throw new AuthorizationException("PB00024: Access Denied:abort on modules failed:" + module.getClass());
        }
    }

    private AuthorizationModule instantiateModule(ClassLoader cl, String name, Map<String, Object> map, RoleGroup subjectRoles) throws PrivilegedActionException {
        AuthorizationModule am;
        block7: {
            am = null;
            try {
                Class<?> clazz = clazzMap.get(name);
                if (clazz == null) {
                    try {
                        if (cl == null) {
                            cl = ((Object)((Object)this)).getClass().getClassLoader();
                        }
                        clazz = cl.loadClass(name);
                    }
                    catch (Exception ignore) {
                        ClassLoader tcl = SecurityActions.getContextClassLoader();
                        clazz = tcl.loadClass(name);
                    }
                    clazzMap.put(name, clazz);
                }
                am = (AuthorizationModule)clazz.newInstance();
            }
            catch (Exception e) {
                if (!this.trace) break block7;
                log.debug((Object)"Error instantiating AuthorizationModule:", (Throwable)e);
            }
        }
        if (am == null) {
            throw new IllegalStateException("PB00015: Null Value:AuthorizationModule has not been instantiated");
        }
        am.initialize(this.authenticatedSubject, this.callbackHandler, this.sharedState, map, subjectRoles);
        return am;
    }

    private AuthorizationInfo getAuthorizationInfo(String domainName, Resource resource) {
        ResourceType layer = resource.getLayer();
        if (this.applicationPolicy != null) {
            return this.applicationPolicy.getAuthorizationInfo();
        }
        ApplicationPolicy aPolicy = SecurityConfiguration.getApplicationPolicy(domainName);
        if (aPolicy == null) {
            if (this.trace) {
                log.trace((Object)("Application Policy not obtained for domain=" + domainName + ". Trying to obtain the App policy for the default domain of the layer:" + layer));
            }
            if (layer == ResourceType.EJB) {
                aPolicy = SecurityConfiguration.getApplicationPolicy("jboss-ejb-policy");
            } else if (layer == ResourceType.WEB) {
                aPolicy = SecurityConfiguration.getApplicationPolicy("jboss-web-policy");
            }
        }
        if (aPolicy == null) {
            throw new IllegalStateException("PB00015: Null Value:Application Policy is null for domain:" + domainName);
        }
        AuthorizationInfo ai = aPolicy.getAuthorizationInfo();
        if (ai == null) {
            return this.getAuthorizationInfo(layer);
        }
        return aPolicy.getAuthorizationInfo();
    }

    private AuthorizationInfo getAuthorizationInfo(ResourceType layer) {
        AuthorizationInfo ai = null;
        if (layer == ResourceType.EJB) {
            ai = SecurityConfiguration.getApplicationPolicy("jboss-ejb-policy").getAuthorizationInfo();
        } else if (layer == ResourceType.WEB) {
            ai = SecurityConfiguration.getApplicationPolicy("jboss-web-policy").getAuthorizationInfo();
        } else {
            if (log.isTraceEnabled()) {
                log.trace((Object)"AuthorizationInfo not found. Providing default authorization info");
            }
            ai = new AuthorizationInfo("other");
            ai.add(new AuthorizationModuleEntry(DelegatingAuthorizationModule.class.getName()));
        }
        return ai;
    }

    private String getAdditionalErrorMessage(Exception e) {
        StringBuilder msg = new StringBuilder(" ");
        if (e != null) {
            msg.append(e.getLocalizedMessage());
        }
        return msg.toString();
    }
}

