/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.plugins;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.jboss.logging.Logger;

public class FilePassword {
    private File passwordFile;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FilePassword(String file) {
        URL url = null;
        try {
            url = new URL(file);
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        if (url == null) {
            this.passwordFile = new File(file);
            return;
        }
        FileOutputStream fos = null;
        InputStream is = null;
        try {
            try {
                int b;
                is = url.openStream();
                this.passwordFile = File.createTempFile("temp", null);
                this.passwordFile.deleteOnExit();
                fos = new FileOutputStream(this.passwordFile);
                while ((b = is.read()) >= 0) {
                    fos.write(b);
                }
                Object var7_8 = null;
                this.safeClose(fos);
            }
            catch (IOException e) {
                Object var7_9 = null;
                this.safeClose(fos);
                FilePassword.safeClose(is);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            this.safeClose(fos);
            FilePassword.safeClose(is);
            throw throwable;
        }
        FilePassword.safeClose(is);
    }

    public char[] toCharArray() throws IOException {
        RandomAccessFile raf = null;
        try {
            char[] password;
            raf = new RandomAccessFile(this.passwordFile, "r");
            char[] cArray = password = FilePassword.decode(raf);
            Object var5_6 = null;
            this.safeClose(raf);
            return cArray;
        }
        catch (Exception e) {
            try {
                Logger log = Logger.getLogger(FilePassword.class);
                log.error((Object)("Failed to decode password file: " + this.passwordFile), (Throwable)e);
                throw new IOException(e.getMessage());
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                this.safeClose(raf);
                throw throwable;
            }
        }
    }

    static char[] decode(RandomAccessFile passwordFile) throws Exception {
        int b;
        byte[] salt = new byte[8];
        passwordFile.readFully(salt);
        int count = passwordFile.readInt();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((b = passwordFile.read()) >= 0) {
            baos.write(b);
        }
        passwordFile.close();
        byte[] secret = baos.toByteArray();
        PBEParameterSpec cipherSpec = new PBEParameterSpec(salt, count);
        PBEKeySpec keySpec = new PBEKeySpec("78aac249a60a13d5e882927928043ebb".toCharArray());
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBEwithMD5andDES");
        SecretKey cipherKey = factory.generateSecret(keySpec);
        Cipher cipher = Cipher.getInstance("PBEwithMD5andDES");
        cipher.init(2, (Key)cipherKey, cipherSpec);
        byte[] decode = cipher.doFinal(secret);
        return new String(decode, "UTF-8").toCharArray();
    }

    static void encode(RandomAccessFile passwordFile, byte[] salt, int count, byte[] secret) throws Exception {
        PBEParameterSpec cipherSpec = new PBEParameterSpec(salt, count);
        PBEKeySpec keySpec = new PBEKeySpec("78aac249a60a13d5e882927928043ebb".toCharArray());
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBEwithMD5andDES");
        SecretKey cipherKey = factory.generateSecret(keySpec);
        Cipher cipher = Cipher.getInstance("PBEwithMD5andDES");
        cipher.init(1, (Key)cipherKey, cipherSpec);
        byte[] encode = cipher.doFinal(secret);
        passwordFile.write(salt);
        passwordFile.writeInt(count);
        passwordFile.write(encode);
        passwordFile.close();
    }

    private static void safeClose(InputStream fis) {
        try {
            if (fis != null) {
                fis.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void safeClose(OutputStream os) {
        try {
            if (os != null) {
                os.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void safeClose(RandomAccessFile raf) {
        try {
            if (raf != null) {
                raf.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 4) {
            System.err.println("Write a password in opaque form to a file for use with the FilePassword accessorUsage: FilePassword salt count password password-file  salt  : an 8 char sequence for PBEKeySpec  count : iteration count for PBEKeySpec  password : the clear text password to write  password-file : the path to the file to write the password to");
        }
        byte[] salt = args[0].substring(0, 8).getBytes();
        int count = Integer.parseInt(args[1]);
        byte[] passwordBytes = args[2].getBytes("UTF-8");
        RandomAccessFile passwordFile = new RandomAccessFile(args[3], "rws");
        FilePassword.encode(passwordFile, salt, count, passwordBytes);
    }
}

