/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.config.parser;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.EventFilter;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.jboss.security.config.Attribute;
import org.jboss.security.config.Element;
import org.jboss.security.config.parser.JavaPropertiesConfigParser;
import org.jboss.security.config.parser.ParserNamespaceSupport;
import org.jboss.security.config.parser.StaxParserUtil;
import org.jboss.security.config.parser.UsersConfigParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleOptionParser
implements XMLStreamConstants {
    private static final Map<String, ParserNamespaceSupport> parsers = Collections.synchronizedMap(new HashMap());

    public static void addParser(String parserName, ParserNamespaceSupport parser) {
        parsers.put(parserName, parser);
    }

    public Map<String, Object> parse(XMLEventReader xmlEventReader) throws XMLStreamException {
        XMLEvent xmlEvent;
        HashMap<String, Object> options = new HashMap<String, Object>();
        while (!((xmlEvent = xmlEventReader.peek()) instanceof EndElement)) {
            Object val;
            javax.xml.stream.events.Attribute attribute;
            block3: {
                String peekedStartElementName;
                StartElement peekedStartElement = (StartElement)xmlEvent;
                if (xmlEvent == null || !"module-option".equals(peekedStartElementName = StaxParserUtil.getStartElementName(peekedStartElement))) break;
                xmlEvent = xmlEventReader.nextEvent();
                attribute = peekedStartElement.getAttributes().next();
                val = null;
                try {
                    val = xmlEventReader.getElementText();
                }
                catch (XMLStreamException xse) {
                    XMLEvent embeddedOrText = xmlEventReader.peek();
                    if (embeddedOrText.getEventType() != 1) break block3;
                    val = this.embeddedXMLParsing(xmlEventReader);
                }
            }
            options.put(attribute.getValue(), val);
        }
        return options;
    }

    private Object embeddedXMLParsing(XMLEventReader xmlEventReader) throws XMLStreamException {
        Object retVal = null;
        XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
        xmlEventReader = xmlInputFactory.createFilteredReader(xmlEventReader, new EventFilter(){

            public boolean accept(XMLEvent xmlEvent) {
                return xmlEvent.isStartElement();
            }
        });
        while (xmlEventReader.hasNext()) {
            XMLEvent xmlEvent = xmlEventReader.peek();
            int eventType = xmlEvent.getEventType();
            switch (eventType) {
                case 1: {
                    StartElement xmlStartElement = (StartElement)xmlEvent;
                    String nsURI = xmlStartElement.getName().getNamespaceURI();
                    ParserNamespaceSupport parser = this.getSupportingParser(nsURI);
                    if (parser == null) {
                        throw StaxParserUtil.unexpectedNS(nsURI, xmlEvent);
                    }
                    return parser.parse(xmlEventReader);
                }
            }
        }
        return retVal;
    }

    private ParserNamespaceSupport getSupportingParser(String nsURI) {
        return parsers.get(nsURI);
    }

    public Map<String, Object> parse(XMLStreamReader reader) throws XMLStreamException {
        HashMap<String, Object> options = new HashMap<String, Object>();
        while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (element.equals((Object)Element.MODULE_OPTION)) {
                int count = reader.getAttributeCount();
                if (count == 0) {
                    throw StaxParserUtil.missingRequired(reader, Collections.singleton(Attribute.NAME));
                }
                String name = null;
                String optionValue = null;
                block5: for (int i = 0; i < count; ++i) {
                    String value = reader.getAttributeValue(i);
                    Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                    switch (attribute) {
                        case NAME: {
                            name = value;
                            continue block5;
                        }
                        case VALUE: {
                            optionValue = value;
                            continue block5;
                        }
                        default: {
                            throw StaxParserUtil.unexpectedAttribute(reader, i);
                        }
                    }
                }
                if (optionValue == null) {
                    optionValue = reader.getElementText();
                } else {
                    StaxParserUtil.requireNoContent(reader);
                }
                options.put(name, optionValue);
                continue;
            }
            throw StaxParserUtil.unexpectedElement(reader);
        }
        return options;
    }

    static {
        parsers.put("urn:jboss:user-roles", new UsersConfigParser());
        parsers.put("urn:jboss:java-properties", new JavaPropertiesConfigParser());
    }
}

