/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.spi;

import java.io.IOException;
import java.security.acl.Group;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.jboss.security.PicketBoxLogger;
import org.jboss.security.PicketBoxMessages;
import org.jboss.security.auth.spi.UsernamePasswordLoginModule;
import org.jboss.security.auth.spi.Util;
import org.jboss.security.util.StringPropertyReplacer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UsersRolesLoginModule
extends UsernamePasswordLoginModule {
    private static final String USER_PROPERTIES = "usersProperties";
    private static final String DEFAULT_USER_PROPERTIES = "defaultUsersProperties";
    private static final String ROLES_PROPERTIES = "rolesProperties";
    private static final String DEFAULT_ROLES_PROPERTIES = "defaultRolesProperties";
    private static final String ROLE_GROUP_SEPERATOR = "roleGroupSeperator";
    private static final String[] ALL_VALID_OPTIONS = new String[]{"usersProperties", "defaultUsersProperties", "rolesProperties", "defaultRolesProperties", "roleGroupSeperator"};
    private String defaultUsersRsrcName = "defaultUsers.properties";
    private String defaultRolesRsrcName = "defaultRoles.properties";
    private String usersRsrcName = "users.properties";
    private String rolesRsrcName = "roles.properties";
    private Properties users;
    private Properties roles;
    private char roleGroupSeperator = (char)46;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.addValidOptions(ALL_VALID_OPTIONS);
        super.initialize(subject, callbackHandler, sharedState, options);
        try {
            String option = (String)options.get(USER_PROPERTIES);
            if (option != null) {
                this.usersRsrcName = StringPropertyReplacer.replaceProperties(option);
            }
            if ((option = (String)options.get(DEFAULT_USER_PROPERTIES)) != null) {
                this.defaultUsersRsrcName = StringPropertyReplacer.replaceProperties(option);
            }
            if ((option = (String)options.get(ROLES_PROPERTIES)) != null) {
                this.rolesRsrcName = StringPropertyReplacer.replaceProperties(option);
            }
            if ((option = (String)options.get(DEFAULT_ROLES_PROPERTIES)) != null) {
                this.defaultRolesRsrcName = StringPropertyReplacer.replaceProperties(option);
            }
            if ((option = (String)options.get(ROLE_GROUP_SEPERATOR)) != null) {
                this.roleGroupSeperator = option.charAt(0);
            }
            this.users = this.createUsers(options);
            this.roles = this.createRoles(options);
        }
        catch (Exception e) {
            PicketBoxLogger.LOGGER.errorLoadingUserRolesPropertiesFiles((Throwable)e);
        }
    }

    @Override
    public boolean login() throws LoginException {
        if (this.users == null) {
            throw PicketBoxMessages.MESSAGES.missingPropertiesFile(this.usersRsrcName);
        }
        if (this.roles == null) {
            throw PicketBoxMessages.MESSAGES.missingPropertiesFile(this.rolesRsrcName);
        }
        return super.login();
    }

    @Override
    protected Group[] getRoleSets() throws LoginException {
        String targetUser = this.getUsername();
        Group[] roleSets = Util.getRoleSets(targetUser, this.roles, this.roleGroupSeperator, this);
        return roleSets;
    }

    @Override
    protected String getUsersPassword() {
        String username = this.getUsername();
        String password = null;
        if (username != null) {
            password = this.users.getProperty(username, null);
        }
        return password;
    }

    protected void loadUsers() throws IOException {
        this.users = Util.loadProperties(this.defaultUsersRsrcName, this.usersRsrcName);
    }

    protected Properties createUsers(Map<String, ?> options) throws IOException {
        this.loadUsers();
        return this.users;
    }

    protected void loadRoles() throws IOException {
        this.roles = Util.loadProperties(this.defaultRolesRsrcName, this.rolesRsrcName);
    }

    protected Properties createRoles(Map<String, ?> options) throws IOException {
        this.loadRoles();
        return this.roles;
    }

    protected void parseGroupMembers(Group group, String roles) {
        Util.parseGroupMembers(group, roles, this);
    }
}

