/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.message.config;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SecurityActions {
    SecurityActions() {
    }

    static ClassLoader getContextClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    static SecurityContext getSecurityContext() {
        return AccessController.doPrivileged(new PrivilegedAction<SecurityContext>(){

            @Override
            public SecurityContext run() {
                return SecurityContextAssociation.getSecurityContext();
            }
        });
    }

    static Class<?> loadClass(final ClassLoader cl, final String name) throws PrivilegedActionException {
        return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){

            @Override
            public Class<?> run() throws PrivilegedActionException {
                if (cl == null) {
                    return SecurityActions.loadClass(name);
                }
                try {
                    return cl.loadClass(name);
                }
                catch (Exception ignore) {
                    return SecurityActions.loadClass(name);
                }
            }
        });
    }

    static Class<?> loadClass(final String name) throws PrivilegedActionException {
        return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){

            @Override
            public Class<?> run() throws PrivilegedActionException {
                try {
                    return this.getClass().getClassLoader().loadClass(name);
                }
                catch (Exception ignore) {
                    try {
                        return SecurityActions.getContextClassLoader().loadClass(name);
                    }
                    catch (Exception e) {
                        throw new PrivilegedActionException(e);
                    }
                }
            }
        });
    }
}

