/*
 * Decompiled with CFR 0.152.
 */
package org.picketbox.plugins.vault;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.jboss.logging.Logger;
import org.jboss.security.plugins.PBEUtils;
import org.jboss.security.vault.SecurityVault;
import org.jboss.security.vault.SecurityVaultException;
import org.jboss.util.Base64;
import org.picketbox.util.EncryptionUtil;
import org.picketbox.util.KeyStoreUtil;
import org.picketbox.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PicketBoxSecurityVault
implements SecurityVault {
    protected static Logger log = Logger.getLogger(PicketBoxSecurityVault.class);
    protected boolean finishedInit = false;
    protected KeyStore keystore = null;
    private KeyPair keypair = null;
    protected String encryptionAlgorithm = "AES";
    protected int keySize = 128;
    private char[] keyStorePWD = null;
    protected Map<String, byte[]> theContent = new ConcurrentHashMap<String, byte[]>();
    protected Map<String, byte[]> sharedKeyMap = new ConcurrentHashMap<String, byte[]>();
    public static final String ENC_FILE_DIR = "ENC_FILE_DIR";
    public static final String KEYSTORE_URL = "KEYSTORE_URL";
    public static final String KEYSTORE_PASSWORD = "KEYSTORE_PASSWORD";
    public static final String KEYSTORE_ALIAS = "KEYSTORE_ALIAS";
    public static final String SALT = "SALT";
    public static final String ITERATION_COUNT = "ITERATION_COUNT";
    public static final String PASS_MASK_PREFIX = "MASK-";
    public static final String PUBLIC_CERT = "PUBLIC_CERT";
    public static final String KEY_SIZE = "KEY_SIZE";
    protected static final String ENCODED_FILE = "ENC.dat";
    protected static final String SHARED_KEY_FILE = "Shared.dat";
    protected static final String ADMIN_KEY = "ADMIN_KEY";
    protected String decodedEncFileDir;
    protected String LINE_BREAK = "LINE_BREAK";

    public void init(Map<String, Object> options) throws SecurityVaultException {
        String encFileDir;
        if (options == null) {
            throw new SecurityVaultException("Options is null");
        }
        if (options.isEmpty()) {
            throw new SecurityVaultException("Options is empty");
        }
        String keystoreURL = (String)options.get(KEYSTORE_URL);
        if (keystoreURL == null) {
            throw new SecurityVaultException("Null KEYSTORE_URL");
        }
        String maskedPassword = (String)options.get(KEYSTORE_PASSWORD);
        if (maskedPassword == null) {
            throw new SecurityVaultException("Null masked keystore password");
        }
        if (!maskedPassword.startsWith(PASS_MASK_PREFIX)) {
            throw new SecurityVaultException("Keystore password is not masked");
        }
        String salt = (String)options.get(SALT);
        if (salt == null) {
            throw new SecurityVaultException("Salt is null");
        }
        String iterationCountStr = (String)options.get(ITERATION_COUNT);
        if (iterationCountStr == null) {
            throw new SecurityVaultException("Iteration Count is not set");
        }
        int iterationCount = Integer.parseInt(iterationCountStr);
        String alias = (String)options.get(KEYSTORE_ALIAS);
        if (alias == null) {
            throw new SecurityVaultException("Keystore Alias is null");
        }
        String keySizeStr = (String)options.get(KEY_SIZE);
        if (keySizeStr != null) {
            this.keySize = Integer.parseInt(keySizeStr);
        }
        if ((encFileDir = (String)options.get(ENC_FILE_DIR)) == null) {
            throw new SecurityVaultException("Option ENC_FILE_DIR is missing");
        }
        try {
            this.decodedEncFileDir = StringUtil.getSystemPropertyAsString(encFileDir);
            if (!this.directoryExists(this.decodedEncFileDir)) {
                throw new SecurityVaultException(this.decodedEncFileDir + " does not exist");
            }
            if (!this.decodedEncFileDir.endsWith("/") && !this.decodedEncFileDir.endsWith("\\")) {
                throw new SecurityVaultException(this.decodedEncFileDir + "does not end with / or \\");
            }
            if (!this.encodedFileExists(this.decodedEncFileDir)) {
                this.setUpVault(this.decodedEncFileDir);
            }
            FileInputStream fis = new FileInputStream(this.decodedEncFileDir + ENCODED_FILE);
            ObjectInputStream ois = new ObjectInputStream(fis);
            this.theContent = (Map)ois.readObject();
            FileInputStream mapFile = new FileInputStream(this.decodedEncFileDir + SHARED_KEY_FILE);
            ObjectInputStream mapIS = new ObjectInputStream(mapFile);
            this.sharedKeyMap = (Map)mapIS.readObject();
        }
        catch (Exception e) {
            throw new SecurityVaultException((Throwable)e);
        }
        try {
            String keystorePass = this.decode(maskedPassword, salt, iterationCount);
            this.keyStorePWD = keystorePass.toCharArray();
            this.keystore = KeyStoreUtil.getKeyStore(keystoreURL, keystorePass.toCharArray());
            this.keypair = KeyStoreUtil.getPrivateKey(this.keystore, alias, keystorePass.toCharArray());
        }
        catch (Exception e) {
            throw new SecurityVaultException("Unable to get Keystore:", (Throwable)e);
        }
        this.finishedInit = true;
    }

    public boolean isInitialized() {
        return this.finishedInit;
    }

    public byte[] handshake(Map<String, Object> handshakeOptions) throws SecurityVaultException {
        if (handshakeOptions == null) {
            throw new SecurityVaultException("Options is null");
        }
        if (handshakeOptions.isEmpty()) {
            throw new SecurityVaultException("Options is empty");
        }
        String publicCert = (String)handshakeOptions.get(PUBLIC_CERT);
        if (publicCert == null) {
            throw new SecurityVaultException("Public Cert Alias is null");
        }
        try {
            PublicKey publicKey = KeyStoreUtil.getPublicKey(this.keystore, publicCert, this.keyStorePWD);
            if (publicKey == null) {
                throw new SecurityVaultException("Could not retrieve Public Key from KeyStore for alias:" + publicCert);
            }
        }
        catch (Exception e) {
            throw new SecurityVaultException((Throwable)e);
        }
        StringBuilder uuid = new StringBuilder(UUID.randomUUID().toString());
        uuid.append("LINE_BREAK");
        uuid.append(publicCert);
        return Base64.encodeBytes((byte[])uuid.toString().getBytes()).getBytes();
    }

    public Set<String> keyList() throws SecurityVaultException {
        Set<String> keys = this.theContent.keySet();
        keys.remove(ADMIN_KEY);
        return keys;
    }

    public void store(String vaultBlock, String attributeName, char[] attributeValue, byte[] sharedKey) throws SecurityVaultException {
        Certificate cert;
        if (StringUtil.isNullOrEmpty(vaultBlock)) {
            throw new SecurityVaultException("vaultBlock is null");
        }
        if (StringUtil.isNullOrEmpty(attributeName)) {
            throw new SecurityVaultException("attributeName is null");
        }
        String mapKey = vaultBlock + "_" + attributeName;
        this.sharedKeyMap.put(mapKey, sharedKey);
        String av = new String(attributeValue);
        String decodedSharedKey = new String(Base64.decode((String)new String(sharedKey)));
        int index = decodedSharedKey.indexOf(this.LINE_BREAK);
        if (index < 0) {
            throw new SecurityVaultException("Shared Key is invalid");
        }
        String alias = decodedSharedKey.substring(index + this.LINE_BREAK.length());
        try {
            cert = this.keystore.getCertificate(alias);
        }
        catch (KeyStoreException e1) {
            throw new SecurityVaultException("Cannot get certificate:", (Throwable)e1);
        }
        EncryptionUtil util = new EncryptionUtil(this.encryptionAlgorithm, this.keySize);
        try {
            byte[] secretKey = this.theContent.get(ADMIN_KEY);
            SecretKeySpec sKeySpec = new SecretKeySpec(secretKey, this.encryptionAlgorithm);
            byte[] encryptedData = util.encrypt(av.getBytes(), cert.getPublicKey(), sKeySpec);
            this.theContent.put(mapKey, encryptedData);
        }
        catch (Exception e1) {
            throw new SecurityVaultException("Unable to encrypt data:", (Throwable)e1);
        }
        try {
            this.writeSharedKeyFile(this.decodedEncFileDir);
        }
        catch (IOException e) {
            throw new SecurityVaultException("Unable to write Shared Key File");
        }
        try {
            this.writeEncodedFile(this.decodedEncFileDir);
        }
        catch (IOException e) {
            throw new SecurityVaultException("Unable to write Encoded File");
        }
    }

    public char[] retrieve(String vaultBlock, String attributeName, byte[] sharedKey) throws SecurityVaultException {
        if (StringUtil.isNullOrEmpty(vaultBlock)) {
            throw new SecurityVaultException("vaultBlock is null");
        }
        if (StringUtil.isNullOrEmpty(attributeName)) {
            throw new SecurityVaultException("attributeName is null");
        }
        String mapKey = vaultBlock + "_" + attributeName;
        byte[] encryptedValue = this.theContent.get(mapKey);
        byte[] fromMap = this.sharedKeyMap.get(mapKey);
        boolean matches = Arrays.equals(sharedKey, fromMap);
        if (!matches) {
            throw new SecurityVaultException("Shared Key does not match for vault block:" + vaultBlock + " and attributeName:" + attributeName);
        }
        byte[] secretKey = this.theContent.get(ADMIN_KEY);
        SecretKeySpec secretKeySpec = new SecretKeySpec(secretKey, this.encryptionAlgorithm);
        EncryptionUtil encUtil = new EncryptionUtil(this.encryptionAlgorithm, this.keySize);
        try {
            return new String(encUtil.decrypt(encryptedValue, this.keypair, secretKeySpec)).toCharArray();
        }
        catch (Exception e) {
            throw new SecurityVaultException("Decryption of value failed:", (Throwable)e);
        }
    }

    private String decode(String maskedString, String salt, int iterationCount) throws Exception {
        String pbeAlgo = "PBEwithMD5andDES";
        if (maskedString.startsWith(PASS_MASK_PREFIX)) {
            String decodedValue;
            SecretKeyFactory factory = SecretKeyFactory.getInstance(pbeAlgo);
            char[] password = "somearbitrarycrazystringthatdoesnotmatter".toCharArray();
            PBEParameterSpec cipherSpec = new PBEParameterSpec(salt.getBytes(), iterationCount);
            PBEKeySpec keySpec = new PBEKeySpec(password);
            SecretKey cipherKey = factory.generateSecret(keySpec);
            maskedString = maskedString.substring(PASS_MASK_PREFIX.length());
            maskedString = decodedValue = PBEUtils.decode64(maskedString, pbeAlgo, cipherKey, cipherSpec);
        }
        return maskedString;
    }

    private void setUpVault(String decodedEncFileDir) throws NoSuchAlgorithmException, IOException {
        this.theContent = new ConcurrentHashMap<String, byte[]>();
        EncryptionUtil util = new EncryptionUtil(this.encryptionAlgorithm, this.keySize);
        SecretKey secretKey = util.generateKey();
        this.theContent.put(ADMIN_KEY, secretKey.getEncoded());
        this.writeEncodedFile(decodedEncFileDir);
        this.writeSharedKeyFile(decodedEncFileDir);
    }

    private void writeEncodedFile(String decodedEncFileDir) throws IOException {
        FileOutputStream fos = new FileOutputStream(decodedEncFileDir + ENCODED_FILE);
        ObjectOutputStream oos = new ObjectOutputStream(fos);
        oos.writeObject(this.theContent);
        oos.close();
    }

    private void writeSharedKeyFile(String decodedEncFileDir) throws IOException {
        FileOutputStream fos = new FileOutputStream(decodedEncFileDir + SHARED_KEY_FILE);
        ObjectOutputStream oos = new ObjectOutputStream(fos);
        oos.writeObject(this.sharedKeyMap);
        oos.close();
    }

    private boolean encodedFileExists(String decodedEncFileDir) {
        File file = new File(decodedEncFileDir + ENCODED_FILE);
        return file != null && file.exists();
    }

    private boolean directoryExists(String dir) {
        File file = new File(dir);
        return file != null && file.exists();
    }
}

