/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.mapping.providers.role;

import java.io.IOException;
import java.security.Principal;
import java.util.Map;
import java.util.Properties;
import org.jboss.logging.Logger;
import org.jboss.security.identity.RoleGroup;
import org.jboss.security.mapping.providers.role.AbstractRolesMappingProvider;
import org.jboss.security.mapping.providers.role.Util;
import org.jboss.util.StringPropertyReplacer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesRolesMappingProvider
extends AbstractRolesMappingProvider {
    protected String rolesRsrcName = "roles.properties";
    protected Properties roles;

    public void init(Map<String, Object> options) {
        this.log = Logger.getLogger(this.getClass());
        if (options != null) {
            String option = (String)options.get("rolesProperties");
            if (option != null) {
                this.rolesRsrcName = StringPropertyReplacer.replaceProperties((String)option);
            }
            try {
                this.roles = this.loadRoles();
            }
            catch (IOException ioe) {
                throw new IllegalStateException("Error loading roles properties file", ioe);
            }
        }
    }

    public void performMapping(Map<String, Object> map, RoleGroup mappedObject) {
        if (map == null || map.isEmpty()) {
            throw new IllegalArgumentException("Context Map is null or empty");
        }
        Principal principal = this.getCallerPrincipal(map);
        if (principal != null) {
            String username = principal.getName();
            Util.addRolesToGroup(username, mappedObject, this.roles, this.log);
            this.result.setMappedObject((Object)mappedObject);
        }
    }

    protected Properties loadRoles() throws IOException {
        return Util.loadProperties(this.rolesRsrcName, this.log);
    }
}

