/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.plugins.authorization;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.security.PicketBoxLogger;
import org.jboss.security.PicketBoxMessages;
import org.jboss.security.authorization.AuthorizationContext;
import org.jboss.security.authorization.AuthorizationException;
import org.jboss.security.authorization.AuthorizationModule;
import org.jboss.security.authorization.Resource;
import org.jboss.security.authorization.ResourceType;
import org.jboss.security.authorization.config.AuthorizationModuleEntry;
import org.jboss.security.authorization.modules.DelegatingAuthorizationModule;
import org.jboss.security.config.ApplicationPolicy;
import org.jboss.security.config.AuthorizationInfo;
import org.jboss.security.config.ControlFlag;
import org.jboss.security.config.SecurityConfiguration;
import org.jboss.security.identity.RoleGroup;
import org.jboss.security.plugins.ClassLoaderLocator;
import org.jboss.security.plugins.ClassLoaderLocatorFactory;
import org.jboss.security.plugins.authorization.SecurityActions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossAuthorizationContext
extends AuthorizationContext {
    private final String EJB = "jboss-ejb-policy";
    private final String WEB = "jboss-web-policy";
    private Subject authenticatedSubject = null;
    private ApplicationPolicy applicationPolicy = null;

    public JBossAuthorizationContext(String name) {
        this.securityDomainName = name;
    }

    public JBossAuthorizationContext(String name, CallbackHandler handler) {
        this(name);
        this.callbackHandler = handler;
    }

    public JBossAuthorizationContext(String name, Subject subject, CallbackHandler handler) {
        this(name, handler);
        this.authenticatedSubject = subject;
    }

    public void setApplicationPolicy(ApplicationPolicy appPolicy) {
        if (appPolicy == null) {
            throw PicketBoxMessages.MESSAGES.invalidNullArgument("appPolicy");
        }
        AuthorizationInfo authzInfo = appPolicy.getAuthorizationInfo();
        if (authzInfo == null) {
            throw PicketBoxMessages.MESSAGES.failedToObtainInfoFromAppPolicy("AuthorizationInfo");
        }
        if (!authzInfo.getName().equals(this.securityDomainName)) {
            throw PicketBoxMessages.MESSAGES.unexpectedSecurityDomainInInfo("AuthorizationInfo", this.securityDomainName);
        }
        this.applicationPolicy = appPolicy;
    }

    public int authorize(Resource resource) throws AuthorizationException {
        return this.authorize(resource, this.authenticatedSubject, (RoleGroup)resource.getMap().get("securityContextRoles"));
    }

    public int authorize(final Resource resource, Subject subject, RoleGroup callerRoles) throws AuthorizationException {
        final ArrayList<AuthorizationModule> modules = new ArrayList<AuthorizationModule>();
        final ArrayList<ControlFlag> controlFlags = new ArrayList<ControlFlag>();
        try {
            try {
                this.authenticatedSubject = subject;
                this.initializeModules(resource, callerRoles, modules, controlFlags);
                AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws AuthorizationException {
                        int result = JBossAuthorizationContext.this.invokeAuthorize(resource, modules, controlFlags);
                        if (result == 1) {
                            JBossAuthorizationContext.this.invokeCommit(modules, controlFlags);
                        }
                        if (result == -1) {
                            JBossAuthorizationContext.this.invokeAbort(modules, controlFlags);
                            throw new AuthorizationException(PicketBoxMessages.MESSAGES.authorizationFailedMessage());
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Exception exc = e.getException();
                this.invokeAbort(modules, controlFlags);
                throw (AuthorizationException)exc;
            }
        }
        finally {
            if (modules != null) {
                modules.clear();
            }
            if (controlFlags != null) {
                controlFlags.clear();
            }
        }
        return 1;
    }

    private void initializeModules(Resource resource, RoleGroup role, List<AuthorizationModule> modules, List<ControlFlag> controlFlags) throws PrivilegedActionException {
        AuthorizationModuleEntry[] entries;
        ClassLoaderLocator cll;
        AuthorizationInfo authzInfo = this.getAuthorizationInfo(this.securityDomainName, resource);
        if (authzInfo == null) {
            throw PicketBoxMessages.MESSAGES.failedToObtainAuthorizationInfo(this.securityDomainName);
        }
        ClassLoader moduleCL = null;
        String jbossModuleName = authzInfo.getJBossModuleName();
        if (jbossModuleName != null && (cll = ClassLoaderLocatorFactory.get()) != null) {
            moduleCL = cll.get(jbossModuleName);
        }
        int len = (entries = authzInfo.getAuthorizationModuleEntry()) != null ? entries.length : 0;
        int i = 0;
        while (i < len) {
            AuthorizationModuleEntry entry = entries[i];
            ControlFlag flag = entry.getControlFlag();
            if (flag == null) {
                flag = ControlFlag.REQUIRED;
            }
            controlFlags.add(flag);
            AuthorizationModule module = this.instantiateModule(moduleCL, entry.getPolicyModuleName(), entry.getOptions(), role);
            modules.add(module);
            ++i;
        }
    }

    private int invokeAuthorize(Resource resource, List<AuthorizationModule> modules, List<ControlFlag> controlFlags) throws AuthorizationException {
        boolean encounteredRequiredError = false;
        boolean encounteredOptionalError = false;
        AuthorizationException moduleException = null;
        int overallDecision = -1;
        int length = modules.size();
        int i = 0;
        while (i < length) {
            int decision;
            ControlFlag flag;
            AuthorizationModule module;
            block15: {
                module = modules.get(i);
                flag = controlFlags.get(i);
                decision = -1;
                try {
                    decision = module.authorize(resource);
                }
                catch (Exception ae) {
                    decision = -1;
                    if (moduleException != null) break block15;
                    moduleException = new AuthorizationException(ae.getMessage());
                }
            }
            if (decision == 1) {
                overallDecision = 1;
                if (flag == ControlFlag.SUFFICIENT && !encounteredRequiredError) {
                    return 1;
                }
            } else {
                if (flag == ControlFlag.REQUISITE) {
                    PicketBoxLogger.LOGGER.debugRequisiteModuleFailure(module.getClass().getName());
                    if (moduleException == null) {
                        moduleException = new AuthorizationException(PicketBoxMessages.MESSAGES.authorizationFailedMessage());
                    } else {
                        throw moduleException;
                    }
                }
                if (flag == ControlFlag.REQUIRED) {
                    PicketBoxLogger.LOGGER.debugRequiredModuleFailure(module.getClass().getName());
                    if (!encounteredRequiredError) {
                        encounteredRequiredError = true;
                    }
                }
                if (flag == ControlFlag.OPTIONAL) {
                    encounteredOptionalError = true;
                }
            }
            ++i;
        }
        String msg = this.getAdditionalErrorMessage((Exception)moduleException);
        if (encounteredRequiredError) {
            throw new AuthorizationException(String.valueOf(PicketBoxMessages.MESSAGES.authorizationFailedMessage()) + msg);
        }
        if (overallDecision == -1 && encounteredOptionalError) {
            throw new AuthorizationException(String.valueOf(PicketBoxMessages.MESSAGES.authorizationFailedMessage()) + msg);
        }
        if (overallDecision == -1) {
            throw new AuthorizationException(PicketBoxMessages.MESSAGES.authorizationFailedMessage());
        }
        return 1;
    }

    private void invokeCommit(List<AuthorizationModule> modules, List<ControlFlag> controlFlags) throws AuthorizationException {
        int length = modules.size();
        int i = 0;
        while (i < length) {
            AuthorizationModule module = modules.get(i);
            boolean bool = module.commit();
            if (!bool) {
                throw new AuthorizationException(PicketBoxMessages.MESSAGES.moduleCommitFailedMessage());
            }
            ++i;
        }
    }

    private void invokeAbort(List<AuthorizationModule> modules, List<ControlFlag> controlFlags) throws AuthorizationException {
        int length = modules.size();
        int i = 0;
        while (i < length) {
            AuthorizationModule module = modules.get(i);
            boolean bool = module.abort();
            if (!bool) {
                throw new AuthorizationException(PicketBoxMessages.MESSAGES.moduleAbortFailedMessage());
            }
            ++i;
        }
    }

    private AuthorizationModule instantiateModule(ClassLoader cl, String name, Map<String, Object> map, RoleGroup subjectRoles) throws PrivilegedActionException {
        AuthorizationModule am = null;
        try {
            Class<?> clazz;
            try {
                if (cl == null) {
                    cl = ((Object)((Object)this)).getClass().getClassLoader();
                }
                clazz = cl.loadClass(name);
            }
            catch (Exception ignore) {
                ClassLoader tcl = SecurityActions.getContextClassLoader();
                clazz = tcl.loadClass(name);
            }
            am = (AuthorizationModule)clazz.newInstance();
        }
        catch (Exception e) {
            PicketBoxLogger.LOGGER.debugFailureToInstantiateClass(name, (Throwable)e);
        }
        if (am == null) {
            throw new IllegalStateException(PicketBoxMessages.MESSAGES.failedToInstantiateClassMessage(AuthorizationModule.class));
        }
        am.initialize(this.authenticatedSubject, this.callbackHandler, this.sharedState, map, subjectRoles);
        return am;
    }

    private AuthorizationInfo getAuthorizationInfo(String domainName, Resource resource) {
        ResourceType layer = resource.getLayer();
        if (this.applicationPolicy != null) {
            return this.applicationPolicy.getAuthorizationInfo();
        }
        ApplicationPolicy aPolicy = SecurityConfiguration.getApplicationPolicy(domainName);
        if (aPolicy == null) {
            if (layer == ResourceType.EJB) {
                aPolicy = SecurityConfiguration.getApplicationPolicy("jboss-ejb-policy");
            } else if (layer == ResourceType.WEB) {
                aPolicy = SecurityConfiguration.getApplicationPolicy("jboss-web-policy");
            }
        }
        if (aPolicy == null) {
            throw PicketBoxMessages.MESSAGES.failedToObtainApplicationPolicy(domainName);
        }
        AuthorizationInfo ai = aPolicy.getAuthorizationInfo();
        if (ai == null) {
            return this.getAuthorizationInfo(layer);
        }
        return aPolicy.getAuthorizationInfo();
    }

    private AuthorizationInfo getAuthorizationInfo(ResourceType layer) {
        AuthorizationInfo ai = null;
        if (layer == ResourceType.EJB) {
            ai = SecurityConfiguration.getApplicationPolicy("jboss-ejb-policy").getAuthorizationInfo();
        } else if (layer == ResourceType.WEB) {
            ai = SecurityConfiguration.getApplicationPolicy("jboss-web-policy").getAuthorizationInfo();
        } else {
            ai = new AuthorizationInfo("other");
            ai.add(new AuthorizationModuleEntry(DelegatingAuthorizationModule.class.getName()));
        }
        return ai;
    }

    private String getAdditionalErrorMessage(Exception e) {
        StringBuilder msg = new StringBuilder(" ");
        if (e != null) {
            msg.append(e.getLocalizedMessage());
        }
        return msg.toString();
    }
}

