/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.jacc;

import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;
import javax.security.jacc.EJBMethodPermission;
import javax.security.jacc.EJBRoleRefPermission;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import javax.security.jacc.WebResourcePermission;
import javax.security.jacc.WebRoleRefPermission;
import javax.security.jacc.WebUserDataPermission;
import org.jboss.security.PicketBoxMessages;
import org.jboss.security.jacc.ContextPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegatingPolicy
extends Policy {
    private static DelegatingPolicy instance;
    private Policy delegate;
    private ConcurrentHashMap<String, ContextPolicy> activePolicies = new ConcurrentHashMap();
    private ConcurrentHashMap<String, ContextPolicy> openPolicies = new ConcurrentHashMap();
    private PolicyProxy policyProxy = new PolicyProxy(this);
    private Class<?>[] externalPermissionTypes = new Class[0];

    public static synchronized DelegatingPolicy getInstance() {
        if (instance == null) {
            instance = new DelegatingPolicy();
        }
        return instance;
    }

    public DelegatingPolicy() {
        this(null);
    }

    public DelegatingPolicy(Policy delegate) {
        RuntimePermission permission;
        if (delegate == null) {
            delegate = Policy.getPolicy();
        }
        this.delegate = delegate;
        if (instance == null) {
            instance = this;
        }
        boolean loadedPerms = !((permission = new RuntimePermission("test")) instanceof EJBMethodPermission) && !(permission instanceof EJBRoleRefPermission) && !(permission instanceof WebResourcePermission) && !(permission instanceof WebRoleRefPermission) && !(permission instanceof WebUserDataPermission);
        Class<PolicyContext> c = PolicyContext.class;
    }

    public Class<?>[] getExternalPermissionTypes() {
        return this.externalPermissionTypes;
    }

    public void setExternalPermissionTypes(Class<?>[] externalPermissionTypes) {
        if (externalPermissionTypes == null) {
            externalPermissionTypes = new Class[]{};
        }
        this.externalPermissionTypes = externalPermissionTypes;
    }

    @Override
    public PermissionCollection getPermissions(ProtectionDomain domain) {
        PermissionCollection pc = super.getPermissions(domain);
        PermissionCollection delegated = this.delegate.getPermissions(domain);
        Enumeration<Permission> e = delegated.elements();
        while (e.hasMoreElements()) {
            Permission p = e.nextElement();
            pc.add(p);
        }
        return pc;
    }

    @Override
    public boolean implies(ProtectionDomain domain, Permission permission) {
        boolean isJaccPermission = permission instanceof EJBMethodPermission || permission instanceof EJBRoleRefPermission || permission instanceof WebResourcePermission || permission instanceof WebRoleRefPermission || permission instanceof WebUserDataPermission;
        boolean implied = false;
        if (!isJaccPermission && this.externalPermissionTypes.length > 0) {
            Class<?> pc = permission.getClass();
            int n = 0;
            while (n < this.externalPermissionTypes.length) {
                Class<?> epc = this.externalPermissionTypes[n];
                if (epc.isAssignableFrom(pc)) {
                    isJaccPermission = true;
                    break;
                }
                ++n;
            }
        }
        if (!isJaccPermission) {
            implied = this.delegate.implies(domain, permission);
        } else {
            String contextID = PolicyContext.getContextID();
            ContextPolicy contextPolicy = this.activePolicies.get(contextID);
            if (contextPolicy != null) {
                implied = contextPolicy.implies(domain, permission);
            }
        }
        return implied;
    }

    @Override
    public PermissionCollection getPermissions(CodeSource cs) {
        PermissionCollection pc = null;
        String contextID = PolicyContext.getContextID();
        if (contextID == null) {
            pc = this.delegate.getPermissions(cs);
        } else {
            ContextPolicy policy = this.activePolicies.get(contextID);
            if (policy != null) {
                pc = policy.getPermissions();
                PermissionCollection delegatePerms = this.delegate.getPermissions(cs);
                Enumeration<Permission> e = delegatePerms.elements();
                while (e.hasMoreElements()) {
                    pc.add(e.nextElement());
                }
            } else {
                pc = this.delegate.getPermissions(cs);
            }
        }
        return pc;
    }

    @Override
    public void refresh() {
    }

    public String listContextPolicies() {
        ContextPolicy cp;
        StringBuffer tmp = new StringBuffer("<ActiveContextPolicies>");
        for (String contextID : this.activePolicies.keySet()) {
            cp = this.activePolicies.get(contextID);
            tmp.append(cp);
            tmp.append('\n');
        }
        tmp.append("</ActiveContextPolicies>");
        tmp.append("<OpenContextPolicies>");
        for (String contextID : this.openPolicies.keySet()) {
            cp = this.openPolicies.get(contextID);
            tmp.append(cp);
            tmp.append('\n');
        }
        tmp.append("</OpenContextPolicies>");
        return tmp.toString();
    }

    public Policy getPolicyProxy() {
        return this.policyProxy;
    }

    synchronized ContextPolicy getContextPolicy(String contextID) throws PolicyContextException {
        ContextPolicy policy = this.openPolicies.get(contextID);
        if (policy == null) {
            throw new PolicyContextException(PicketBoxMessages.MESSAGES.noPolicyContextForIdMessage(contextID));
        }
        return policy;
    }

    synchronized void initPolicyConfiguration(String contextID, boolean remove) throws PolicyContextException {
        ContextPolicy policy = this.activePolicies.remove(contextID);
        if (policy == null) {
            policy = this.openPolicies.get(contextID);
        }
        if (policy == null) {
            policy = new ContextPolicy(contextID);
        }
        this.openPolicies.put(contextID, policy);
        if (remove) {
            policy.clear();
        }
    }

    void addToExcludedPolicy(String contextID, Permission permission) throws PolicyContextException {
        ContextPolicy policy = this.getContextPolicy(contextID);
        policy.addToExcludedPolicy(permission);
    }

    void addToExcludedPolicy(String contextID, PermissionCollection permissions) throws PolicyContextException {
        ContextPolicy policy = this.getContextPolicy(contextID);
        policy.addToExcludedPolicy(permissions);
    }

    void addToRole(String contextID, String roleName, Permission permission) throws PolicyContextException {
        ContextPolicy policy = this.getContextPolicy(contextID);
        policy.addToRole(roleName, permission);
    }

    void addToRole(String contextID, String roleName, PermissionCollection permissions) throws PolicyContextException {
        ContextPolicy policy = this.getContextPolicy(contextID);
        policy.addToRole(roleName, permissions);
    }

    void addToUncheckedPolicy(String contextID, Permission permission) throws PolicyContextException {
        ContextPolicy policy = this.getContextPolicy(contextID);
        policy.addToUncheckedPolicy(permission);
    }

    void addToUncheckedPolicy(String contextID, PermissionCollection permissions) throws PolicyContextException {
        ContextPolicy policy = this.getContextPolicy(contextID);
        policy.addToUncheckedPolicy(permissions);
    }

    void linkConfiguration(String contextID, PolicyConfiguration link) throws PolicyContextException {
        ContextPolicy policy = this.getContextPolicy(contextID);
        ContextPolicy linkPolicy = this.getContextPolicy(link.getContextID());
        policy.linkConfiguration(linkPolicy);
    }

    public void commit(String contextID) throws PolicyContextException {
        ContextPolicy policy = this.getContextPolicy(contextID);
        this.openPolicies.remove(contextID);
        this.activePolicies.put(contextID, policy);
        policy.commit();
    }

    public void delete(String contextID) throws PolicyContextException {
        ContextPolicy policy = this.activePolicies.remove(contextID);
        if (policy == null) {
            policy = this.openPolicies.remove(contextID);
        }
        if (policy != null) {
            policy.delete();
        }
    }

    void removeExcludedPolicy(String contextID) throws PolicyContextException {
        ContextPolicy policy = this.getContextPolicy(contextID);
        policy.removeExcludedPolicy();
    }

    void removeRole(String contextID, String roleName) throws PolicyContextException {
        ContextPolicy policy = this.getContextPolicy(contextID);
        policy.removeRole(roleName);
    }

    void removeUncheckedPolicy(String contextID) throws PolicyContextException {
        ContextPolicy policy = this.getContextPolicy(contextID);
        policy.removeUncheckedPolicy();
    }

    private static class PolicyProxy
    extends Policy {
        private Policy delegate;

        PolicyProxy(Policy delegate) {
            this.delegate = delegate;
        }

        public void refresh() {
            this.delegate.refresh();
        }

        public PermissionCollection getPermissions(CodeSource codesource) {
            return this.delegate.getPermissions(codesource);
        }

        public boolean implies(ProtectionDomain domain, Permission permission) {
            return this.delegate.implies(domain, permission);
        }

        public PermissionCollection getPermissions(ProtectionDomain domain) {
            return this.delegate.getPermissions(domain);
        }
    }
}

