/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.config.parser;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.jboss.security.authorization.config.AuthorizationModuleEntry;
import org.jboss.security.config.Attribute;
import org.jboss.security.config.ControlFlag;
import org.jboss.security.config.Element;
import org.jboss.security.config.parser.ModuleOptionParser;
import org.jboss.security.config.parser.StaxParserUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthorizationConfigParser
implements XMLStreamConstants {
    public Set<AuthorizationModuleEntry> parse(XMLEventReader xmlEventReader) throws XMLStreamException {
        LinkedHashSet<AuthorizationModuleEntry> entries = new LinkedHashSet<AuthorizationModuleEntry>();
        while (xmlEventReader.hasNext()) {
            XMLEvent xmlEvent = xmlEventReader.peek();
            StartElement peekedStartElement = (StartElement)xmlEvent;
            AuthorizationModuleEntry entry = null;
            if (!"policy-module".equals(StaxParserUtil.getStartElementName(peekedStartElement))) break;
            entry = this.getEntry(xmlEventReader);
            entries.add(entry);
        }
        return entries;
    }

    private AuthorizationModuleEntry getEntry(XMLEventReader xmlEventReader) throws XMLStreamException {
        XMLEvent xmlEvent = xmlEventReader.nextEvent();
        HashMap<String, Object> options = new HashMap<String, Object>();
        String codeName = null;
        ControlFlag controlFlag = ControlFlag.REQUIRED;
        StartElement policyModuleElement = (StartElement)xmlEvent;
        Iterator<javax.xml.stream.events.Attribute> attrs = policyModuleElement.getAttributes();
        while (attrs.hasNext()) {
            javax.xml.stream.events.Attribute attribute = attrs.next();
            QName attQName = attribute.getName();
            String attributeValue = StaxParserUtil.getAttributeValue(attribute);
            if ("code".equals(attQName.getLocalPart())) {
                codeName = attributeValue;
                continue;
            }
            if (!"flag".equals(attQName.getLocalPart())) continue;
            controlFlag = ControlFlag.valueOf((String)attributeValue);
        }
        ModuleOptionParser moParser = new ModuleOptionParser();
        options.putAll(moParser.parse(xmlEventReader));
        AuthorizationModuleEntry entry = new AuthorizationModuleEntry(codeName, options);
        entry.setControlFlag(controlFlag);
        return entry;
    }

    public Set<AuthorizationModuleEntry> parse(XMLStreamReader reader) throws XMLStreamException {
        LinkedHashSet<AuthorizationModuleEntry> entries = new LinkedHashSet<AuthorizationModuleEntry>();
        while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            AuthorizationModuleEntry entry = null;
            if (!element.equals((Object)Element.POLICY_MODULE)) {
                throw StaxParserUtil.unexpectedElement(reader);
            }
            entry = this.getEntry(reader);
            entries.add(entry);
        }
        return entries;
    }

    private AuthorizationModuleEntry getEntry(XMLStreamReader reader) throws XMLStreamException {
        HashMap<String, Object> options = new HashMap<String, Object>();
        String codeName = null;
        ControlFlag controlFlag = ControlFlag.REQUIRED;
        int count = reader.getAttributeCount();
        if (count < 2) {
            HashSet<Attribute> set = new HashSet<Attribute>();
            set.add(Attribute.CODE);
            set.add(Attribute.FLAG);
            throw StaxParserUtil.missingRequired(reader, set);
        }
        int i = 0;
        while (i < count) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CODE: {
                    codeName = value;
                    break;
                }
                case FLAG: {
                    controlFlag = ControlFlag.valueOf((String)value);
                    break;
                }
                default: {
                    throw StaxParserUtil.unexpectedAttribute(reader, i);
                }
            }
            ++i;
        }
        ModuleOptionParser moParser = new ModuleOptionParser();
        options.putAll(moParser.parse(reader));
        AuthorizationModuleEntry entry = new AuthorizationModuleEntry(codeName, options);
        entry.setControlFlag(controlFlag);
        return entry;
    }
}

