/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.spi;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.acl.Group;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.jboss.security.PicketBoxLogger;
import org.jboss.security.PicketBoxMessages;
import org.jboss.security.auth.spi.SecurityActions;
import org.jboss.security.auth.spi.UsernamePasswordLoginModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UsersLoginModule
extends UsernamePasswordLoginModule {
    private static final String USER_PROPERTIES = "usersProperties";
    private static final String[] ALL_VALID_OPTIONS = new String[]{"usersProperties"};
    private String usersRsrcName = "users.properties";
    private Properties users;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.addValidOptions(ALL_VALID_OPTIONS);
        super.initialize(subject, callbackHandler, sharedState, options);
        try {
            String option = (String)options.get(USER_PROPERTIES);
            if (option != null) {
                this.usersRsrcName = option;
            }
            this.loadUsers();
        }
        catch (Exception e) {
            PicketBoxLogger.LOGGER.errorLoadingUserRolesPropertiesFiles((Throwable)e);
        }
    }

    @Override
    public boolean login() throws LoginException {
        if (this.users == null) {
            throw PicketBoxMessages.MESSAGES.missingPropertiesFile(this.usersRsrcName);
        }
        return super.login();
    }

    @Override
    protected Group[] getRoleSets() throws LoginException {
        return new Group[0];
    }

    @Override
    protected String getUsersPassword() {
        String username = this.getUsername();
        String password = null;
        if (username != null) {
            password = this.users.getProperty(username, null);
        }
        return password;
    }

    private void loadUsers() throws IOException {
        this.users = this.loadProperties(this.usersRsrcName);
    }

    private Properties loadProperties(String propertiesName) throws IOException {
        Properties bundle = null;
        ClassLoader loader = SecurityActions.getContextClassLoader();
        URL url = loader.getResource(propertiesName);
        if (url == null) {
            throw PicketBoxMessages.MESSAGES.unableToFindPropertiesFile(propertiesName);
        }
        InputStream is = null;
        try {
            is = url.openStream();
            if (is == null) {
                throw PicketBoxMessages.MESSAGES.unableToLoadPropertiesFile(propertiesName);
            }
            bundle = new Properties();
            bundle.load(is);
            Properties properties = bundle;
            return properties;
        }
        finally {
            this.safeClose(is);
        }
    }
}

