/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.message.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.AuthStatus;
import javax.security.auth.message.MessageInfo;
import javax.security.auth.message.config.ServerAuthContext;
import javax.security.auth.message.module.ServerAuthModule;
import org.jboss.security.PicketBoxMessages;
import org.jboss.security.config.ControlFlag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossServerAuthContext
implements ServerAuthContext {
    private List<ServerAuthModule> modules = new ArrayList<ServerAuthModule>();
    private Map<String, Map> moduleOptionsByName = new HashMap<String, Map>();
    protected List<ControlFlag> controlFlags = new ArrayList<ControlFlag>();

    public JBossServerAuthContext(List<ServerAuthModule> modules, Map<String, Map> moduleNameToOptions, CallbackHandler cbh) throws AuthException {
        this.modules = modules;
        this.moduleOptionsByName = moduleNameToOptions;
        for (ServerAuthModule sam : modules) {
            sam.initialize(null, null, cbh, this.moduleOptionsByName.get(sam.getClass().getName()));
        }
    }

    public void setControlFlags(List<ControlFlag> controlFlags) {
        this.controlFlags = controlFlags;
    }

    public void cleanSubject(MessageInfo messageInfo, Subject subject) throws AuthException {
        for (ServerAuthModule sam : this.modules) {
            sam.cleanSubject(messageInfo, subject);
        }
    }

    public AuthStatus secureResponse(MessageInfo messageInfo, Subject serviceSubject) throws AuthException {
        AuthStatus status = null;
        for (ServerAuthModule sam : this.modules) {
            status = sam.secureResponse(messageInfo, serviceSubject);
        }
        return status;
    }

    public AuthStatus validateRequest(MessageInfo messageInfo, Subject clientSubject, Subject serviceSubject) throws AuthException {
        ArrayList<ServerAuthModule> supportingModules = new ArrayList<ServerAuthModule>();
        Class<?> requestType = messageInfo.getRequestMessage().getClass();
        Class<?>[] requestInterfaces = requestType.getInterfaces();
        List<Class<?>> intfaee = Arrays.asList(requestInterfaces);
        for (ServerAuthModule sam : this.modules) {
            List<Class> supportedTypes = Arrays.asList(sam.getSupportedMessageTypes());
            for (Class<?> clazz : intfaee) {
                if (!supportedTypes.contains(clazz) || supportingModules.contains(sam)) continue;
                supportingModules.add(sam);
            }
            if (!supportedTypes.contains(Object.class) && !supportedTypes.contains(requestType) || supportingModules.contains(sam)) continue;
            supportingModules.add(sam);
        }
        if (supportingModules.size() == 0) {
            throw PicketBoxMessages.MESSAGES.noServerAuthModuleForRequestType(requestType);
        }
        AuthStatus authStatus = this.invokeModules(messageInfo, clientSubject, serviceSubject);
        return authStatus;
    }

    private AuthStatus invokeModules(MessageInfo messageInfo, Subject clientSubject, Subject serviceSubject) throws AuthException {
        boolean encounteredRequiredError = false;
        boolean encounteredOptionalError = false;
        AuthException moduleException = null;
        AuthStatus overallDecision = AuthStatus.FAILURE;
        int length = this.modules.size();
        int i = 0;
        while (i < length) {
            AuthStatus decision;
            ControlFlag flag;
            block14: {
                ServerAuthModule module = this.modules.get(i);
                flag = this.controlFlags.get(i);
                decision = AuthStatus.FAILURE;
                try {
                    decision = module.validateRequest(messageInfo, clientSubject, serviceSubject);
                }
                catch (Exception ae) {
                    decision = AuthStatus.FAILURE;
                    if (moduleException != null) break block14;
                    moduleException = new AuthException(ae.getMessage());
                }
            }
            if (decision == AuthStatus.SUCCESS) {
                overallDecision = AuthStatus.SUCCESS;
                if (flag == ControlFlag.SUFFICIENT && !encounteredRequiredError) {
                    return AuthStatus.SUCCESS;
                }
            } else {
                if (flag == ControlFlag.REQUISITE) {
                    if (moduleException == null) {
                        moduleException = new AuthException(PicketBoxMessages.MESSAGES.authenticationFailedMessage());
                    } else {
                        throw moduleException;
                    }
                }
                if (flag == ControlFlag.REQUIRED && !encounteredRequiredError) {
                    encounteredRequiredError = true;
                }
                if (flag == ControlFlag.OPTIONAL) {
                    encounteredOptionalError = true;
                }
            }
            ++i;
        }
        String msg = this.getAdditionalErrorMessage((Exception)((Object)moduleException));
        if (encounteredRequiredError) {
            throw new AuthException(String.valueOf(PicketBoxMessages.MESSAGES.authenticationFailedMessage()) + msg);
        }
        if (overallDecision == AuthStatus.FAILURE && encounteredOptionalError) {
            throw new AuthException(String.valueOf(PicketBoxMessages.MESSAGES.authenticationFailedMessage()) + msg);
        }
        if (overallDecision == AuthStatus.FAILURE) {
            throw new AuthException(PicketBoxMessages.MESSAGES.authenticationFailedMessage());
        }
        return AuthStatus.SUCCESS;
    }

    private String getAdditionalErrorMessage(Exception e) {
        StringBuilder msg = new StringBuilder(" ");
        if (e != null) {
            msg.append(e.getLocalizedMessage());
        }
        return msg.toString();
    }
}

