/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.spi;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.ReferralException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.jboss.security.PicketBoxLogger;
import org.jboss.security.PicketBoxMessages;
import org.jboss.security.SimpleGroup;
import org.jboss.security.Util;
import org.jboss.security.auth.spi.DecodeAction;
import org.jboss.security.auth.spi.SecurityActions;
import org.jboss.security.auth.spi.UsernamePasswordLoginModule;
import org.jboss.security.vault.SecurityVaultUtil;

public class LdapExtLoginModule
extends UsernamePasswordLoginModule {
    private static final String ROLES_CTX_DN_OPT = "rolesCtxDN";
    private static final String ROLE_ATTRIBUTE_ID_OPT = "roleAttributeID";
    private static final String ROLE_ATTRIBUTE_IS_DN_OPT = "roleAttributeIsDN";
    private static final String ROLE_NAME_ATTRIBUTE_ID_OPT = "roleNameAttributeID";
    private static final String PARSE_ROLE_NAME_FROM_DN_OPT = "parseRoleNameFromDN";
    private static final String BIND_DN = "bindDN";
    private static final String BIND_CREDENTIAL = "bindCredential";
    private static final String BASE_CTX_DN = "baseCtxDN";
    private static final String BASE_FILTER_OPT = "baseFilter";
    private static final String ROLE_FILTER_OPT = "roleFilter";
    private static final String ROLE_RECURSION = "roleRecursion";
    private static final String DEFAULT_ROLE = "defaultRole";
    private static final String SEARCH_TIME_LIMIT_OPT = "searchTimeLimit";
    private static final String SEARCH_SCOPE_OPT = "searchScope";
    private static final String SECURITY_DOMAIN_OPT = "jaasSecurityDomain";
    private static final String DISTINGUISHED_NAME_ATTRIBUTE_OPT = "distinguishedNameAttribute";
    private static final String PARSE_USERNAME = "parseUsername";
    private static final String USERNAME_BEGIN_STRING = "usernameBeginString";
    private static final String USERNAME_END_STRING = "usernameEndString";
    private static final String ALLOW_EMPTY_PASSWORDS = "allowEmptyPasswords";
    private static final String REFERRAL_USER_ATTRIBUTE_ID_TO_CHECK = "referralUserAttributeIDToCheck";
    private static final String[] ALL_VALID_OPTIONS = new String[]{"rolesCtxDN", "roleAttributeID", "roleAttributeIsDN", "roleNameAttributeID", "parseRoleNameFromDN", "bindDN", "bindCredential", "baseCtxDN", "baseFilter", "roleFilter", "roleRecursion", "defaultRole", "searchTimeLimit", "searchScope", "jaasSecurityDomain", "distinguishedNameAttribute", "parseUsername", "usernameBeginString", "usernameEndString", "allowEmptyPasswords", "referralUserAttributeIDToCheck", "java.naming.factory.initial", "java.naming.factory.object", "java.naming.factory.state", "java.naming.factory.url.pkgs", "java.naming.provider.url", "java.naming.dns.url", "java.naming.authoritative", "java.naming.batchsize", "java.naming.referral", "java.naming.security.protocol", "java.naming.security.authentication", "java.naming.security.principal", "java.naming.security.credentials", "java.naming.language", "java.naming.applet"};
    protected String bindDN;
    protected String bindCredential;
    protected String baseDN;
    protected String baseFilter;
    protected String rolesCtxDN;
    protected String roleFilter;
    protected String roleAttributeID;
    protected String roleNameAttributeID;
    protected boolean roleAttributeIsDN;
    protected boolean parseRoleNameFromDN;
    protected int recursion = 0;
    protected int searchTimeLimit = 10000;
    protected int searchScope = 2;
    protected String distinguishedNameAttribute;
    protected boolean parseUsername;
    protected String usernameBeginString;
    protected String usernameEndString;
    protected boolean isPasswordValidated = false;
    protected String referralUserAttributeIDToCheck = null;
    private transient SimpleGroup userRoles = new SimpleGroup("Roles");

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.addValidOptions(ALL_VALID_OPTIONS);
        super.initialize(subject, callbackHandler, sharedState, options);
    }

    protected String getUsersPassword() throws LoginException {
        return "";
    }

    protected Group[] getRoleSets() throws LoginException {
        if (!this.isPasswordValidated && this.getIdentity() != this.unauthenticatedIdentity) {
            try {
                String username = this.getUsername();
                PicketBoxLogger.LOGGER.traceBindingLDAPUsername(username);
                this.createLdapInitContext(username, null);
                this.defaultRole();
            }
            catch (Exception e) {
                LoginException le = new LoginException();
                le.initCause(e);
                throw le;
            }
        }
        Group[] roleSets = new Group[]{this.userRoles};
        return roleSets;
    }

    protected boolean validatePassword(String inputPassword, String expectedPassword) {
        this.isPasswordValidated = true;
        boolean isValid = false;
        if (inputPassword != null) {
            if (inputPassword.length() == 0) {
                boolean allowEmptyPasswords = false;
                String flag = (String)this.options.get(ALLOW_EMPTY_PASSWORDS);
                if (flag != null) {
                    allowEmptyPasswords = Boolean.valueOf(flag);
                }
                if (!allowEmptyPasswords) {
                    PicketBoxLogger.LOGGER.traceRejectingEmptyPassword();
                    return false;
                }
            }
            try {
                String username = this.getUsername();
                isValid = this.createLdapInitContext(username, inputPassword);
                this.defaultRole();
                isValid = true;
            }
            catch (Throwable e) {
                super.setValidateError(e);
            }
        }
        return isValid;
    }

    private void defaultRole() {
        String defaultRole = (String)this.options.get(DEFAULT_ROLE);
        try {
            if (defaultRole == null || defaultRole.equals("")) {
                return;
            }
            Principal p = super.createIdentity(defaultRole);
            PicketBoxLogger.LOGGER.traceAssignUserToRole(defaultRole);
            this.userRoles.addMember(p);
        }
        catch (Exception e) {
            PicketBoxLogger.LOGGER.debugFailureToCreatePrincipal(defaultRole, (Throwable)e);
        }
    }

    private boolean createLdapInitContext(String username, Object credential) throws Exception {
        String scope;
        String securityDomain;
        this.bindDN = (String)this.options.get(BIND_DN);
        this.bindCredential = (String)this.options.get(BIND_CREDENTIAL);
        if (this.bindCredential != null && this.bindCredential.startsWith("{EXT}")) {
            this.bindCredential = new String(Util.loadPassword(this.bindCredential));
        }
        if ((securityDomain = (String)this.options.get(SECURITY_DOMAIN_OPT)) != null) {
            ObjectName serviceName = new ObjectName(securityDomain);
            char[] tmp = DecodeAction.decode(this.bindCredential, serviceName);
            this.bindCredential = new String(tmp);
        }
        if (this.bindCredential != null && SecurityVaultUtil.isVaultFormat((String)this.bindCredential)) {
            this.bindCredential = SecurityVaultUtil.getValueAsString((String)this.bindCredential);
        }
        this.baseDN = (String)this.options.get(BASE_CTX_DN);
        this.baseFilter = (String)this.options.get(BASE_FILTER_OPT);
        this.roleFilter = (String)this.options.get(ROLE_FILTER_OPT);
        this.roleAttributeID = (String)this.options.get(ROLE_ATTRIBUTE_ID_OPT);
        if (this.roleAttributeID == null) {
            this.roleAttributeID = "role";
        }
        String roleAttributeIsDNOption = (String)this.options.get(ROLE_ATTRIBUTE_IS_DN_OPT);
        this.roleAttributeIsDN = Boolean.valueOf(roleAttributeIsDNOption);
        this.roleNameAttributeID = (String)this.options.get(ROLE_NAME_ATTRIBUTE_ID_OPT);
        if (this.roleNameAttributeID == null) {
            this.roleNameAttributeID = "name";
        }
        this.referralUserAttributeIDToCheck = (String)this.options.get(REFERRAL_USER_ATTRIBUTE_ID_TO_CHECK);
        String parseRoleNameFromDNOption = (String)this.options.get(PARSE_ROLE_NAME_FROM_DN_OPT);
        this.parseRoleNameFromDN = Boolean.valueOf(parseRoleNameFromDNOption);
        this.rolesCtxDN = (String)this.options.get(ROLES_CTX_DN_OPT);
        String strRecursion = (String)this.options.get(ROLE_RECURSION);
        try {
            this.recursion = Integer.parseInt(strRecursion);
        }
        catch (NumberFormatException e) {
            PicketBoxLogger.LOGGER.debugFailureToParseNumberProperty(ROLE_RECURSION, 0L);
            this.recursion = 0;
        }
        String timeLimit = (String)this.options.get(SEARCH_TIME_LIMIT_OPT);
        if (timeLimit != null) {
            try {
                this.searchTimeLimit = Integer.parseInt(timeLimit);
            }
            catch (NumberFormatException e) {
                PicketBoxLogger.LOGGER.debugFailureToParseNumberProperty(SEARCH_TIME_LIMIT_OPT, (long)this.searchTimeLimit);
            }
        }
        if ("OBJECT_SCOPE".equalsIgnoreCase(scope = (String)this.options.get(SEARCH_SCOPE_OPT))) {
            this.searchScope = 0;
        } else if ("ONELEVEL_SCOPE".equalsIgnoreCase(scope)) {
            this.searchScope = 1;
        }
        if ("SUBTREE_SCOPE".equalsIgnoreCase(scope)) {
            this.searchScope = 2;
        }
        this.distinguishedNameAttribute = (String)this.options.get(DISTINGUISHED_NAME_ATTRIBUTE_OPT);
        if (this.distinguishedNameAttribute == null) {
            this.distinguishedNameAttribute = "distinguishedName";
        }
        InitialContext ctx = null;
        ClassLoader currentTCCL = SecurityActions.getContextClassLoader();
        try {
            if (currentTCCL != null) {
                SecurityActions.setContextClassLoader(null);
            }
            ctx = this.constructInitialLdapContext(this.bindDN, this.bindCredential);
            String userDN = this.bindDNAuthentication((InitialLdapContext)ctx, username, credential, this.baseDN, this.baseFilter);
            SearchControls constraints = new SearchControls();
            constraints.setSearchScope(this.searchScope);
            constraints.setTimeLimit(this.searchTimeLimit);
            this.rolesSearch((LdapContext)((Object)ctx), constraints, username, userDN, this.recursion, 0);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (ctx != null) {
                ctx.close();
            }
            if (currentTCCL != null) {
                SecurityActions.setContextClassLoader(currentTCCL);
            }
        }
        return true;
    }

    protected String bindDNAuthentication(InitialLdapContext ctx, String user, Object credential, String baseDN, String filter) throws NamingException {
        Attribute dn;
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(2);
        constraints.setTimeLimit(this.searchTimeLimit);
        String[] attrList = new String[]{this.distinguishedNameAttribute};
        constraints.setReturningAttributes(attrList);
        NamingEnumeration<SearchResult> results = null;
        Object[] filterArgs = new Object[]{user};
        LdapContext ldapCtx = ctx;
        boolean referralsLeft = true;
        NameClassPair sr = null;
        while (referralsLeft) {
            try {
                results = ldapCtx.search(baseDN, filter, filterArgs, constraints);
                if (results.hasMore()) {
                    sr = results.next();
                }
                referralsLeft = false;
            }
            catch (ReferralException e) {
                ldapCtx = (LdapContext)e.getReferralContext();
                if (results == null) continue;
                results.close();
            }
        }
        if (sr == null) {
            results.close();
            throw PicketBoxMessages.MESSAGES.failedToFindBaseContextDN(baseDN);
        }
        String name = sr.getName();
        String userDN = null;
        Attributes attrs = ((SearchResult)sr).getAttributes();
        if (attrs != null && (dn = attrs.get(this.distinguishedNameAttribute)) != null) {
            userDN = (String)dn.get();
        }
        if (userDN == null) {
            if (sr.isRelative()) {
                userDN = name + ("".equals(baseDN) ? "" : "," + baseDN);
            } else {
                throw PicketBoxMessages.MESSAGES.unableToFollowReferralForAuth(name);
            }
        }
        results.close();
        results = null;
        if (this.isPasswordValidated) {
            InitialLdapContext userCtx = this.constructInitialLdapContext(userDN, credential);
            userCtx.close();
        }
        return userDN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rolesSearch(LdapContext ctx, SearchControls constraints, String user, String userDN, int recursionMax, int nesting) throws NamingException {
        LdapContext ldapCtx = ctx;
        Object[] filterArgs = new Object[]{user, userDN};
        boolean referralsExist = true;
        while (referralsExist) {
            NamingEnumeration<SearchResult> results = ldapCtx.search(this.rolesCtxDN, this.roleFilter, filterArgs, constraints);
            try {
                while (results.hasMore()) {
                    String roleName;
                    String[] attrNames;
                    SearchResult sr = results.next();
                    String dn = sr.isRelative() ? this.canonicalize(sr.getName()) : sr.getNameInNamespace();
                    if (nesting == 0 && this.roleAttributeIsDN && this.roleNameAttributeID != null) {
                        if (this.parseRoleNameFromDN) {
                            this.parseRole(dn);
                        } else {
                            Attribute roles2;
                            attrNames = new String[]{this.roleNameAttributeID};
                            Attributes result2 = null;
                            result2 = sr.isRelative() ? ldapCtx.getAttributes(dn, attrNames) : this.getAttributesFromReferralEntity(sr, user, userDN);
                            Attribute attribute = roles2 = result2 != null ? result2.get(this.roleNameAttributeID) : null;
                            if (roles2 != null) {
                                for (int m = 0; m < roles2.size(); ++m) {
                                    roleName = (String)roles2.get(m);
                                    this.addRole(roleName);
                                }
                            }
                        }
                    }
                    attrNames = new String[]{this.roleAttributeID};
                    Attributes result = null;
                    result = sr.isRelative() ? ldapCtx.getAttributes(dn, attrNames) : this.getAttributesFromReferralEntity(sr, user, userDN);
                    if (result != null && result.size() > 0) {
                        Attribute roles = result.get(this.roleAttributeID);
                        for (int n = 0; n < roles.size(); ++n) {
                            roleName = (String)roles.get(n);
                            if (this.roleAttributeIsDN && this.parseRoleNameFromDN) {
                                this.parseRole(roleName);
                                continue;
                            }
                            if (this.roleAttributeIsDN) {
                                String roleDN = roleName;
                                String[] returnAttribute = new String[]{this.roleNameAttributeID};
                                try {
                                    Attribute roles2;
                                    Attributes result2 = null;
                                    result2 = sr.isRelative() ? ldapCtx.getAttributes(roleDN, returnAttribute) : this.getAttributesFromReferralEntity(sr, user, userDN);
                                    Attribute attribute = roles2 = result2 != null ? result2.get(this.roleNameAttributeID) : null;
                                    if (roles2 == null) continue;
                                    for (int m = 0; m < roles2.size(); ++m) {
                                        roleName = (String)roles2.get(m);
                                        this.addRole(roleName);
                                    }
                                    continue;
                                }
                                catch (NamingException e) {
                                    PicketBoxLogger.LOGGER.debugFailureToQueryLDAPAttribute(this.roleNameAttributeID, roleDN, (Throwable)e);
                                    continue;
                                }
                            }
                            this.addRole(roleName);
                        }
                    }
                    if (nesting >= recursionMax) continue;
                    this.rolesSearch(ldapCtx, constraints, user, dn, recursionMax, nesting + 1);
                }
                referralsExist = false;
            }
            catch (ReferralException e) {
                ldapCtx = (LdapContext)e.getReferralContext();
            }
            finally {
                if (results == null) continue;
                results.close();
            }
        }
    }

    private Attributes getAttributesFromReferralEntity(SearchResult sr, String ... users) throws NamingException {
        Attributes result = sr.getAttributes();
        boolean chkSuccessful = false;
        if (this.referralUserAttributeIDToCheck != null) {
            Attribute usersToCheck = result.get(this.referralUserAttributeIDToCheck);
            block0: for (int i = 0; usersToCheck != null && i < usersToCheck.size(); ++i) {
                String userDNToCheck = (String)usersToCheck.get(i);
                for (String u : users) {
                    if (!u.equals(userDNToCheck)) continue;
                    chkSuccessful = true;
                    break block0;
                }
            }
        }
        return chkSuccessful ? result : null;
    }

    private InitialLdapContext constructInitialLdapContext(String dn, Object credential) throws NamingException {
        String authType;
        Properties env = new Properties();
        for (Map.Entry entry : this.options.entrySet()) {
            env.put(entry.getKey(), entry.getValue());
        }
        String factoryName = env.getProperty("java.naming.factory.initial");
        if (factoryName == null) {
            factoryName = "com.sun.jndi.ldap.LdapCtxFactory";
            env.setProperty("java.naming.factory.initial", factoryName);
        }
        if ((authType = env.getProperty("java.naming.security.authentication")) == null) {
            env.setProperty("java.naming.security.authentication", "simple");
        }
        String protocol = env.getProperty("java.naming.security.protocol");
        String providerURL = (String)this.options.get("java.naming.provider.url");
        if (providerURL == null) {
            providerURL = "ldap://localhost:" + (protocol != null && protocol.equals("ssl") ? "636" : "389");
        }
        env.setProperty("java.naming.provider.url", providerURL);
        if (dn != null) {
            env.setProperty("java.naming.security.principal", dn);
        }
        if (credential != null) {
            env.put("java.naming.security.credentials", credential);
        }
        PicketBoxLogger.LOGGER.traceLDAPConnectionEnv(env);
        return new InitialLdapContext(env, null);
    }

    private String canonicalize(String searchResult) {
        String result = searchResult;
        int len = searchResult.length();
        String appendRolesCtxDN = "" + ("".equals(this.rolesCtxDN) ? "" : "," + this.rolesCtxDN);
        result = searchResult.endsWith("\"") ? searchResult.substring(0, len - 1) + appendRolesCtxDN + "\"" : searchResult + appendRolesCtxDN;
        return result;
    }

    private void addRole(String roleName) {
        if (roleName != null) {
            try {
                Principal p = super.createIdentity(roleName);
                PicketBoxLogger.LOGGER.traceAssignUserToRole(roleName);
                this.userRoles.addMember(p);
            }
            catch (Exception e) {
                PicketBoxLogger.LOGGER.debugFailureToCreatePrincipal(roleName, (Throwable)e);
            }
        }
    }

    private void parseRole(String dn) {
        this.parseRole(dn, this.roleNameAttributeID);
    }

    private void parseRole(String dn, String roleNameAttributeIdentifier) {
        StringTokenizer st = new StringTokenizer(dn, ",");
        while (st != null && st.hasMoreTokens()) {
            String keyVal = st.nextToken();
            if (keyVal.indexOf(roleNameAttributeIdentifier) <= -1) continue;
            StringTokenizer kst = new StringTokenizer(keyVal, "=");
            kst.nextToken();
            this.addRole(kst.nextToken());
        }
    }

    protected String getUsername() {
        String username = super.getUsername();
        this.parseUsername = Boolean.valueOf((String)this.options.get(PARSE_USERNAME));
        if (this.parseUsername) {
            this.usernameBeginString = (String)this.options.get(USERNAME_BEGIN_STRING);
            this.usernameEndString = (String)this.options.get(USERNAME_END_STRING);
            int beginIndex = 0;
            if (this.usernameBeginString != null && !this.usernameBeginString.equals("")) {
                beginIndex = username.indexOf(this.usernameBeginString) + this.usernameBeginString.length();
            }
            if (beginIndex == -1) {
                beginIndex = 0;
            }
            int endIndex = username.length();
            if (this.usernameEndString != null && !this.usernameEndString.equals("")) {
                endIndex = username.substring(beginIndex).indexOf(this.usernameEndString);
            }
            endIndex = endIndex == -1 ? username.length() : (endIndex += beginIndex);
            username = username.substring(beginIndex, endIndex);
        }
        return username;
    }
}

