/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.plugins.mapping;

import java.util.ArrayList;
import java.util.Map;
import java.util.WeakHashMap;
import org.jboss.logging.Logger;
import org.jboss.security.SecurityUtil;
import org.jboss.security.config.ApplicationPolicy;
import org.jboss.security.config.MappingInfo;
import org.jboss.security.config.SecurityConfiguration;
import org.jboss.security.mapping.MappingContext;
import org.jboss.security.mapping.MappingManager;
import org.jboss.security.mapping.MappingProvider;
import org.jboss.security.mapping.config.MappingModuleEntry;
import org.jboss.security.plugins.mapping.SecurityActions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossMappingManager
implements MappingManager {
    protected static final Logger log = Logger.getLogger(JBossMappingManager.class);
    protected boolean trace = log.isTraceEnabled();
    private String securityDomain;
    private static Map<String, Class<?>> clazzMap = new WeakHashMap();

    public JBossMappingManager(String domain) {
        this.securityDomain = SecurityUtil.unprefixSecurityDomain(domain);
    }

    public <T> MappingContext<T> getMappingContext(String mappingType) {
        ApplicationPolicy aPolicy = SecurityConfiguration.getApplicationPolicy(this.securityDomain);
        if (aPolicy == null) {
            String defaultDomain = "other";
            if (this.trace) {
                log.trace((Object)("Application Policy not found for domain=" + this.securityDomain + ".Mapping framework will use the default domain:" + defaultDomain));
            }
            aPolicy = SecurityConfiguration.getApplicationPolicy(defaultDomain);
        }
        if (aPolicy == null) {
            throw new IllegalStateException("Application Policy is null for the security domain:" + this.securityDomain);
        }
        MappingContext<T> mc = null;
        MappingInfo rmi = aPolicy.getMappingInfo(mappingType);
        if (rmi != null) {
            mc = this.generateMappingContext(mc, rmi);
        }
        return mc;
    }

    public <T> MappingContext<T> getMappingContext(Class<T> mappingType) {
        ApplicationPolicy aPolicy = SecurityConfiguration.getApplicationPolicy(this.securityDomain);
        if (aPolicy == null) {
            String defaultDomain = "other";
            if (this.trace) {
                log.trace((Object)("Application Policy not found for domain=" + this.securityDomain + ".Mapping framework will use the default domain:" + defaultDomain));
            }
            aPolicy = SecurityConfiguration.getApplicationPolicy(defaultDomain);
        }
        if (aPolicy == null) {
            throw new IllegalStateException("Application Policy is null for the security domain:" + this.securityDomain);
        }
        MappingContext<T> mc = null;
        MappingInfo rmi = aPolicy.getMappingInfo(mappingType);
        if (rmi != null) {
            mc = this.generateMappingContext(mc, rmi);
        }
        return mc;
    }

    private <T> MappingContext<T> generateMappingContext(MappingContext<T> mc, MappingInfo rmi) {
        MappingModuleEntry[] mpe = rmi.getMappingModuleEntry();
        ArrayList<MappingProvider<T>> al = new ArrayList<MappingProvider<T>>();
        for (int i = 0; i < mpe.length; ++i) {
            MappingProvider<T> mp = this.getMappingProvider(mpe[i]);
            if (mp == null) continue;
            al.add(mp);
        }
        return new MappingContext(al);
    }

    public String getSecurityDomain() {
        return this.securityDomain;
    }

    private <T> MappingProvider<T> getMappingProvider(MappingModuleEntry mme) {
        MappingProvider mp;
        block5: {
            mp = null;
            try {
                String fqn = mme.getMappingModuleName();
                Class<?> clazz = clazzMap.get(fqn);
                if (clazz == null) {
                    try {
                        clazz = this.getClass().getClassLoader().loadClass(fqn);
                    }
                    catch (Exception e) {
                        ClassLoader tcl = SecurityActions.getContextClassLoader();
                        clazz = tcl.loadClass(fqn);
                    }
                    clazzMap.put(fqn, clazz);
                }
                mp = (MappingProvider)clazz.newInstance();
                mp.init(mme.getOptions());
            }
            catch (Exception e) {
                if (!this.trace) break block5;
                log.trace((Object)"Error in getting Mapping Provider", (Throwable)e);
            }
        }
        return mp;
    }
}

