/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.plugins;

import java.security.Principal;
import javax.security.auth.Subject;
import org.jboss.logging.Logger;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.ISecurityManagement;
import org.jboss.security.SubjectFactory;
import org.jboss.security.auth.callback.JBossCallbackHandler;
import org.jboss.security.plugins.DefaultSecurityManagement;
import org.jboss.security.plugins.SubjectActions;

public class JBossSecuritySubjectFactory
implements SubjectFactory {
    private static Logger log = Logger.getLogger(JBossSecuritySubjectFactory.class);
    private ISecurityManagement securityManagement;

    public Subject createSubject() {
        return this.createSubject("other");
    }

    public Subject createSubject(String securityDomainName) {
        if (this.securityManagement == null) {
            log.warn((Object)"SecurityManagement is not set. Creating a default one");
            this.securityManagement = new DefaultSecurityManagement(new JBossCallbackHandler());
        }
        Subject subject = new Subject();
        Principal principal = SubjectActions.getPrincipal();
        AuthenticationManager authenticationManager = this.securityManagement.getAuthenticationManager(securityDomainName);
        if (authenticationManager == null) {
            String defaultSecurityDomain = "other";
            if (log.isTraceEnabled()) {
                log.trace((Object)("AuthenticationManager for " + securityDomainName + " not found. Using " + defaultSecurityDomain));
            }
            authenticationManager = this.securityManagement.getAuthenticationManager(defaultSecurityDomain);
        }
        if (!authenticationManager.isValid(principal, SubjectActions.getCredential(), subject)) {
            throw new SecurityException("Unauthenticated caller:" + principal);
        }
        return subject;
    }

    public void setSecurityManagement(ISecurityManagement securityManagement) {
        this.securityManagement = securityManagement;
    }
}

