/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.signature.builder;

import java.util.NoSuchElementException;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.api.OpenPGPCertificate;
import org.bouncycastle.openpgp.api.OpenPGPKey;
import org.jetbrains.annotations.NotNull;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.SignatureType;
import org.pgpainless.bouncycastle.extensions.PreferredAlgorithmsExtensionsKt;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.protection.UnlockSecretKey;
import org.pgpainless.signature.subpackets.SignatureSubpackets;
import org.pgpainless.signature.subpackets.SignatureSubpacketsHelper;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u0000 6*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00002\u00020\u0002:\u00016B?\b\u0014\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010B'\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0011B'\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0014B5\u0012\u0006\u0010\u0005\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\n\u0012\u0006\u0010\u0017\u001a\u00020\u0004\u0012\u0006\u0010\u0018\u001a\u00020\f\u0012\u0006\u0010\u0019\u001a\u00020\f\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u001aJ\b\u0010/\u001a\u000200H\u0004J\u0013\u00101\u001a\u00028\u00002\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u00102J\u0013\u00103\u001a\u00028\u00002\u0006\u00104\u001a\u00020\u0004\u00a2\u0006\u0002\u00105R\u001a\u0010\u0016\u001a\u00020\nX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u0014\u0010\u0018\u001a\u00020\fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u001a\u0010\u0017\u001a\u00020\u0004X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u0014\u0010\u0019\u001a\u00020\fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010 R\u0014\u0010\u000e\u001a\u00020\u000fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u001cR\u0018\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00040*X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u0014\u0010\u0005\u001a\u00020\u0015X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.\u00a8\u00067"}, d2={"Lorg/pgpainless/signature/builder/AbstractSignatureBuilder;", "B", "", "signatureType", "Lorg/pgpainless/algorithm/SignatureType;", "signingKey", "Lorg/bouncycastle/openpgp/api/OpenPGPKey$OpenPGPSecretKey;", "protector", "Lorg/pgpainless/key/protection/SecretKeyRingProtector;", "hashAlgorithm", "Lorg/pgpainless/algorithm/HashAlgorithm;", "hashedSubpackets", "Lorg/pgpainless/signature/subpackets/SignatureSubpackets;", "unhashedSubpackets", "api", "Lorg/pgpainless/PGPainless;", "(Lorg/pgpainless/algorithm/SignatureType;Lorg/bouncycastle/openpgp/api/OpenPGPKey$OpenPGPSecretKey;Lorg/pgpainless/key/protection/SecretKeyRingProtector;Lorg/pgpainless/algorithm/HashAlgorithm;Lorg/pgpainless/signature/subpackets/SignatureSubpackets;Lorg/pgpainless/signature/subpackets/SignatureSubpackets;Lorg/pgpainless/PGPainless;)V", "(Lorg/pgpainless/algorithm/SignatureType;Lorg/bouncycastle/openpgp/api/OpenPGPKey$OpenPGPSecretKey;Lorg/pgpainless/key/protection/SecretKeyRingProtector;Lorg/pgpainless/PGPainless;)V", "archetypeSignature", "Lorg/bouncycastle/openpgp/PGPSignature;", "(Lorg/bouncycastle/openpgp/api/OpenPGPKey$OpenPGPSecretKey;Lorg/pgpainless/key/protection/SecretKeyRingProtector;Lorg/bouncycastle/openpgp/PGPSignature;Lorg/pgpainless/PGPainless;)V", "Lorg/bouncycastle/openpgp/api/OpenPGPKey$OpenPGPPrivateKey;", "_hashAlgorithm", "_signatureType", "_hashedSubpackets", "_unhashedSubpackets", "(Lorg/bouncycastle/openpgp/api/OpenPGPKey$OpenPGPPrivateKey;Lorg/pgpainless/algorithm/HashAlgorithm;Lorg/pgpainless/algorithm/SignatureType;Lorg/pgpainless/signature/subpackets/SignatureSubpackets;Lorg/pgpainless/signature/subpackets/SignatureSubpackets;Lorg/pgpainless/PGPainless;)V", "get_hashAlgorithm", "()Lorg/pgpainless/algorithm/HashAlgorithm;", "set_hashAlgorithm", "(Lorg/pgpainless/algorithm/HashAlgorithm;)V", "get_hashedSubpackets", "()Lorg/pgpainless/signature/subpackets/SignatureSubpackets;", "get_signatureType", "()Lorg/pgpainless/algorithm/SignatureType;", "set_signatureType", "(Lorg/pgpainless/algorithm/SignatureType;)V", "get_unhashedSubpackets", "getApi", "()Lorg/pgpainless/PGPainless;", "getHashAlgorithm", "signatureTypePredicate", "Ljava/util/function/Predicate;", "getSignatureTypePredicate", "()Ljava/util/function/Predicate;", "getSigningKey", "()Lorg/bouncycastle/openpgp/api/OpenPGPKey$OpenPGPPrivateKey;", "buildAndInitSignatureGenerator", "Lorg/bouncycastle/openpgp/PGPSignatureGenerator;", "overrideHashAlgorithm", "(Lorg/pgpainless/algorithm/HashAlgorithm;)Lorg/pgpainless/signature/builder/AbstractSignatureBuilder;", "setSignatureType", "type", "(Lorg/pgpainless/algorithm/SignatureType;)Lorg/pgpainless/signature/builder/AbstractSignatureBuilder;", "Companion", "pgpainless-core"})
@SourceDebugExtension(value={"SMAP\nAbstractSignatureBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractSignatureBuilder.kt\norg/pgpainless/signature/builder/AbstractSignatureBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,136:1\n1#2:137\n*E\n"})
public abstract class AbstractSignatureBuilder<B extends AbstractSignatureBuilder<B>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final OpenPGPKey.OpenPGPPrivateKey signingKey;
    @NotNull
    private HashAlgorithm _hashAlgorithm;
    @NotNull
    private SignatureType _signatureType;
    @NotNull
    private final SignatureSubpackets _hashedSubpackets;
    @NotNull
    private final SignatureSubpackets _unhashedSubpackets;
    @NotNull
    private final PGPainless api;
    @NotNull
    private final HashAlgorithm hashAlgorithm;

    public AbstractSignatureBuilder(@NotNull OpenPGPKey.OpenPGPPrivateKey signingKey, @NotNull HashAlgorithm _hashAlgorithm, @NotNull SignatureType _signatureType, @NotNull SignatureSubpackets _hashedSubpackets, @NotNull SignatureSubpackets _unhashedSubpackets, @NotNull PGPainless api) {
        Intrinsics.checkNotNullParameter((Object)signingKey, (String)"signingKey");
        Intrinsics.checkNotNullParameter((Object)((Object)_hashAlgorithm), (String)"_hashAlgorithm");
        Intrinsics.checkNotNullParameter((Object)((Object)_signatureType), (String)"_signatureType");
        Intrinsics.checkNotNullParameter((Object)_hashedSubpackets, (String)"_hashedSubpackets");
        Intrinsics.checkNotNullParameter((Object)_unhashedSubpackets, (String)"_unhashedSubpackets");
        Intrinsics.checkNotNullParameter((Object)api, (String)"api");
        this.signingKey = signingKey;
        this._hashAlgorithm = _hashAlgorithm;
        this._signatureType = _signatureType;
        this._hashedSubpackets = _hashedSubpackets;
        this._unhashedSubpackets = _unhashedSubpackets;
        this.api = api;
        if (!this.getSignatureTypePredicate().test(this._signatureType)) {
            boolean bl = false;
            String string = "Invalid signature type: " + this._signatureType;
            throw new IllegalArgumentException(string.toString());
        }
        this.hashAlgorithm = this._hashAlgorithm;
    }

    @NotNull
    protected final OpenPGPKey.OpenPGPPrivateKey getSigningKey() {
        return this.signingKey;
    }

    @NotNull
    protected final HashAlgorithm get_hashAlgorithm() {
        return this._hashAlgorithm;
    }

    protected final void set_hashAlgorithm(@NotNull HashAlgorithm hashAlgorithm) {
        Intrinsics.checkNotNullParameter((Object)((Object)hashAlgorithm), (String)"<set-?>");
        this._hashAlgorithm = hashAlgorithm;
    }

    @NotNull
    protected final SignatureType get_signatureType() {
        return this._signatureType;
    }

    protected final void set_signatureType(@NotNull SignatureType signatureType) {
        Intrinsics.checkNotNullParameter((Object)((Object)signatureType), (String)"<set-?>");
        this._signatureType = signatureType;
    }

    @NotNull
    protected final SignatureSubpackets get_hashedSubpackets() {
        return this._hashedSubpackets;
    }

    @NotNull
    protected final SignatureSubpackets get_unhashedSubpackets() {
        return this._unhashedSubpackets;
    }

    @NotNull
    protected final PGPainless getApi() {
        return this.api;
    }

    @NotNull
    protected abstract Predicate<SignatureType> getSignatureTypePredicate();

    protected AbstractSignatureBuilder(@NotNull SignatureType signatureType, @NotNull OpenPGPKey.OpenPGPSecretKey signingKey, @NotNull SecretKeyRingProtector protector, @NotNull HashAlgorithm hashAlgorithm, @NotNull SignatureSubpackets hashedSubpackets, @NotNull SignatureSubpackets unhashedSubpackets, @NotNull PGPainless api) throws PGPException {
        Intrinsics.checkNotNullParameter((Object)((Object)signatureType), (String)"signatureType");
        Intrinsics.checkNotNullParameter((Object)signingKey, (String)"signingKey");
        Intrinsics.checkNotNullParameter((Object)protector, (String)"protector");
        Intrinsics.checkNotNullParameter((Object)((Object)hashAlgorithm), (String)"hashAlgorithm");
        Intrinsics.checkNotNullParameter((Object)hashedSubpackets, (String)"hashedSubpackets");
        Intrinsics.checkNotNullParameter((Object)unhashedSubpackets, (String)"unhashedSubpackets");
        Intrinsics.checkNotNullParameter((Object)api, (String)"api");
        this(UnlockSecretKey.Companion.unlockSecretKey$default(UnlockSecretKey.Companion, signingKey, protector, null, 4, null), hashAlgorithm, signatureType, hashedSubpackets, unhashedSubpackets, api);
    }

    public AbstractSignatureBuilder(@NotNull SignatureType signatureType, @NotNull OpenPGPKey.OpenPGPSecretKey signingKey, @NotNull SecretKeyRingProtector protector, @NotNull PGPainless api) throws PGPException {
        Intrinsics.checkNotNullParameter((Object)((Object)signatureType), (String)"signatureType");
        Intrinsics.checkNotNullParameter((Object)signingKey, (String)"signingKey");
        Intrinsics.checkNotNullParameter((Object)protector, (String)"protector");
        Intrinsics.checkNotNullParameter((Object)api, (String)"api");
        HashAlgorithm hashAlgorithm = Companion.negotiateHashAlgorithm((OpenPGPCertificate.OpenPGPComponentKey)signingKey, api);
        PGPPublicKey pGPPublicKey = signingKey.getPGPSecretKey().getPublicKey();
        Intrinsics.checkNotNullExpressionValue((Object)pGPPublicKey, (String)"getPublicKey(...)");
        this(signatureType, signingKey, protector, hashAlgorithm, SignatureSubpackets.Companion.createHashedSubpackets(pGPPublicKey), SignatureSubpackets.Companion.createEmptySubpackets(), api);
    }

    public AbstractSignatureBuilder(@NotNull OpenPGPKey.OpenPGPSecretKey signingKey, @NotNull SecretKeyRingProtector protector, @NotNull PGPSignature archetypeSignature, @NotNull PGPainless api) throws PGPException {
        Intrinsics.checkNotNullParameter((Object)signingKey, (String)"signingKey");
        Intrinsics.checkNotNullParameter((Object)protector, (String)"protector");
        Intrinsics.checkNotNullParameter((Object)archetypeSignature, (String)"archetypeSignature");
        Intrinsics.checkNotNullParameter((Object)api, (String)"api");
        SignatureType signatureType = SignatureType.Companion.requireFromCode(archetypeSignature.getSignatureType());
        HashAlgorithm hashAlgorithm = Companion.negotiateHashAlgorithm((OpenPGPCertificate.OpenPGPComponentKey)signingKey, api);
        PGPPublicKey pGPPublicKey = signingKey.getPublicKey().getPGPPublicKey();
        Intrinsics.checkNotNullExpressionValue((Object)pGPPublicKey, (String)"getPGPPublicKey(...)");
        this(signatureType, signingKey, protector, hashAlgorithm, SignatureSubpackets.Companion.refreshHashedSubpackets(pGPPublicKey, archetypeSignature), SignatureSubpackets.Companion.refreshUnhashedSubpackets(archetypeSignature), api);
    }

    @NotNull
    public final HashAlgorithm getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    @NotNull
    public final B overrideHashAlgorithm(@NotNull HashAlgorithm hashAlgorithm) {
        AbstractSignatureBuilder abstractSignatureBuilder;
        Intrinsics.checkNotNullParameter((Object)((Object)hashAlgorithm), (String)"hashAlgorithm");
        AbstractSignatureBuilder $this$overrideHashAlgorithm_u24lambda_u241 = abstractSignatureBuilder = this;
        boolean bl = false;
        $this$overrideHashAlgorithm_u24lambda_u241._hashAlgorithm = hashAlgorithm;
        AbstractSignatureBuilder abstractSignatureBuilder2 = abstractSignatureBuilder;
        Intrinsics.checkNotNull((Object)abstractSignatureBuilder2, (String)"null cannot be cast to non-null type B of org.pgpainless.signature.builder.AbstractSignatureBuilder");
        return (B)abstractSignatureBuilder2;
    }

    @NotNull
    public final B setSignatureType(@NotNull SignatureType type) {
        AbstractSignatureBuilder abstractSignatureBuilder;
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        AbstractSignatureBuilder $this$setSignatureType_u24lambda_u243 = abstractSignatureBuilder = this;
        boolean bl = false;
        if (!$this$setSignatureType_u24lambda_u243.getSignatureTypePredicate().test(type)) {
            boolean bl2 = false;
            String string = "Invalid signature type: " + type;
            throw new IllegalArgumentException(string.toString());
        }
        $this$setSignatureType_u24lambda_u243._signatureType = type;
        AbstractSignatureBuilder abstractSignatureBuilder2 = abstractSignatureBuilder;
        Intrinsics.checkNotNull((Object)abstractSignatureBuilder2, (String)"null cannot be cast to non-null type B of org.pgpainless.signature.builder.AbstractSignatureBuilder");
        return (B)abstractSignatureBuilder2;
    }

    @NotNull
    protected final PGPSignatureGenerator buildAndInitSignatureGenerator() throws PGPException {
        PGPSignatureGenerator pGPSignatureGenerator;
        PGPSignatureGenerator $this$buildAndInitSignatureGenerator_u24lambda_u244 = pGPSignatureGenerator = new PGPSignatureGenerator(this.api.getImplementation().pgpContentSignerBuilder(this.signingKey.getKeyPair().getPublicKey().getAlgorithm(), this.hashAlgorithm.getAlgorithmId()), this.signingKey.getKeyPair().getPublicKey());
        boolean bl = false;
        $this$buildAndInitSignatureGenerator_u24lambda_u244.setUnhashedSubpackets(SignatureSubpacketsHelper.Companion.toVector(this._unhashedSubpackets));
        $this$buildAndInitSignatureGenerator_u24lambda_u244.setHashedSubpackets(SignatureSubpacketsHelper.Companion.toVector(this._hashedSubpackets));
        $this$buildAndInitSignatureGenerator_u24lambda_u244.init(this._signatureType.getCode(), this.signingKey.getKeyPair().getPrivateKey());
        return pGPSignatureGenerator;
    }

    @JvmStatic
    @NotNull
    public static final HashAlgorithm negotiateHashAlgorithm(@NotNull OpenPGPCertificate.OpenPGPComponentKey key, @NotNull PGPainless api) {
        return Companion.negotiateHashAlgorithm(key, api);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\t"}, d2={"Lorg/pgpainless/signature/builder/AbstractSignatureBuilder$Companion;", "", "()V", "negotiateHashAlgorithm", "Lorg/pgpainless/algorithm/HashAlgorithm;", "key", "Lorg/bouncycastle/openpgp/api/OpenPGPCertificate$OpenPGPComponentKey;", "api", "Lorg/pgpainless/PGPainless;", "pgpainless-core"})
    @SourceDebugExtension(value={"SMAP\nAbstractSignatureBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractSignatureBuilder.kt\norg/pgpainless/signature/builder/AbstractSignatureBuilder$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,136:1\n223#2,2:137\n*S KotlinDebug\n*F\n+ 1 AbstractSignatureBuilder.kt\norg/pgpainless/signature/builder/AbstractSignatureBuilder$Companion\n*L\n130#1:137,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final HashAlgorithm negotiateHashAlgorithm(@NotNull OpenPGPCertificate.OpenPGPComponentKey key, @NotNull PGPainless api) {
            Object object;
            block5: {
                block4: {
                    Object element$iv2;
                    block3: {
                        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                        Intrinsics.checkNotNullParameter((Object)api, (String)"api");
                        object = key.getHashAlgorithmPreferences();
                        if (object == null || (object = PreferredAlgorithmsExtensionsKt.toHashAlgorithms(object)) == null) break block4;
                        Iterable $this$first$iv = (Iterable)object;
                        boolean $i$f$first = false;
                        for (Object element$iv2 : $this$first$iv) {
                            HashAlgorithm it = (HashAlgorithm)((Object)element$iv2);
                            boolean bl = false;
                            if (!api.getAlgorithmPolicy().getDataSignatureHashAlgorithmPolicy().isAcceptable(it)) continue;
                            break block3;
                        }
                        throw new NoSuchElementException("Collection contains no element matching the predicate.");
                    }
                    object = (HashAlgorithm)((Object)element$iv2);
                    if (object != null) break block5;
                }
                object = api.getAlgorithmPolicy().getDataSignatureHashAlgorithmPolicy().getDefaultHashAlgorithm();
            }
            return object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

