/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.SecureRandom;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bouncycastle.bcpg.BCPGKey;
import org.bouncycastle.bcpg.DSAPublicBCPGKey;
import org.bouncycastle.bcpg.DSASecretBCPGKey;
import org.bouncycastle.bcpg.EdDSAPublicBCPGKey;
import org.bouncycastle.bcpg.EdSecretBCPGKey;
import org.bouncycastle.bcpg.ElGamalPublicBCPGKey;
import org.bouncycastle.bcpg.ElGamalSecretBCPGKey;
import org.bouncycastle.bcpg.RSAPublicBCPGKey;
import org.bouncycastle.bcpg.RSASecretBCPGKey;
import org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyEncryptedData;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.api.OpenPGPImplementation;
import org.bouncycastle.openpgp.operator.PGPKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.PublicKeyDataDecryptorFactory;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.io.Streams;
import org.jetbrains.annotations.NotNull;
import org.pgpainless.algorithm.PublicKeyAlgorithm;
import org.pgpainless.algorithm.SignatureType;
import org.pgpainless.bouncycastle.extensions.PGPPublicKeyExtensionsKt;
import org.pgpainless.exception.KeyIntegrityException;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lorg/pgpainless/key/util/PublicKeyParameterValidationUtil;", "", "()V", "Companion", "pgpainless-core"})
public final class PublicKeyParameterValidationUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @JvmStatic
    public static final void verifyPublicKeyParameterIntegrity(@NotNull PGPPrivateKey privateKey, @NotNull PGPPublicKey publicKey) throws KeyIntegrityException {
        Companion.verifyPublicKeyParameterIntegrity(privateKey, publicKey);
    }

    @JvmStatic
    private static final boolean verifyRSAKeyIntegrity(RSASecretBCPGKey secretKey, RSAPublicBCPGKey publicKey) throws KeyIntegrityException {
        return PublicKeyParameterValidationUtil.Companion.verifyRSAKeyIntegrity(secretKey, publicKey);
    }

    @JvmStatic
    private static final boolean verifyEdDsaKeyIntegrity(EdSecretBCPGKey secretKey, EdDSAPublicBCPGKey publicKey) throws KeyIntegrityException {
        return PublicKeyParameterValidationUtil.Companion.verifyEdDsaKeyIntegrity(secretKey, publicKey);
    }

    @JvmStatic
    private static final boolean verifyDsaKeyIntegrity(DSASecretBCPGKey privateKey, DSAPublicBCPGKey publicKey) throws KeyIntegrityException {
        return PublicKeyParameterValidationUtil.Companion.verifyDsaKeyIntegrity(privateKey, publicKey);
    }

    @JvmStatic
    private static final boolean verifyElGamalKeyIntegrity(ElGamalSecretBCPGKey secretKey, ElGamalPublicBCPGKey publicKey) throws KeyIntegrityException {
        return PublicKeyParameterValidationUtil.Companion.verifyElGamalKeyIntegrity(secretKey, publicKey);
    }

    @JvmStatic
    private static final boolean verifyCanSign(PGPPrivateKey privateKey, PGPPublicKey publicKey) {
        return PublicKeyParameterValidationUtil.Companion.verifyCanSign(privateKey, publicKey);
    }

    @JvmStatic
    private static final boolean verifyCanDecrypt(PGPPrivateKey privateKey, PGPPublicKey publicKey) {
        return PublicKeyParameterValidationUtil.Companion.verifyCanDecrypt(privateKey, publicKey);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0003J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0003J\u0018\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\fH\u0003J\u0018\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u0010H\u0003J\u0018\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\u0013H\u0003J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0018\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00172\u0006\u0010\u0007\u001a\u00020\u0018H\u0003\u00a8\u0006\u0019"}, d2={"Lorg/pgpainless/key/util/PublicKeyParameterValidationUtil$Companion;", "", "()V", "verifyCanDecrypt", "", "privateKey", "Lorg/bouncycastle/openpgp/PGPPrivateKey;", "publicKey", "Lorg/bouncycastle/openpgp/PGPPublicKey;", "verifyCanSign", "verifyDsaKeyIntegrity", "Lorg/bouncycastle/bcpg/DSASecretBCPGKey;", "Lorg/bouncycastle/bcpg/DSAPublicBCPGKey;", "verifyEdDsaKeyIntegrity", "secretKey", "Lorg/bouncycastle/bcpg/EdSecretBCPGKey;", "Lorg/bouncycastle/bcpg/EdDSAPublicBCPGKey;", "verifyElGamalKeyIntegrity", "Lorg/bouncycastle/bcpg/ElGamalSecretBCPGKey;", "Lorg/bouncycastle/bcpg/ElGamalPublicBCPGKey;", "verifyPublicKeyParameterIntegrity", "", "verifyRSAKeyIntegrity", "Lorg/bouncycastle/bcpg/RSASecretBCPGKey;", "Lorg/bouncycastle/bcpg/RSAPublicBCPGKey;", "pgpainless-core"})
    @SourceDebugExtension(value={"SMAP\nPublicKeyParameterValidationUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PublicKeyParameterValidationUtil.kt\norg/pgpainless/key/util/PublicKeyParameterValidationUtil$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,290:1\n1#2:291\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void verifyPublicKeyParameterIntegrity(@NotNull PGPPrivateKey privateKey, @NotNull PGPPublicKey publicKey) throws KeyIntegrityException {
            Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
            Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
            PublicKeyAlgorithm algorithm = PGPPublicKeyExtensionsKt.getPublicKeyAlgorithm(publicKey);
            boolean valid = true;
            BCPGKey key = privateKey.getPrivateKeyDataPacket();
            BCPGKey bCPGKey = privateKey.getPrivateKeyDataPacket();
            if (bCPGKey instanceof RSASecretBCPGKey) {
                Intrinsics.checkNotNull((Object)key, (String)"null cannot be cast to non-null type org.bouncycastle.bcpg.RSASecretBCPGKey");
                RSASecretBCPGKey rSASecretBCPGKey = (RSASecretBCPGKey)key;
                BCPGKey bCPGKey2 = publicKey.getPublicKeyPacket().getKey();
                Intrinsics.checkNotNull((Object)bCPGKey2, (String)"null cannot be cast to non-null type org.bouncycastle.bcpg.RSAPublicBCPGKey");
                valid = this.verifyRSAKeyIntegrity(rSASecretBCPGKey, (RSAPublicBCPGKey)bCPGKey2);
            } else if (bCPGKey instanceof EdSecretBCPGKey) {
                Intrinsics.checkNotNull((Object)key, (String)"null cannot be cast to non-null type org.bouncycastle.bcpg.EdSecretBCPGKey");
                EdSecretBCPGKey edSecretBCPGKey = (EdSecretBCPGKey)key;
                BCPGKey bCPGKey3 = publicKey.getPublicKeyPacket().getKey();
                Intrinsics.checkNotNull((Object)bCPGKey3, (String)"null cannot be cast to non-null type org.bouncycastle.bcpg.EdDSAPublicBCPGKey");
                valid = this.verifyEdDsaKeyIntegrity(edSecretBCPGKey, (EdDSAPublicBCPGKey)bCPGKey3);
            } else if (bCPGKey instanceof DSASecretBCPGKey) {
                Intrinsics.checkNotNull((Object)key, (String)"null cannot be cast to non-null type org.bouncycastle.bcpg.DSASecretBCPGKey");
                DSASecretBCPGKey dSASecretBCPGKey = (DSASecretBCPGKey)key;
                BCPGKey bCPGKey4 = publicKey.getPublicKeyPacket().getKey();
                Intrinsics.checkNotNull((Object)bCPGKey4, (String)"null cannot be cast to non-null type org.bouncycastle.bcpg.DSAPublicBCPGKey");
                valid = this.verifyDsaKeyIntegrity(dSASecretBCPGKey, (DSAPublicBCPGKey)bCPGKey4);
            } else if (bCPGKey instanceof ElGamalSecretBCPGKey) {
                Intrinsics.checkNotNull((Object)key, (String)"null cannot be cast to non-null type org.bouncycastle.bcpg.ElGamalSecretBCPGKey");
                ElGamalSecretBCPGKey elGamalSecretBCPGKey = (ElGamalSecretBCPGKey)key;
                BCPGKey bCPGKey5 = publicKey.getPublicKeyPacket().getKey();
                Intrinsics.checkNotNull((Object)bCPGKey5, (String)"null cannot be cast to non-null type org.bouncycastle.bcpg.ElGamalPublicBCPGKey");
                valid = this.verifyElGamalKeyIntegrity(elGamalSecretBCPGKey, (ElGamalPublicBCPGKey)bCPGKey5);
            }
            if (!valid) {
                throw new KeyIntegrityException();
            }
            if (algorithm.isSigningCapable()) {
                valid = this.verifyCanSign(privateKey, publicKey);
            }
            if (algorithm.isEncryptionCapable()) {
                valid &= this.verifyCanDecrypt(privateKey, publicKey);
            }
            if (!valid) {
                throw new KeyIntegrityException();
            }
        }

        @JvmStatic
        private final boolean verifyRSAKeyIntegrity(RSASecretBCPGKey secretKey, RSAPublicBCPGKey publicKey) throws KeyIntegrityException {
            return publicKey.getModulus().equals(secretKey.getPrimeP().multiply(secretKey.getPrimeQ()));
        }

        @JvmStatic
        private final boolean verifyEdDsaKeyIntegrity(EdSecretBCPGKey secretKey, EdDSAPublicBCPGKey publicKey) throws KeyIntegrityException {
            return true;
        }

        @JvmStatic
        private final boolean verifyDsaKeyIntegrity(DSASecretBCPGKey privateKey, DSAPublicBCPGKey publicKey) throws KeyIntegrityException {
            boolean gInBounds;
            boolean qLarge;
            int certainty = 40;
            BigInteger pG = publicKey.getG();
            BigInteger pP = publicKey.getP();
            BigInteger pQ = publicKey.getQ();
            BigInteger pY = publicKey.getY();
            BigInteger sX = privateKey.getX();
            boolean pPrime = pP.isProbablePrime(certainty);
            if (!pPrime) {
                return false;
            }
            boolean qPrime = pQ.isProbablePrime(certainty);
            if (!qPrime) {
                return false;
            }
            boolean bl = qLarge = pQ.bitLength() > 160;
            if (!qLarge) {
                return false;
            }
            boolean qDividesPminus1 = Intrinsics.areEqual((Object)pP.subtract(BigInteger.ONE).mod(pQ), (Object)BigInteger.ZERO);
            if (!qDividesPminus1) {
                return false;
            }
            boolean bl2 = gInBounds = Intrinsics.areEqual((Object)BigInteger.ONE.max(pG), (Object)pG) && Intrinsics.areEqual((Object)pG.max(pP), (Object)pP);
            if (!gInBounds) {
                return false;
            }
            boolean gPowXModPEquals1 = Intrinsics.areEqual((Object)pG.modPow(pQ, pP), (Object)BigInteger.ONE);
            if (!gPowXModPEquals1) {
                return false;
            }
            return Intrinsics.areEqual((Object)pY, (Object)pG.modPow(sX, pP));
        }

        @JvmStatic
        private final boolean verifyElGamalKeyIntegrity(ElGamalSecretBCPGKey secretKey, ElGamalPublicBCPGKey publicKey) throws KeyIntegrityException {
            BigInteger p = publicKey.getP();
            BigInteger g = publicKey.getG();
            BigInteger y = publicKey.getY();
            BigInteger one = BigInteger.ONE;
            if (Intrinsics.areEqual((Object)g.min(one), (Object)g) || Intrinsics.areEqual((Object)g.max(p), (Object)g)) {
                return false;
            }
            if (p.bitLength() < 1023) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)g.modPow(p.subtract(one), p), (Object)one)) {
                return false;
            }
            BigInteger res = g;
            int threshold = 262144;
            for (int i = 1; i < threshold; ++i) {
                if (!Intrinsics.areEqual((Object)(res = res.multiply(g).mod(p)), (Object)one)) continue;
                return false;
            }
            SecureRandom random = new SecureRandom();
            BigInteger x = secretKey.getX();
            BigInteger r = new BigInteger(p.bitLength(), random);
            BigInteger rqx = p.subtract(one).multiply(r).add(x);
            return Intrinsics.areEqual((Object)y, (Object)g.modPow(rqx, p));
        }

        @JvmStatic
        private final boolean verifyCanSign(PGPPrivateKey privateKey, PGPPublicKey publicKey) {
            boolean bl;
            byte[] byArray;
            byte[] it = byArray = new byte[512];
            boolean bl2 = false;
            new SecureRandom().nextBytes(it);
            byte[] data = byArray;
            PGPSignatureGenerator signatureGenerator = new PGPSignatureGenerator(OpenPGPImplementation.getInstance().pgpContentSignerBuilder(publicKey.getAlgorithm(), 8), publicKey);
            try {
                PGPSignatureGenerator pGPSignatureGenerator;
                PGPSignatureGenerator $this$verifyCanSign_u24lambda_u241 = pGPSignatureGenerator = signatureGenerator;
                boolean bl3 = false;
                $this$verifyCanSign_u24lambda_u241.init(SignatureType.TIMESTAMP.getCode(), privateKey);
                $this$verifyCanSign_u24lambda_u241.update(data);
                PGPSignatureGenerator $this$verifyCanSign_u24lambda_u242 = pGPSignatureGenerator = pGPSignatureGenerator.generate();
                boolean bl4 = false;
                $this$verifyCanSign_u24lambda_u242.init(OpenPGPImplementation.getInstance().pgpContentVerifierBuilderProvider(), publicKey);
                $this$verifyCanSign_u24lambda_u242.update(data);
                bl = pGPSignatureGenerator.verify();
            }
            catch (PGPException e) {
                bl = false;
            }
            return bl;
        }

        @JvmStatic
        private final boolean verifyCanDecrypt(PGPPrivateKey privateKey, PGPPublicKey publicKey) {
            byte[] byArray;
            Object it = byArray = new byte[1024];
            boolean bl = false;
            new SecureRandom().nextBytes((byte[])it);
            byte[] data = byArray;
            Object $this$verifyCanDecrypt_u24lambda_u244 = it = (Object)new PGPEncryptedDataGenerator(OpenPGPImplementation.getInstance().pgpDataEncryptorBuilder(9));
            boolean bl2 = false;
            $this$verifyCanDecrypt_u24lambda_u244.addMethod((PGPKeyEncryptionMethodGenerator)OpenPGPImplementation.getInstance().publicKeyKeyEncryptionMethodGenerator(publicKey));
            Object encryptedDataGenerator = it;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                OutputStream outputStream = encryptedDataGenerator.open((OutputStream)out, new byte[1024]);
                outputStream.write(data);
                encryptedDataGenerator.close();
                PGPEncryptedDataList encryptedDataList = new PGPEncryptedDataList(out.toByteArray());
                PublicKeyDataDecryptorFactory decryptorFactory = OpenPGPImplementation.getInstance().publicKeyDataDecryptorFactory(privateKey);
                Object e = encryptedDataList.getEncryptedDataObjects().next();
                Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type org.bouncycastle.openpgp.PGPPublicKeyEncryptedData");
                PGPPublicKeyEncryptedData encryptedData = (PGPPublicKeyEncryptedData)e;
                InputStream decrypted = encryptedData.getDataStream(decryptorFactory);
                out = new ByteArrayOutputStream();
                Streams.pipeAll((InputStream)decrypted, (OutputStream)out);
                decrypted.close();
            }
            catch (IOException e) {
                return false;
            }
            catch (PGPException e) {
                return false;
            }
            return Arrays.constantTimeAreEqual((byte[])data, (byte[])out.toByteArray());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

