/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.protection;

import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import openpgp.LongExtensionsKt;
import org.bouncycastle.bcpg.KeyIdentifier;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.api.KeyPassphraseProvider;
import org.bouncycastle.openpgp.api.OpenPGPKey;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.PGPainless;
import org.pgpainless.bouncycastle.extensions.PGPSecretKeyExtensionsKt;
import org.pgpainless.exception.KeyIntegrityException;
import org.pgpainless.exception.WrongPassphraseException;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.util.PublicKeyParameterValidationUtil;
import org.pgpainless.policy.Policy;
import org.pgpainless.util.Passphrase;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lorg/pgpainless/key/protection/UnlockSecretKey;", "", "()V", "Companion", "pgpainless-core"})
public final class UnlockSecretKey {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @JvmStatic
    @NotNull
    public static final PGPPrivateKey unlockSecretKey(@NotNull PGPSecretKey secretKey, @NotNull SecretKeyRingProtector protector) throws PGPException, KeyIntegrityException {
        return Companion.unlockSecretKey(secretKey, protector);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final OpenPGPKey.OpenPGPPrivateKey unlockSecretKey(@NotNull OpenPGPKey.OpenPGPSecretKey secretKey, @NotNull SecretKeyRingProtector protector, @NotNull Policy policy) throws PGPException {
        return Companion.unlockSecretKey(secretKey, protector, policy);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final PGPPrivateKey unlockSecretKey(@NotNull PGPSecretKey secretKey, @Nullable PBESecretKeyDecryptor decryptor, @NotNull Policy policy) throws PGPException {
        return Companion.unlockSecretKey(secretKey, decryptor, policy);
    }

    @JvmStatic
    @NotNull
    public static final PGPPrivateKey unlockSecretKey(@NotNull PGPSecretKey secretKey, @Nullable Passphrase passphrase) {
        return Companion.unlockSecretKey(secretKey, passphrase);
    }

    @JvmStatic
    @NotNull
    public static final OpenPGPKey.OpenPGPPrivateKey unlockSecretKey(@NotNull OpenPGPKey.OpenPGPSecretKey secretKey, @NotNull Passphrase passphrase) {
        return Companion.unlockSecretKey(secretKey, passphrase);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final OpenPGPKey.OpenPGPPrivateKey unlockSecretKey(@NotNull OpenPGPKey.OpenPGPSecretKey secretKey, @NotNull SecretKeyRingProtector protector) throws PGPException {
        return Companion.unlockSecretKey(secretKey, protector);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final PGPPrivateKey unlockSecretKey(@NotNull PGPSecretKey secretKey, @Nullable PBESecretKeyDecryptor decryptor) throws PGPException {
        return Companion.unlockSecretKey(secretKey, decryptor);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u0007J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0007J\"\u0010\u0003\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\t\u001a\u00020\nH\u0007J\u0018\u0010\u0003\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0007\u00a8\u0006\u0011"}, d2={"Lorg/pgpainless/key/protection/UnlockSecretKey$Companion;", "", "()V", "unlockSecretKey", "Lorg/bouncycastle/openpgp/PGPPrivateKey;", "secretKey", "Lorg/bouncycastle/openpgp/PGPSecretKey;", "decryptor", "Lorg/bouncycastle/openpgp/operator/PBESecretKeyDecryptor;", "policy", "Lorg/pgpainless/policy/Policy;", "protector", "Lorg/pgpainless/key/protection/SecretKeyRingProtector;", "passphrase", "Lorg/pgpainless/util/Passphrase;", "Lorg/bouncycastle/openpgp/api/OpenPGPKey$OpenPGPPrivateKey;", "Lorg/bouncycastle/openpgp/api/OpenPGPKey$OpenPGPSecretKey;", "pgpainless-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final PGPPrivateKey unlockSecretKey(@NotNull PGPSecretKey secretKey, @NotNull SecretKeyRingProtector protector) throws PGPException, KeyIntegrityException {
            PGPPrivateKey pGPPrivateKey;
            Intrinsics.checkNotNullParameter((Object)secretKey, (String)"secretKey");
            Intrinsics.checkNotNullParameter((Object)protector, (String)"protector");
            if (PGPSecretKeyExtensionsKt.isEncrypted(secretKey)) {
                KeyIdentifier keyIdentifier = secretKey.getKeyIdentifier();
                Intrinsics.checkNotNullExpressionValue((Object)keyIdentifier, (String)"getKeyIdentifier(...)");
                pGPPrivateKey = org.pgpainless.key.protection.UnlockSecretKey$Companion.unlockSecretKey$default(this, secretKey, protector.getDecryptor(keyIdentifier), null, 4, null);
            } else {
                pGPPrivateKey = org.pgpainless.key.protection.UnlockSecretKey$Companion.unlockSecretKey$default(this, secretKey, null, null, 4, null);
            }
            return pGPPrivateKey;
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final OpenPGPKey.OpenPGPPrivateKey unlockSecretKey(@NotNull OpenPGPKey.OpenPGPSecretKey secretKey, @NotNull SecretKeyRingProtector protector, @NotNull Policy policy) throws PGPException {
            OpenPGPKey.OpenPGPPrivateKey openPGPPrivateKey;
            Intrinsics.checkNotNullParameter((Object)secretKey, (String)"secretKey");
            Intrinsics.checkNotNullParameter((Object)protector, (String)"protector");
            Intrinsics.checkNotNullParameter((Object)policy, (String)"policy");
            try {
                openPGPPrivateKey = secretKey.unlock((KeyPassphraseProvider)protector);
            }
            catch (PGPException e) {
                KeyIdentifier keyIdentifier = secretKey.getKeyIdentifier();
                Intrinsics.checkNotNullExpressionValue((Object)keyIdentifier, (String)"getKeyIdentifier(...)");
                throw new WrongPassphraseException(keyIdentifier, e);
            }
            OpenPGPKey.OpenPGPPrivateKey privateKey = openPGPPrivateKey;
            if (privateKey == null) {
                int n = secretKey.getPGPSecretKey().getS2K().getType();
                boolean bl = 100 <= n ? n < 111 : false;
                if (bl) {
                    throw new PGPException("Cannot decrypt secret key " + secretKey.getKeyIdentifier() + ": \nUnsupported private S2K type " + secretKey.getPGPSecretKey().getS2K().getType());
                }
                throw new PGPException("Cannot decrypt secret key.");
            }
            if (policy.isEnableKeyParameterValidation()) {
                PGPPrivateKey pGPPrivateKey = privateKey.getKeyPair().getPrivateKey();
                Intrinsics.checkNotNullExpressionValue((Object)pGPPrivateKey, (String)"getPrivateKey(...)");
                PGPPublicKey pGPPublicKey = privateKey.getKeyPair().getPublicKey();
                Intrinsics.checkNotNullExpressionValue((Object)pGPPublicKey, (String)"getPublicKey(...)");
                PublicKeyParameterValidationUtil.Companion.verifyPublicKeyParameterIntegrity(pGPPrivateKey, pGPPublicKey);
            }
            return privateKey;
        }

        public static /* synthetic */ OpenPGPKey.OpenPGPPrivateKey unlockSecretKey$default(Companion companion, OpenPGPKey.OpenPGPSecretKey openPGPSecretKey, SecretKeyRingProtector secretKeyRingProtector, Policy policy, int n, Object object) throws PGPException {
            if ((n & 4) != 0) {
                policy = PGPainless.Companion.getInstance().getAlgorithmPolicy();
            }
            return companion.unlockSecretKey(openPGPSecretKey, secretKeyRingProtector, policy);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final PGPPrivateKey unlockSecretKey(@NotNull PGPSecretKey secretKey, @Nullable PBESecretKeyDecryptor decryptor, @NotNull Policy policy) throws PGPException {
            PGPPrivateKey pGPPrivateKey;
            Intrinsics.checkNotNullParameter((Object)secretKey, (String)"secretKey");
            Intrinsics.checkNotNullParameter((Object)policy, (String)"policy");
            try {
                pGPPrivateKey = secretKey.extractPrivateKey(decryptor);
            }
            catch (PGPException e) {
                throw new WrongPassphraseException(secretKey.getKeyID(), e);
            }
            PGPPrivateKey privateKey = pGPPrivateKey;
            if (privateKey == null) {
                int n = secretKey.getS2K().getType();
                boolean bl = 100 <= n ? n < 111 : false;
                if (bl) {
                    throw new PGPException("Cannot decrypt secret key " + LongExtensionsKt.openPgpKeyId(secretKey.getKeyID()) + ": \nUnsupported private S2K type " + secretKey.getS2K().getType());
                }
                throw new PGPException("Cannot decrypt secret key.");
            }
            if (policy.isEnableKeyParameterValidation()) {
                PGPPublicKey pGPPublicKey = secretKey.getPublicKey();
                Intrinsics.checkNotNullExpressionValue((Object)pGPPublicKey, (String)"getPublicKey(...)");
                PublicKeyParameterValidationUtil.Companion.verifyPublicKeyParameterIntegrity(privateKey, pGPPublicKey);
            }
            return privateKey;
        }

        public static /* synthetic */ PGPPrivateKey unlockSecretKey$default(Companion companion, PGPSecretKey pGPSecretKey, PBESecretKeyDecryptor pBESecretKeyDecryptor, Policy policy, int n, Object object) throws PGPException {
            if ((n & 4) != 0) {
                policy = PGPainless.Companion.getInstance().getAlgorithmPolicy();
            }
            return companion.unlockSecretKey(pGPSecretKey, pBESecretKeyDecryptor, policy);
        }

        @JvmStatic
        @NotNull
        public final PGPPrivateKey unlockSecretKey(@NotNull PGPSecretKey secretKey, @Nullable Passphrase passphrase) {
            Intrinsics.checkNotNullParameter((Object)secretKey, (String)"secretKey");
            return passphrase == null ? this.unlockSecretKey(secretKey, (SecretKeyRingProtector)SecretKeyRingProtector.Companion.unprotectedKeys()) : this.unlockSecretKey(secretKey, SecretKeyRingProtector.Companion.unlockSingleKeyWith(passphrase, secretKey));
        }

        @JvmStatic
        @NotNull
        public final OpenPGPKey.OpenPGPPrivateKey unlockSecretKey(@NotNull OpenPGPKey.OpenPGPSecretKey secretKey, @NotNull Passphrase passphrase) {
            Intrinsics.checkNotNullParameter((Object)secretKey, (String)"secretKey");
            Intrinsics.checkNotNullParameter((Object)passphrase, (String)"passphrase");
            return org.pgpainless.key.protection.UnlockSecretKey$Companion.unlockSecretKey$default(this, secretKey, SecretKeyRingProtector.Companion.unlockAnyKeyWith(passphrase), null, 4, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final OpenPGPKey.OpenPGPPrivateKey unlockSecretKey(@NotNull OpenPGPKey.OpenPGPSecretKey secretKey, @NotNull SecretKeyRingProtector protector) throws PGPException {
            Intrinsics.checkNotNullParameter((Object)secretKey, (String)"secretKey");
            Intrinsics.checkNotNullParameter((Object)protector, (String)"protector");
            return org.pgpainless.key.protection.UnlockSecretKey$Companion.unlockSecretKey$default(this, secretKey, protector, null, 4, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final PGPPrivateKey unlockSecretKey(@NotNull PGPSecretKey secretKey, @Nullable PBESecretKeyDecryptor decryptor) throws PGPException {
            Intrinsics.checkNotNullParameter((Object)secretKey, (String)"secretKey");
            return org.pgpainless.key.protection.UnlockSecretKey$Companion.unlockSecretKey$default(this, secretKey, decryptor, null, 4, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

