/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.generation.type.xdh_legacy;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.openpgp.PGPKeyPair;
import org.bouncycastle.openpgp.operator.PGPKeyPairGenerator;
import org.jetbrains.annotations.NotNull;
import org.pgpainless.algorithm.PublicKeyAlgorithm;
import org.pgpainless.key.generation.type.KeyType;
import org.pgpainless.key.generation.type.xdh_legacy.XDHLegacySpec;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0016"}, d2={"Lorg/pgpainless/key/generation/type/xdh_legacy/XDHLegacy;", "Lorg/pgpainless/key/generation/type/KeyType;", "spec", "Lorg/pgpainless/key/generation/type/xdh_legacy/XDHLegacySpec;", "(Lorg/pgpainless/key/generation/type/xdh_legacy/XDHLegacySpec;)V", "algorithm", "Lorg/pgpainless/algorithm/PublicKeyAlgorithm;", "getAlgorithm", "()Lorg/pgpainless/algorithm/PublicKeyAlgorithm;", "bitStrength", "", "getBitStrength", "()I", "name", "", "getName", "()Ljava/lang/String;", "generateKeyPair", "Lorg/bouncycastle/openpgp/PGPKeyPair;", "generator", "Lorg/bouncycastle/openpgp/operator/PGPKeyPairGenerator;", "Companion", "pgpainless-core"})
public final class XDHLegacy
implements KeyType {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final PublicKeyAlgorithm algorithm = PublicKeyAlgorithm.ECDH;
    private final int bitStrength;

    private XDHLegacy(XDHLegacySpec spec) {
        this.name = "XDH";
        this.bitStrength = spec.getBitStrength();
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public PublicKeyAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public int getBitStrength() {
        return this.bitStrength;
    }

    @Override
    @NotNull
    public PGPKeyPair generateKeyPair(@NotNull PGPKeyPairGenerator generator) {
        Intrinsics.checkNotNullParameter((Object)generator, (String)"generator");
        PGPKeyPair pGPKeyPair = generator.generateLegacyX25519KeyPair();
        Intrinsics.checkNotNullExpressionValue((Object)pGPKeyPair, (String)"generateLegacyX25519KeyPair(...)");
        return pGPKeyPair;
    }

    @JvmStatic
    @NotNull
    public static final XDHLegacy fromSpec(@NotNull XDHLegacySpec spec) {
        return Companion.fromSpec(spec);
    }

    public /* synthetic */ XDHLegacy(XDHLegacySpec spec, DefaultConstructorMarker $constructor_marker) {
        this(spec);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lorg/pgpainless/key/generation/type/xdh_legacy/XDHLegacy$Companion;", "", "()V", "fromSpec", "Lorg/pgpainless/key/generation/type/xdh_legacy/XDHLegacy;", "spec", "Lorg/pgpainless/key/generation/type/xdh_legacy/XDHLegacySpec;", "pgpainless-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final XDHLegacy fromSpec(@NotNull XDHLegacySpec spec) {
            Intrinsics.checkNotNullParameter((Object)((Object)spec), (String)"spec");
            return new XDHLegacy(spec, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

