/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.generation.type.ecc.ecdh;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import org.bouncycastle.openpgp.PGPKeyPair;
import org.bouncycastle.openpgp.operator.PGPKeyPairGenerator;
import org.jetbrains.annotations.NotNull;
import org.pgpainless.algorithm.PublicKeyAlgorithm;
import org.pgpainless.key.generation.type.KeyType;
import org.pgpainless.key.generation.type.ecc.EllipticCurve;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0018"}, d2={"Lorg/pgpainless/key/generation/type/ecc/ecdh/ECDH;", "Lorg/pgpainless/key/generation/type/KeyType;", "curve", "Lorg/pgpainless/key/generation/type/ecc/EllipticCurve;", "(Lorg/pgpainless/key/generation/type/ecc/EllipticCurve;)V", "algorithm", "Lorg/pgpainless/algorithm/PublicKeyAlgorithm;", "getAlgorithm", "()Lorg/pgpainless/algorithm/PublicKeyAlgorithm;", "bitStrength", "", "getBitStrength", "()I", "getCurve", "()Lorg/pgpainless/key/generation/type/ecc/EllipticCurve;", "name", "", "getName", "()Ljava/lang/String;", "generateKeyPair", "Lorg/bouncycastle/openpgp/PGPKeyPair;", "generator", "Lorg/bouncycastle/openpgp/operator/PGPKeyPairGenerator;", "Companion", "pgpainless-core"})
@SourceDebugExtension(value={"SMAP\nECDH.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ECDH.kt\norg/pgpainless/key/generation/type/ecc/ecdh/ECDH\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,27:1\n1#2:28\n*E\n"})
public final class ECDH
implements KeyType {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EllipticCurve curve;
    @NotNull
    private final String name;
    @NotNull
    private final PublicKeyAlgorithm algorithm;
    private final int bitStrength;

    private ECDH(EllipticCurve curve) {
        this.curve = curve;
        this.name = "ECDH";
        this.algorithm = PublicKeyAlgorithm.ECDH;
        this.bitStrength = this.curve.getBitStrength();
    }

    @NotNull
    public final EllipticCurve getCurve() {
        return this.curve;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public PublicKeyAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public int getBitStrength() {
        return this.bitStrength;
    }

    @Override
    @NotNull
    public PGPKeyPair generateKeyPair(@NotNull PGPKeyPairGenerator generator) {
        Intrinsics.checkNotNullParameter((Object)generator, (String)"generator");
        ASN1ObjectIdentifier it = ECUtil.getNamedCurveOid((String)this.curve.getCurveName());
        boolean bl = false;
        PGPKeyPair pGPKeyPair = generator.generateECDHKeyPair(it);
        Intrinsics.checkNotNullExpressionValue((Object)pGPKeyPair, (String)"let(...)");
        return pGPKeyPair;
    }

    @JvmStatic
    @NotNull
    public static final ECDH fromCurve(@NotNull EllipticCurve curve) {
        return Companion.fromCurve(curve);
    }

    public /* synthetic */ ECDH(EllipticCurve curve, DefaultConstructorMarker $constructor_marker) {
        this(curve);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lorg/pgpainless/key/generation/type/ecc/ecdh/ECDH$Companion;", "", "()V", "fromCurve", "Lorg/pgpainless/key/generation/type/ecc/ecdh/ECDH;", "curve", "Lorg/pgpainless/key/generation/type/ecc/EllipticCurve;", "pgpainless-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ECDH fromCurve(@NotNull EllipticCurve curve) {
            Intrinsics.checkNotNullParameter((Object)((Object)curve), (String)"curve");
            return new ECDH(curve, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

