/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.generation.type.ecc;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.openpgp.PGPKeyPair;
import org.bouncycastle.openpgp.operator.PGPKeyPairGenerator;
import org.jetbrains.annotations.NotNull;
import org.pgpainless.algorithm.PublicKeyAlgorithm;
import org.pgpainless.key.generation.type.KeyType;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0013"}, d2={"Lorg/pgpainless/key/generation/type/ecc/Ed25519;", "Lorg/pgpainless/key/generation/type/KeyType;", "()V", "algorithm", "Lorg/pgpainless/algorithm/PublicKeyAlgorithm;", "getAlgorithm", "()Lorg/pgpainless/algorithm/PublicKeyAlgorithm;", "bitStrength", "", "getBitStrength", "()I", "name", "", "getName", "()Ljava/lang/String;", "generateKeyPair", "Lorg/bouncycastle/openpgp/PGPKeyPair;", "generator", "Lorg/bouncycastle/openpgp/operator/PGPKeyPairGenerator;", "pgpainless-core"})
public final class Ed25519
implements KeyType {
    @NotNull
    private final String name;
    @NotNull
    private final PublicKeyAlgorithm algorithm = PublicKeyAlgorithm.ED25519;
    private final int bitStrength;

    public Ed25519() {
        this.name = "Ed25519";
        this.bitStrength = 256;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public PublicKeyAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public int getBitStrength() {
        return this.bitStrength;
    }

    @Override
    @NotNull
    public PGPKeyPair generateKeyPair(@NotNull PGPKeyPairGenerator generator) {
        Intrinsics.checkNotNullParameter((Object)generator, (String)"generator");
        PGPKeyPair pGPKeyPair = generator.generateEd25519KeyPair();
        Intrinsics.checkNotNullExpressionValue((Object)pGPKeyPair, (String)"generateEd25519KeyPair(...)");
        return pGPKeyPair;
    }
}

