/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.generation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyPair;
import org.bouncycastle.openpgp.PGPKeyRingGenerator;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.bouncycastle.openpgp.api.OpenPGPImplementation;
import org.bouncycastle.openpgp.api.OpenPGPKey;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.PGPKeyPairGenerator;
import org.bouncycastle.util.Strings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.AEADCipherMode;
import org.pgpainless.algorithm.AlgorithmSuite;
import org.pgpainless.algorithm.CompressionAlgorithm;
import org.pgpainless.algorithm.Feature;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.algorithm.OpenPGPKeyVersion;
import org.pgpainless.algorithm.PublicKeyAlgorithm;
import org.pgpainless.algorithm.SignatureType;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.bouncycastle.extensions.OpenPGPImplementationExtensionsKt;
import org.pgpainless.bouncycastle.extensions.PGPSecretKeyExtensionsKt;
import org.pgpainless.key.generation.KeyRingBuilderInterface;
import org.pgpainless.key.generation.KeySpec;
import org.pgpainless.key.generation.type.KeyType;
import org.pgpainless.key.protection.KeyRingProtectionSettings;
import org.pgpainless.policy.Policy;
import org.pgpainless.signature.subpackets.BaseSignatureSubpackets;
import org.pgpainless.signature.subpackets.SelfSignatureSubpackets;
import org.pgpainless.signature.subpackets.SignatureSubpackets;
import org.pgpainless.signature.subpackets.SignatureSubpacketsHelper;
import org.pgpainless.util.Passphrase;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 =2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001=B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J(\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\nH\u0002J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u000eH\u0016J\u0010\u0010\"\u001a\u00020\u00002\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010\"\u001a\u00020\u00002\u0006\u0010#\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0018H\u0002J\n\u0010+\u001a\u0004\u0018\u00010,H\u0002J\u0012\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010/\u001a\u000200H\u0002J\u0010\u00101\u001a\u0002022\u0006\u0010!\u001a\u00020\u000eH\u0002J\u0012\u00103\u001a\u00020\u00002\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0010\u00104\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u00105\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u000eH\u0016J\u0018\u00106\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u000e2\u0006\u00107\u001a\u000208H\u0002J\u0010\u00109\u001a\u00020\u001d2\u0006\u0010:\u001a\u00020\u000eH\u0002J\u0010\u0010;\u001a\u00020\u00002\u0006\u0010<\u001a\u00020\bH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lorg/pgpainless/key/generation/KeyRingBuilder;", "Lorg/pgpainless/key/generation/KeyRingBuilderInterface;", "version", "Lorg/pgpainless/algorithm/OpenPGPKeyVersion;", "api", "Lorg/pgpainless/PGPainless;", "(Lorg/pgpainless/algorithm/OpenPGPKeyVersion;Lorg/pgpainless/PGPainless;)V", "algorithmSuite", "Lorg/pgpainless/algorithm/AlgorithmSuite;", "expirationDate", "Ljava/util/Date;", "passphrase", "Lorg/pgpainless/util/Passphrase;", "primaryKeySpec", "Lorg/pgpainless/key/generation/KeySpec;", "subKeySpecs", "", "userIds", "", "", "Lorg/pgpainless/signature/subpackets/SelfSignatureSubpackets$Callback;", "addPrimaryKeyBindingSignatureIfNecessary", "Lorg/bouncycastle/openpgp/PGPSignatureSubpacketVector;", "primaryKey", "Lorg/bouncycastle/openpgp/PGPKeyPair;", "subKey", "hashedSubpackets", "bindingTime", "addSubKeys", "", "ringGenerator", "Lorg/bouncycastle/openpgp/PGPKeyRingGenerator;", "addSubkey", "keySpec", "addUserId", "userId", "", "", "build", "Lorg/bouncycastle/openpgp/api/OpenPGPKey;", "buildContentSigner", "Lorg/bouncycastle/openpgp/operator/PGPContentSignerBuilder;", "certKey", "buildSecretKeyDecryptor", "Lorg/bouncycastle/openpgp/operator/PBESecretKeyDecryptor;", "buildSecretKeyEncryptor", "Lorg/bouncycastle/openpgp/operator/PBESecretKeyEncryptor;", "publicKey", "Lorg/bouncycastle/openpgp/PGPPublicKey;", "keyIsCertificationCapable", "", "setExpirationDate", "setPassphrase", "setPrimaryKey", "verifyKeySpecCompliesToPolicy", "policy", "Lorg/pgpainless/policy/Policy;", "verifyPrimaryKeyCanCertify", "spec", "withPreferences", "preferences", "Companion", "pgpainless-core"})
@SourceDebugExtension(value={"SMAP\nKeyRingBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KeyRingBuilder.kt\norg/pgpainless/key/generation/KeyRingBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,308:1\n1#2:309\n37#3,2:310\n37#3,2:312\n*S KotlinDebug\n*F\n+ 1 KeyRingBuilder.kt\norg/pgpainless/key/generation/KeyRingBuilder\n*L\n119#1:310,2\n212#1:312,2\n*E\n"})
public final class KeyRingBuilder
implements KeyRingBuilderInterface<KeyRingBuilder> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final OpenPGPKeyVersion version;
    @NotNull
    private final PGPainless api;
    @Nullable
    private KeySpec primaryKeySpec;
    @NotNull
    private final List<KeySpec> subKeySpecs;
    @NotNull
    private final Map<String, SelfSignatureSubpackets.Callback> userIds;
    @NotNull
    private Passphrase passphrase;
    @Nullable
    private Date expirationDate;
    @NotNull
    private AlgorithmSuite algorithmSuite;
    public static final long MILLIS_IN_YEAR = 31536000000L;

    public KeyRingBuilder(@NotNull OpenPGPKeyVersion version, @NotNull PGPainless api) {
        Intrinsics.checkNotNullParameter((Object)((Object)version), (String)"version");
        Intrinsics.checkNotNullParameter((Object)api, (String)"api");
        this.version = version;
        this.api = api;
        this.subKeySpecs = new ArrayList();
        this.userIds = new LinkedHashMap();
        this.passphrase = Passphrase.Companion.emptyPassphrase();
        this.expirationDate = new Date(System.currentTimeMillis() + 157680000000L);
        this.algorithmSuite = this.api.getAlgorithmPolicy().getKeyGenerationAlgorithmSuite();
    }

    @Override
    @NotNull
    public KeyRingBuilder withPreferences(@NotNull AlgorithmSuite preferences) {
        KeyRingBuilder keyRingBuilder;
        Intrinsics.checkNotNullParameter((Object)preferences, (String)"preferences");
        KeyRingBuilder $this$withPreferences_u24lambda_u240 = keyRingBuilder = this;
        boolean bl = false;
        $this$withPreferences_u24lambda_u240.algorithmSuite = preferences;
        return keyRingBuilder;
    }

    @Override
    @NotNull
    public KeyRingBuilder setPrimaryKey(@NotNull KeySpec keySpec) {
        KeyRingBuilder keyRingBuilder;
        Intrinsics.checkNotNullParameter((Object)keySpec, (String)"keySpec");
        KeyRingBuilder $this$setPrimaryKey_u24lambda_u241 = keyRingBuilder = this;
        boolean bl = false;
        $this$setPrimaryKey_u24lambda_u241.verifyKeySpecCompliesToPolicy(keySpec, $this$setPrimaryKey_u24lambda_u241.api.getAlgorithmPolicy());
        $this$setPrimaryKey_u24lambda_u241.verifyPrimaryKeyCanCertify(keySpec);
        $this$setPrimaryKey_u24lambda_u241.primaryKeySpec = keySpec;
        return keyRingBuilder;
    }

    @Override
    @NotNull
    public KeyRingBuilder addSubkey(@NotNull KeySpec keySpec) {
        KeyRingBuilder keyRingBuilder;
        Intrinsics.checkNotNullParameter((Object)keySpec, (String)"keySpec");
        KeyRingBuilder $this$addSubkey_u24lambda_u242 = keyRingBuilder = this;
        boolean bl = false;
        $this$addSubkey_u24lambda_u242.verifyKeySpecCompliesToPolicy(keySpec, $this$addSubkey_u24lambda_u242.api.getAlgorithmPolicy());
        $this$addSubkey_u24lambda_u242.subKeySpecs.add(keySpec);
        return keyRingBuilder;
    }

    @Override
    @NotNull
    public KeyRingBuilder addUserId(@NotNull CharSequence userId) {
        KeyRingBuilder keyRingBuilder;
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        KeyRingBuilder $this$addUserId_u24lambda_u243 = keyRingBuilder = this;
        boolean bl = false;
        $this$addUserId_u24lambda_u243.userIds.put(((Object)userId).toString(), null);
        return keyRingBuilder;
    }

    @Override
    @NotNull
    public KeyRingBuilder addUserId(@NotNull byte[] userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        String string = Strings.fromUTF8ByteArray((byte[])userId);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"fromUTF8ByteArray(...)");
        return this.addUserId(string);
    }

    @Override
    @NotNull
    public KeyRingBuilder setExpirationDate(@Nullable Date expirationDate) {
        Date date;
        KeyRingBuilder keyRingBuilder;
        KeyRingBuilder $this$setExpirationDate_u24lambda_u246 = keyRingBuilder = this;
        boolean bl = false;
        KeyRingBuilder keyRingBuilder2 = $this$setExpirationDate_u24lambda_u246;
        Date date2 = expirationDate;
        if (date2 != null) {
            Date date3 = date2;
            KeyRingBuilder keyRingBuilder3 = keyRingBuilder2;
            boolean bl2 = false;
            if (!(new Date().compareTo(expirationDate) < 0)) {
                boolean bl3 = false;
                String string = "Expiration date must be in the future.";
                throw new IllegalArgumentException(string.toString());
            }
            date = expirationDate;
            keyRingBuilder2 = keyRingBuilder3;
        } else {
            date = null;
        }
        keyRingBuilder2.expirationDate = date;
        return keyRingBuilder;
    }

    @Override
    @NotNull
    public KeyRingBuilder setPassphrase(@NotNull Passphrase passphrase) {
        KeyRingBuilder keyRingBuilder;
        Intrinsics.checkNotNullParameter((Object)passphrase, (String)"passphrase");
        KeyRingBuilder $this$setPassphrase_u24lambda_u247 = keyRingBuilder = this;
        boolean bl = false;
        $this$setPassphrase_u24lambda_u247.passphrase = passphrase;
        return keyRingBuilder;
    }

    private final void verifyKeySpecCompliesToPolicy(KeySpec keySpec, Policy policy) {
        PublicKeyAlgorithm algorithm = keySpec.getKeyType().getAlgorithm();
        int bitStrength = keySpec.getKeyType().getBitStrength();
        if (!policy.getPublicKeyAlgorithmPolicy().isAcceptable(algorithm, bitStrength)) {
            boolean bl = false;
            String string = "Public key algorithm policy violation: " + algorithm + " with bit strength " + bitStrength + " is not acceptable.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    private final void verifyPrimaryKeyCanCertify(KeySpec spec) {
        if (!this.keyIsCertificationCapable(spec)) {
            boolean bl = false;
            String string = "Key algorithm " + spec.getKeyType().getName() + " is not capable of creation certifications.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    private final boolean keyIsCertificationCapable(KeySpec keySpec) {
        return keySpec.getKeyType().canCertify();
    }

    @Override
    @NotNull
    public OpenPGPKey build() {
        Object[] callback2;
        Set<Object> set;
        Set<Enum> it;
        SignatureSubpackets signatureSubpackets;
        PGPDigestCalculator checksumCalculator = OpenPGPImplementationExtensionsKt.checksumCalculator(this.api.getImplementation());
        if (this.primaryKeySpec == null) {
            boolean $i$a$-requireNotNull-KeyRingBuilder$build$22 = false;
            String $i$a$-requireNotNull-KeyRingBuilder$build$22 = "Primary Key spec required.";
            throw new IllegalArgumentException($i$a$-requireNotNull-KeyRingBuilder$build$22.toString());
        }
        KeySpec keySpec = this.primaryKeySpec;
        Intrinsics.checkNotNull((Object)keySpec);
        PGPKeyPair certKey = org.pgpainless.key.generation.KeyRingBuilder$Companion.generateKeyPair$default(Companion, keySpec, this.version, this.api.getImplementation(), null, 8, null);
        PGPPublicKey pGPPublicKey = certKey.getPublicKey();
        Intrinsics.checkNotNullExpressionValue((Object)pGPPublicKey, (String)"getPublicKey(...)");
        PBESecretKeyEncryptor secretKeyEncryptor = this.buildSecretKeyEncryptor(pGPPublicKey);
        PBESecretKeyDecryptor secretKeyDecryptor = this.buildSecretKeyDecryptor();
        this.passphrase.clear();
        PGPContentSignerBuilder signer = this.buildContentSigner(certKey);
        PGPSignatureGenerator signatureGenerator = new PGPSignatureGenerator(signer, certKey.getPublicKey());
        PGPPublicKey pGPPublicKey2 = certKey.getPublicKey();
        Intrinsics.checkNotNullExpressionValue((Object)pGPPublicKey2, (String)"getPublicKey(...)");
        SignatureSubpackets $this$build_u24lambda_u2417 = signatureSubpackets = SignatureSubpackets.Companion.createHashedSubpackets(pGPPublicKey2);
        boolean bl = false;
        KeySpec keySpec2 = this.primaryKeySpec;
        Intrinsics.checkNotNull((Object)keySpec2);
        Date date = keySpec2.getKeyCreationDate();
        if (date != null) {
            it = date;
            boolean bl2 = false;
            $this$build_u24lambda_u2417.setSignatureCreationTime((Date)((Object)it));
        }
        KeySpec keySpec3 = this.primaryKeySpec;
        Intrinsics.checkNotNull((Object)keySpec3);
        $this$build_u24lambda_u2417.setKeyFlags(keySpec3.getKeyFlags());
        KeySpec keySpec4 = this.primaryKeySpec;
        Intrinsics.checkNotNull((Object)keySpec4);
        Set<HashAlgorithm> set2 = keySpec4.getPreferredHashAlgorithmsOverride();
        if (set2 == null) {
            set2 = this.algorithmSuite.getHashAlgorithms();
        }
        if ((set = set2) != null) {
            it = set;
            boolean bl3 = false;
            $this$build_u24lambda_u2417.setPreferredHashAlgorithms(it);
        }
        KeySpec keySpec5 = this.primaryKeySpec;
        Intrinsics.checkNotNull((Object)keySpec5);
        Set<CompressionAlgorithm> set3 = keySpec5.getPreferredCompressionAlgorithmsOverride();
        if (set3 == null) {
            set3 = this.algorithmSuite.getCompressionAlgorithms();
        }
        if ((set = set3) != null) {
            it = set;
            boolean bl4 = false;
            $this$build_u24lambda_u2417.setPreferredCompressionAlgorithms(it);
        }
        KeySpec keySpec6 = this.primaryKeySpec;
        Intrinsics.checkNotNull((Object)keySpec6);
        Set<SymmetricKeyAlgorithm> set4 = keySpec6.getPreferredSymmetricAlgorithmsOverride();
        if (set4 == null) {
            set4 = this.algorithmSuite.getSymmetricKeyAlgorithms();
        }
        if ((set = set4) != null) {
            it = set;
            boolean bl5 = false;
            $this$build_u24lambda_u2417.setPreferredSymmetricKeyAlgorithms(it);
        }
        KeySpec keySpec7 = this.primaryKeySpec;
        Intrinsics.checkNotNull((Object)keySpec7);
        Set<AEADCipherMode> set5 = keySpec7.getPreferredAEADAlgorithmsOverride();
        if (set5 == null) {
            set5 = this.algorithmSuite.getAeadAlgorithms();
        }
        if ((set = set5) != null) {
            it = set;
            boolean bl6 = false;
            $this$build_u24lambda_u2417.setPreferredAEADCiphersuites(it);
        }
        KeySpec keySpec8 = this.primaryKeySpec;
        Intrinsics.checkNotNull((Object)keySpec8);
        Set<Feature> set6 = keySpec8.getFeaturesOverride();
        if (set6 == null) {
            set6 = this.algorithmSuite.getFeatures();
        }
        if (set6 != null) {
            it = set6;
            boolean bl7 = false;
            Collection $this$toTypedArray$iv = it;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Feature[] featureArray = thisCollection$iv.toArray(new Feature[0]);
            $this$build_u24lambda_u2417.setFeatures(Arrays.copyOf(featureArray, featureArray.length));
        }
        SignatureSubpackets hashedSignatureSubpackets = signatureSubpackets;
        Date date2 = this.expirationDate;
        if (date2 != null) {
            Date it2 = date2;
            boolean bl8 = false;
            PGPPublicKey pGPPublicKey3 = certKey.getPublicKey();
            Intrinsics.checkNotNullExpressionValue((Object)pGPPublicKey3, (String)"getPublicKey(...)");
            hashedSignatureSubpackets.setKeyExpirationTime(pGPPublicKey3, it2);
        }
        if (!this.userIds.isEmpty()) {
            hashedSignatureSubpackets.setPrimaryUserId();
        }
        PGPSignatureSubpacketVector hashedSubPackets = hashedSignatureSubpackets.getSubpacketsGenerator().generate();
        PGPKeyRingGenerator ringGenerator = this.userIds.isEmpty() ? new PGPKeyRingGenerator(certKey, checksumCalculator, hashedSubPackets, null, signer, secretKeyEncryptor) : new PGPKeyRingGenerator(SignatureType.POSITIVE_CERTIFICATION.getCode(), certKey, (String)CollectionsKt.first((Iterable)this.userIds.keySet()), checksumCalculator, hashedSubPackets, null, signer, secretKeyEncryptor);
        this.addSubKeys(certKey, ringGenerator);
        PGPSecretKeyRing secretKeyRing = ringGenerator.generateSecretKeyRing();
        Iterator secretKeys = secretKeyRing.getSecretKeys();
        PGPPublicKey primaryPubKey = ((PGPSecretKey)secretKeys.next()).getPublicKey();
        PGPSecretKey pGPSecretKey = secretKeyRing.getSecretKey();
        Intrinsics.checkNotNullExpressionValue((Object)pGPSecretKey, (String)"getSecretKey(...)");
        PGPPrivateKey privateKey = PGPSecretKeyExtensionsKt.unlock(pGPSecretKey, secretKeyDecryptor);
        Iterator<Map.Entry<String, SelfSignatureSubpackets.Callback>> userIdIterator = this.userIds.entrySet().iterator();
        if (userIdIterator.hasNext()) {
            userIdIterator.next();
        }
        while (userIdIterator.hasNext()) {
            SignatureSubpackets signatureSubpackets2;
            SignatureSubpackets it3;
            SignatureSubpackets signatureSubpackets3;
            Map.Entry<String, SelfSignatureSubpackets.Callback> additionalUserId = userIdIterator.next();
            String userIdString = additionalUserId.getKey();
            callback2 = additionalUserId.getValue();
            if (callback2 == null) {
                it3 = signatureSubpackets3 = hashedSignatureSubpackets;
                boolean bl9 = false;
                it3.setPrimaryUserId(null);
                signatureSubpackets2 = signatureSubpackets3;
            } else {
                signatureSubpackets3 = primaryPubKey;
                Intrinsics.checkNotNull((Object)signatureSubpackets3);
                it3 = signatureSubpackets3 = SignatureSubpackets.Companion.createHashedSubpackets((PGPPublicKey)signatureSubpackets3);
                boolean bl10 = false;
                callback2.modifyHashedSubpackets((BaseSignatureSubpackets)it3);
                signatureSubpackets2 = signatureSubpackets3;
            }
            SignatureSubpackets subpackets = signatureSubpackets2;
            signatureGenerator.init(SignatureType.POSITIVE_CERTIFICATION.getCode(), privateKey);
            signatureGenerator.setHashedSubpackets(SignatureSubpacketsHelper.Companion.toVector(subpackets));
            PGPSignature additionalUserIdSignature = signatureGenerator.generateCertification(userIdString, primaryPubKey);
            primaryPubKey = PGPPublicKey.addCertification((PGPPublicKey)primaryPubKey, (String)userIdString, (PGPSignature)additionalUserIdSignature);
        }
        PGPSecretKey primarySecretKey = new PGPSecretKey(privateKey, primaryPubKey, checksumCalculator, true, secretKeyEncryptor);
        callback2 = new PGPSecretKey[]{primarySecretKey};
        List secretKeyList = CollectionsKt.mutableListOf((Object[])callback2);
        while (secretKeys.hasNext()) {
            Object e = secretKeys.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            secretKeyList.add(e);
        }
        PGPSecretKeyRing pgpSecretKeyRing = new PGPSecretKeyRing(secretKeyList);
        return new OpenPGPKey(pgpSecretKeyRing, this.api.getImplementation());
    }

    private final void addSubKeys(PGPKeyPair primaryKey, PGPKeyRingGenerator ringGenerator) {
        for (KeySpec subKeySpec : this.subKeySpecs) {
            Set<Object> it;
            SignatureSubpackets signatureSubpackets;
            PGPKeyPair subKey = org.pgpainless.key.generation.KeyRingBuilder$Companion.generateKeyPair$default(Companion, subKeySpec, this.version, this.api.getImplementation(), null, 8, null);
            Date date = subKeySpec.getKeyCreationDate();
            if (date == null) {
                date = new Date();
            }
            Date creationTime = date;
            PGPPublicKey pGPPublicKey = primaryKey.getPublicKey();
            Intrinsics.checkNotNullExpressionValue((Object)pGPPublicKey, (String)"getPublicKey(...)");
            SignatureSubpackets $this$addSubKeys_u24lambda_u2426 = signatureSubpackets = SignatureSubpackets.Companion.createHashedSubpackets(pGPPublicKey);
            boolean bl = false;
            $this$addSubKeys_u24lambda_u2426.setSignatureCreationTime(creationTime);
            $this$addSubKeys_u24lambda_u2426.setKeyFlags(subKeySpec.getKeyFlags());
            if (subKeySpec.getPreferredHashAlgorithmsOverride() != null) {
                boolean bl2 = false;
                $this$addSubKeys_u24lambda_u2426.setPreferredHashAlgorithms(it);
            }
            if (subKeySpec.getPreferredCompressionAlgorithmsOverride() != null) {
                boolean bl3 = false;
                $this$addSubKeys_u24lambda_u2426.setPreferredCompressionAlgorithms(it);
            }
            if (subKeySpec.getPreferredSymmetricAlgorithmsOverride() != null) {
                boolean bl4 = false;
                $this$addSubKeys_u24lambda_u2426.setPreferredSymmetricKeyAlgorithms(it);
            }
            if (subKeySpec.getPreferredAEADAlgorithmsOverride() != null) {
                boolean bl5 = false;
                $this$addSubKeys_u24lambda_u2426.setPreferredAEADCiphersuites(it);
            }
            if (subKeySpec.getFeaturesOverride() != null) {
                boolean bl6 = false;
                Collection $this$toTypedArray$iv = it;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                Feature[] featureArray = thisCollection$iv.toArray(new Feature[0]);
                $this$addSubKeys_u24lambda_u2426.setFeatures(Arrays.copyOf(featureArray, featureArray.length));
            }
            SignatureSubpackets hashedSignatureSubpackets = signatureSubpackets;
            PGPSignatureSubpacketVector pGPSignatureSubpacketVector = hashedSignatureSubpackets.getSubpacketsGenerator().generate();
            Intrinsics.checkNotNullExpressionValue((Object)pGPSignatureSubpacketVector, (String)"generate(...)");
            PGPSignatureSubpacketVector hashedSubpackets = pGPSignatureSubpacketVector;
            try {
                hashedSubpackets = this.addPrimaryKeyBindingSignatureIfNecessary(primaryKey, subKey, hashedSubpackets, creationTime);
            }
            catch (IOException e) {
                throw new PGPException("Exception while adding primary key binding signature to signing subkey.", (Exception)e);
            }
            ringGenerator.addSubKey(subKey, hashedSubpackets, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final PGPSignatureSubpacketVector addPrimaryKeyBindingSignatureIfNecessary(PGPKeyPair primaryKey, PGPKeyPair subKey, PGPSignatureSubpacketVector hashedSubpackets, Date bindingTime) {
        void $this$addPrimaryKeyBindingSignatureIfNecessary_u24lambda_u2427;
        PGPSignatureSubpacketGenerator pGPSignatureSubpacketGenerator;
        int keyFlagMask = hashedSubpackets.getKeyFlags();
        if (!KeyFlag.Companion.hasKeyFlag(keyFlagMask, KeyFlag.SIGN_DATA) && !KeyFlag.Companion.hasKeyFlag(keyFlagMask, KeyFlag.CERTIFY_OTHER)) {
            return hashedSubpackets;
        }
        PGPSignatureGenerator bindingSignatureGenerator = new PGPSignatureGenerator(this.buildContentSigner(subKey), subKey.getPublicKey());
        bindingSignatureGenerator.init(SignatureType.PRIMARYKEY_BINDING.getCode(), subKey.getPrivateKey());
        PGPSignatureSubpacketGenerator pGPSignatureSubpacketGenerator2 = pGPSignatureSubpacketGenerator = new PGPSignatureSubpacketGenerator();
        PGPSignatureGenerator pGPSignatureGenerator = bindingSignatureGenerator;
        boolean bl = false;
        $this$addPrimaryKeyBindingSignatureIfNecessary_u24lambda_u2427.setSignatureCreationTime(bindingTime);
        $this$addPrimaryKeyBindingSignatureIfNecessary_u24lambda_u2427.setIssuerFingerprint(false, subKey.getPublicKey());
        pGPSignatureGenerator.setHashedSubpackets(pGPSignatureSubpacketGenerator.generate());
        PGPSignature primaryKeyBindingSig = bindingSignatureGenerator.generateCertification(primaryKey.getPublicKey(), subKey.getPublicKey());
        PGPSignatureSubpacketGenerator subpacketGenerator = new PGPSignatureSubpacketGenerator(hashedSubpackets);
        subpacketGenerator.addEmbeddedSignature(false, primaryKeyBindingSig);
        PGPSignatureSubpacketVector pGPSignatureSubpacketVector = subpacketGenerator.generate();
        Intrinsics.checkNotNullExpressionValue((Object)pGPSignatureSubpacketVector, (String)"generate(...)");
        return pGPSignatureSubpacketVector;
    }

    private final PGPContentSignerBuilder buildContentSigner(PGPKeyPair certKey) {
        HashAlgorithm hashAlgorithm = this.api.getAlgorithmPolicy().getCertificationSignatureHashAlgorithmPolicy().getDefaultHashAlgorithm();
        PGPContentSignerBuilder pGPContentSignerBuilder = this.api.getImplementation().pgpContentSignerBuilder(certKey.getPublicKey().getAlgorithm(), hashAlgorithm.getAlgorithmId());
        Intrinsics.checkNotNullExpressionValue((Object)pGPContentSignerBuilder, (String)"pgpContentSignerBuilder(...)");
        return pGPContentSignerBuilder;
    }

    private final PBESecretKeyEncryptor buildSecretKeyEncryptor(PGPPublicKey publicKey) {
        if (!this.passphrase.isValid()) {
            boolean bl = false;
            String string = "Passphrase was cleared.";
            throw new IllegalStateException(string.toString());
        }
        KeyRingProtectionSettings protectionSettings = this.api.getAlgorithmPolicy().getKeyProtectionSettings();
        return this.passphrase.isEmpty() ? null : this.api.getImplementation().pbeSecretKeyEncryptorFactory(protectionSettings.getAead(), protectionSettings.getEncryptionAlgorithm().getAlgorithmId(), protectionSettings.getS2kCount()).build(this.passphrase.getChars(), publicKey.getPublicKeyPacket());
    }

    private final PBESecretKeyDecryptor buildSecretKeyDecryptor() {
        if (!this.passphrase.isValid()) {
            boolean bl = false;
            String string = "Passphrase was cleared.";
            throw new IllegalStateException(string.toString());
        }
        return this.passphrase.isEmpty() ? null : this.api.getImplementation().pbeSecretKeyDecryptorBuilderProvider().provide().build(this.passphrase.getChars());
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final PGPKeyPair generateKeyPair(@NotNull KeySpec spec, @NotNull OpenPGPKeyVersion version, @NotNull OpenPGPImplementation implementation, @NotNull Date creationTime) {
        return Companion.generateKeyPair(spec, version, implementation, creationTime);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final PGPKeyPair generateKeyPair(@NotNull KeySpec spec, @NotNull OpenPGPKeyVersion version, @NotNull OpenPGPImplementation implementation) {
        return Companion.generateKeyPair(spec, version, implementation);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final PGPKeyPair generateKeyPair(@NotNull KeySpec spec, @NotNull OpenPGPKeyVersion version) {
        return Companion.generateKeyPair(spec, version);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000eH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/pgpainless/key/generation/KeyRingBuilder$Companion;", "", "()V", "MILLIS_IN_YEAR", "", "generateKeyPair", "Lorg/bouncycastle/openpgp/PGPKeyPair;", "spec", "Lorg/pgpainless/key/generation/KeySpec;", "version", "Lorg/pgpainless/algorithm/OpenPGPKeyVersion;", "implementation", "Lorg/bouncycastle/openpgp/api/OpenPGPImplementation;", "creationTime", "Ljava/util/Date;", "pgpainless-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final PGPKeyPair generateKeyPair(@NotNull KeySpec spec, @NotNull OpenPGPKeyVersion version, @NotNull OpenPGPImplementation implementation, @NotNull Date creationTime) {
            Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
            Intrinsics.checkNotNullParameter((Object)((Object)version), (String)"version");
            Intrinsics.checkNotNullParameter((Object)implementation, (String)"implementation");
            Intrinsics.checkNotNullParameter((Object)creationTime, (String)"creationTime");
            PGPKeyPairGenerator gen = implementation.pgpKeyPairGeneratorProvider().get(version.getNumeric(), creationTime);
            KeyType keyType = spec.getKeyType();
            Intrinsics.checkNotNull((Object)gen);
            return keyType.generateKeyPair(gen);
        }

        public static /* synthetic */ PGPKeyPair generateKeyPair$default(Companion companion, KeySpec keySpec, OpenPGPKeyVersion openPGPKeyVersion, OpenPGPImplementation openPGPImplementation, Date date, int n, Object object) {
            if ((n & 4) != 0) {
                openPGPImplementation = PGPainless.Companion.getInstance().getImplementation();
            }
            if ((n & 8) != 0) {
                Date date2 = keySpec.getKeyCreationDate();
                if (date2 == null) {
                    date2 = new Date();
                }
                date = date2;
            }
            return companion.generateKeyPair(keySpec, openPGPKeyVersion, openPGPImplementation, date);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final PGPKeyPair generateKeyPair(@NotNull KeySpec spec, @NotNull OpenPGPKeyVersion version, @NotNull OpenPGPImplementation implementation) {
            Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
            Intrinsics.checkNotNullParameter((Object)((Object)version), (String)"version");
            Intrinsics.checkNotNullParameter((Object)implementation, (String)"implementation");
            return org.pgpainless.key.generation.KeyRingBuilder$Companion.generateKeyPair$default(this, spec, version, implementation, null, 8, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final PGPKeyPair generateKeyPair(@NotNull KeySpec spec, @NotNull OpenPGPKeyVersion version) {
            Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
            Intrinsics.checkNotNullParameter((Object)((Object)version), (String)"version");
            return org.pgpainless.key.generation.KeyRingBuilder$Companion.generateKeyPair$default(this, spec, version, null, null, 12, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

