/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key;

import java.net.URI;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.bouncycastle.bcpg.FingerprintUtil;
import org.bouncycastle.bcpg.KeyIdentifier;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.api.OpenPGPCertificate;
import org.jetbrains.annotations.NotNull;
import org.pgpainless.key.OpenPgpFingerprint;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 #2\u00020\u0001:\u0001#B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u000f\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB\u000f\b\u0016\u0012\u0006\u0010\b\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fB\u000f\b\u0016\u0012\u0006\u0010\b\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eB\u000f\b\u0016\u0012\u0006\u0010\b\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010B\u000f\b\u0016\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0014J\b\u0010 \u001a\u00020\u0003H\u0016J\u0006\u0010!\u001a\u00020\"R\u0014\u0010\u0014\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006$"}, d2={"Lorg/pgpainless/key/OpenPgpV4Fingerprint;", "Lorg/pgpainless/key/OpenPgpFingerprint;", "fingerprint", "", "(Ljava/lang/String;)V", "bytes", "", "([B)V", "key", "Lorg/bouncycastle/openpgp/api/OpenPGPCertificate;", "(Lorg/bouncycastle/openpgp/api/OpenPGPCertificate;)V", "Lorg/bouncycastle/openpgp/api/OpenPGPCertificate$OpenPGPComponentKey;", "(Lorg/bouncycastle/openpgp/api/OpenPGPCertificate$OpenPGPComponentKey;)V", "Lorg/bouncycastle/openpgp/PGPPublicKey;", "(Lorg/bouncycastle/openpgp/PGPPublicKey;)V", "Lorg/bouncycastle/openpgp/PGPSecretKey;", "(Lorg/bouncycastle/openpgp/PGPSecretKey;)V", "keys", "Lorg/bouncycastle/openpgp/PGPKeyRing;", "(Lorg/bouncycastle/openpgp/PGPKeyRing;)V", "keyId", "", "getKeyId", "()J", "keyIdentifier", "Lorg/bouncycastle/bcpg/KeyIdentifier;", "getKeyIdentifier", "()Lorg/bouncycastle/bcpg/KeyIdentifier;", "getVersion", "", "isValid", "", "prettyPrint", "toUri", "Ljava/net/URI;", "Companion", "pgpainless-core"})
public final class OpenPgpV4Fingerprint
extends OpenPgpFingerprint {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long keyId;
    @NotNull
    private final KeyIdentifier keyIdentifier;
    @NotNull
    private static final String SCHEME = "openpgp4fpr";

    public OpenPgpV4Fingerprint(@NotNull String fingerprint) {
        Intrinsics.checkNotNullParameter((Object)fingerprint, (String)"fingerprint");
        super(fingerprint);
        this.keyId = FingerprintUtil.keyIdFromV4Fingerprint((byte[])this.getBytes());
        this.keyIdentifier = new KeyIdentifier(this.getBytes());
    }

    public OpenPgpV4Fingerprint(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        super(bytes);
        this.keyId = FingerprintUtil.keyIdFromV4Fingerprint((byte[])this.getBytes());
        this.keyIdentifier = new KeyIdentifier(this.getBytes());
    }

    public OpenPgpV4Fingerprint(@NotNull OpenPGPCertificate key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        byte[] byArray = key.getFingerprint();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getFingerprint(...)");
        super(byArray);
        this.keyId = FingerprintUtil.keyIdFromV4Fingerprint((byte[])this.getBytes());
        this.keyIdentifier = new KeyIdentifier(this.getBytes());
    }

    public OpenPgpV4Fingerprint(@NotNull OpenPGPCertificate.OpenPGPComponentKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        PGPPublicKey pGPPublicKey = key.getPGPPublicKey();
        Intrinsics.checkNotNullExpressionValue((Object)pGPPublicKey, (String)"getPGPPublicKey(...)");
        super(pGPPublicKey);
        this.keyId = FingerprintUtil.keyIdFromV4Fingerprint((byte[])this.getBytes());
        this.keyIdentifier = new KeyIdentifier(this.getBytes());
    }

    public OpenPgpV4Fingerprint(@NotNull PGPPublicKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        super(key);
        this.keyId = FingerprintUtil.keyIdFromV4Fingerprint((byte[])this.getBytes());
        this.keyIdentifier = new KeyIdentifier(this.getBytes());
    }

    public OpenPgpV4Fingerprint(@NotNull PGPSecretKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        super(key);
        this.keyId = FingerprintUtil.keyIdFromV4Fingerprint((byte[])this.getBytes());
        this.keyIdentifier = new KeyIdentifier(this.getBytes());
    }

    public OpenPgpV4Fingerprint(@NotNull PGPKeyRing keys) {
        Intrinsics.checkNotNullParameter((Object)keys, (String)"keys");
        super(keys);
        this.keyId = FingerprintUtil.keyIdFromV4Fingerprint((byte[])this.getBytes());
        this.keyIdentifier = new KeyIdentifier(this.getBytes());
    }

    @Override
    public int getVersion() {
        return 4;
    }

    @Override
    public long getKeyId() {
        return this.keyId;
    }

    @Override
    @NotNull
    public KeyIdentifier getKeyIdentifier() {
        return this.keyIdentifier;
    }

    @Override
    protected boolean isValid(@NotNull String fingerprint) {
        Intrinsics.checkNotNullParameter((Object)fingerprint, (String)"fingerprint");
        CharSequence charSequence = fingerprint;
        return new Regex("^[0-9A-F]{40}$").matches(charSequence);
    }

    @NotNull
    public final URI toUri() {
        return new URI(SCHEME, this.toString(), null);
    }

    @Override
    @NotNull
    public String prettyPrint() {
        int i;
        StringBuilder stringBuilder;
        StringBuilder $this$prettyPrint_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        for (i = 0; i < 5; ++i) {
            $this$prettyPrint_u24lambda_u240.append(this.getFingerprint(), i * 4, (i + 1) * 4).append(' ');
        }
        $this$prettyPrint_u24lambda_u240.append(' ');
        for (i = 5; i < 9; ++i) {
            $this$prettyPrint_u24lambda_u240.append(this.getFingerprint(), i * 4, (i + 1) * 4).append(' ');
        }
        $this$prettyPrint_u24lambda_u240.append(this.getFingerprint(), 36, 40);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public static final String getSCHEME() {
        return Companion.getSCHEME();
    }

    @JvmStatic
    @NotNull
    public static final OpenPgpV4Fingerprint fromUri(@NotNull URI uri) {
        return Companion.fromUri(uri);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/pgpainless/key/OpenPgpV4Fingerprint$Companion;", "", "()V", "SCHEME", "", "getSCHEME$annotations", "getSCHEME", "()Ljava/lang/String;", "fromUri", "Lorg/pgpainless/key/OpenPgpV4Fingerprint;", "uri", "Ljava/net/URI;", "pgpainless-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getSCHEME() {
            return SCHEME;
        }

        @JvmStatic
        public static /* synthetic */ void getSCHEME$annotations() {
        }

        @JvmStatic
        @NotNull
        public final OpenPgpV4Fingerprint fromUri(@NotNull URI uri) {
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            if (!Intrinsics.areEqual((Object)this.getSCHEME(), (Object)uri.getScheme())) {
                throw new IllegalArgumentException("URI scheme MUST equal '" + this.getSCHEME() + "'.");
            }
            String string = uri.getSchemeSpecificPart();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSchemeSpecificPart(...)");
            return new OpenPgpV4Fingerprint(string);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

