/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.exception;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSignature;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.algorithm.SignatureType;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0011\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004B\u001d\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u00a2\u0006\u0002\u0010\bB'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0016\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\b\u0012\u00060\u0006j\u0002`\u00070\n\u00a2\u0006\u0002\u0010\f\u00a8\u0006\u000e"}, d2={"Lorg/pgpainless/exception/SignatureValidationException;", "Lorg/bouncycastle/openpgp/PGPException;", "message", "", "(Ljava/lang/String;)V", "underlying", "Ljava/lang/Exception;", "Lkotlin/Exception;", "(Ljava/lang/String;Ljava/lang/Exception;)V", "rejections", "", "Lorg/bouncycastle/openpgp/PGPSignature;", "(Ljava/lang/String;Ljava/util/Map;)V", "Companion", "pgpainless-core"})
public final class SignatureValidationException
extends PGPException {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public SignatureValidationException(@Nullable String message) {
        super(message);
    }

    public SignatureValidationException(@Nullable String message, @NotNull Exception underlying) {
        Intrinsics.checkNotNullParameter((Object)underlying, (String)"underlying");
        super(message, underlying);
    }

    public SignatureValidationException(@NotNull String message, @NotNull Map<PGPSignature, ? extends Exception> rejections) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(rejections, (String)"rejections");
        super(message + ": " + SignatureValidationException.Companion.exceptionMapToString(rejections));
    }

    @JvmStatic
    private static final String exceptionMapToString(Map<PGPSignature, ? extends Exception> rejections) {
        return SignatureValidationException.Companion.exceptionMapToString(rejections);
    }

    @JvmStatic
    private static final String sigTypeToString(int type) {
        return SignatureValidationException.Companion.sigTypeToString(type);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0016\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\b\u0012\u00060\bj\u0002`\t0\u0006H\u0003J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0003\u00a8\u0006\r"}, d2={"Lorg/pgpainless/exception/SignatureValidationException$Companion;", "", "()V", "exceptionMapToString", "", "rejections", "", "Lorg/bouncycastle/openpgp/PGPSignature;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "sigTypeToString", "type", "", "pgpainless-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private final String exceptionMapToString(Map<PGPSignature, ? extends Exception> rejections) {
            StringBuilder stringBuilder;
            StringBuilder $this$exceptionMapToString_u24lambda_u240 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$exceptionMapToString_u24lambda_u240.append(rejections.size()).append(" rejected signatures:\n");
            for (PGPSignature signature : rejections.keySet()) {
                StringBuilder stringBuilder2 = $this$exceptionMapToString_u24lambda_u240.append(Companion.sigTypeToString(signature.getSignatureType())).append(' ').append(signature.getCreationTime()).append(": ");
                Exception exception = rejections.get(signature);
                Intrinsics.checkNotNull((Object)exception);
                stringBuilder2.append(exception.getMessage()).append('\n');
            }
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        @JvmStatic
        private final String sigTypeToString(int type) {
            Object object = SignatureType.Companion.fromCode(type);
            if (object == null || (object = object.toString()) == null) {
                object = "0x" + Long.toHexString(type);
            }
            return object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

