/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.encryption_signing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bouncycastle.bcpg.KeyIdentifier;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.api.MessageEncryptionMechanism;
import org.bouncycastle.openpgp.api.OpenPGPCertificate;
import org.bouncycastle.openpgp.operator.PBEKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.PGPKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.PublicKeyKeyEncryptionMethodGenerator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.EncryptionPurpose;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.algorithm.negotiation.EncryptionMechanismNegotiator;
import org.pgpainless.algorithm.negotiation.SymmetricKeyAlgorithmNegotiator;
import org.pgpainless.authentication.CertificateAuthenticity;
import org.pgpainless.authentication.CertificateAuthority;
import org.pgpainless.exception.KeyException;
import org.pgpainless.key.SubkeyIdentifier;
import org.pgpainless.key.info.KeyAccessor;
import org.pgpainless.key.info.KeyRingInfo;
import org.pgpainless.util.Passphrase;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00ba\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\b\r\u0018\u0000 \\2\u00020\u0001:\u0002\\]B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J \u00103\u001a\u00020\u00002\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\u001e2\u0006\u00107\u001a\u00020\u0012H\u0002J*\u00108\u001a\u00020\u00002\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020\u00122\u0006\u0010<\u001a\u00020=2\b\b\u0002\u0010>\u001a\u00020?H\u0007J\u000e\u0010@\u001a\u00020\u00002\u0006\u0010A\u001a\u00020\fJ\u001a\u0010B\u001a\u00020\u00002\u0006\u0010C\u001a\u00020D2\b\b\u0002\u00106\u001a\u00020\u001eH\u0007J\u001a\u0010B\u001a\u00020\u00002\u0006\u00104\u001a\u0002052\b\b\u0002\u00106\u001a\u00020\u001eH\u0007J\u000e\u0010E\u001a\u00020\u00002\u0006\u0010F\u001a\u00020GJ\u0010\u0010H\u001a\u00020\u00002\u0006\u0010F\u001a\u00020GH\u0007J\u0010\u0010I\u001a\u00020\u00002\u0006\u0010C\u001a\u00020DH\u0007J\u0018\u0010I\u001a\u00020\u00002\u0006\u0010C\u001a\u00020D2\u0006\u00109\u001a\u00020JH\u0007J \u0010I\u001a\u00020\u00002\u0006\u0010C\u001a\u00020D2\u0006\u00109\u001a\u00020J2\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J\u0018\u0010I\u001a\u00020\u00002\u0006\u0010C\u001a\u00020D2\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J\u000e\u0010I\u001a\u00020\u00002\u0006\u00104\u001a\u000205J\u0016\u0010I\u001a\u00020\u00002\u0006\u00104\u001a\u0002052\u0006\u00109\u001a\u00020JJ\u001e\u0010I\u001a\u00020\u00002\u0006\u00104\u001a\u0002052\u0006\u00109\u001a\u00020J2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0016\u0010I\u001a\u00020\u00002\u0006\u00104\u001a\u0002052\u0006\u0010\u001d\u001a\u00020\u001eJ \u0010K\u001a\u00020L2\u0006\u0010C\u001a\u00020!2\u0006\u0010M\u001a\u0002022\u0006\u0010N\u001a\u00020\u0012H\u0002J\u0016\u0010O\u001a\u00020\u00002\f\u0010P\u001a\b\u0012\u0004\u0012\u00020D0QH\u0007J\u001e\u0010O\u001a\u00020\u00002\f\u0010P\u001a\b\u0012\u0004\u0012\u00020D0Q2\u0006\u00106\u001a\u00020\u001eH\u0007J\u0006\u0010R\u001a\u00020\u0012J\r\u0010S\u001a\u00020\tH\u0000\u00a2\u0006\u0002\bTJ\u0010\u0010U\u001a\u00020\u00002\u0006\u0010V\u001a\u00020\u0014H\u0007J\u000e\u0010W\u001a\u00020\u00002\u0006\u0010X\u001a\u00020\tJ\u0006\u0010Y\u001a\u00020\u0000J\u000e\u0010Z\u001a\u00020\u00002\u0006\u0010/\u001a\u000200J\u0006\u0010[\u001a\u00020\u0012R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u00148FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u001a\u0010$\u001a\u00020%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u0013\u0010*\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u0017\u0010-\u001a\b\u0012\u0004\u0012\u00020\f0 8F\u00a2\u0006\u0006\u001a\u0004\b.\u0010#R\u000e\u0010/\u001a\u000200X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u00101\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u0002020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006^"}, d2={"Lorg/pgpainless/encryption_signing/EncryptionOptions;", "", "api", "Lorg/pgpainless/PGPainless;", "(Lorg/pgpainless/PGPainless;)V", "purpose", "Lorg/pgpainless/algorithm/EncryptionPurpose;", "(Lorg/pgpainless/algorithm/EncryptionPurpose;Lorg/pgpainless/PGPainless;)V", "_encryptionMechanismOverride", "Lorg/bouncycastle/openpgp/api/MessageEncryptionMechanism;", "_encryptionMethods", "", "Lorg/bouncycastle/openpgp/operator/PGPKeyEncryptionMethodGenerator;", "_keyRingInfo", "", "Lorg/pgpainless/key/SubkeyIdentifier;", "Lorg/pgpainless/key/info/KeyRingInfo;", "allowEncryptionWithMissingKeyFlags", "", "encryptionAlgorithmOverride", "Lorg/pgpainless/algorithm/SymmetricKeyAlgorithm;", "getEncryptionAlgorithmOverride$annotations", "()V", "getEncryptionAlgorithmOverride", "()Lorg/pgpainless/algorithm/SymmetricKeyAlgorithm;", "encryptionKeyIdentifiers", "", "getEncryptionKeyIdentifiers", "()Ljava/util/List;", "encryptionKeySelector", "Lorg/pgpainless/encryption_signing/EncryptionOptions$EncryptionKeySelector;", "encryptionKeys", "", "Lorg/bouncycastle/openpgp/api/OpenPGPCertificate$OpenPGPComponentKey;", "getEncryptionKeys", "()Ljava/util/Set;", "encryptionMechanismNegotiator", "Lorg/pgpainless/algorithm/negotiation/EncryptionMechanismNegotiator;", "getEncryptionMechanismNegotiator", "()Lorg/pgpainless/algorithm/negotiation/EncryptionMechanismNegotiator;", "setEncryptionMechanismNegotiator", "(Lorg/pgpainless/algorithm/negotiation/EncryptionMechanismNegotiator;)V", "encryptionMechanismOverride", "getEncryptionMechanismOverride", "()Lorg/bouncycastle/openpgp/api/MessageEncryptionMechanism;", "encryptionMethods", "getEncryptionMethods", "evaluationDate", "Ljava/util/Date;", "keysAndAccessors", "Lorg/pgpainless/key/info/KeyAccessor;", "addAsRecipient", "cert", "Lorg/bouncycastle/openpgp/api/OpenPGPCertificate;", "selector", "wildcardKeyId", "addAuthenticatableRecipients", "userId", "", "email", "authority", "Lorg/pgpainless/authentication/CertificateAuthority;", "targetAmount", "", "addEncryptionMethod", "encryptionMethod", "addHiddenRecipient", "key", "Lorg/bouncycastle/openpgp/PGPPublicKeyRing;", "addMessagePassphrase", "passphrase", "Lorg/pgpainless/util/Passphrase;", "addPassphrase", "addRecipient", "", "addRecipientKey", "", "accessor", "wildcardRecipient", "addRecipients", "keys", "", "hasEncryptionMethod", "negotiateEncryptionMechanism", "negotiateEncryptionMechanism$pgpainless_core", "overrideEncryptionAlgorithm", "encryptionAlgorithm", "overrideEncryptionMechanism", "encryptionMechanism", "setAllowEncryptionWithMissingKeyFlags", "setEvaluationDate", "usesOnlyPasswordBasedEncryption", "Companion", "EncryptionKeySelector", "pgpainless-core"})
@SourceDebugExtension(value={"SMAP\nEncryptionOptions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EncryptionOptions.kt\norg/pgpainless/encryption_signing/EncryptionOptions\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,500:1\n1549#2:501\n1620#2,3:502\n766#2:506\n857#2,2:507\n1855#2,2:509\n1855#2,2:511\n1855#2,2:513\n766#2:515\n857#2,2:516\n766#2:518\n857#2,2:519\n1726#2,3:521\n1549#2:524\n1620#2,3:525\n1549#2:528\n1620#2,3:529\n1549#2:532\n1620#2,3:533\n1#3:505\n*S KotlinDebug\n*F\n+ 1 EncryptionOptions.kt\norg/pgpainless/encryption_signing/EncryptionOptions\n*L\n46#1:501\n46#1:502,3\n97#1:506\n97#1:507,2\n98#1:509,2\n117#1:511,2\n136#1:513,2\n320#1:515\n320#1:516,2\n321#1:518\n321#1:519,2\n435#1:521,3\n442#1:524\n442#1:525,3\n443#1:528\n443#1:529,3\n445#1:532\n445#1:533,3\n*E\n"})
public final class EncryptionOptions {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EncryptionPurpose purpose;
    @NotNull
    private final PGPainless api;
    @NotNull
    private EncryptionMechanismNegotiator encryptionMechanismNegotiator;
    @NotNull
    private final Set<PGPKeyEncryptionMethodGenerator> _encryptionMethods;
    @NotNull
    private final Map<OpenPGPCertificate.OpenPGPComponentKey, KeyAccessor> keysAndAccessors;
    @NotNull
    private final Map<SubkeyIdentifier, KeyRingInfo> _keyRingInfo;
    @NotNull
    private final EncryptionKeySelector encryptionKeySelector;
    private boolean allowEncryptionWithMissingKeyFlags;
    @NotNull
    private Date evaluationDate;
    @Nullable
    private MessageEncryptionMechanism _encryptionMechanismOverride;

    public EncryptionOptions(@NotNull EncryptionPurpose purpose, @NotNull PGPainless api) {
        Intrinsics.checkNotNullParameter((Object)((Object)purpose), (String)"purpose");
        Intrinsics.checkNotNullParameter((Object)api, (String)"api");
        this.purpose = purpose;
        this.api = api;
        this.encryptionMechanismNegotiator = EncryptionMechanismNegotiator.Companion.modificationDetectionOrBetter(SymmetricKeyAlgorithmNegotiator.Companion.byPopularity());
        this._encryptionMethods = new LinkedHashSet();
        this.keysAndAccessors = new LinkedHashMap();
        this._keyRingInfo = new LinkedHashMap();
        this.encryptionKeySelector = Companion.encryptToAllCapableSubkeys();
        this.evaluationDate = new Date();
    }

    @NotNull
    public final EncryptionMechanismNegotiator getEncryptionMechanismNegotiator() {
        return this.encryptionMechanismNegotiator;
    }

    public final void setEncryptionMechanismNegotiator(@NotNull EncryptionMechanismNegotiator encryptionMechanismNegotiator) {
        Intrinsics.checkNotNullParameter((Object)encryptionMechanismNegotiator, (String)"<set-?>");
        this.encryptionMechanismNegotiator = encryptionMechanismNegotiator;
    }

    @NotNull
    public final Set<PGPKeyEncryptionMethodGenerator> getEncryptionMethods() {
        return CollectionsKt.toSet((Iterable)this._encryptionMethods);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<SubkeyIdentifier> getEncryptionKeyIdentifiers() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.keysAndAccessors.keySet();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            OpenPGPCertificate.OpenPGPComponentKey openPGPComponentKey = (OpenPGPCertificate.OpenPGPComponentKey)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new SubkeyIdentifier((OpenPGPCertificate.OpenPGPComponentKey)it));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final Set<OpenPGPCertificate.OpenPGPComponentKey> getEncryptionKeys() {
        return CollectionsKt.toSet((Iterable)this.keysAndAccessors.keySet());
    }

    @Nullable
    public final SymmetricKeyAlgorithm getEncryptionAlgorithmOverride() {
        SymmetricKeyAlgorithm symmetricKeyAlgorithm;
        MessageEncryptionMechanism messageEncryptionMechanism = this._encryptionMechanismOverride;
        if (messageEncryptionMechanism != null) {
            MessageEncryptionMechanism it = messageEncryptionMechanism;
            boolean bl = false;
            symmetricKeyAlgorithm = SymmetricKeyAlgorithm.Companion.requireFromId(it.getSymmetricKeyAlgorithm());
        } else {
            symmetricKeyAlgorithm = null;
        }
        return symmetricKeyAlgorithm;
    }

    @Deprecated(message="Deprecated in favor of encryptionMechanismOverride", replaceWith=@ReplaceWith(expression="encryptionMechanismOverride", imports={}))
    public static /* synthetic */ void getEncryptionAlgorithmOverride$annotations() {
    }

    @Nullable
    public final MessageEncryptionMechanism getEncryptionMechanismOverride() {
        return this._encryptionMechanismOverride;
    }

    public EncryptionOptions(@NotNull PGPainless api) {
        Intrinsics.checkNotNullParameter((Object)api, (String)"api");
        this(EncryptionPurpose.ANY, api);
    }

    @NotNull
    public final EncryptionOptions setEvaluationDate(@NotNull Date evaluationDate) {
        EncryptionOptions encryptionOptions;
        Intrinsics.checkNotNullParameter((Object)evaluationDate, (String)"evaluationDate");
        EncryptionOptions $this$setEvaluationDate_u24lambda_u242 = encryptionOptions = this;
        boolean bl = false;
        $this$setEvaluationDate_u24lambda_u242.evaluationDate = evaluationDate;
        return encryptionOptions;
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public final EncryptionOptions addAuthenticatableRecipients(@NotNull String userId, boolean email, @NotNull CertificateAuthority authority, int targetAmount) {
        void $this$forEach$iv;
        Object it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        EncryptionOptions encryptionOptions;
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)authority, (String)"authority");
        EncryptionOptions $this$addAuthenticatableRecipients_u24lambda_u247 = encryptionOptions = this;
        boolean bl = false;
        boolean foundAcceptable = false;
        Iterable iterable = authority.lookupByUserId(userId, email, $this$addAuthenticatableRecipients_u24lambda_u247.evaluationDate, targetAmount);
        boolean $i$f$filter = false;
        Iterator iterator = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (CertificateAuthenticity)element$iv$iv;
            boolean bl2 = false;
            if (!((CertificateAuthenticity)it).isAuthenticated()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CertificateAuthenticity it2 = (CertificateAuthenticity)element$iv;
            boolean bl3 = false;
            EncryptionOptions encryptionOptions2 = $this$addAuthenticatableRecipients_u24lambda_u247.addRecipient(it2.getCertificate());
            it = encryptionOptions2;
            boolean bl4 = false;
            foundAcceptable = true;
        }
        if (!foundAcceptable) {
            boolean bl5 = false;
            String string = "Could not identify any trust-worthy certificates for '" + userId + "' and target trust amount " + targetAmount + ".";
            throw new IllegalArgumentException(string.toString());
        }
        return encryptionOptions;
    }

    public static /* synthetic */ EncryptionOptions addAuthenticatableRecipients$default(EncryptionOptions encryptionOptions, String string, boolean bl, CertificateAuthority certificateAuthority, int n, int n2, Object object) {
        if ((n2 & 8) != 0) {
            n = 120;
        }
        return encryptionOptions.addAuthenticatableRecipients(string, bl, certificateAuthority, n);
    }

    @Deprecated(message="Repeatedly pass OpenPGPCertificate instances instead.")
    @NotNull
    public final EncryptionOptions addRecipients(@NotNull Iterable<? extends PGPPublicKeyRing> keys) {
        EncryptionOptions encryptionOptions;
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        EncryptionOptions $this$addRecipients_u24lambda_u2411 = encryptionOptions = this;
        boolean bl = false;
        List it = CollectionsKt.toList(keys);
        boolean bl2 = false;
        if (!(!((Collection)it).isEmpty())) {
            boolean $i$a$-require-EncryptionOptions$addRecipients$1$1$22 = false;
            String $i$a$-require-EncryptionOptions$addRecipients$1$1$22 = "Set of recipient keys cannot be empty.";
            throw new IllegalArgumentException($i$a$-require-EncryptionOptions$addRecipients$1$1$22.toString());
        }
        Iterable $this$forEach$iv = it;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PGPPublicKeyRing key = (PGPPublicKeyRing)element$iv;
            boolean bl3 = false;
            $this$addRecipients_u24lambda_u2411.addRecipient(key);
        }
        return encryptionOptions;
    }

    @Deprecated(message="Repeatedly pass OpenPGPCertificate instances instead.")
    @NotNull
    public final EncryptionOptions addRecipients(@NotNull Iterable<? extends PGPPublicKeyRing> keys, @NotNull EncryptionKeySelector selector) {
        EncryptionOptions encryptionOptions;
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
        EncryptionOptions $this$addRecipients_u24lambda_u2415 = encryptionOptions = this;
        boolean bl = false;
        List it = CollectionsKt.toList(keys);
        boolean bl2 = false;
        if (!(!((Collection)it).isEmpty())) {
            boolean $i$a$-require-EncryptionOptions$addRecipients$2$1$22 = false;
            String $i$a$-require-EncryptionOptions$addRecipients$2$1$22 = "Set of recipient keys cannot be empty.";
            throw new IllegalArgumentException($i$a$-require-EncryptionOptions$addRecipients$2$1$22.toString());
        }
        Iterable $this$forEach$iv = it;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PGPPublicKeyRing key = (PGPPublicKeyRing)element$iv;
            boolean bl3 = false;
            $this$addRecipients_u24lambda_u2415.addRecipient(key, selector);
        }
        return encryptionOptions;
    }

    @NotNull
    public final EncryptionOptions addRecipient(@NotNull OpenPGPCertificate cert) {
        Intrinsics.checkNotNullParameter((Object)cert, (String)"cert");
        return this.addRecipient(cert, this.encryptionKeySelector);
    }

    @Deprecated(message="Pass in OpenPGPCertificate instead.", replaceWith=@ReplaceWith(expression="addRecipient(key.toOpenPGPCertificate(), encryptionKeySelector)", imports={}))
    @NotNull
    public final EncryptionOptions addRecipient(@NotNull PGPPublicKeyRing key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.addRecipient(key, this.encryptionKeySelector);
    }

    @NotNull
    public final EncryptionOptions addRecipient(@NotNull OpenPGPCertificate cert, @NotNull CharSequence userId) {
        Intrinsics.checkNotNullParameter((Object)cert, (String)"cert");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        return this.addRecipient(cert, userId, this.encryptionKeySelector);
    }

    @Deprecated(message="Pass in OpenPGPCertificate instead.", replaceWith=@ReplaceWith(expression="addRecipient(key.toOpenPGPCertificate(), userId)", imports={}))
    @NotNull
    public final EncryptionOptions addRecipient(@NotNull PGPPublicKeyRing key, @NotNull CharSequence userId) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        return this.addRecipient(key, userId, this.encryptionKeySelector);
    }

    @NotNull
    public final EncryptionOptions addRecipient(@NotNull OpenPGPCertificate cert, @NotNull CharSequence userId, @NotNull EncryptionKeySelector encryptionKeySelector) {
        EncryptionOptions encryptionOptions;
        Intrinsics.checkNotNullParameter((Object)cert, (String)"cert");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)encryptionKeySelector, (String)"encryptionKeySelector");
        EncryptionOptions $this$addRecipient_u24lambda_u2416 = encryptionOptions = this;
        boolean bl = false;
        KeyRingInfo info = $this$addRecipient_u24lambda_u2416.api.inspect(cert, $this$addRecipient_u24lambda_u2416.evaluationDate);
        List<OpenPGPCertificate.OpenPGPComponentKey> subkeys = encryptionKeySelector.selectEncryptionSubkeys(info.getEncryptionSubkeys(userId, $this$addRecipient_u24lambda_u2416.purpose));
        if (subkeys.isEmpty()) {
            throw new KeyException.UnacceptableEncryptionKeyException(cert);
        }
        for (OpenPGPCertificate.OpenPGPComponentKey subkey : subkeys) {
            SubkeyIdentifier keyId = new SubkeyIdentifier(subkey);
            $this$addRecipient_u24lambda_u2416._keyRingInfo.put(keyId, info);
            OpenPGPCertificate.OpenPGPUserId openPGPUserId = cert.getUserId(((Object)userId).toString());
            Intrinsics.checkNotNullExpressionValue((Object)openPGPUserId, (String)"getUserId(...)");
            KeyAccessor.ViaUserId accessor = new KeyAccessor.ViaUserId(subkey, (OpenPGPCertificate.OpenPGPIdentityComponent)openPGPUserId, null, 4, null);
            $this$addRecipient_u24lambda_u2416.addRecipientKey(subkey, accessor, false);
        }
        return encryptionOptions;
    }

    @Deprecated(message="Pass in OpenPGPCertificate instead.", replaceWith=@ReplaceWith(expression="addRecipient(key.toOpenPGPCertificate(), userId, encryptionKeySelector)", imports={}))
    @NotNull
    public final EncryptionOptions addRecipient(@NotNull PGPPublicKeyRing key, @NotNull CharSequence userId, @NotNull EncryptionKeySelector encryptionKeySelector) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)encryptionKeySelector, (String)"encryptionKeySelector");
        return this.addRecipient(this.api.toCertificate(key), userId, encryptionKeySelector);
    }

    @NotNull
    public final EncryptionOptions addRecipient(@NotNull OpenPGPCertificate cert, @NotNull EncryptionKeySelector encryptionKeySelector) {
        Intrinsics.checkNotNullParameter((Object)cert, (String)"cert");
        Intrinsics.checkNotNullParameter((Object)encryptionKeySelector, (String)"encryptionKeySelector");
        return this.addAsRecipient(cert, encryptionKeySelector, false);
    }

    @Deprecated(message="Pass in OpenPGPCertificate instead.", replaceWith=@ReplaceWith(expression="addRecipient(key.toOpenPGPCertificate(), encryptionKeySelector)", imports={}))
    @NotNull
    public final EncryptionOptions addRecipient(@NotNull PGPPublicKeyRing key, @NotNull EncryptionKeySelector encryptionKeySelector) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)encryptionKeySelector, (String)"encryptionKeySelector");
        return this.addRecipient(this.api.toCertificate(key), encryptionKeySelector);
    }

    @JvmOverloads
    @NotNull
    public final EncryptionOptions addHiddenRecipient(@NotNull OpenPGPCertificate cert, @NotNull EncryptionKeySelector selector) {
        Intrinsics.checkNotNullParameter((Object)cert, (String)"cert");
        Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
        return this.addAsRecipient(cert, selector, true);
    }

    public static /* synthetic */ EncryptionOptions addHiddenRecipient$default(EncryptionOptions encryptionOptions, OpenPGPCertificate openPGPCertificate, EncryptionKeySelector encryptionKeySelector, int n, Object object) {
        if ((n & 2) != 0) {
            encryptionKeySelector = encryptionOptions.encryptionKeySelector;
        }
        return encryptionOptions.addHiddenRecipient(openPGPCertificate, encryptionKeySelector);
    }

    @Deprecated(message="Pass in an OpenPGPCertificate instead.", replaceWith=@ReplaceWith(expression="addHiddenRecipient(key.toOpenPGPCertificate(), selector)", imports={}))
    @JvmOverloads
    @NotNull
    public final EncryptionOptions addHiddenRecipient(@NotNull PGPPublicKeyRing key, @NotNull EncryptionKeySelector selector) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
        return this.addHiddenRecipient(this.api.toCertificate(key), selector);
    }

    public static /* synthetic */ EncryptionOptions addHiddenRecipient$default(EncryptionOptions encryptionOptions, PGPPublicKeyRing pGPPublicKeyRing, EncryptionKeySelector encryptionKeySelector, int n, Object object) {
        if ((n & 2) != 0) {
            encryptionKeySelector = encryptionOptions.encryptionKeySelector;
        }
        return encryptionOptions.addHiddenRecipient(pGPPublicKeyRing, encryptionKeySelector);
    }

    private final EncryptionOptions addAsRecipient(OpenPGPCertificate cert, EncryptionKeySelector selector, boolean wildcardKeyId) {
        Date date;
        EncryptionOptions encryptionOptions;
        EncryptionOptions $this$addAsRecipient_u24lambda_u2419 = encryptionOptions = this;
        boolean bl = false;
        KeyRingInfo info = $this$addAsRecipient_u24lambda_u2419.api.inspect(cert, $this$addAsRecipient_u24lambda_u2419.evaluationDate);
        try {
            date = info.getPrimaryKeyExpirationDate();
        }
        catch (NoSuchElementException e) {
            throw new KeyException.UnacceptableSelfSignatureException(cert);
        }
        Date primaryKeyExpiration = date;
        if (primaryKeyExpiration != null && primaryKeyExpiration.compareTo($this$addAsRecipient_u24lambda_u2419.evaluationDate) < 0) {
            throw new KeyException.ExpiredKeyException(cert, primaryKeyExpiration);
        }
        List encryptionSubkeys = selector.selectEncryptionSubkeys(info.getEncryptionSubkeys($this$addAsRecipient_u24lambda_u2419.purpose));
        if (encryptionSubkeys.isEmpty() && $this$addAsRecipient_u24lambda_u2419.allowEncryptionWithMissingKeyFlags) {
            OpenPGPCertificate.OpenPGPComponentKey it;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Iterable e = info.getValidSubkeys();
            boolean $i$f$filter = false;
            void var12_14 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (OpenPGPCertificate.OpenPGPComponentKey)element$iv$iv;
                boolean bl2 = false;
                if (!it.getPGPPublicKey().isEncryptionKey()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (OpenPGPCertificate.OpenPGPComponentKey)element$iv$iv;
                boolean bl3 = false;
                KeyIdentifier keyIdentifier = it.getKeyIdentifier();
                Intrinsics.checkNotNullExpressionValue((Object)keyIdentifier, (String)"getKeyIdentifier(...)");
                if (!info.getKeyFlagsOf(keyIdentifier).isEmpty()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            encryptionSubkeys = (List)destination$iv$iv;
        }
        if (encryptionSubkeys.isEmpty()) {
            throw new KeyException.UnacceptableEncryptionKeyException(cert);
        }
        for (OpenPGPCertificate.OpenPGPComponentKey subkey : encryptionSubkeys) {
            SubkeyIdentifier keyId = new SubkeyIdentifier(subkey);
            $this$addAsRecipient_u24lambda_u2419._keyRingInfo.put(keyId, info);
            KeyAccessor.ViaKeyIdentifier accessor = new KeyAccessor.ViaKeyIdentifier(subkey, null, 2, null);
            $this$addAsRecipient_u24lambda_u2419.addRecipientKey(subkey, accessor, wildcardKeyId);
        }
        return encryptionOptions;
    }

    /*
     * WARNING - void declaration
     */
    private final void addRecipientKey(OpenPGPCertificate.OpenPGPComponentKey key, KeyAccessor accessor, boolean wildcardRecipient) {
        void it;
        PublicKeyKeyEncryptionMethodGenerator publicKeyKeyEncryptionMethodGenerator;
        this.keysAndAccessors.put(key, accessor);
        PublicKeyKeyEncryptionMethodGenerator publicKeyKeyEncryptionMethodGenerator2 = publicKeyKeyEncryptionMethodGenerator = this.api.getImplementation().publicKeyKeyEncryptionMethodGenerator(key.getPGPPublicKey());
        EncryptionOptions encryptionOptions = this;
        boolean bl = false;
        it.setUseWildcardRecipient(wildcardRecipient);
        PublicKeyKeyEncryptionMethodGenerator publicKeyKeyEncryptionMethodGenerator3 = publicKeyKeyEncryptionMethodGenerator;
        Intrinsics.checkNotNullExpressionValue((Object)publicKeyKeyEncryptionMethodGenerator3, (String)"also(...)");
        encryptionOptions.addEncryptionMethod((PGPKeyEncryptionMethodGenerator)publicKeyKeyEncryptionMethodGenerator3);
    }

    @Deprecated(message="Deprecated in favor of addMessagePassphrase", replaceWith=@ReplaceWith(expression="addMessagePassphrase(passphrase)", imports={}))
    @NotNull
    public final EncryptionOptions addPassphrase(@NotNull Passphrase passphrase) {
        Intrinsics.checkNotNullParameter((Object)passphrase, (String)"passphrase");
        return this.addMessagePassphrase(passphrase);
    }

    @NotNull
    public final EncryptionOptions addMessagePassphrase(@NotNull Passphrase passphrase) {
        EncryptionOptions encryptionOptions;
        Intrinsics.checkNotNullParameter((Object)passphrase, (String)"passphrase");
        EncryptionOptions $this$addMessagePassphrase_u24lambda_u2422 = encryptionOptions = this;
        boolean bl = false;
        if (!(!passphrase.isEmpty())) {
            boolean bl2 = false;
            String string = "Passphrase MUST NOT be empty.";
            throw new IllegalArgumentException(string.toString());
        }
        PBEKeyEncryptionMethodGenerator pBEKeyEncryptionMethodGenerator = $this$addMessagePassphrase_u24lambda_u2422.api.getImplementation().pbeKeyEncryptionMethodGenerator(passphrase.getChars());
        Intrinsics.checkNotNullExpressionValue((Object)pBEKeyEncryptionMethodGenerator, (String)"pbeKeyEncryptionMethodGenerator(...)");
        $this$addMessagePassphrase_u24lambda_u2422.addEncryptionMethod((PGPKeyEncryptionMethodGenerator)pBEKeyEncryptionMethodGenerator);
        return encryptionOptions;
    }

    @NotNull
    public final EncryptionOptions addEncryptionMethod(@NotNull PGPKeyEncryptionMethodGenerator encryptionMethod) {
        EncryptionOptions encryptionOptions;
        Intrinsics.checkNotNullParameter((Object)encryptionMethod, (String)"encryptionMethod");
        EncryptionOptions $this$addEncryptionMethod_u24lambda_u2423 = encryptionOptions = this;
        boolean bl = false;
        $this$addEncryptionMethod_u24lambda_u2423._encryptionMethods.add(encryptionMethod);
        return encryptionOptions;
    }

    @Deprecated(message="Deprecated in favor of overrideEncryptionMechanism", replaceWith=@ReplaceWith(expression="overrideEncryptionMechanism(MessageEncryptionMechanism.integrityProtected(encryptionAlgorithm.algorithmId))", imports={}))
    @NotNull
    public final EncryptionOptions overrideEncryptionAlgorithm(@NotNull SymmetricKeyAlgorithm encryptionAlgorithm) {
        EncryptionOptions encryptionOptions;
        Intrinsics.checkNotNullParameter((Object)((Object)encryptionAlgorithm), (String)"encryptionAlgorithm");
        EncryptionOptions $this$overrideEncryptionAlgorithm_u24lambda_u2425 = encryptionOptions = this;
        boolean bl = false;
        if (!(encryptionAlgorithm != SymmetricKeyAlgorithm.NULL)) {
            boolean bl2 = false;
            String string = "Encryption algorithm override cannot be NULL.";
            throw new IllegalArgumentException(string.toString());
        }
        MessageEncryptionMechanism messageEncryptionMechanism = MessageEncryptionMechanism.integrityProtected((int)encryptionAlgorithm.getAlgorithmId());
        Intrinsics.checkNotNullExpressionValue((Object)messageEncryptionMechanism, (String)"integrityProtected(...)");
        $this$overrideEncryptionAlgorithm_u24lambda_u2425.overrideEncryptionMechanism(messageEncryptionMechanism);
        return encryptionOptions;
    }

    @NotNull
    public final EncryptionOptions overrideEncryptionMechanism(@NotNull MessageEncryptionMechanism encryptionMechanism) {
        EncryptionOptions encryptionOptions;
        Intrinsics.checkNotNullParameter((Object)encryptionMechanism, (String)"encryptionMechanism");
        EncryptionOptions $this$overrideEncryptionMechanism_u24lambda_u2427 = encryptionOptions = this;
        boolean bl = false;
        if (!$this$overrideEncryptionMechanism_u24lambda_u2427.api.getAlgorithmPolicy().getMessageEncryptionAlgorithmPolicy().isAcceptable(encryptionMechanism)) {
            boolean bl2 = false;
            String string = "Provided symmetric encryption algorithm is not acceptable.";
            throw new IllegalArgumentException(string.toString());
        }
        $this$overrideEncryptionMechanism_u24lambda_u2427._encryptionMechanismOverride = encryptionMechanism;
        return encryptionOptions;
    }

    @NotNull
    public final EncryptionOptions setAllowEncryptionWithMissingKeyFlags() {
        EncryptionOptions encryptionOptions;
        EncryptionOptions $this$setAllowEncryptionWithMissingKeyFlags_u24lambda_u2428 = encryptionOptions = this;
        boolean bl = false;
        $this$setAllowEncryptionWithMissingKeyFlags_u24lambda_u2428.allowEncryptionWithMissingKeyFlags = true;
        return encryptionOptions;
    }

    public final boolean hasEncryptionMethod() {
        return !((Collection)this._encryptionMethods).isEmpty();
    }

    public final boolean usesOnlyPasswordBasedEncryption() {
        boolean bl;
        block3: {
            Iterable $this$all$iv = this._encryptionMethods;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    PGPKeyEncryptionMethodGenerator it = (PGPKeyEncryptionMethodGenerator)element$iv;
                    boolean bl2 = false;
                    if (it instanceof PBEKeyEncryptionMethodGenerator) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final MessageEncryptionMechanism negotiateEncryptionMechanism$pgpainless_core() {
        void $this$mapTo$iv$iv;
        void $this$mapTo$iv$iv2;
        Collection collection;
        void $this$mapTo$iv$iv3;
        if (this.getEncryptionMechanismOverride() != null) {
            MessageEncryptionMechanism messageEncryptionMechanism = this.getEncryptionMechanismOverride();
            Intrinsics.checkNotNull((Object)messageEncryptionMechanism);
            return messageEncryptionMechanism;
        }
        Iterable $this$map$iv = this.keysAndAccessors.values();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            void it;
            KeyAccessor keyAccessor = (KeyAccessor)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getFeatures());
        }
        List features = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        Iterable $this$map$iv2 = this.keysAndAccessors.values();
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            KeyAccessor bl = (KeyAccessor)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(it.getPreferredAEADCipherSuites());
        }
        List aeadAlgorithms = CollectionsKt.toList((Iterable)((List)destination$iv$iv2));
        Iterable $this$map$iv3 = this.keysAndAccessors.values();
        boolean $i$f$map3 = false;
        destination$iv$iv2 = $this$map$iv3;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KeyAccessor bl2 = (KeyAccessor)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl = false;
            collection.add(it.getPreferredSymmetricKeyAlgorithms());
        }
        List symmetricKeyAlgorithms = CollectionsKt.toList((Iterable)((List)destination$iv$iv3));
        MessageEncryptionMechanism mechanism = this.encryptionMechanismNegotiator.negotiate(this.api.getAlgorithmPolicy(), this.getEncryptionMechanismOverride(), features, aeadAlgorithms, symmetricKeyAlgorithms);
        return mechanism;
    }

    @JvmOverloads
    @NotNull
    public final EncryptionOptions addAuthenticatableRecipients(@NotNull String userId, boolean email, @NotNull CertificateAuthority authority) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)authority, (String)"authority");
        return EncryptionOptions.addAuthenticatableRecipients$default(this, userId, email, authority, 0, 8, null);
    }

    @JvmOverloads
    @NotNull
    public final EncryptionOptions addHiddenRecipient(@NotNull OpenPGPCertificate cert) {
        Intrinsics.checkNotNullParameter((Object)cert, (String)"cert");
        return EncryptionOptions.addHiddenRecipient$default(this, cert, null, 2, null);
    }

    @Deprecated(message="Pass in an OpenPGPCertificate instead.", replaceWith=@ReplaceWith(expression="addHiddenRecipient(key.toOpenPGPCertificate(), selector)", imports={}))
    @JvmOverloads
    @NotNull
    public final EncryptionOptions addHiddenRecipient(@NotNull PGPPublicKeyRing key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return EncryptionOptions.addHiddenRecipient$default(this, key, null, 2, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final EncryptionOptions get(@NotNull PGPainless api) {
        return Companion.get(api);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final EncryptionOptions encryptCommunications(@NotNull PGPainless api) {
        return Companion.encryptCommunications(api);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final EncryptionOptions encryptDataAtRest(@NotNull PGPainless api) {
        return Companion.encryptDataAtRest(api);
    }

    @JvmStatic
    @NotNull
    public static final EncryptionKeySelector encryptToFirstSubkey() {
        return Companion.encryptToFirstSubkey();
    }

    @JvmStatic
    @NotNull
    public static final EncryptionKeySelector encryptToAllCapableSubkeys() {
        return Companion.encryptToAllCapableSubkeys();
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final EncryptionOptions get() {
        return Companion.get();
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final EncryptionOptions encryptCommunications() {
        return Companion.encryptCommunications();
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final EncryptionOptions encryptDataAtRest() {
        return Companion.encryptDataAtRest();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u0007J\u0012\u0010\u0007\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u0007J\b\u0010\b\u001a\u00020\tH\u0007J\b\u0010\n\u001a\u00020\tH\u0007J\u0012\u0010\u000b\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\f"}, d2={"Lorg/pgpainless/encryption_signing/EncryptionOptions$Companion;", "", "()V", "encryptCommunications", "Lorg/pgpainless/encryption_signing/EncryptionOptions;", "api", "Lorg/pgpainless/PGPainless;", "encryptDataAtRest", "encryptToAllCapableSubkeys", "Lorg/pgpainless/encryption_signing/EncryptionOptions$EncryptionKeySelector;", "encryptToFirstSubkey", "get", "pgpainless-core"})
    @SourceDebugExtension(value={"SMAP\nEncryptionOptions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EncryptionOptions.kt\norg/pgpainless/encryption_signing/EncryptionOptions$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,500:1\n1#2:501\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final EncryptionOptions get(@NotNull PGPainless api) {
            Intrinsics.checkNotNullParameter((Object)api, (String)"api");
            return new EncryptionOptions(api);
        }

        public static /* synthetic */ EncryptionOptions get$default(Companion companion, PGPainless pGPainless, int n, Object object) {
            if ((n & 1) != 0) {
                pGPainless = PGPainless.Companion.getInstance();
            }
            return companion.get(pGPainless);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final EncryptionOptions encryptCommunications(@NotNull PGPainless api) {
            Intrinsics.checkNotNullParameter((Object)api, (String)"api");
            return new EncryptionOptions(EncryptionPurpose.COMMUNICATIONS, api);
        }

        public static /* synthetic */ EncryptionOptions encryptCommunications$default(Companion companion, PGPainless pGPainless, int n, Object object) {
            if ((n & 1) != 0) {
                pGPainless = PGPainless.Companion.getInstance();
            }
            return companion.encryptCommunications(pGPainless);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final EncryptionOptions encryptDataAtRest(@NotNull PGPainless api) {
            Intrinsics.checkNotNullParameter((Object)api, (String)"api");
            return new EncryptionOptions(EncryptionPurpose.STORAGE, api);
        }

        public static /* synthetic */ EncryptionOptions encryptDataAtRest$default(Companion companion, PGPainless pGPainless, int n, Object object) {
            if ((n & 1) != 0) {
                pGPainless = PGPainless.Companion.getInstance();
            }
            return companion.encryptDataAtRest(pGPainless);
        }

        @JvmStatic
        @NotNull
        public final EncryptionKeySelector encryptToFirstSubkey() {
            return Companion::encryptToFirstSubkey$lambda$1;
        }

        @JvmStatic
        @NotNull
        public final EncryptionKeySelector encryptToAllCapableSubkeys() {
            return Companion::encryptToAllCapableSubkeys$lambda$2;
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final EncryptionOptions get() {
            return org.pgpainless.encryption_signing.EncryptionOptions$Companion.get$default(this, null, 1, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final EncryptionOptions encryptCommunications() {
            return org.pgpainless.encryption_signing.EncryptionOptions$Companion.encryptCommunications$default(this, null, 1, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final EncryptionOptions encryptDataAtRest() {
            return org.pgpainless.encryption_signing.EncryptionOptions$Companion.encryptDataAtRest$default(this, null, 1, null);
        }

        private static final List encryptToFirstSubkey$lambda$1(List encryptionCapableKeys) {
            Object object;
            block3: {
                block2: {
                    Intrinsics.checkNotNullParameter((Object)encryptionCapableKeys, (String)"encryptionCapableKeys");
                    object = (OpenPGPCertificate.OpenPGPComponentKey)CollectionsKt.firstOrNull((List)encryptionCapableKeys);
                    if (object == null) break block2;
                    OpenPGPCertificate.OpenPGPComponentKey it = object;
                    boolean bl = false;
                    List list = CollectionsKt.listOf((Object)it);
                    object = list;
                    if (list != null) break block3;
                }
                object = CollectionsKt.emptyList();
            }
            return object;
        }

        private static final List encryptToAllCapableSubkeys$lambda$2(List encryptionCapableKeys) {
            Intrinsics.checkNotNullParameter((Object)encryptionCapableKeys, (String)"encryptionCapableKeys");
            return encryptionCapableKeys;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u001c\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H&\u00a8\u0006\u0006\u00c0\u0006\u0003"}, d2={"Lorg/pgpainless/encryption_signing/EncryptionOptions$EncryptionKeySelector;", "", "selectEncryptionSubkeys", "", "Lorg/bouncycastle/openpgp/api/OpenPGPCertificate$OpenPGPComponentKey;", "encryptionCapableKeys", "pgpainless-core"})
    public static interface EncryptionKeySelector {
        @NotNull
        public List<OpenPGPCertificate.OpenPGPComponentKey> selectEncryptionSubkeys(@NotNull List<? extends OpenPGPCertificate.OpenPGPComponentKey> var1);
    }
}

