/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.decryption_verification;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bouncycastle.bcpg.KeyIdentifier;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.api.OpenPGPCertificate;
import org.bouncycastle.openpgp.api.OpenPGPKey;
import org.bouncycastle.openpgp.api.OpenPGPKeyMaterialProvider;
import org.bouncycastle.openpgp.api.OpenPGPSignature;
import org.bouncycastle.openpgp.operator.PublicKeyDataDecryptorFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.PGPainless;
import org.pgpainless.decryption_verification.CustomPublicKeyDataDecryptorFactory;
import org.pgpainless.decryption_verification.MissingKeyPassphraseStrategy;
import org.pgpainless.decryption_verification.cleartext_signatures.InMemoryMultiPassStrategy;
import org.pgpainless.decryption_verification.cleartext_signatures.MultiPassStrategy;
import org.pgpainless.key.SubkeyIdentifier;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.signature.SignatureUtils;
import org.pgpainless.util.Passphrase;
import org.pgpainless.util.SessionKey;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00ba\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0010\"\n\u0002\b\u0018\u0018\u0000 ^2\u00020\u0001:\u0002]^B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010&\u001a\u00020\u00002\u0006\u0010'\u001a\u00020(J\u001a\u0010)\u001a\u00020\u00002\u0006\u0010*\u001a\u00020+2\b\b\u0002\u0010,\u001a\u00020\u000fH\u0007J\u001a\u0010)\u001a\u00020\u00002\u0006\u0010*\u001a\u00020\u000e2\b\b\u0002\u0010,\u001a\u00020\u000fH\u0007J\u001a\u0010-\u001a\u00020\u00002\u0006\u0010.\u001a\u00020/2\b\b\u0002\u0010,\u001a\u00020\u000fH\u0007J\u000e\u00100\u001a\u00020\u00002\u0006\u00101\u001a\u00020\u0012J\u0010\u00102\u001a\u00020\u00002\u0006\u00103\u001a\u000204H\u0007J\u000e\u00102\u001a\u00020\u00002\u0006\u00103\u001a\u000205J\u0014\u00106\u001a\u00020\u00002\f\u00107\u001a\b\u0012\u0004\u0012\u00020508J\u0010\u00106\u001a\u00020\u00002\u0006\u00107\u001a\u000209H\u0007J\u000e\u0010:\u001a\u00020\u00002\u0006\u0010;\u001a\u00020\u0014J\u000e\u0010:\u001a\u00020\u00002\u0006\u0010<\u001a\u00020=J\u000e\u0010>\u001a\u00020\u00002\u0006\u0010?\u001a\u00020@J\u0014\u0010>\u001a\u00020\u00002\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140AJ\u0006\u0010\u0015\u001a\u00020\u0000J\u0006\u0010B\u001a\u00020\u0006J\u0006\u0010C\u001a\u00020\bJ\u0012\u0010D\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0EJ\f\u0010F\u001a\b\u0012\u0004\u0012\u00020\u000e0GJ\f\u0010H\u001a\b\u0012\u0004\u0012\u00020\u00120GJ\f\u0010I\u001a\b\u0012\u0004\u0012\u00020\u00140AJ\b\u0010J\u001a\u0004\u0018\u00010\u001cJ\u0006\u0010K\u001a\u00020\u001eJ\u0006\u0010L\u001a\u00020 J\u0010\u0010M\u001a\u0004\u0018\u00010\u000f2\u0006\u0010N\u001a\u00020\u000eJ\b\u0010O\u001a\u0004\u0018\u00010\"J\b\u0010P\u001a\u0004\u0018\u00010$J\b\u0010Q\u001a\u0004\u0018\u00010$J\u0006\u0010R\u001a\u00020\u0006J\u0006\u0010S\u001a\u00020\u0006J\u0006\u0010T\u001a\u00020\u0000J\u0010\u0010U\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0006H\u0007J\u000e\u0010V\u001a\u00020\u00002\u0006\u0010W\u001a\u00020\u001cJ\u000e\u0010X\u001a\u00020\u00002\u0006\u0010Y\u001a\u00020\u001eJ\u000e\u0010Z\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010[\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\"J\u0010\u0010#\u001a\u00020\u00002\b\u0010\\\u001a\u0004\u0018\u00010$J\u0010\u0010%\u001a\u00020\u00002\b\u0010\\\u001a\u0004\u0018\u00010$R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u0004\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u0004\u0018\u00010$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u0004\u0018\u00010$X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006_"}, d2={"Lorg/pgpainless/decryption_verification/ConsumerOptions;", "", "api", "Lorg/pgpainless/PGPainless;", "(Lorg/pgpainless/PGPainless;)V", "allowDecryptionWithNonEncryptionKey", "", "certificates", "Lorg/pgpainless/decryption_verification/ConsumerOptions$CertificateSource;", "customDecryptorFactories", "", "Lorg/pgpainless/key/SubkeyIdentifier;", "Lorg/bouncycastle/openpgp/operator/PublicKeyDataDecryptorFactory;", "decryptionKeys", "Lorg/bouncycastle/openpgp/api/OpenPGPKey;", "Lorg/pgpainless/key/protection/SecretKeyRingProtector;", "decryptionPassphrases", "", "Lorg/pgpainless/util/Passphrase;", "detachedSignatures", "Lorg/bouncycastle/openpgp/PGPSignature;", "forceNonOpenPgpData", "ignoreMDCErrors", "isDisableAsciiArmorCRC", "()Z", "setDisableAsciiArmorCRC", "(Z)V", "missingCertificateCallback", "Lorg/bouncycastle/openpgp/api/OpenPGPKeyMaterialProvider$OpenPGPCertificateProvider;", "missingKeyPassphraseStrategy", "Lorg/pgpainless/decryption_verification/MissingKeyPassphraseStrategy;", "multiPassStrategy", "Lorg/pgpainless/decryption_verification/cleartext_signatures/MultiPassStrategy;", "sessionKey", "Lorg/pgpainless/util/SessionKey;", "verifyNotAfter", "Ljava/util/Date;", "verifyNotBefore", "addCustomDecryptorFactory", "factory", "Lorg/pgpainless/decryption_verification/CustomPublicKeyDataDecryptorFactory;", "addDecryptionKey", "key", "Lorg/bouncycastle/openpgp/PGPSecretKeyRing;", "protector", "addDecryptionKeys", "keys", "Lorg/bouncycastle/openpgp/PGPSecretKeyRingCollection;", "addMessagePassphrase", "passphrase", "addVerificationCert", "verificationCert", "Lorg/bouncycastle/openpgp/PGPPublicKeyRing;", "Lorg/bouncycastle/openpgp/api/OpenPGPCertificate;", "addVerificationCerts", "verificationCerts", "", "Lorg/bouncycastle/openpgp/PGPPublicKeyRingCollection;", "addVerificationOfDetachedSignature", "detachedSignature", "signature", "Lorg/bouncycastle/openpgp/api/OpenPGPSignature$OpenPGPDocumentSignature;", "addVerificationOfDetachedSignatures", "signatureInputStream", "Ljava/io/InputStream;", "", "getAllowDecryptionWithNonEncryptionKey", "getCertificateSource", "getCustomDecryptorFactories", "", "getDecryptionKeys", "", "getDecryptionPassphrases", "getDetachedSignatures", "getMissingCertificateCallback", "getMissingKeyPassphraseStrategy", "getMultiPassStrategy", "getSecretKeyProtector", "decryptionKeyRing", "getSessionKey", "getVerifyNotAfter", "getVerifyNotBefore", "isForceNonOpenPgpData", "isIgnoreMDCErrors", "setAllowDecryptionWithMissingKeyFlags", "setIgnoreMDCErrors", "setMissingCertificateCallback", "callback", "setMissingKeyPassphraseStrategy", "strategy", "setMultiPassStrategy", "setSessionKey", "timestamp", "CertificateSource", "Companion", "pgpainless-core"})
@SourceDebugExtension(value={"SMAP\nConsumerOptions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConsumerOptions.kt\norg/pgpainless/decryption_verification/ConsumerOptions\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,476:1\n1#2:477\n*E\n"})
public final class ConsumerOptions {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PGPainless api;
    private boolean ignoreMDCErrors;
    private boolean isDisableAsciiArmorCRC;
    private boolean forceNonOpenPgpData;
    @Nullable
    private Date verifyNotBefore;
    @Nullable
    private Date verifyNotAfter;
    @NotNull
    private final CertificateSource certificates;
    @NotNull
    private final Set<PGPSignature> detachedSignatures;
    @Nullable
    private OpenPGPKeyMaterialProvider.OpenPGPCertificateProvider missingCertificateCallback;
    @Nullable
    private SessionKey sessionKey;
    @NotNull
    private final Map<SubkeyIdentifier, PublicKeyDataDecryptorFactory> customDecryptorFactories;
    @NotNull
    private final Map<OpenPGPKey, SecretKeyRingProtector> decryptionKeys;
    @NotNull
    private final Set<Passphrase> decryptionPassphrases;
    @NotNull
    private MissingKeyPassphraseStrategy missingKeyPassphraseStrategy;
    @NotNull
    private MultiPassStrategy multiPassStrategy;
    private boolean allowDecryptionWithNonEncryptionKey;

    public ConsumerOptions(@NotNull PGPainless api) {
        Intrinsics.checkNotNullParameter((Object)api, (String)"api");
        this.api = api;
        this.verifyNotAfter = new Date();
        this.certificates = new CertificateSource(this.api);
        this.detachedSignatures = new LinkedHashSet();
        this.customDecryptorFactories = new LinkedHashMap();
        this.decryptionKeys = new LinkedHashMap();
        this.decryptionPassphrases = new LinkedHashSet();
        this.missingKeyPassphraseStrategy = MissingKeyPassphraseStrategy.INTERACTIVE;
        this.multiPassStrategy = new InMemoryMultiPassStrategy();
    }

    public final boolean isDisableAsciiArmorCRC() {
        return this.isDisableAsciiArmorCRC;
    }

    public final void setDisableAsciiArmorCRC(boolean bl) {
        this.isDisableAsciiArmorCRC = bl;
    }

    @NotNull
    public final ConsumerOptions verifyNotBefore(@Nullable Date timestamp) {
        ConsumerOptions consumerOptions;
        ConsumerOptions $this$verifyNotBefore_u24lambda_u240 = consumerOptions = this;
        boolean bl = false;
        $this$verifyNotBefore_u24lambda_u240.verifyNotBefore = timestamp;
        return consumerOptions;
    }

    @Nullable
    public final Date getVerifyNotBefore() {
        return this.verifyNotBefore;
    }

    @NotNull
    public final ConsumerOptions verifyNotAfter(@Nullable Date timestamp) {
        ConsumerOptions consumerOptions;
        ConsumerOptions $this$verifyNotAfter_u24lambda_u241 = consumerOptions = this;
        boolean bl = false;
        $this$verifyNotAfter_u24lambda_u241.verifyNotAfter = timestamp;
        return consumerOptions;
    }

    @Nullable
    public final Date getVerifyNotAfter() {
        return this.verifyNotAfter;
    }

    @NotNull
    public final ConsumerOptions addVerificationCert(@NotNull OpenPGPCertificate verificationCert) {
        ConsumerOptions consumerOptions;
        Intrinsics.checkNotNullParameter((Object)verificationCert, (String)"verificationCert");
        ConsumerOptions $this$addVerificationCert_u24lambda_u242 = consumerOptions = this;
        boolean bl = false;
        $this$addVerificationCert_u24lambda_u242.certificates.addCertificate(verificationCert);
        return consumerOptions;
    }

    @NotNull
    public final ConsumerOptions addVerificationCerts(@NotNull Collection<? extends OpenPGPCertificate> verificationCerts) {
        ConsumerOptions consumerOptions;
        Intrinsics.checkNotNullParameter(verificationCerts, (String)"verificationCerts");
        ConsumerOptions $this$addVerificationCerts_u24lambda_u243 = consumerOptions = this;
        boolean bl = false;
        for (OpenPGPCertificate openPGPCertificate : verificationCerts) {
            $this$addVerificationCerts_u24lambda_u243.addVerificationCert(openPGPCertificate);
        }
        return consumerOptions;
    }

    @Deprecated(message="Pass OpenPGPCertificate instead.")
    @NotNull
    public final ConsumerOptions addVerificationCert(@NotNull PGPPublicKeyRing verificationCert) {
        ConsumerOptions consumerOptions;
        Intrinsics.checkNotNullParameter((Object)verificationCert, (String)"verificationCert");
        ConsumerOptions $this$addVerificationCert_u24lambda_u244 = consumerOptions = this;
        boolean bl = false;
        $this$addVerificationCert_u24lambda_u244.certificates.addCertificate($this$addVerificationCert_u24lambda_u244.api.toCertificate(verificationCert));
        return consumerOptions;
    }

    @Deprecated(message="Use of methods taking PGPPublicKeyRingCollections is discouraged.")
    @NotNull
    public final ConsumerOptions addVerificationCerts(@NotNull PGPPublicKeyRingCollection verificationCerts) {
        ConsumerOptions consumerOptions;
        Intrinsics.checkNotNullParameter((Object)verificationCerts, (String)"verificationCerts");
        ConsumerOptions $this$addVerificationCerts_u24lambda_u245 = consumerOptions = this;
        boolean bl = false;
        for (PGPPublicKeyRing cert : verificationCerts) {
            PGPainless pGPainless = $this$addVerificationCerts_u24lambda_u245.api;
            Intrinsics.checkNotNull((Object)cert);
            $this$addVerificationCerts_u24lambda_u245.addVerificationCert(pGPainless.toCertificate(cert));
        }
        return consumerOptions;
    }

    @NotNull
    public final ConsumerOptions addVerificationOfDetachedSignatures(@NotNull InputStream signatureInputStream) throws IOException, PGPException {
        ConsumerOptions consumerOptions;
        Intrinsics.checkNotNullParameter((Object)signatureInputStream, (String)"signatureInputStream");
        ConsumerOptions $this$addVerificationOfDetachedSignatures_u24lambda_u246 = consumerOptions = this;
        boolean bl = false;
        List<PGPSignature> signatures = SignatureUtils.Companion.readSignatures(signatureInputStream);
        $this$addVerificationOfDetachedSignatures_u24lambda_u246.addVerificationOfDetachedSignatures(signatures);
        return consumerOptions;
    }

    @NotNull
    public final ConsumerOptions addVerificationOfDetachedSignatures(@NotNull List<? extends PGPSignature> detachedSignatures) {
        ConsumerOptions consumerOptions;
        Intrinsics.checkNotNullParameter(detachedSignatures, (String)"detachedSignatures");
        ConsumerOptions $this$addVerificationOfDetachedSignatures_u24lambda_u247 = consumerOptions = this;
        boolean bl = false;
        for (PGPSignature pGPSignature : detachedSignatures) {
            $this$addVerificationOfDetachedSignatures_u24lambda_u247.addVerificationOfDetachedSignature(pGPSignature);
        }
        return consumerOptions;
    }

    @NotNull
    public final ConsumerOptions addVerificationOfDetachedSignature(@NotNull OpenPGPSignature.OpenPGPDocumentSignature signature) {
        ConsumerOptions consumerOptions;
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        ConsumerOptions $this$addVerificationOfDetachedSignature_u24lambda_u248 = consumerOptions = this;
        boolean bl = false;
        if (signature.getIssuerCertificate() != null) {
            OpenPGPCertificate openPGPCertificate = signature.getIssuerCertificate();
            Intrinsics.checkNotNullExpressionValue((Object)openPGPCertificate, (String)"getIssuerCertificate(...)");
            $this$addVerificationOfDetachedSignature_u24lambda_u248.addVerificationCert(openPGPCertificate);
        }
        PGPSignature pGPSignature = signature.getSignature();
        Intrinsics.checkNotNullExpressionValue((Object)pGPSignature, (String)"getSignature(...)");
        $this$addVerificationOfDetachedSignature_u24lambda_u248.addVerificationOfDetachedSignature(pGPSignature);
        return consumerOptions;
    }

    @NotNull
    public final ConsumerOptions addVerificationOfDetachedSignature(@NotNull PGPSignature detachedSignature) {
        ConsumerOptions consumerOptions;
        Intrinsics.checkNotNullParameter((Object)detachedSignature, (String)"detachedSignature");
        ConsumerOptions $this$addVerificationOfDetachedSignature_u24lambda_u249 = consumerOptions = this;
        boolean bl = false;
        $this$addVerificationOfDetachedSignature_u24lambda_u249.detachedSignatures.add(detachedSignature);
        return consumerOptions;
    }

    @NotNull
    public final List<PGPSignature> getDetachedSignatures() {
        return CollectionsKt.toList((Iterable)this.detachedSignatures);
    }

    @NotNull
    public final ConsumerOptions setMissingCertificateCallback(@NotNull OpenPGPKeyMaterialProvider.OpenPGPCertificateProvider callback2) {
        ConsumerOptions consumerOptions;
        Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
        ConsumerOptions $this$setMissingCertificateCallback_u24lambda_u2410 = consumerOptions = this;
        boolean bl = false;
        $this$setMissingCertificateCallback_u24lambda_u2410.missingCertificateCallback = callback2;
        return consumerOptions;
    }

    @NotNull
    public final ConsumerOptions setSessionKey(@NotNull SessionKey sessionKey) {
        ConsumerOptions consumerOptions;
        Intrinsics.checkNotNullParameter((Object)sessionKey, (String)"sessionKey");
        ConsumerOptions $this$setSessionKey_u24lambda_u2411 = consumerOptions = this;
        boolean bl = false;
        $this$setSessionKey_u24lambda_u2411.sessionKey = sessionKey;
        return consumerOptions;
    }

    @Nullable
    public final SessionKey getSessionKey() {
        return this.sessionKey;
    }

    @JvmOverloads
    @NotNull
    public final ConsumerOptions addDecryptionKey(@NotNull OpenPGPKey key, @NotNull SecretKeyRingProtector protector) {
        ConsumerOptions consumerOptions;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)protector, (String)"protector");
        ConsumerOptions $this$addDecryptionKey_u24lambda_u2412 = consumerOptions = this;
        boolean bl = false;
        $this$addDecryptionKey_u24lambda_u2412.decryptionKeys.put(key, protector);
        return consumerOptions;
    }

    public static /* synthetic */ ConsumerOptions addDecryptionKey$default(ConsumerOptions consumerOptions, OpenPGPKey openPGPKey, SecretKeyRingProtector secretKeyRingProtector, int n, Object object) {
        if ((n & 2) != 0) {
            secretKeyRingProtector = SecretKeyRingProtector.Companion.unprotectedKeys();
        }
        return consumerOptions.addDecryptionKey(openPGPKey, secretKeyRingProtector);
    }

    @Deprecated(message="Pass OpenPGPKey instead.")
    @JvmOverloads
    @NotNull
    public final ConsumerOptions addDecryptionKey(@NotNull PGPSecretKeyRing key, @NotNull SecretKeyRingProtector protector) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)protector, (String)"protector");
        return this.addDecryptionKey(this.api.toKey(key), protector);
    }

    public static /* synthetic */ ConsumerOptions addDecryptionKey$default(ConsumerOptions consumerOptions, PGPSecretKeyRing pGPSecretKeyRing, SecretKeyRingProtector secretKeyRingProtector, int n, Object object) {
        if ((n & 2) != 0) {
            secretKeyRingProtector = SecretKeyRingProtector.Companion.unprotectedKeys();
        }
        return consumerOptions.addDecryptionKey(pGPSecretKeyRing, secretKeyRingProtector);
    }

    @Deprecated(message="Pass OpenPGPKey instances instead.")
    @JvmOverloads
    @NotNull
    public final ConsumerOptions addDecryptionKeys(@NotNull PGPSecretKeyRingCollection keys, @NotNull SecretKeyRingProtector protector) {
        ConsumerOptions consumerOptions;
        Intrinsics.checkNotNullParameter((Object)keys, (String)"keys");
        Intrinsics.checkNotNullParameter((Object)protector, (String)"protector");
        ConsumerOptions $this$addDecryptionKeys_u24lambda_u2413 = consumerOptions = this;
        boolean bl = false;
        for (PGPSecretKeyRing key : keys) {
            PGPainless pGPainless = $this$addDecryptionKeys_u24lambda_u2413.api;
            Intrinsics.checkNotNull((Object)key);
            $this$addDecryptionKeys_u24lambda_u2413.addDecryptionKey(pGPainless.toKey(key), protector);
        }
        return consumerOptions;
    }

    public static /* synthetic */ ConsumerOptions addDecryptionKeys$default(ConsumerOptions consumerOptions, PGPSecretKeyRingCollection pGPSecretKeyRingCollection, SecretKeyRingProtector secretKeyRingProtector, int n, Object object) {
        if ((n & 2) != 0) {
            secretKeyRingProtector = SecretKeyRingProtector.Companion.unprotectedKeys();
        }
        return consumerOptions.addDecryptionKeys(pGPSecretKeyRingCollection, secretKeyRingProtector);
    }

    @NotNull
    public final ConsumerOptions addMessagePassphrase(@NotNull Passphrase passphrase) {
        ConsumerOptions consumerOptions;
        Intrinsics.checkNotNullParameter((Object)passphrase, (String)"passphrase");
        ConsumerOptions $this$addMessagePassphrase_u24lambda_u2414 = consumerOptions = this;
        boolean bl = false;
        $this$addMessagePassphrase_u24lambda_u2414.decryptionPassphrases.add(passphrase);
        return consumerOptions;
    }

    @NotNull
    public final ConsumerOptions addCustomDecryptorFactory(@NotNull CustomPublicKeyDataDecryptorFactory factory) {
        ConsumerOptions consumerOptions;
        Intrinsics.checkNotNullParameter((Object)((Object)factory), (String)"factory");
        ConsumerOptions $this$addCustomDecryptorFactory_u24lambda_u2415 = consumerOptions = this;
        boolean bl = false;
        $this$addCustomDecryptorFactory_u24lambda_u2415.customDecryptorFactories.put(factory.getSubkeyIdentifier(), (PublicKeyDataDecryptorFactory)factory);
        return consumerOptions;
    }

    @NotNull
    public final Map<SubkeyIdentifier, PublicKeyDataDecryptorFactory> getCustomDecryptorFactories() {
        return MapsKt.toMap(this.customDecryptorFactories);
    }

    @NotNull
    public final Set<OpenPGPKey> getDecryptionKeys() {
        return CollectionsKt.toSet((Iterable)this.decryptionKeys.keySet());
    }

    @NotNull
    public final Set<Passphrase> getDecryptionPassphrases() {
        return CollectionsKt.toSet((Iterable)this.decryptionPassphrases);
    }

    @NotNull
    public final CertificateSource getCertificateSource() {
        return this.certificates;
    }

    @Nullable
    public final OpenPGPKeyMaterialProvider.OpenPGPCertificateProvider getMissingCertificateCallback() {
        return this.missingCertificateCallback;
    }

    @Nullable
    public final SecretKeyRingProtector getSecretKeyProtector(@NotNull OpenPGPKey decryptionKeyRing) {
        Intrinsics.checkNotNullParameter((Object)decryptionKeyRing, (String)"decryptionKeyRing");
        return this.decryptionKeys.get(decryptionKeyRing);
    }

    @Deprecated(message="Ignoring non-integrity-protected packets is discouraged.")
    @NotNull
    public final ConsumerOptions setIgnoreMDCErrors(boolean ignoreMDCErrors) {
        ConsumerOptions consumerOptions;
        ConsumerOptions $this$setIgnoreMDCErrors_u24lambda_u2416 = consumerOptions = this;
        boolean bl = false;
        $this$setIgnoreMDCErrors_u24lambda_u2416.ignoreMDCErrors = ignoreMDCErrors;
        return consumerOptions;
    }

    public final boolean isIgnoreMDCErrors() {
        return this.ignoreMDCErrors;
    }

    @NotNull
    public final ConsumerOptions setAllowDecryptionWithMissingKeyFlags() {
        ConsumerOptions consumerOptions;
        ConsumerOptions $this$setAllowDecryptionWithMissingKeyFlags_u24lambda_u2417 = consumerOptions = this;
        boolean bl = false;
        $this$setAllowDecryptionWithMissingKeyFlags_u24lambda_u2417.allowDecryptionWithNonEncryptionKey = true;
        return consumerOptions;
    }

    public final boolean getAllowDecryptionWithNonEncryptionKey() {
        return this.allowDecryptionWithNonEncryptionKey;
    }

    @NotNull
    public final ConsumerOptions forceNonOpenPgpData() {
        ConsumerOptions consumerOptions;
        ConsumerOptions $this$forceNonOpenPgpData_u24lambda_u2418 = consumerOptions = this;
        boolean bl = false;
        $this$forceNonOpenPgpData_u24lambda_u2418.forceNonOpenPgpData = true;
        return consumerOptions;
    }

    public final boolean isForceNonOpenPgpData() {
        return this.forceNonOpenPgpData;
    }

    @NotNull
    public final ConsumerOptions setMissingKeyPassphraseStrategy(@NotNull MissingKeyPassphraseStrategy strategy) {
        Intrinsics.checkNotNullParameter((Object)((Object)strategy), (String)"strategy");
        this.missingKeyPassphraseStrategy = strategy;
        return this;
    }

    @NotNull
    public final MissingKeyPassphraseStrategy getMissingKeyPassphraseStrategy() {
        return this.missingKeyPassphraseStrategy;
    }

    @NotNull
    public final ConsumerOptions setMultiPassStrategy(@NotNull MultiPassStrategy multiPassStrategy) {
        Intrinsics.checkNotNullParameter((Object)multiPassStrategy, (String)"multiPassStrategy");
        this.multiPassStrategy = multiPassStrategy;
        return this;
    }

    @NotNull
    public final MultiPassStrategy getMultiPassStrategy() {
        return this.multiPassStrategy;
    }

    @JvmOverloads
    @NotNull
    public final ConsumerOptions addDecryptionKey(@NotNull OpenPGPKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return ConsumerOptions.addDecryptionKey$default(this, key, null, 2, null);
    }

    @Deprecated(message="Pass OpenPGPKey instead.")
    @JvmOverloads
    @NotNull
    public final ConsumerOptions addDecryptionKey(@NotNull PGPSecretKeyRing key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return ConsumerOptions.addDecryptionKey$default(this, key, null, 2, null);
    }

    @Deprecated(message="Pass OpenPGPKey instances instead.")
    @JvmOverloads
    @NotNull
    public final ConsumerOptions addDecryptionKeys(@NotNull PGPSecretKeyRingCollection keys) {
        Intrinsics.checkNotNullParameter((Object)keys, (String)"keys");
        return ConsumerOptions.addDecryptionKeys$default(this, keys, null, 2, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final ConsumerOptions get(@NotNull PGPainless api) {
        return Companion.get(api);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final ConsumerOptions get() {
        return Companion.get();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0011\u001a\u00020\u0012J\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/pgpainless/decryption_verification/ConsumerOptions$CertificateSource;", "", "api", "Lorg/pgpainless/PGPainless;", "(Lorg/pgpainless/PGPainless;)V", "explicitCertificates", "", "Lorg/bouncycastle/openpgp/api/OpenPGPCertificate;", "addCertificate", "", "certificate", "Lorg/bouncycastle/openpgp/PGPPublicKeyRing;", "getCertificate", "keyId", "", "identifier", "Lorg/bouncycastle/bcpg/KeyIdentifier;", "signature", "Lorg/bouncycastle/openpgp/PGPSignature;", "getExplicitCertificates", "", "pgpainless-core"})
    @SourceDebugExtension(value={"SMAP\nConsumerOptions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConsumerOptions.kt\norg/pgpainless/decryption_verification/ConsumerOptions$CertificateSource\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,476:1\n288#2,2:477\n288#2,2:479\n*S KotlinDebug\n*F\n+ 1 ConsumerOptions.kt\norg/pgpainless/decryption_verification/ConsumerOptions$CertificateSource\n*L\n462#1:477,2\n467#1:479,2\n*E\n"})
    public static final class CertificateSource {
        @NotNull
        private final PGPainless api;
        @NotNull
        private final Set<OpenPGPCertificate> explicitCertificates;

        public CertificateSource(@NotNull PGPainless api) {
            Intrinsics.checkNotNullParameter((Object)api, (String)"api");
            this.api = api;
            this.explicitCertificates = new LinkedHashSet();
        }

        @Deprecated(message="Pass in an OpenPGPCertificate instead.")
        public final void addCertificate(@NotNull PGPPublicKeyRing certificate) {
            Intrinsics.checkNotNullParameter((Object)certificate, (String)"certificate");
            this.explicitCertificates.add(this.api.toCertificate(certificate));
        }

        public final void addCertificate(@NotNull OpenPGPCertificate certificate) {
            Intrinsics.checkNotNullParameter((Object)certificate, (String)"certificate");
            this.explicitCertificates.add(certificate);
        }

        @NotNull
        public final Set<OpenPGPCertificate> getExplicitCertificates() {
            return CollectionsKt.toSet((Iterable)this.explicitCertificates);
        }

        @Deprecated(message="Pass in a KeyIdentifier instead.")
        @Nullable
        public final OpenPGPCertificate getCertificate(long keyId) {
            return this.getCertificate(new KeyIdentifier(keyId));
        }

        @Nullable
        public final OpenPGPCertificate getCertificate(@NotNull KeyIdentifier identifier) {
            Object v0;
            block1: {
                Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
                Iterable $this$firstOrNull$iv = this.explicitCertificates;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    OpenPGPCertificate it = (OpenPGPCertificate)element$iv;
                    boolean bl = false;
                    if (!(it.getKey(identifier) != null)) continue;
                    v0 = element$iv;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        @Nullable
        public final OpenPGPCertificate getCertificate(@NotNull PGPSignature signature) {
            Object v0;
            block1: {
                Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
                Iterable $this$firstOrNull$iv = this.explicitCertificates;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    OpenPGPCertificate it = (OpenPGPCertificate)element$iv;
                    boolean bl = false;
                    if (!(it.getSigningKeyFor(signature) != null)) continue;
                    v0 = element$iv;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lorg/pgpainless/decryption_verification/ConsumerOptions$Companion;", "", "()V", "get", "Lorg/pgpainless/decryption_verification/ConsumerOptions;", "api", "Lorg/pgpainless/PGPainless;", "pgpainless-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final ConsumerOptions get(@NotNull PGPainless api) {
            Intrinsics.checkNotNullParameter((Object)api, (String)"api");
            return new ConsumerOptions(api);
        }

        public static /* synthetic */ ConsumerOptions get$default(Companion companion, PGPainless pGPainless, int n, Object object) {
            if ((n & 1) != 0) {
                pGPainless = PGPainless.Companion.getInstance();
            }
            return companion.get(pGPainless);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final ConsumerOptions get() {
            return org.pgpainless.decryption_verification.ConsumerOptions$Companion.get$default(this, null, 1, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

