/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.authentication;

import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.api.OpenPGPCertificate;
import org.jetbrains.annotations.NotNull;
import org.pgpainless.PGPainless;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/pgpainless/authentication/ChainLink;", "", "certificate", "Lorg/bouncycastle/openpgp/PGPPublicKeyRing;", "(Lorg/bouncycastle/openpgp/PGPPublicKeyRing;)V", "Lorg/bouncycastle/openpgp/api/OpenPGPCertificate;", "(Lorg/bouncycastle/openpgp/api/OpenPGPCertificate;)V", "getCertificate", "()Lorg/bouncycastle/openpgp/api/OpenPGPCertificate;", "pgpPublicKeyRing", "getPgpPublicKeyRing$annotations", "()V", "getPgpPublicKeyRing", "()Lorg/bouncycastle/openpgp/PGPPublicKeyRing;", "pgpainless-core"})
public final class ChainLink {
    @NotNull
    private final OpenPGPCertificate certificate;
    @NotNull
    private final PGPPublicKeyRing pgpPublicKeyRing;

    public ChainLink(@NotNull OpenPGPCertificate certificate) {
        Intrinsics.checkNotNullParameter((Object)certificate, (String)"certificate");
        this.certificate = certificate;
        PGPPublicKeyRing pGPPublicKeyRing = this.certificate.getPGPPublicKeyRing();
        Intrinsics.checkNotNullExpressionValue((Object)pGPPublicKeyRing, (String)"getPGPPublicKeyRing(...)");
        this.pgpPublicKeyRing = pGPPublicKeyRing;
    }

    @NotNull
    public final OpenPGPCertificate getCertificate() {
        return this.certificate;
    }

    public ChainLink(@NotNull PGPPublicKeyRing certificate) {
        Intrinsics.checkNotNullParameter((Object)certificate, (String)"certificate");
        this(PGPainless.Companion.getInstance().toCertificate(certificate));
    }

    @NotNull
    public final PGPPublicKeyRing getPgpPublicKeyRing() {
        return this.pgpPublicKeyRing;
    }

    @Deprecated(message="Use certificate instead.", replaceWith=@ReplaceWith(expression="certificate", imports={}))
    public static /* synthetic */ void getPgpPublicKeyRing$annotations() {
    }
}

