/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.signature.builder;

import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPUserAttributeSubpacketVector;
import org.bouncycastle.openpgp.api.OpenPGPKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.SignatureType;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.signature.builder.AbstractSignatureBuilder;
import org.pgpainless.signature.subpackets.BaseSignatureSubpackets;
import org.pgpainless.signature.subpackets.SelfSignatureSubpackets;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB'\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000bB'\b\u0016\u0012\u0006\u0010\f\u001a\u00020\u0003\u0012\u0006\u0010\r\u001a\u00020\u0005\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u001b\u001a\u00020\u00002\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dJ\u000e\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010\u001e\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\"R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\n0\u00168TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0014\u00a8\u0006#"}, d2={"Lorg/pgpainless/signature/builder/SelfSignatureBuilder;", "Lorg/pgpainless/signature/builder/AbstractSignatureBuilder;", "signingKey", "Lorg/bouncycastle/openpgp/api/OpenPGPKey$OpenPGPSecretKey;", "protector", "Lorg/pgpainless/key/protection/SecretKeyRingProtector;", "api", "Lorg/pgpainless/PGPainless;", "(Lorg/bouncycastle/openpgp/api/OpenPGPKey$OpenPGPSecretKey;Lorg/pgpainless/key/protection/SecretKeyRingProtector;Lorg/pgpainless/PGPainless;)V", "signatureType", "Lorg/pgpainless/algorithm/SignatureType;", "(Lorg/pgpainless/algorithm/SignatureType;Lorg/bouncycastle/openpgp/api/OpenPGPKey$OpenPGPSecretKey;Lorg/pgpainless/key/protection/SecretKeyRingProtector;Lorg/pgpainless/PGPainless;)V", "primaryKey", "primaryKeyProtector", "oldCertification", "Lorg/bouncycastle/openpgp/PGPSignature;", "(Lorg/bouncycastle/openpgp/api/OpenPGPKey$OpenPGPSecretKey;Lorg/pgpainless/key/protection/SecretKeyRingProtector;Lorg/bouncycastle/openpgp/PGPSignature;Lorg/pgpainless/PGPainless;)V", "hashedSubpackets", "Lorg/pgpainless/signature/subpackets/SelfSignatureSubpackets;", "getHashedSubpackets", "()Lorg/pgpainless/signature/subpackets/SelfSignatureSubpackets;", "signatureTypePredicate", "Ljava/util/function/Predicate;", "getSignatureTypePredicate", "()Ljava/util/function/Predicate;", "unhashedSubpackets", "getUnhashedSubpackets", "applyCallback", "callback", "Lorg/pgpainless/signature/subpackets/SelfSignatureSubpackets$Callback;", "build", "userId", "", "userAttributes", "Lorg/bouncycastle/openpgp/PGPUserAttributeSubpacketVector;", "pgpainless-core"})
public final class SelfSignatureBuilder
extends AbstractSignatureBuilder<SelfSignatureBuilder> {
    @NotNull
    private final SelfSignatureSubpackets hashedSubpackets;
    @NotNull
    private final SelfSignatureSubpackets unhashedSubpackets;

    @Override
    @NotNull
    protected Predicate<SignatureType> getSignatureTypePredicate() {
        return SelfSignatureBuilder::_get_signatureTypePredicate_$lambda$0;
    }

    public SelfSignatureBuilder(@NotNull OpenPGPKey.OpenPGPSecretKey signingKey, @NotNull SecretKeyRingProtector protector, @NotNull PGPainless api) throws PGPException {
        Intrinsics.checkNotNullParameter((Object)signingKey, (String)"signingKey");
        Intrinsics.checkNotNullParameter((Object)protector, (String)"protector");
        Intrinsics.checkNotNullParameter((Object)api, (String)"api");
        super(SignatureType.GENERIC_CERTIFICATION, signingKey, protector, api);
        this.hashedSubpackets = this.get_hashedSubpackets();
        this.unhashedSubpackets = this.get_unhashedSubpackets();
    }

    public SelfSignatureBuilder(@NotNull SignatureType signatureType, @NotNull OpenPGPKey.OpenPGPSecretKey signingKey, @NotNull SecretKeyRingProtector protector, @NotNull PGPainless api) throws PGPException {
        Intrinsics.checkNotNullParameter((Object)((Object)signatureType), (String)"signatureType");
        Intrinsics.checkNotNullParameter((Object)signingKey, (String)"signingKey");
        Intrinsics.checkNotNullParameter((Object)protector, (String)"protector");
        Intrinsics.checkNotNullParameter((Object)api, (String)"api");
        super(signatureType, signingKey, protector, api);
        this.hashedSubpackets = this.get_hashedSubpackets();
        this.unhashedSubpackets = this.get_unhashedSubpackets();
    }

    public SelfSignatureBuilder(@NotNull OpenPGPKey.OpenPGPSecretKey primaryKey, @NotNull SecretKeyRingProtector primaryKeyProtector, @NotNull PGPSignature oldCertification, @NotNull PGPainless api) throws PGPException {
        Intrinsics.checkNotNullParameter((Object)primaryKey, (String)"primaryKey");
        Intrinsics.checkNotNullParameter((Object)primaryKeyProtector, (String)"primaryKeyProtector");
        Intrinsics.checkNotNullParameter((Object)oldCertification, (String)"oldCertification");
        Intrinsics.checkNotNullParameter((Object)api, (String)"api");
        super(primaryKey, primaryKeyProtector, oldCertification, api);
        this.hashedSubpackets = this.get_hashedSubpackets();
        this.unhashedSubpackets = this.get_unhashedSubpackets();
    }

    @NotNull
    public final SelfSignatureSubpackets getHashedSubpackets() {
        return this.hashedSubpackets;
    }

    @NotNull
    public final SelfSignatureSubpackets getUnhashedSubpackets() {
        return this.unhashedSubpackets;
    }

    @NotNull
    public final SelfSignatureBuilder applyCallback(@Nullable SelfSignatureSubpackets.Callback callback2) {
        SelfSignatureBuilder selfSignatureBuilder;
        block0: {
            SelfSignatureBuilder $this$applyCallback_u24lambda_u242 = selfSignatureBuilder = this;
            boolean bl = false;
            SelfSignatureSubpackets.Callback callback3 = callback2;
            if (callback3 == null) break block0;
            SelfSignatureSubpackets.Callback it = callback3;
            boolean bl2 = false;
            it.modifyHashedSubpackets((BaseSignatureSubpackets)$this$applyCallback_u24lambda_u242.hashedSubpackets);
            it.modifyUnhashedSubpackets((BaseSignatureSubpackets)$this$applyCallback_u24lambda_u242.unhashedSubpackets);
        }
        return selfSignatureBuilder;
    }

    @NotNull
    public final PGPSignature build(@NotNull CharSequence userId) throws PGPException {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        PGPSignature pGPSignature = this.buildAndInitSignatureGenerator().generateCertification(((Object)userId).toString(), this.getSigningKey().getPublicKey().getPGPPublicKey());
        Intrinsics.checkNotNullExpressionValue((Object)pGPSignature, (String)"generateCertification(...)");
        return pGPSignature;
    }

    @NotNull
    public final PGPSignature build(@NotNull PGPUserAttributeSubpacketVector userAttributes) throws PGPException {
        Intrinsics.checkNotNullParameter((Object)userAttributes, (String)"userAttributes");
        PGPSignature pGPSignature = this.buildAndInitSignatureGenerator().generateCertification(userAttributes, this.getSigningKey().getPublicKey().getPGPPublicKey());
        Intrinsics.checkNotNullExpressionValue((Object)pGPSignature, (String)"generateCertification(...)");
        return pGPSignature;
    }

    private static final boolean _get_signatureTypePredicate_$lambda$0(SignatureType it) {
        SignatureType[] signatureTypeArray = new SignatureType[]{SignatureType.GENERIC_CERTIFICATION, SignatureType.NO_CERTIFICATION, SignatureType.CASUAL_CERTIFICATION, SignatureType.POSITIVE_CERTIFICATION};
        return CollectionsKt.listOf((Object[])signatureTypeArray).contains((Object)it);
    }
}

