/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.collection;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPMarker;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.api.OpenPGPImplementation;
import org.jetbrains.annotations.NotNull;
import org.pgpainless.util.ArmorUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0017\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tB\u001d\b\u0016\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\rB\u001b\b\u0012\u0012\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f\u00a2\u0006\u0002\u0010\u0012B\u0015\u0012\u0006\u0010\u0013\u001a\u00020\u0010\u0012\u0006\u0010\u0014\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u001e\u001a\u00020\u0010H\u0007J\u0006\u0010\u001a\u001a\u00020\u001bR\u0011\u0010\u0014\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0013\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006 "}, d2={"Lorg/pgpainless/key/collection/PGPKeyRingCollection;", "", "encoding", "", "isSilent", "", "([BZ)V", "inputStream", "Ljava/io/InputStream;", "(Ljava/io/InputStream;Z)V", "collection", "", "Lorg/bouncycastle/openpgp/PGPKeyRing;", "(Ljava/util/Collection;Z)V", "arguments", "Lkotlin/Pair;", "Lorg/bouncycastle/openpgp/PGPSecretKeyRingCollection;", "Lorg/bouncycastle/openpgp/PGPPublicKeyRingCollection;", "(Lkotlin/Pair;)V", "pgpSecretKeyRingCollection", "pgpPublicKeyRingCollection", "(Lorg/bouncycastle/openpgp/PGPSecretKeyRingCollection;Lorg/bouncycastle/openpgp/PGPPublicKeyRingCollection;)V", "getPgpPublicKeyRingCollection", "()Lorg/bouncycastle/openpgp/PGPPublicKeyRingCollection;", "getPgpSecretKeyRingCollection", "()Lorg/bouncycastle/openpgp/PGPSecretKeyRingCollection;", "size", "", "getSize", "()I", "getPGPSecretKeyRingCollection", "Companion", "pgpainless-core"})
public final class PGPKeyRingCollection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PGPSecretKeyRingCollection pgpSecretKeyRingCollection;
    @NotNull
    private final PGPPublicKeyRingCollection pgpPublicKeyRingCollection;

    public PGPKeyRingCollection(@NotNull PGPSecretKeyRingCollection pgpSecretKeyRingCollection, @NotNull PGPPublicKeyRingCollection pgpPublicKeyRingCollection) {
        Intrinsics.checkNotNullParameter((Object)pgpSecretKeyRingCollection, (String)"pgpSecretKeyRingCollection");
        Intrinsics.checkNotNullParameter((Object)pgpPublicKeyRingCollection, (String)"pgpPublicKeyRingCollection");
        this.pgpSecretKeyRingCollection = pgpSecretKeyRingCollection;
        this.pgpPublicKeyRingCollection = pgpPublicKeyRingCollection;
    }

    @NotNull
    public final PGPSecretKeyRingCollection getPgpSecretKeyRingCollection() {
        return this.pgpSecretKeyRingCollection;
    }

    @NotNull
    public final PGPPublicKeyRingCollection getPgpPublicKeyRingCollection() {
        return this.pgpPublicKeyRingCollection;
    }

    public PGPKeyRingCollection(@NotNull byte[] encoding, boolean isSilent) {
        Intrinsics.checkNotNullParameter((Object)encoding, (String)"encoding");
        this(new ByteArrayInputStream(encoding), isSilent);
    }

    public PGPKeyRingCollection(@NotNull InputStream inputStream, boolean isSilent) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        this((Pair<? extends PGPSecretKeyRingCollection, ? extends PGPPublicKeyRingCollection>)PGPKeyRingCollection.Companion.parse(inputStream, isSilent));
    }

    public PGPKeyRingCollection(@NotNull Collection<? extends PGPKeyRing> collection, boolean isSilent) {
        Intrinsics.checkNotNullParameter(collection, (String)"collection");
        this((Pair<? extends PGPSecretKeyRingCollection, ? extends PGPPublicKeyRingCollection>)PGPKeyRingCollection.Companion.segment(collection, isSilent));
    }

    private PGPKeyRingCollection(Pair<? extends PGPSecretKeyRingCollection, ? extends PGPPublicKeyRingCollection> arguments) {
        this((PGPSecretKeyRingCollection)arguments.getFirst(), (PGPPublicKeyRingCollection)arguments.getSecond());
    }

    public final int getSize() {
        return this.pgpSecretKeyRingCollection.size() + this.pgpPublicKeyRingCollection.size();
    }

    public final int size() {
        return this.getSize();
    }

    @Deprecated(message="Wrong case of PGP -> Pgp", replaceWith=@ReplaceWith(expression="getPgpSecretKeyRingCollection()", imports={}))
    @NotNull
    public final PGPSecretKeyRingCollection getPGPSecretKeyRingCollection() {
        return this.pgpSecretKeyRingCollection;
    }

    @JvmStatic
    private static final Pair<PGPSecretKeyRingCollection, PGPPublicKeyRingCollection> parse(InputStream inputStream, boolean isSilent) {
        return PGPKeyRingCollection.Companion.parse(inputStream, isSilent);
    }

    @JvmStatic
    private static final Pair<PGPSecretKeyRingCollection, PGPPublicKeyRingCollection> segment(Collection<? extends PGPKeyRing> collection, boolean isSilent) {
        return PGPKeyRingCollection.Companion.segment(collection, isSilent);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0003J*\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\t\u001a\u00020\nH\u0003\u00a8\u0006\u000f"}, d2={"Lorg/pgpainless/key/collection/PGPKeyRingCollection$Companion;", "", "()V", "parse", "Lkotlin/Pair;", "Lorg/bouncycastle/openpgp/PGPSecretKeyRingCollection;", "Lorg/bouncycastle/openpgp/PGPPublicKeyRingCollection;", "inputStream", "Ljava/io/InputStream;", "isSilent", "", "segment", "collection", "", "Lorg/bouncycastle/openpgp/PGPKeyRing;", "pgpainless-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private final Pair<PGPSecretKeyRingCollection, PGPPublicKeyRingCollection> parse(InputStream inputStream, boolean isSilent) {
            List secretKeyRings = new ArrayList();
            List certificates = new ArrayList();
            PGPObjectFactory objectFactory = OpenPGPImplementation.getInstance().pgpObjectFactory(ArmorUtils.Companion.getDecoderStream(inputStream));
            for (Object obj : objectFactory) {
                if (obj == null) break;
                if (obj instanceof PGPMarker) continue;
                if (obj instanceof PGPSecretKeyRing) {
                    secretKeyRings.add(obj);
                    continue;
                }
                if (obj instanceof PGPPublicKeyRing) {
                    certificates.add(obj);
                    continue;
                }
                if (isSilent) continue;
                throw new PGPException(obj.getClass().getName() + " found where " + PGPSecretKeyRing.class.getSimpleName() + " or " + PGPPublicKeyRing.class.getSimpleName() + " expected");
            }
            return TuplesKt.to((Object)new PGPSecretKeyRingCollection((Collection)secretKeyRings), (Object)new PGPPublicKeyRingCollection((Collection)certificates));
        }

        @JvmStatic
        private final Pair<PGPSecretKeyRingCollection, PGPPublicKeyRingCollection> segment(Collection<? extends PGPKeyRing> collection, boolean isSilent) {
            List secretKeyRings = new ArrayList();
            List certificates = new ArrayList();
            for (PGPKeyRing pGPKeyRing : collection) {
                if (pGPKeyRing instanceof PGPSecretKeyRing) {
                    secretKeyRings.add(pGPKeyRing);
                    continue;
                }
                if (pGPKeyRing instanceof PGPPublicKeyRing) {
                    certificates.add(pGPKeyRing);
                    continue;
                }
                if (isSilent) continue;
                throw new PGPException(pGPKeyRing.getClass().getName() + " found where " + PGPSecretKeyRing.class.getSimpleName() + " or " + PGPPublicKeyRing.class.getSimpleName() + " expected");
            }
            return TuplesKt.to((Object)new PGPSecretKeyRingCollection((Collection)secretKeyRings), (Object)new PGPPublicKeyRingCollection((Collection)certificates));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

