/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key;

import java.util.NoSuchElementException;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.bcpg.KeyIdentifier;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.api.OpenPGPCertificate;
import org.bouncycastle.openpgp.api.OpenPGPKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.key.OpenPgpFingerprint;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0017\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u000f\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB\u0017\b\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rB\u000f\b\u0016\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010B\u000f\b\u0016\u0012\u0006\u0010\u000e\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012B\u0017\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0013\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0014B\u0017\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0002\u0010\u0017B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0013\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0018J\u0013\u00108\u001a\u00020#2\b\u00109\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010:\u001a\u00020;H\u0016J\u000e\u0010<\u001a\u00020#2\u0006\u0010 \u001a\u00020\u0003J\b\u0010=\u001a\u00020>H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u0013\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001aR\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001dR\u0011\u0010 \u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001aR\u0011\u0010\"\u001a\u00020#\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010$R\u001c\u0010%\u001a\u00020\f8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b&\u0010'\u001a\u0004\b(\u0010)R\u0011\u0010*\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\u001dR\u001c\u0010,\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b-\u0010'\u001a\u0004\b.\u0010\u001aR\u001c\u0010/\u001a\u00020\f8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b0\u0010'\u001a\u0004\b1\u0010)R\u001c\u00102\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b3\u0010'\u001a\u0004\b4\u0010\u001aR\u001c\u00105\u001a\u00020\f8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b6\u0010'\u001a\u0004\b7\u0010)\u00a8\u0006?"}, d2={"Lorg/pgpainless/key/SubkeyIdentifier;", "", "certificateFingerprint", "Lorg/pgpainless/key/OpenPgpFingerprint;", "(Lorg/pgpainless/key/OpenPgpFingerprint;)V", "certificate", "Lorg/bouncycastle/openpgp/PGPKeyRing;", "(Lorg/bouncycastle/openpgp/PGPKeyRing;)V", "primaryKey", "Lorg/bouncycastle/openpgp/PGPPublicKey;", "(Lorg/bouncycastle/openpgp/PGPPublicKey;)V", "componentKeyId", "", "(Lorg/bouncycastle/openpgp/PGPKeyRing;J)V", "componentKey", "Lorg/bouncycastle/openpgp/api/OpenPGPCertificate$OpenPGPComponentKey;", "(Lorg/bouncycastle/openpgp/api/OpenPGPCertificate$OpenPGPComponentKey;)V", "Lorg/bouncycastle/openpgp/api/OpenPGPKey$OpenPGPPrivateKey;", "(Lorg/bouncycastle/openpgp/api/OpenPGPKey$OpenPGPPrivateKey;)V", "componentKeyFingerprint", "(Lorg/bouncycastle/openpgp/PGPKeyRing;Lorg/pgpainless/key/OpenPgpFingerprint;)V", "componentKeyIdentifier", "Lorg/bouncycastle/bcpg/KeyIdentifier;", "(Lorg/bouncycastle/openpgp/PGPKeyRing;Lorg/bouncycastle/bcpg/KeyIdentifier;)V", "(Lorg/pgpainless/key/OpenPgpFingerprint;Lorg/pgpainless/key/OpenPgpFingerprint;)V", "getCertificateFingerprint", "()Lorg/pgpainless/key/OpenPgpFingerprint;", "certificateIdentifier", "getCertificateIdentifier", "()Lorg/bouncycastle/bcpg/KeyIdentifier;", "getComponentKeyFingerprint", "getComponentKeyIdentifier", "fingerprint", "getFingerprint", "isPrimaryKey", "", "()Z", "keyId", "getKeyId$annotations", "()V", "getKeyId", "()J", "keyIdentifier", "getKeyIdentifier", "primaryKeyFingerprint", "getPrimaryKeyFingerprint$annotations", "getPrimaryKeyFingerprint", "primaryKeyId", "getPrimaryKeyId$annotations", "getPrimaryKeyId", "subkeyFingerprint", "getSubkeyFingerprint$annotations", "getSubkeyFingerprint", "subkeyId", "getSubkeyId$annotations", "getSubkeyId", "equals", "other", "hashCode", "", "matches", "toString", "", "pgpainless-core"})
public final class SubkeyIdentifier {
    @NotNull
    private final OpenPgpFingerprint certificateFingerprint;
    @NotNull
    private final OpenPgpFingerprint componentKeyFingerprint;
    @NotNull
    private final OpenPgpFingerprint primaryKeyFingerprint;
    @NotNull
    private final OpenPgpFingerprint subkeyFingerprint;
    @NotNull
    private final KeyIdentifier keyIdentifier;
    @NotNull
    private final KeyIdentifier componentKeyIdentifier;
    @NotNull
    private final KeyIdentifier certificateIdentifier;
    private final long keyId;
    @NotNull
    private final OpenPgpFingerprint fingerprint;
    private final long subkeyId;
    private final long primaryKeyId;
    private final boolean isPrimaryKey;

    public SubkeyIdentifier(@NotNull OpenPgpFingerprint certificateFingerprint, @NotNull OpenPgpFingerprint componentKeyFingerprint) {
        Intrinsics.checkNotNullParameter((Object)certificateFingerprint, (String)"certificateFingerprint");
        Intrinsics.checkNotNullParameter((Object)componentKeyFingerprint, (String)"componentKeyFingerprint");
        this.certificateFingerprint = certificateFingerprint;
        this.componentKeyFingerprint = componentKeyFingerprint;
        this.primaryKeyFingerprint = this.certificateFingerprint;
        this.subkeyFingerprint = this.componentKeyFingerprint;
        this.componentKeyIdentifier = this.keyIdentifier = this.componentKeyFingerprint.getKeyIdentifier();
        this.certificateIdentifier = this.certificateFingerprint.getKeyIdentifier();
        this.keyId = this.keyIdentifier.getKeyId();
        this.fingerprint = this.componentKeyFingerprint;
        this.subkeyId = this.componentKeyIdentifier.getKeyId();
        this.primaryKeyId = this.certificateIdentifier.getKeyId();
        this.isPrimaryKey = this.certificateIdentifier.matchesExplicit(this.componentKeyIdentifier);
    }

    @NotNull
    public final OpenPgpFingerprint getCertificateFingerprint() {
        return this.certificateFingerprint;
    }

    @NotNull
    public final OpenPgpFingerprint getComponentKeyFingerprint() {
        return this.componentKeyFingerprint;
    }

    public SubkeyIdentifier(@NotNull OpenPgpFingerprint certificateFingerprint) {
        Intrinsics.checkNotNullParameter((Object)certificateFingerprint, (String)"certificateFingerprint");
        this(certificateFingerprint, certificateFingerprint);
    }

    public SubkeyIdentifier(@NotNull PGPKeyRing certificate) {
        Intrinsics.checkNotNullParameter((Object)certificate, (String)"certificate");
        PGPPublicKey pGPPublicKey = certificate.getPublicKey();
        Intrinsics.checkNotNullExpressionValue((Object)pGPPublicKey, (String)"getPublicKey(...)");
        this(pGPPublicKey);
    }

    public SubkeyIdentifier(@NotNull PGPPublicKey primaryKey) {
        Intrinsics.checkNotNullParameter((Object)primaryKey, (String)"primaryKey");
        this(OpenPgpFingerprint.Companion.of(primaryKey));
    }

    @Deprecated(message="Pass in a KeyIdentifier instead of a keyId.")
    public SubkeyIdentifier(@NotNull PGPKeyRing certificate, long componentKeyId) {
        Intrinsics.checkNotNullParameter((Object)certificate, (String)"certificate");
        this(certificate, new KeyIdentifier(componentKeyId));
    }

    public SubkeyIdentifier(@NotNull OpenPGPCertificate.OpenPGPComponentKey componentKey) {
        Intrinsics.checkNotNullParameter((Object)componentKey, (String)"componentKey");
        OpenPGPCertificate openPGPCertificate = componentKey.getCertificate();
        Intrinsics.checkNotNullExpressionValue((Object)openPGPCertificate, (String)"getCertificate(...)");
        this(OpenPgpFingerprint.Companion.of(openPGPCertificate), OpenPgpFingerprint.Companion.of(componentKey));
    }

    public SubkeyIdentifier(@NotNull OpenPGPKey.OpenPGPPrivateKey componentKey) {
        Intrinsics.checkNotNullParameter((Object)componentKey, (String)"componentKey");
        OpenPGPKey.OpenPGPSecretKey openPGPSecretKey = componentKey.getSecretKey();
        Intrinsics.checkNotNullExpressionValue((Object)openPGPSecretKey, (String)"getSecretKey(...)");
        this((OpenPGPCertificate.OpenPGPComponentKey)openPGPSecretKey);
    }

    public SubkeyIdentifier(@NotNull PGPKeyRing certificate, @NotNull OpenPgpFingerprint componentKeyFingerprint) {
        Intrinsics.checkNotNullParameter((Object)certificate, (String)"certificate");
        Intrinsics.checkNotNullParameter((Object)componentKeyFingerprint, (String)"componentKeyFingerprint");
        this(OpenPgpFingerprint.Companion.of(certificate), componentKeyFingerprint);
    }

    public SubkeyIdentifier(@NotNull PGPKeyRing certificate, @NotNull KeyIdentifier componentKeyIdentifier) {
        Intrinsics.checkNotNullParameter((Object)certificate, (String)"certificate");
        Intrinsics.checkNotNullParameter((Object)componentKeyIdentifier, (String)"componentKeyIdentifier");
        PGPPublicKey pGPPublicKey = certificate.getPublicKey(componentKeyIdentifier);
        if (pGPPublicKey == null) {
            throw new NoSuchElementException("OpenPGP key does not contain subkey " + componentKeyIdentifier);
        }
        this(OpenPgpFingerprint.Companion.of(certificate), OpenPgpFingerprint.Companion.of(pGPPublicKey));
    }

    @NotNull
    public final OpenPgpFingerprint getPrimaryKeyFingerprint() {
        return this.primaryKeyFingerprint;
    }

    @Deprecated(message="Use certificateFingerprint instead.", replaceWith=@ReplaceWith(expression="certificateFingerprint", imports={}))
    public static /* synthetic */ void getPrimaryKeyFingerprint$annotations() {
    }

    @NotNull
    public final OpenPgpFingerprint getSubkeyFingerprint() {
        return this.subkeyFingerprint;
    }

    @Deprecated(message="Use componentKeyFingerprint instead.", replaceWith=@ReplaceWith(expression="componentKeyFingerprint", imports={}))
    public static /* synthetic */ void getSubkeyFingerprint$annotations() {
    }

    @NotNull
    public final KeyIdentifier getKeyIdentifier() {
        return this.keyIdentifier;
    }

    @NotNull
    public final KeyIdentifier getComponentKeyIdentifier() {
        return this.componentKeyIdentifier;
    }

    @NotNull
    public final KeyIdentifier getCertificateIdentifier() {
        return this.certificateIdentifier;
    }

    public final long getKeyId() {
        return this.keyId;
    }

    @Deprecated(message="Use of key-ids is discouraged.")
    public static /* synthetic */ void getKeyId$annotations() {
    }

    @NotNull
    public final OpenPgpFingerprint getFingerprint() {
        return this.fingerprint;
    }

    public final long getSubkeyId() {
        return this.subkeyId;
    }

    @Deprecated(message="Use of key-ids is discouraged.")
    public static /* synthetic */ void getSubkeyId$annotations() {
    }

    public final long getPrimaryKeyId() {
        return this.primaryKeyId;
    }

    @Deprecated(message="Use of key-ids is discouraged.")
    public static /* synthetic */ void getPrimaryKeyId$annotations() {
    }

    public final boolean isPrimaryKey() {
        return this.isPrimaryKey;
    }

    public final boolean matches(@NotNull OpenPgpFingerprint fingerprint) {
        Intrinsics.checkNotNullParameter((Object)fingerprint, (String)"fingerprint");
        return Intrinsics.areEqual((Object)this.certificateFingerprint, (Object)fingerprint) || Intrinsics.areEqual((Object)this.componentKeyFingerprint, (Object)fingerprint);
    }

    public boolean equals(@Nullable Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!(other instanceof SubkeyIdentifier)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.certificateFingerprint, (Object)((SubkeyIdentifier)other).certificateFingerprint) && Intrinsics.areEqual((Object)this.componentKeyFingerprint, (Object)((SubkeyIdentifier)other).componentKeyFingerprint);
    }

    public int hashCode() {
        return this.certificateFingerprint.hashCode() + 31 * this.componentKeyFingerprint.hashCode();
    }

    @NotNull
    public String toString() {
        return this.componentKeyFingerprint + " " + this.certificateFingerprint;
    }
}

