/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key;

import java.nio.charset.Charset;
import java.util.Locale;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.bouncycastle.bcpg.KeyIdentifier;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.api.OpenPGPCertificate;
import org.bouncycastle.openpgp.api.OpenPGPKey;
import org.bouncycastle.util.encoders.Hex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.key.OpenPgpV4Fingerprint;
import org.pgpainless.key.OpenPgpV5Fingerprint;
import org.pgpainless.key.OpenPgpV6Fingerprint;
import org.pgpainless.key._64DigitFingerprint;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\f\n\u0002\b\u000b\b&\u0018\u0000 12\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002:\u00011B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u000f\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bB\u000f\b\u0016\u0012\u0006\u0010\t\u001a\u00020\f\u00a2\u0006\u0002\u0010\rB\u000f\b\u0016\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0011\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010#\u001a\u00020$2\b\u0010\"\u001a\u0004\u0018\u00010%H\u0096\u0002J\u0011\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u001eH\u0096\u0002J\b\u0010)\u001a\u00020\u001eH&J\b\u0010*\u001a\u00020\u001eH\u0016J\u0010\u0010+\u001a\u00020$2\u0006\u0010\u0003\u001a\u00020\u0004H$J\b\u0010,\u001a\u00020\u0004H&J\u0018\u0010-\u001a\u00020\u00012\u0006\u0010.\u001a\u00020\u001e2\u0006\u0010/\u001a\u00020\u001eH\u0016J\b\u00100\u001a\u00020\u0004H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0012\u0010\u0015\u001a\u00020\u0016X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0012\u0010\u0019\u001a\u00020\u001aX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u00062"}, d2={"Lorg/pgpainless/key/OpenPgpFingerprint;", "", "", "fingerprint", "", "(Ljava/lang/String;)V", "bytes", "", "([B)V", "key", "Lorg/bouncycastle/openpgp/PGPPublicKey;", "(Lorg/bouncycastle/openpgp/PGPPublicKey;)V", "Lorg/bouncycastle/openpgp/PGPSecretKey;", "(Lorg/bouncycastle/openpgp/PGPSecretKey;)V", "keys", "Lorg/bouncycastle/openpgp/PGPKeyRing;", "(Lorg/bouncycastle/openpgp/PGPKeyRing;)V", "getBytes", "()[B", "getFingerprint", "()Ljava/lang/String;", "keyId", "", "getKeyId", "()J", "keyIdentifier", "Lorg/bouncycastle/bcpg/KeyIdentifier;", "getKeyIdentifier", "()Lorg/bouncycastle/bcpg/KeyIdentifier;", "length", "", "getLength", "()I", "compareTo", "other", "equals", "", "", "get", "", "index", "getVersion", "hashCode", "isValid", "prettyPrint", "subSequence", "startIndex", "endIndex", "toString", "Companion", "pgpainless-core"})
public abstract class OpenPgpFingerprint
implements CharSequence,
Comparable<OpenPgpFingerprint> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String fingerprint;
    @NotNull
    private final byte[] bytes;
    @NotNull
    private static final Charset utf8;

    @NotNull
    public final String getFingerprint() {
        return this.fingerprint;
    }

    @NotNull
    public final byte[] getBytes() {
        return this.bytes;
    }

    public abstract int getVersion();

    public abstract long getKeyId();

    public OpenPgpFingerprint(@NotNull String fingerprint) {
        Intrinsics.checkNotNullParameter((Object)fingerprint, (String)"fingerprint");
        String string = ((Object)StringsKt.trim((CharSequence)StringsKt.replace$default((String)fingerprint, (String)" ", (String)"", (boolean)false, (int)4, null))).toString().toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        String prep = string;
        if (!this.isValid(prep)) {
            throw new IllegalArgumentException("Fingerprint '" + fingerprint + "' does not appear to be a valid OpenPGP V" + this.getVersion() + " fingerprint.");
        }
        this.fingerprint = prep;
        byte[] byArray = Hex.decode((String)prep);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(...)");
        this.bytes = byArray;
    }

    public OpenPgpFingerprint(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        String string = Hex.toHexString((byte[])bytes);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toHexString(...)");
        this(string);
    }

    public OpenPgpFingerprint(@NotNull PGPPublicKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        byte[] byArray = key.getFingerprint();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getFingerprint(...)");
        this(byArray);
        if (key.getVersion() != this.getVersion()) {
            throw new IllegalArgumentException("Key is not a v" + this.getVersion() + " OpenPgp key.");
        }
    }

    public OpenPgpFingerprint(@NotNull PGPSecretKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        PGPPublicKey pGPPublicKey = key.getPublicKey();
        Intrinsics.checkNotNullExpressionValue((Object)pGPPublicKey, (String)"getPublicKey(...)");
        this(pGPPublicKey);
    }

    public OpenPgpFingerprint(@NotNull PGPKeyRing keys) {
        Intrinsics.checkNotNullParameter((Object)keys, (String)"keys");
        PGPPublicKey pGPPublicKey = keys.getPublicKey();
        Intrinsics.checkNotNullExpressionValue((Object)pGPPublicKey, (String)"getPublicKey(...)");
        this(pGPPublicKey);
    }

    @NotNull
    public abstract KeyIdentifier getKeyIdentifier();

    protected abstract boolean isValid(@NotNull String var1);

    public int getLength() {
        return this.fingerprint.length();
    }

    public char get(int index) {
        return this.fingerprint.charAt(index);
    }

    @Override
    @NotNull
    public CharSequence subSequence(int startIndex, int endIndex) {
        return this.fingerprint.subSequence(startIndex, endIndex);
    }

    @Override
    public int compareTo(@NotNull OpenPgpFingerprint other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.fingerprint.compareTo(other.fingerprint);
    }

    public boolean equals(@Nullable Object other) {
        return Intrinsics.areEqual((Object)this.toString(), (Object)String.valueOf(other));
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    @NotNull
    public String toString() {
        return this.fingerprint;
    }

    @NotNull
    public abstract String prettyPrint();

    @NotNull
    public static final Charset getUtf8() {
        return Companion.getUtf8();
    }

    @JvmStatic
    @NotNull
    public static final OpenPgpFingerprint of(@NotNull PGPSecretKey key) {
        return Companion.of(key);
    }

    @JvmStatic
    @NotNull
    public static final OpenPgpFingerprint of(@NotNull PGPPublicKey key) {
        return Companion.of(key);
    }

    @JvmStatic
    @NotNull
    public static final OpenPgpFingerprint of(@NotNull PGPKeyRing keys) {
        return Companion.of(keys);
    }

    @JvmStatic
    @NotNull
    public static final OpenPgpFingerprint of(@NotNull OpenPGPCertificate cert) {
        return Companion.of(cert);
    }

    @JvmStatic
    @NotNull
    public static final OpenPgpFingerprint of(@NotNull OpenPGPCertificate.OpenPGPComponentKey key) {
        return Companion.of(key);
    }

    @JvmStatic
    @NotNull
    public static final OpenPgpFingerprint of(@NotNull OpenPGPKey.OpenPGPPrivateKey key) {
        return Companion.of(key);
    }

    @JvmStatic
    @Deprecated(message="Use the constructor methods of the versioned fingerprint subclasses instead.")
    @NotNull
    public static final OpenPgpFingerprint parse(@NotNull String fingerprint) {
        return Companion.parse(fingerprint);
    }

    @JvmStatic
    @Deprecated(message="use the parse() methods of the versioned fingerprint subclasses instead.")
    @NotNull
    public static final OpenPgpFingerprint parseFromBinary(@NotNull byte[] binaryFingerprint) {
        return Companion.parseFromBinary(binaryFingerprint);
    }

    static {
        Charset charset = Charset.forName("UTF-8");
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(...)");
        utf8 = charset;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000eH\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0011H\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0012H\u0007J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0018H\u0007R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0019"}, d2={"Lorg/pgpainless/key/OpenPgpFingerprint$Companion;", "", "()V", "utf8", "Ljava/nio/charset/Charset;", "getUtf8$annotations", "getUtf8", "()Ljava/nio/charset/Charset;", "of", "Lorg/pgpainless/key/OpenPgpFingerprint;", "keys", "Lorg/bouncycastle/openpgp/PGPKeyRing;", "key", "Lorg/bouncycastle/openpgp/PGPPublicKey;", "Lorg/bouncycastle/openpgp/PGPSecretKey;", "cert", "Lorg/bouncycastle/openpgp/api/OpenPGPCertificate;", "Lorg/bouncycastle/openpgp/api/OpenPGPCertificate$OpenPGPComponentKey;", "Lorg/bouncycastle/openpgp/api/OpenPGPKey$OpenPGPPrivateKey;", "parse", "fingerprint", "", "parseFromBinary", "binaryFingerprint", "", "pgpainless-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Charset getUtf8() {
            return utf8;
        }

        @JvmStatic
        public static /* synthetic */ void getUtf8$annotations() {
        }

        @JvmStatic
        @NotNull
        public final OpenPgpFingerprint of(@NotNull PGPSecretKey key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            PGPPublicKey pGPPublicKey = key.getPublicKey();
            Intrinsics.checkNotNullExpressionValue((Object)pGPPublicKey, (String)"getPublicKey(...)");
            return this.of(pGPPublicKey);
        }

        @JvmStatic
        @NotNull
        public final OpenPgpFingerprint of(@NotNull PGPPublicKey key) {
            OpenPgpFingerprint openPgpFingerprint;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            switch (key.getVersion()) {
                case 4: {
                    openPgpFingerprint = new OpenPgpV4Fingerprint(key);
                    break;
                }
                case 5: {
                    openPgpFingerprint = new OpenPgpV5Fingerprint(key);
                    break;
                }
                case 6: {
                    openPgpFingerprint = new OpenPgpV6Fingerprint(key);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("OpenPGP keys of version " + key.getVersion() + " are not supported.");
                }
            }
            return openPgpFingerprint;
        }

        @JvmStatic
        @NotNull
        public final OpenPgpFingerprint of(@NotNull PGPKeyRing keys) {
            Intrinsics.checkNotNullParameter((Object)keys, (String)"keys");
            PGPPublicKey pGPPublicKey = keys.getPublicKey();
            Intrinsics.checkNotNullExpressionValue((Object)pGPPublicKey, (String)"getPublicKey(...)");
            return this.of(pGPPublicKey);
        }

        @JvmStatic
        @NotNull
        public final OpenPgpFingerprint of(@NotNull OpenPGPCertificate cert) {
            Intrinsics.checkNotNullParameter((Object)cert, (String)"cert");
            PGPPublicKeyRing pGPPublicKeyRing = cert.getPGPPublicKeyRing();
            Intrinsics.checkNotNullExpressionValue((Object)pGPPublicKeyRing, (String)"getPGPPublicKeyRing(...)");
            return this.of((PGPKeyRing)pGPPublicKeyRing);
        }

        @JvmStatic
        @NotNull
        public final OpenPgpFingerprint of(@NotNull OpenPGPCertificate.OpenPGPComponentKey key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            PGPPublicKey pGPPublicKey = key.getPGPPublicKey();
            Intrinsics.checkNotNullExpressionValue((Object)pGPPublicKey, (String)"getPGPPublicKey(...)");
            return this.of(pGPPublicKey);
        }

        @JvmStatic
        @NotNull
        public final OpenPgpFingerprint of(@NotNull OpenPGPKey.OpenPGPPrivateKey key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            OpenPGPKey.OpenPGPSecretKey openPGPSecretKey = key.getSecretKey();
            Intrinsics.checkNotNullExpressionValue((Object)openPGPSecretKey, (String)"getSecretKey(...)");
            return this.of((OpenPGPCertificate.OpenPGPComponentKey)openPGPSecretKey);
        }

        @JvmStatic
        @Deprecated(message="Use the constructor methods of the versioned fingerprint subclasses instead.")
        @NotNull
        public final OpenPgpFingerprint parse(@NotNull String fingerprint) {
            Intrinsics.checkNotNullParameter((Object)fingerprint, (String)"fingerprint");
            String string = ((Object)StringsKt.trim((CharSequence)StringsKt.replace$default((String)fingerprint, (String)" ", (String)"", (boolean)false, (int)4, null))).toString().toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
            String prep = string;
            CharSequence charSequence = prep;
            if (new Regex("^[0-9A-F]{40}$").matches(charSequence)) {
                return new OpenPgpV4Fingerprint(prep);
            }
            charSequence = prep;
            if (new Regex("^[0-9A-F]{64}$").matches(charSequence)) {
                return new _64DigitFingerprint(prep);
            }
            throw new IllegalArgumentException("Fingerprint does not appear to match any known fingerprint pattern.");
        }

        @JvmStatic
        @Deprecated(message="use the parse() methods of the versioned fingerprint subclasses instead.")
        @NotNull
        public final OpenPgpFingerprint parseFromBinary(@NotNull byte[] binaryFingerprint) {
            Intrinsics.checkNotNullParameter((Object)binaryFingerprint, (String)"binaryFingerprint");
            String string = Hex.toHexString((byte[])binaryFingerprint);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toHexString(...)");
            return this.parse(string);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

