/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.decryption_verification;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import openpgp.LongExtensionsKt;
import org.bouncycastle.bcpg.AEADEncDataPacket;
import org.bouncycastle.bcpg.ArmoredInputStream;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.InputStreamPacket;
import org.bouncycastle.bcpg.KeyIdentifier;
import org.bouncycastle.bcpg.S2K;
import org.bouncycastle.bcpg.SymmetricEncIntegrityPacket;
import org.bouncycastle.bcpg.UnsupportedPacketVersionException;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPEncryptedData;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyPair;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPOnePassSignature;
import org.bouncycastle.openpgp.PGPPBEEncryptedData;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyEncryptedData;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSessionKey;
import org.bouncycastle.openpgp.PGPSessionKeyEncryptedData;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureException;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.api.EncryptedDataPacketType;
import org.bouncycastle.openpgp.api.KeyPassphraseProvider;
import org.bouncycastle.openpgp.api.MessageEncryptionMechanism;
import org.bouncycastle.openpgp.api.OpenPGPCertificate;
import org.bouncycastle.openpgp.api.OpenPGPKey;
import org.bouncycastle.openpgp.api.OpenPGPKeyMaterialProvider;
import org.bouncycastle.openpgp.api.OpenPGPSignature;
import org.bouncycastle.openpgp.api.exception.MalformedOpenPGPSignatureException;
import org.bouncycastle.openpgp.operator.PBEDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.PublicKeyDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.SessionKeyDataDecryptorFactory;
import org.bouncycastle.util.io.TeeInputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.CompressionAlgorithm;
import org.pgpainless.algorithm.OpenPgpPacket;
import org.pgpainless.algorithm.StreamEncoding;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.bouncycastle.extensions.OpenPGPCertificateExtensionsKt;
import org.pgpainless.bouncycastle.extensions.OpenPGPKeyExtensionsKt;
import org.pgpainless.bouncycastle.extensions.PGPSecretKeyRingExtensionsKt;
import org.pgpainless.bouncycastle.extensions.PGPSignatureExtensionsKt;
import org.pgpainless.decryption_verification.ConsumerOptions;
import org.pgpainless.decryption_verification.DecryptionStream;
import org.pgpainless.decryption_verification.IntegrityProtectedInputStream;
import org.pgpainless.decryption_verification.MessageMetadata;
import org.pgpainless.decryption_verification.MissingKeyPassphraseStrategy;
import org.pgpainless.decryption_verification.OpenPGPAnimalSnifferInputStream;
import org.pgpainless.decryption_verification.SignatureVerification;
import org.pgpainless.decryption_verification.TeeBCPGInputStream;
import org.pgpainless.decryption_verification.cleartext_signatures.ClearsignedMessageUtil;
import org.pgpainless.decryption_verification.cleartext_signatures.MultiPassStrategy;
import org.pgpainless.decryption_verification.syntax_check.InputSymbol;
import org.pgpainless.decryption_verification.syntax_check.PDA;
import org.pgpainless.decryption_verification.syntax_check.StackSymbol;
import org.pgpainless.exception.MalformedOpenPgpMessageException;
import org.pgpainless.exception.MessageNotIntegrityProtectedException;
import org.pgpainless.exception.MissingDecryptionMethodException;
import org.pgpainless.exception.MissingPassphraseException;
import org.pgpainless.exception.SignatureValidationException;
import org.pgpainless.exception.UnacceptableAlgorithmException;
import org.pgpainless.exception.WrongPassphraseException;
import org.pgpainless.key.SubkeyIdentifier;
import org.pgpainless.key.info.KeyRingInfo;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.protection.UnlockSecretKey;
import org.pgpainless.signature.consumer.OnePassSignatureCheck;
import org.pgpainless.util.ArmoredInputStreamFactory;
import org.pgpainless.util.Passphrase;
import org.pgpainless.util.SessionKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\b\u0018\u0000 I2\u00020\u0001:\u0004IJKLB'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB-\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\r\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001cH\u0002J\b\u0010\u001e\u001a\u00020\u001cH\u0002J\u0010\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020!H\u0002J(\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0002J \u0010+\u001a\u00020\u00102\u0006\u0010#\u001a\u00020$2\u0006\u0010,\u001a\u00020-2\u0006\u0010'\u001a\u00020.H\u0002J(\u0010/\u001a\u00020\u00102\u0006\u0010#\u001a\u00020$2\u0006\u00100\u001a\u0002012\u0006\u0010%\u001a\u00020&2\u0006\u0010)\u001a\u00020*H\u0002J\u0016\u00102\u001a\b\u0012\u0004\u0012\u000204032\u0006\u0010)\u001a\u00020*H\u0002J\u0012\u00105\u001a\u0004\u0018\u0001062\u0006\u0010)\u001a\u00020*H\u0002J\u0016\u00107\u001a\b\u0012\u0004\u0012\u000206032\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u00108\u001a\u00020\u00102\u0006\u00109\u001a\u000204H\u0002J\u0010\u0010:\u001a\u00020\u00102\u0006\u0010;\u001a\u00020<H\u0002J\b\u0010=\u001a\u00020\u001cH\u0002J\b\u0010>\u001a\u00020\u0010H\u0002J\b\u0010?\u001a\u00020\u001cH\u0002J\b\u0010@\u001a\u00020\u001cH\u0002J\b\u0010A\u001a\u00020\u001cH\u0002J\b\u0010B\u001a\u00020CH\u0016J \u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020C2\u0006\u0010G\u001a\u00020CH\u0016J\u0010\u0010H\u001a\u00020\u001c2\u0006\u0010;\u001a\u00020<H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006M"}, d2={"Lorg/pgpainless/decryption_verification/OpenPgpMessageInputStream;", "Lorg/pgpainless/decryption_verification/DecryptionStream;", "inputStream", "Ljava/io/InputStream;", "options", "Lorg/pgpainless/decryption_verification/ConsumerOptions;", "metadata", "Lorg/pgpainless/decryption_verification/MessageMetadata$Layer;", "api", "Lorg/pgpainless/PGPainless;", "(Ljava/io/InputStream;Lorg/pgpainless/decryption_verification/ConsumerOptions;Lorg/pgpainless/decryption_verification/MessageMetadata$Layer;Lorg/pgpainless/PGPainless;)V", "type", "Lorg/pgpainless/decryption_verification/OpenPgpMessageInputStream$Type;", "layerMetadata", "(Lorg/pgpainless/decryption_verification/OpenPgpMessageInputStream$Type;Ljava/io/InputStream;Lorg/pgpainless/decryption_verification/ConsumerOptions;Lorg/pgpainless/decryption_verification/MessageMetadata$Layer;Lorg/pgpainless/PGPainless;)V", "closed", "", "Lorg/pgpainless/decryption_verification/MessageMetadata;", "getMetadata", "()Lorg/pgpainless/decryption_verification/MessageMetadata;", "nestedInputStream", "packetInputStream", "Lorg/pgpainless/decryption_verification/TeeBCPGInputStream;", "signatures", "Lorg/pgpainless/decryption_verification/OpenPgpMessageInputStream$Signatures;", "syntaxVerifier", "Lorg/pgpainless/decryption_verification/syntax_check/PDA;", "close", "", "collectMetadata", "consumePackets", "decompress", "compressedData", "Lorg/bouncycastle/openpgp/PGPCompressedData;", "decryptPKESKAndStream", "esks", "Lorg/pgpainless/decryption_verification/OpenPgpMessageInputStream$ESKsAndData;", "decryptionKeyId", "Lorg/pgpainless/key/SubkeyIdentifier;", "decryptorFactory", "Lorg/bouncycastle/openpgp/operator/PublicKeyDataDecryptorFactory;", "pkesk", "Lorg/bouncycastle/openpgp/PGPPublicKeyEncryptedData;", "decryptSKESKAndStream", "skesk", "Lorg/bouncycastle/openpgp/PGPPBEEncryptedData;", "Lorg/bouncycastle/openpgp/operator/PBEDataDecryptorFactory;", "decryptWithPrivateKey", "privateKey", "Lorg/bouncycastle/openpgp/PGPKeyPair;", "findPotentialDecryptionKeys", "", "Lorg/bouncycastle/openpgp/api/OpenPGPKey$OpenPGPSecretKey;", "getDecryptionKey", "Lorg/bouncycastle/openpgp/api/OpenPGPKey;", "getDecryptionKeys", "hasUnsupportedS2KSpecifier", "secretKey", "isAcceptable", "algorithm", "Lorg/pgpainless/algorithm/SymmetricKeyAlgorithm;", "processCompressedData", "processEncryptedData", "processLiteralData", "processOnePassSignature", "processSignature", "read", "", "b", "", "off", "len", "throwIfUnacceptable", "Companion", "ESKsAndData", "Signatures", "Type", "pgpainless-core"})
@SourceDebugExtension(value={"SMAP\nOpenPgpMessageInputStream.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenPgpMessageInputStream.kt\norg/pgpainless/decryption_verification/OpenPgpMessageInputStream\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1147:1\n766#2:1148\n857#2,2:1149\n1855#2,2:1151\n1855#2,2:1153\n1549#2:1155\n1620#2,3:1156\n1549#2:1160\n1620#2,3:1161\n1549#2:1164\n1620#2,3:1165\n288#2:1168\n1747#2,3:1169\n289#2:1172\n766#2:1173\n857#2:1174\n1747#2,3:1175\n858#2:1178\n1855#2,2:1179\n1#3:1159\n*S KotlinDebug\n*F\n+ 1 OpenPgpMessageInputStream.kt\norg/pgpainless/decryption_verification/OpenPgpMessageInputStream\n*L\n364#1:1148\n364#1:1149,2\n368#1:1151,2\n426#1:1153,2\n496#1:1155\n496#1:1156,3\n564#1:1160\n564#1:1161,3\n593#1:1164\n593#1:1165,3\n709#1:1168\n711#1:1169,3\n709#1:1172\n717#1:1173\n717#1:1174\n719#1:1175,3\n717#1:1178\n729#1:1179,2\n*E\n"})
public final class OpenPgpMessageInputStream
extends DecryptionStream {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConsumerOptions options;
    @NotNull
    private final MessageMetadata.Layer layerMetadata;
    @NotNull
    private final PGPainless api;
    @NotNull
    private final Signatures signatures;
    @Nullable
    private TeeBCPGInputStream packetInputStream;
    @Nullable
    private InputStream nestedInputStream;
    @NotNull
    private final PDA syntaxVerifier;
    private boolean closed;
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenPgpMessageInputStream.class);

    public OpenPgpMessageInputStream(@NotNull Type type, @NotNull InputStream inputStream, @NotNull ConsumerOptions options, @NotNull MessageMetadata.Layer layerMetadata, @NotNull PGPainless api) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)layerMetadata, (String)"layerMetadata");
        Intrinsics.checkNotNullParameter((Object)api, (String)"api");
        this.options = options;
        this.layerMetadata = layerMetadata;
        this.api = api;
        this.signatures = new Signatures(this.options, this.api);
        this.syntaxVerifier = new PDA();
        if (this.layerMetadata instanceof MessageMetadata.Message) {
            this.signatures.addDetachedSignatures((Collection<? extends PGPSignature>)this.options.getDetachedSignatures());
        }
        switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                BCPGInputStream bCPGInputStream = BCPGInputStream.wrap((InputStream)inputStream);
                Intrinsics.checkNotNullExpressionValue((Object)bCPGInputStream, (String)"wrap(...)");
                this.packetInputStream = new TeeBCPGInputStream(bCPGInputStream, this.signatures);
                this.consumePackets();
                break;
            }
            case 2: {
                MultiPassStrategy multiPassStrategy = this.options.getMultiPassStrategy();
                PGPSignatureList detachedSignatures = ClearsignedMessageUtil.Companion.detachSignaturesFromInbandClearsignedMessage(inputStream, multiPassStrategy.getMessageOutputStream());
                for (PGPSignature signature : detachedSignatures) {
                    Intrinsics.checkNotNull((Object)signature);
                    this.signatures.addDetachedSignature(signature);
                }
                this.options.isForceNonOpenPgpData();
                this.nestedInputStream = (InputStream)new TeeInputStream(multiPassStrategy.getMessageInputStream(), (OutputStream)this.signatures);
                break;
            }
            case 3: {
                this.packetInputStream = null;
                this.nestedInputStream = (InputStream)new TeeInputStream(inputStream, (OutputStream)this.signatures);
            }
        }
    }

    public OpenPgpMessageInputStream(@NotNull InputStream inputStream, @NotNull ConsumerOptions options, @NotNull MessageMetadata.Layer metadata, @NotNull PGPainless api) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        Intrinsics.checkNotNullParameter((Object)api, (String)"api");
        this(Type.standard, inputStream, options, metadata, api);
    }

    private final void consumePackets() {
        TeeBCPGInputStream teeBCPGInputStream = this.packetInputStream;
        if (teeBCPGInputStream == null) {
            return;
        }
        TeeBCPGInputStream pIn = teeBCPGInputStream;
        OpenPgpPacket packet = null;
        block11: while (true) {
            OpenPgpMessageInputStream $this$consumePackets_u24lambda_u240 = this;
            boolean bl = false;
            packet = pIn.nextPacketTag();
            if (packet == null) break;
            OpenPgpPacket openPgpPacket = packet;
            Intrinsics.checkNotNull((Object)((Object)openPgpPacket));
            this.signatures.nextPacket(openPgpPacket);
            OpenPgpPacket openPgpPacket2 = packet;
            switch (WhenMappings.$EnumSwitchMapping$1[openPgpPacket2.ordinal()]) {
                case 1: {
                    this.processLiteralData();
                    break block11;
                }
                case 2: {
                    this.processCompressedData();
                    break block11;
                }
                case 3: {
                    this.processOnePassSignature();
                    continue block11;
                }
                case 4: {
                    this.processSignature();
                    continue block11;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    if (this.processEncryptedData()) break block11;
                    throw new MissingDecryptionMethodException("No working decryption method found.");
                }
                case 10: {
                    LOGGER.debug("Skipping Marker Packet");
                    pIn.readMarker();
                    continue block11;
                }
                case 11: {
                    LOGGER.debug("Skipping Padding Packet");
                    pIn.readPadding();
                    continue block11;
                }
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: {
                    throw new MalformedOpenPgpMessageException("Illegal Packet in Stream: " + (Object)((Object)packet));
                }
                case 19: 
                case 20: 
                case 21: 
                case 22: {
                    throw new MalformedOpenPgpMessageException("Unsupported Packet in Stream: " + (Object)((Object)packet));
                }
                default: {
                    throw new MalformedOpenPgpMessageException("Unexpected Packet in Stream: " + (Object)((Object)packet));
                }
            }
            break;
        }
    }

    private final void processLiteralData() {
        LOGGER.debug("Literal Data Packet at depth " + this.layerMetadata.getDepth() + " encountered.");
        this.syntaxVerifier.next(InputSymbol.LITERAL_DATA);
        TeeBCPGInputStream teeBCPGInputStream = this.packetInputStream;
        Intrinsics.checkNotNull((Object)teeBCPGInputStream);
        PGPLiteralData literalData = teeBCPGInputStream.readLiteralData();
        String string = literalData.getFileName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFileName(...)");
        Date date = literalData.getModificationTime();
        Intrinsics.checkNotNullExpressionValue((Object)date, (String)"getModificationTime(...)");
        this.layerMetadata.setChild(new MessageMetadata.LiteralData(string, date, StreamEncoding.Companion.requireFromCode(literalData.getFormat())));
        this.nestedInputStream = literalData.getInputStream();
    }

    private final void processCompressedData() {
        this.syntaxVerifier.next(InputSymbol.COMPRESSED_DATA);
        this.signatures.enterNesting();
        TeeBCPGInputStream teeBCPGInputStream = this.packetInputStream;
        Intrinsics.checkNotNull((Object)teeBCPGInputStream);
        PGPCompressedData compressedData = teeBCPGInputStream.readCompressedData();
        MessageMetadata.CompressedData compressionLayer = new MessageMetadata.CompressedData(CompressionAlgorithm.Companion.requireFromId(compressedData.getAlgorithm()), this.layerMetadata.getDepth() + 1);
        LOGGER.debug("Compressed Data Packet (" + compressionLayer.getAlgorithm() + ") at depth " + this.layerMetadata.getDepth() + " encountered.");
        this.nestedInputStream = new OpenPgpMessageInputStream(this.decompress(compressedData), this.options, compressionLayer, this.api);
    }

    private final InputStream decompress(PGPCompressedData compressedData) {
        InputStream inputStream;
        switch (compressedData.getAlgorithm()) {
            case 1: {
                InputStream inputStream2 = compressedData.getInputStream();
                Inflater inflater = new Inflater(true);
                inputStream = new InflaterInputStream(inputStream2, inflater){
                    private boolean eof;

                    protected void fill() {
                        if (this.eof) {
                            throw new EOFException("Unexpected end of ZIP input stream");
                        }
                        this.len = this.in.read(this.buf, 0, this.buf.length);
                        if (this.len == -1) {
                            this.buf[0] = 0;
                            this.len = 0;
                            this.eof = true;
                        }
                        this.inf.setInput(this.buf, 0, this.len);
                    }
                };
                break;
            }
            case 2: {
                InputStream inputStream3 = compressedData.getInputStream();
                inputStream = new InflaterInputStream(inputStream3){
                    private boolean eof;

                    protected void fill() {
                        if (this.eof) {
                            throw new EOFException("Unexpected end of ZIP input stream");
                        }
                        this.len = this.in.read(this.buf, 0, this.buf.length);
                        if (this.len == -1) {
                            this.buf[0] = 0;
                            this.len = 0;
                            this.eof = true;
                        }
                        this.inf.setInput(this.buf, 0, this.len);
                    }
                };
                break;
            }
            default: {
                InputStream inputStream4 = compressedData.getDataStream();
                inputStream = inputStream4;
                Intrinsics.checkNotNullExpressionValue((Object)inputStream4, (String)"getDataStream(...)");
            }
        }
        return inputStream;
    }

    private final void processOnePassSignature() {
        PGPOnePassSignature pGPOnePassSignature;
        this.syntaxVerifier.next(InputSymbol.ONE_PASS_SIGNATURE);
        try {
            TeeBCPGInputStream teeBCPGInputStream = this.packetInputStream;
            Intrinsics.checkNotNull((Object)teeBCPGInputStream);
            pGPOnePassSignature = teeBCPGInputStream.readOnePassSignature();
        }
        catch (UnsupportedPacketVersionException e) {
            LOGGER.debug("Unsupported One-Pass-Signature packet version encountered.", (Throwable)e);
            return;
        }
        PGPOnePassSignature ops = pGPOnePassSignature;
        this.signatures.addOnePassSignature(ops);
    }

    private final void processSignature() {
        PGPSignature pGPSignature;
        boolean isSigForOps = this.syntaxVerifier.peekStack() == StackSymbol.OPS;
        this.syntaxVerifier.next(InputSymbol.SIGNATURE);
        try {
            TeeBCPGInputStream teeBCPGInputStream = this.packetInputStream;
            Intrinsics.checkNotNull((Object)teeBCPGInputStream);
            pGPSignature = teeBCPGInputStream.readSignature();
        }
        catch (UnsupportedPacketVersionException e) {
            LOGGER.debug("Unsupported Signature at depth " + this.layerMetadata.getDepth() + " encountered.", (Throwable)e);
            return;
        }
        PGPSignature signature = pGPSignature;
        long keyId = PGPSignatureExtensionsKt.getIssuerKeyId(signature);
        if (isSigForOps) {
            LOGGER.debug("Signature Packet corresponding to One-Pass-Signature by key " + LongExtensionsKt.openPgpKeyId(keyId) + " at depth " + this.layerMetadata.getDepth() + " encountered.");
            this.signatures.leaveNesting();
            this.signatures.addCorrespondingOnePassSignature(signature, this.layerMetadata);
        } else {
            LOGGER.debug("Prepended Signature Packet by key " + LongExtensionsKt.openPgpKeyId(keyId) + " at depth " + this.layerMetadata.getDepth() + " encountered.");
            this.signatures.addPrependedSignature(signature);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean processEncryptedData() {
        this.syntaxVerifier.next(InputSymbol.ENCRYPTED_DATA);
        TeeBCPGInputStream teeBCPGInputStream = this.packetInputStream;
        Intrinsics.checkNotNull((Object)teeBCPGInputStream);
        PGPEncryptedDataList encDataList = teeBCPGInputStream.readEncryptedDataList();
        ESKsAndData esks = new ESKsAndData(encDataList);
        EncryptedDataPacketType encryptedDataPacketType = EncryptedDataPacketType.of((PGPEncryptedDataList)encDataList);
        Intrinsics.checkNotNull((Object)encryptedDataPacketType);
        switch (WhenMappings.$EnumSwitchMapping$2[encryptedDataPacketType.ordinal()]) {
            case 1: {
                LOGGER.debug("Symmetrically Encrypted Integrity Protected Data Packet version 2 at depth " + this.layerMetadata.getDepth() + " encountered.");
                break;
            }
            case 2: {
                LOGGER.debug("Symmetrically Encrypted Integrity Protected Data Packet version 1 at depth " + this.layerMetadata.getDepth() + " encountered.");
                break;
            }
            case 3: {
                LOGGER.debug("LibrePGP OCB-Encrypted Data Packet at depth " + this.layerMetadata.getDepth() + " encountered.");
                break;
            }
            case 4: {
                LOGGER.debug("(Deprecated) Symmetrically Encrypted Data Packet at depth " + this.layerMetadata.getDepth() + " encountered.");
                LOGGER.warn("Symmetrically Encrypted Data Packet is not integrity-protected.");
                if (this.options.isIgnoreMDCErrors()) break;
                throw new MessageNotIntegrityProtectedException();
            }
        }
        LOGGER.debug("Encrypted Data has " + esks.getSkesks().size() + " SKESK(s) and " + (esks.getPkesks().size() + esks.getAnonPkesks().size()) + " PKESK(s) from which " + esks.getAnonPkesks().size() + " PKESK(s) have an anonymous recipient.");
        for (Map.Entry<SubkeyIdentifier, PublicKeyDataDecryptorFactory> object : this.options.getCustomDecryptorFactories().entrySet()) {
            void $this$forEach$iv;
            Iterator $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            SubkeyIdentifier key = object.getKey();
            PublicKeyDataDecryptorFactory publicKeyDataDecryptorFactory = object.getValue();
            LOGGER.debug("Attempt decryption with custom decryptor factory with key " + key + ".");
            Iterable iterable = esks.getPkesks();
            boolean $i$f$filter = false;
            void var9_42 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv$iv = iterator.next();
                PGPPublicKeyEncryptedData it = (PGPPublicKeyEncryptedData)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getKeyIdentifier(), (Object)key.getKeyIdentifier())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            $this$filterTo$iv$iv = $this$forEach$iv.iterator();
            while ($this$filterTo$iv$iv.hasNext()) {
                Object element$iv = $this$filterTo$iv$iv.next();
                PGPPublicKeyEncryptedData it = (PGPPublicKeyEncryptedData)element$iv;
                boolean bl = false;
                if (!this.decryptPKESKAndStream(esks, key, publicKeyDataDecryptorFactory, it)) continue;
                return true;
            }
        }
        if (this.options.getSessionKey() != null) {
            SessionKey sessionKey = this.options.getSessionKey();
            Intrinsics.checkNotNull((Object)sessionKey);
            SessionKey sk = sessionKey;
            LOGGER.debug("Attempt decryption with provided session key.");
            this.throwIfUnacceptable(sk.getAlgorithm());
            PGPSessionKey pGPSessionKey = new PGPSessionKey(sk.getAlgorithm().getAlgorithmId(), sk.getKey());
            SessionKeyDataDecryptorFactory decryptorFactory = this.api.getImplementation().sessionKeyDataDecryptorFactory(pGPSessionKey);
            MessageMetadata.EncryptedData encryptedData = esks.toEncryptedData(sk, this.layerMetadata.getDepth() + 1);
            PGPSessionKeyEncryptedData skEncData = encDataList.extractSessionKeyEncryptedData();
            try {
                InputStream decrypted = skEncData.getDataStream(decryptorFactory);
                encryptedData.setSessionKey(sk);
                Intrinsics.checkNotNull((Object)decrypted);
                Intrinsics.checkNotNull((Object)skEncData);
                IntegrityProtectedInputStream integrityProtected = new IntegrityProtectedInputStream(decrypted, (PGPEncryptedData)skEncData, this.options);
                this.nestedInputStream = new OpenPgpMessageInputStream(integrityProtected, this.options, encryptedData, this.api);
                LOGGER.debug("Successfully decrypted data using provided session key");
                return true;
            }
            catch (PGPException e) {
                LOGGER.debug("Decryption using provided session key failed. Mismatched session key and message?", (Throwable)e);
            }
        }
        for (Passphrase passphrase : this.options.getDecryptionPassphrases()) {
            for (PGPPBEEncryptedData pGPPBEEncryptedData : esks.getSkesks()) {
                LOGGER.debug("Attempt decryption with provided passphrase");
                SymmetricKeyAlgorithm algorithm = SymmetricKeyAlgorithm.Companion.requireFromId(pGPPBEEncryptedData.getAlgorithm());
                if (!this.isAcceptable(algorithm)) {
                    LOGGER.debug("Skipping SKESK with unacceptable encapsulation algorithm " + algorithm);
                    continue;
                }
                PBEDataDecryptorFactory decryptorFactory = this.api.getImplementation().pbeDataDecryptorFactory(passphrase.getChars());
                Intrinsics.checkNotNull((Object)decryptorFactory);
                if (!this.decryptSKESKAndStream(esks, pGPPBEEncryptedData, decryptorFactory)) continue;
                return true;
            }
        }
        List postponedDueToMissingPassphrase = new ArrayList();
        Iterable iterable = esks.getPkesks();
        boolean $i$f$forEach = false;
        for (Object element$iv : iterable) {
            PGPPublicKeyEncryptedData pkesk = (PGPPublicKeyEncryptedData)element$iv;
            boolean bl = false;
            LOGGER.debug("Encountered PKESK for recipient " + pkesk.getKeyIdentifier());
            List<OpenPGPKey> decryptionKeyCandidates = this.getDecryptionKeys(pkesk);
            for (OpenPGPKey decryptionKeys : decryptionKeyCandidates) {
                OpenPGPKey.OpenPGPPrivateKey openPGPPrivateKey;
                SecretKeyRingProtector protector;
                OpenPGPKey.OpenPGPSecretKey secretKey;
                Intrinsics.checkNotNull((Object)OpenPGPKeyExtensionsKt.getSecretKeyFor(decryptionKeys, pkesk));
                if (!secretKey.isEncryptionKey() && !this.options.getAllowDecryptionWithNonEncryptionKey()) {
                    LOGGER.debug("Message is encrypted for " + secretKey.getKeyIdentifier() + ", but the key is not encryption capable.");
                    continue;
                }
                if (this.hasUnsupportedS2KSpecifier(secretKey)) continue;
                LOGGER.debug("Attempt decryption using secret key " + decryptionKeys.getKeyIdentifier());
                if (this.options.getSecretKeyProtector(decryptionKeys) == null) continue;
                KeyIdentifier keyIdentifier = secretKey.getKeyIdentifier();
                Intrinsics.checkNotNullExpressionValue((Object)keyIdentifier, (String)"getKeyIdentifier(...)");
                if (!protector.hasPassphraseFor(keyIdentifier)) {
                    LOGGER.debug("Missing passphrase for key " + decryptionKeys.getKeyIdentifier() + ". Postponing decryption until all other keys were tried.");
                    postponedDueToMissingPassphrase.add(TuplesKt.to((Object)secretKey, (Object)pkesk));
                    continue;
                }
                try {
                    openPGPPrivateKey = UnlockSecretKey.Companion.unlockSecretKey$default(UnlockSecretKey.Companion, secretKey, protector, null, 4, null);
                }
                catch (PGPException e) {
                    KeyIdentifier keyIdentifier2 = secretKey.getKeyIdentifier();
                    Intrinsics.checkNotNullExpressionValue((Object)keyIdentifier2, (String)"getKeyIdentifier(...)");
                    throw new WrongPassphraseException(keyIdentifier2, e);
                }
                OpenPGPKey.OpenPGPPrivateKey privateKey = openPGPPrivateKey;
                PGPKeyPair pGPKeyPair = privateKey.getKeyPair();
                Intrinsics.checkNotNullExpressionValue((Object)pGPKeyPair, (String)"getKeyPair(...)");
                PGPSecretKeyRing pGPSecretKeyRing = secretKey.getOpenPGPKey().getPGPSecretKeyRing();
                Intrinsics.checkNotNullExpressionValue((Object)pGPSecretKeyRing, (String)"getPGPSecretKeyRing(...)");
                PGPKeyRing pGPKeyRing = (PGPKeyRing)pGPSecretKeyRing;
                KeyIdentifier keyIdentifier3 = secretKey.getKeyIdentifier();
                Intrinsics.checkNotNullExpressionValue((Object)keyIdentifier3, (String)"getKeyIdentifier(...)");
                if (!this.decryptWithPrivateKey(esks, pGPKeyPair, new SubkeyIdentifier(pGPKeyRing, keyIdentifier3), pkesk)) continue;
                return true;
            }
        }
        for (PGPPublicKeyEncryptedData pkesk : esks.getAnonPkesks()) {
            for (OpenPGPKey.OpenPGPSecretKey decryptionKey2 : this.findPotentialDecryptionKeys(pkesk)) {
                SecretKeyRingProtector protector;
                if (this.hasUnsupportedS2KSpecifier(decryptionKey2)) continue;
                LOGGER.debug("Attempt decryption of anonymous PKESK with key " + decryptionKey2 + ".");
                OpenPGPKey openPGPKey = decryptionKey2.getOpenPGPKey();
                Intrinsics.checkNotNullExpressionValue((Object)openPGPKey, (String)"getOpenPGPKey(...)");
                if (this.options.getSecretKeyProtector(openPGPKey) == null) continue;
                KeyIdentifier keyIdentifier = decryptionKey2.getKeyIdentifier();
                Intrinsics.checkNotNullExpressionValue((Object)keyIdentifier, (String)"getKeyIdentifier(...)");
                if (!protector.hasPassphraseFor(keyIdentifier)) {
                    LOGGER.debug("Missing passphrase for key " + decryptionKey2.getKeyIdentifier() + ". Postponing decryption until all other keys were tried.");
                    postponedDueToMissingPassphrase.add(TuplesKt.to((Object)decryptionKey2, (Object)pkesk));
                    continue;
                }
                OpenPGPKey.OpenPGPPrivateKey privateKey = decryptionKey2.unlock((KeyPassphraseProvider)protector);
                PGPKeyPair pGPKeyPair = privateKey.getKeyPair();
                Intrinsics.checkNotNullExpressionValue((Object)pGPKeyPair, (String)"getKeyPair(...)");
                if (!this.decryptWithPrivateKey(esks, pGPKeyPair, new SubkeyIdentifier((OpenPGPCertificate.OpenPGPComponentKey)decryptionKey2), pkesk)) continue;
                return true;
            }
        }
        if (this.options.getMissingKeyPassphraseStrategy() == MissingKeyPassphraseStrategy.THROW_EXCEPTION) {
            List list;
            Iterable iterable2 = postponedDueToMissingPassphrase;
            boolean $i$f$map = false;
            Iterable iterable3 = iterable2;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable2, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : iterable3) {
                Pair it = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new SubkeyIdentifier((OpenPGPCertificate.OpenPGPComponentKey)it.getFirst()));
            }
            List it = list = (List)destination$iv$iv;
            boolean bl = false;
            if (!((Collection)it).isEmpty()) {
                throw new MissingPassphraseException(CollectionsKt.toSet((Iterable)it));
            }
        } else if (this.options.getMissingKeyPassphraseStrategy() == MissingKeyPassphraseStrategy.INTERACTIVE) {
            for (Pair pair : postponedDueToMissingPassphrase) {
                OpenPGPKey.OpenPGPPrivateKey openPGPPrivateKey;
                OpenPGPKey decryptionKeys;
                OpenPGPKey.OpenPGPSecretKey openPGPSecretKey = (OpenPGPKey.OpenPGPSecretKey)pair.component1();
                PGPPublicKeyEncryptedData pkesk = (PGPPublicKeyEncryptedData)pair.component2();
                KeyIdentifier keyId = openPGPSecretKey.getKeyIdentifier();
                Intrinsics.checkNotNull((Object)this.getDecryptionKey(pkesk));
                PGPSecretKeyRing pGPSecretKeyRing = decryptionKeys.getPGPSecretKeyRing();
                Intrinsics.checkNotNullExpressionValue((Object)pGPSecretKeyRing, (String)"getPGPSecretKeyRing(...)");
                PGPKeyRing pGPKeyRing = (PGPKeyRing)pGPSecretKeyRing;
                Intrinsics.checkNotNull((Object)keyId);
                SubkeyIdentifier decryptionKeyId = new SubkeyIdentifier(pGPKeyRing, keyId);
                if (this.hasUnsupportedS2KSpecifier(openPGPSecretKey)) continue;
                LOGGER.debug("Attempt decryption with key " + decryptionKeyId + " while interactively requesting its passphrase.");
                if (this.options.getSecretKeyProtector(decryptionKeys) == null) continue;
                try {
                    SecretKeyRingProtector protector;
                    openPGPPrivateKey = UnlockSecretKey.Companion.unlockSecretKey$default(UnlockSecretKey.Companion, openPGPSecretKey, protector, null, 4, null);
                }
                catch (PGPException e) {
                    KeyIdentifier keyIdentifier = openPGPSecretKey.getKeyIdentifier();
                    Intrinsics.checkNotNullExpressionValue((Object)keyIdentifier, (String)"getKeyIdentifier(...)");
                    throw new WrongPassphraseException(keyIdentifier, e);
                }
                OpenPGPKey.OpenPGPPrivateKey privateKey = openPGPPrivateKey;
                PGPKeyPair pGPKeyPair = privateKey.getKeyPair();
                Intrinsics.checkNotNullExpressionValue((Object)pGPKeyPair, (String)"getKeyPair(...)");
                if (!this.decryptWithPrivateKey(esks, pGPKeyPair, decryptionKeyId, pkesk)) continue;
                return true;
            }
        } else {
            throw new IllegalStateException("Invalid PostponedKeysStrategy set in consumer options.");
        }
        LOGGER.debug("Failed to decrypt encrypted data packet.");
        return false;
    }

    private final boolean decryptWithPrivateKey(ESKsAndData esks, PGPKeyPair privateKey, SubkeyIdentifier decryptionKeyId, PGPPublicKeyEncryptedData pkesk) {
        PublicKeyDataDecryptorFactory decryptorFactory = this.api.getImplementation().publicKeyDataDecryptorFactory(privateKey.getPrivateKey());
        Intrinsics.checkNotNull((Object)decryptorFactory);
        return this.decryptPKESKAndStream(esks, decryptionKeyId, decryptorFactory, pkesk);
    }

    private final boolean hasUnsupportedS2KSpecifier(OpenPGPKey.OpenPGPSecretKey secretKey) {
        S2K s2k = secretKey.getPGPSecretKey().getS2K();
        if (s2k != null) {
            int n = s2k.getType();
            boolean bl = 100 <= n ? n < 111 : false;
            if (bl) {
                LOGGER.debug("Skipping PKESK because key " + secretKey.getKeyIdentifier() + " has unsupported private S2K specifier " + s2k.getType());
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean decryptSKESKAndStream(ESKsAndData esks, PGPPBEEncryptedData skesk, PBEDataDecryptorFactory decryptorFactory) {
        try {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            InputStream decrypted = skesk.getDataStream(decryptorFactory);
            PGPSessionKey pGPSessionKey = skesk.getSessionKey(decryptorFactory);
            Intrinsics.checkNotNullExpressionValue((Object)pGPSessionKey, (String)"getSessionKey(...)");
            SessionKey sessionKey = new SessionKey(pGPSessionKey);
            this.throwIfUnacceptable(sessionKey.getAlgorithm());
            MessageMetadata.EncryptedData encryptedData = esks.toEncryptedData(sessionKey, this.layerMetadata.getDepth() + 1);
            encryptedData.setSessionKey(sessionKey);
            Iterable iterable = esks.getPkesks();
            MessageMetadata.EncryptedData encryptedData2 = encryptedData;
            boolean $i$f$map = false;
            void var9_12 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                PGPPublicKeyEncryptedData pGPPublicKeyEncryptedData = (PGPPublicKeyEncryptedData)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getKeyIdentifier());
            }
            encryptedData2.addRecipients((List)destination$iv$iv);
            LOGGER.debug("Successfully decrypted data with passphrase");
            Intrinsics.checkNotNull((Object)decrypted);
            IntegrityProtectedInputStream integrityProtected = new IntegrityProtectedInputStream(decrypted, (PGPEncryptedData)skesk, this.options);
            this.nestedInputStream = new OpenPgpMessageInputStream(integrityProtected, this.options, encryptedData, this.api);
            return true;
        }
        catch (UnacceptableAlgorithmException e) {
            throw e;
        }
        catch (PGPException e) {
            LOGGER.debug("Decryption of encrypted data packet using password failed. Password mismatch?", (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean decryptPKESKAndStream(ESKsAndData esks, SubkeyIdentifier decryptionKeyId, PublicKeyDataDecryptorFactory decryptorFactory, PGPPublicKeyEncryptedData pkesk) {
        try {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            InputStream decrypted = pkesk.getDataStream(decryptorFactory);
            PGPSessionKey pGPSessionKey = pkesk.getSessionKey(decryptorFactory);
            Intrinsics.checkNotNullExpressionValue((Object)pGPSessionKey, (String)"getSessionKey(...)");
            SessionKey sessionKey = new SessionKey(pGPSessionKey);
            this.throwIfUnacceptable(sessionKey.getAlgorithm());
            MessageMetadata.EncryptedData encryptedData = esks.toEncryptedData(sessionKey, this.layerMetadata.getDepth());
            encryptedData.setDecryptionKey(decryptionKeyId);
            encryptedData.setSessionKey(sessionKey);
            Iterable iterable = CollectionsKt.plus((Collection)esks.getPkesks(), (Iterable)esks.getAnonPkesks());
            MessageMetadata.EncryptedData encryptedData2 = encryptedData;
            boolean $i$f$map = false;
            void var10_13 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                PGPPublicKeyEncryptedData pGPPublicKeyEncryptedData = (PGPPublicKeyEncryptedData)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getKeyIdentifier());
            }
            encryptedData2.addRecipients((List)destination$iv$iv);
            LOGGER.debug("Successfully decrypted data with key " + decryptionKeyId);
            Intrinsics.checkNotNull((Object)decrypted);
            IntegrityProtectedInputStream integrityProtected = new IntegrityProtectedInputStream(decrypted, (PGPEncryptedData)pkesk, this.options);
            this.nestedInputStream = new OpenPgpMessageInputStream(integrityProtected, this.options, encryptedData, this.api);
            return true;
        }
        catch (UnacceptableAlgorithmException e) {
            throw e;
        }
        catch (PGPException e) {
            LOGGER.debug("Decryption of encrypted data packet using secret key failed.", (Throwable)e);
            return false;
        }
    }

    @Override
    public int read() {
        int n;
        if (this.nestedInputStream == null) {
            if (this.packetInputStream != null) {
                this.syntaxVerifier.next(InputSymbol.END_OF_SEQUENCE);
                this.syntaxVerifier.assertValid();
            }
            return -1;
        }
        try {
            InputStream inputStream = this.nestedInputStream;
            Intrinsics.checkNotNull((Object)inputStream);
            n = inputStream.read();
        }
        catch (IOException e) {
            n = -1;
        }
        int r = n;
        if (r != -1) {
            this.signatures.updateLiteral((byte)r);
        } else {
            InputStream inputStream = this.nestedInputStream;
            Intrinsics.checkNotNull((Object)inputStream);
            inputStream.close();
            this.collectMetadata();
            this.nestedInputStream = null;
            if (this.packetInputStream != null) {
                try {
                    this.consumePackets();
                }
                catch (PGPException e) {
                    throw new RuntimeException(e);
                }
            }
            this.signatures.finish(this.layerMetadata);
        }
        return r;
    }

    @Override
    public int read(@NotNull byte[] b, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        if (this.nestedInputStream == null) {
            if (this.packetInputStream != null) {
                this.syntaxVerifier.next(InputSymbol.END_OF_SEQUENCE);
                this.syntaxVerifier.assertValid();
            }
            return -1;
        }
        InputStream inputStream = this.nestedInputStream;
        Intrinsics.checkNotNull((Object)inputStream);
        int r = inputStream.read(b, off, len);
        if (r != -1) {
            this.signatures.updateLiteral(b, off, r);
        } else {
            InputStream inputStream2 = this.nestedInputStream;
            Intrinsics.checkNotNull((Object)inputStream2);
            inputStream2.close();
            this.collectMetadata();
            this.nestedInputStream = null;
            if (this.packetInputStream != null) {
                try {
                    this.consumePackets();
                }
                catch (PGPException e) {
                    throw new RuntimeException(e);
                }
            }
            this.signatures.finish(this.layerMetadata);
        }
        return r;
    }

    @Override
    public void close() {
        super.close();
        if (this.closed) {
            if (this.packetInputStream != null) {
                this.syntaxVerifier.next(InputSymbol.END_OF_SEQUENCE);
                this.syntaxVerifier.assertValid();
            }
            return;
        }
        if (this.nestedInputStream != null) {
            InputStream inputStream = this.nestedInputStream;
            Intrinsics.checkNotNull((Object)inputStream);
            inputStream.close();
            this.collectMetadata();
            this.nestedInputStream = null;
        }
        try {
            this.consumePackets();
        }
        catch (PGPException e) {
            throw new RuntimeException(e);
        }
        if (this.packetInputStream != null) {
            this.syntaxVerifier.next(InputSymbol.END_OF_SEQUENCE);
            this.syntaxVerifier.assertValid();
            TeeBCPGInputStream teeBCPGInputStream = this.packetInputStream;
            Intrinsics.checkNotNull((Object)teeBCPGInputStream);
            teeBCPGInputStream.close();
        }
        this.closed = true;
    }

    private final void collectMetadata() {
        if (this.nestedInputStream instanceof OpenPgpMessageInputStream) {
            InputStream inputStream = this.nestedInputStream;
            Intrinsics.checkNotNull((Object)inputStream, (String)"null cannot be cast to non-null type org.pgpainless.decryption_verification.OpenPgpMessageInputStream");
            OpenPgpMessageInputStream child = (OpenPgpMessageInputStream)inputStream;
            MessageMetadata.Layer layer = child.layerMetadata;
            Intrinsics.checkNotNull((Object)layer, (String)"null cannot be cast to non-null type org.pgpainless.decryption_verification.MessageMetadata.Nested");
            this.layerMetadata.setChild((MessageMetadata.Nested)((Object)layer));
        }
    }

    @Override
    @NotNull
    public MessageMetadata getMetadata() {
        if (!this.closed) {
            boolean bl = false;
            String string = "Stream must be closed before access to metadata can be granted.";
            throw new IllegalStateException(string.toString());
        }
        MessageMetadata.Layer layer = this.layerMetadata;
        Intrinsics.checkNotNull((Object)layer, (String)"null cannot be cast to non-null type org.pgpainless.decryption_verification.MessageMetadata.Message");
        return new MessageMetadata((MessageMetadata.Message)layer);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final OpenPGPKey getDecryptionKey(PGPPublicKeyEncryptedData pkesk) {
        Object element$iv;
        Object v0;
        boolean bl;
        Iterable $this$firstOrNull$iv = this.options.getDecryptionKeys();
        boolean $i$f$firstOrNull = false;
        Iterator iterator = $this$firstOrNull$iv.iterator();
        do {
            if (!iterator.hasNext()) {
                v0 = null;
                return v0;
            }
            element$iv = iterator.next();
            OpenPGPKey it = (OpenPGPKey)element$iv;
            boolean bl2 = false;
            PGPSecretKeyRing pGPSecretKeyRing = it.getPGPSecretKeyRing();
            Intrinsics.checkNotNullExpressionValue((Object)pGPSecretKeyRing, (String)"getPGPSecretKeyRing(...)");
            if (PGPSecretKeyRingExtensionsKt.getSecretKeyFor(pGPSecretKeyRing, pkesk) != null) {
                boolean bl3;
                block7: {
                    Iterable $this$any$iv = PGPainless.inspect$default(this.api, (OpenPGPCertificate)it, null, 2, null).getDecryptionSubkeys();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl3 = false;
                    } else {
                        for (Object element$iv2 : $this$any$iv) {
                            OpenPGPCertificate.OpenPGPComponentKey subkey = (OpenPGPCertificate.OpenPGPComponentKey)element$iv2;
                            boolean bl4 = false;
                            if (!pkesk.getKeyIdentifier().matchesExplicit(subkey.getKeyIdentifier())) continue;
                            bl3 = true;
                            break block7;
                        }
                        bl3 = false;
                    }
                }
                if (bl3) {
                    bl = true;
                    continue;
                }
            }
            bl = false;
        } while (!bl);
        v0 = element$iv;
        return v0;
    }

    /*
     * Unable to fully structure code
     */
    private final List<OpenPGPKey> getDecryptionKeys(PGPPublicKeyEncryptedData pkesk) {
        $this$filter$iv = this.options.getDecryptionKeys();
        $i$f$filter = false;
        var4_4 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            block6: {
                it = (OpenPGPKey)element$iv$iv;
                $i$a$-filter-OpenPgpMessageInputStream$getDecryptionKeys$1 = false;
                v0 = it.getPGPSecretKeyRing();
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getPGPSecretKeyRing(...)");
                if (PGPSecretKeyRingExtensionsKt.getSecretKeyFor(v0, pkesk) == null) ** GOTO lbl-1000
                $this$any$iv = PGPainless.inspect$default(this.api, (OpenPGPCertificate)it, null, 2, null).getDecryptionSubkeys();
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v1 = false;
                } else {
                    for (T element$iv : $this$any$iv) {
                        subkey = (OpenPGPCertificate.OpenPGPComponentKey)element$iv;
                        $i$a$-any-OpenPgpMessageInputStream$getDecryptionKeys$1$1 = false;
                        if (!pkesk.getKeyIdentifier().matchesExplicit(subkey.getKeyIdentifier())) continue;
                        v1 = true;
                        break block6;
                    }
                    v1 = false;
                }
            }
            if (v1) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = false;
            }
            if (!v2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final List<OpenPGPKey.OpenPGPSecretKey> findPotentialDecryptionKeys(PGPPublicKeyEncryptedData pkesk) {
        int algorithm = pkesk.getAlgorithm();
        List candidates = new ArrayList();
        Iterable $this$forEach$iv = this.options.getDecryptionKeys();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OpenPGPKey it = (OpenPGPKey)element$iv;
            boolean bl = false;
            KeyRingInfo info = PGPainless.inspect$default(this.api, (OpenPGPCertificate)it, null, 2, null);
            for (OpenPGPCertificate.OpenPGPComponentKey key : info.getDecryptionSubkeys()) {
                if (key.getPGPPublicKey().getAlgorithm() != algorithm) continue;
                KeyIdentifier keyIdentifier = key.getKeyIdentifier();
                Intrinsics.checkNotNullExpressionValue((Object)keyIdentifier, (String)"getKeyIdentifier(...)");
                if (!info.isSecretKeyAvailable(keyIdentifier)) continue;
                OpenPGPKey.OpenPGPSecretKey openPGPSecretKey = it.getSecretKey(key.getKeyIdentifier());
                Intrinsics.checkNotNullExpressionValue((Object)openPGPSecretKey, (String)"getSecretKey(...)");
                candidates.add(openPGPSecretKey);
            }
        }
        return candidates;
    }

    private final boolean isAcceptable(SymmetricKeyAlgorithm algorithm) {
        return this.api.getAlgorithmPolicy().getMessageDecryptionAlgorithmPolicy().getSymmetricAlgorithmPolicy().isAcceptable(algorithm);
    }

    private final void throwIfUnacceptable(SymmetricKeyAlgorithm algorithm) {
        if (!this.isAcceptable(algorithm)) {
            throw new UnacceptableAlgorithmException("Symmetric-Key algorithm " + algorithm + " is not acceptable for message decryption.");
        }
    }

    @JvmStatic
    @NotNull
    public static final OpenPgpMessageInputStream create(@NotNull InputStream inputStream, @NotNull ConsumerOptions options, @NotNull PGPainless api) {
        return Companion.create(inputStream, options, api);
    }

    @JvmStatic
    @NotNull
    public static final OpenPgpMessageInputStream create$pgpainless_core(@NotNull InputStream inputStream, @NotNull ConsumerOptions options, @NotNull MessageMetadata.Layer metadata, @NotNull PGPainless api) {
        return Companion.create$pgpainless_core(inputStream, options, metadata, api);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J-\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0001\u00a2\u0006\u0002\b\u0011R\u001e\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u00a8\u0006\u0012"}, d2={"Lorg/pgpainless/decryption_verification/OpenPgpMessageInputStream$Companion;", "", "()V", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLOGGER$annotations", "create", "Lorg/pgpainless/decryption_verification/OpenPgpMessageInputStream;", "inputStream", "Ljava/io/InputStream;", "options", "Lorg/pgpainless/decryption_verification/ConsumerOptions;", "api", "Lorg/pgpainless/PGPainless;", "metadata", "Lorg/pgpainless/decryption_verification/MessageMetadata$Layer;", "create$pgpainless_core", "pgpainless-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private static /* synthetic */ void getLOGGER$annotations() {
        }

        @JvmStatic
        @NotNull
        public final OpenPgpMessageInputStream create(@NotNull InputStream inputStream, @NotNull ConsumerOptions options, @NotNull PGPainless api) {
            Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            Intrinsics.checkNotNullParameter((Object)api, (String)"api");
            return this.create$pgpainless_core(inputStream, options, new MessageMetadata.Message(false, 1, null), api);
        }

        @JvmStatic
        @NotNull
        public final OpenPgpMessageInputStream create$pgpainless_core(@NotNull InputStream inputStream, @NotNull ConsumerOptions options, @NotNull MessageMetadata.Layer metadata, @NotNull PGPainless api) {
            OpenPgpMessageInputStream openPgpMessageInputStream;
            Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
            Intrinsics.checkNotNullParameter((Object)api, (String)"api");
            OpenPGPAnimalSnifferInputStream openPgpIn = new OpenPGPAnimalSnifferInputStream(inputStream);
            openPgpIn.reset();
            if (openPgpIn.isNonOpenPgp() || options.isForceNonOpenPgpData()) {
                return new OpenPgpMessageInputStream(Type.non_openpgp, openPgpIn, options, metadata, api);
            }
            if (openPgpIn.isBinaryOpenPgp()) {
                return new OpenPgpMessageInputStream(Type.standard, openPgpIn, options, metadata, api);
            }
            if (openPgpIn.isAsciiArmored()) {
                ArmoredInputStream armorIn = ArmoredInputStreamFactory.Companion.get$default(ArmoredInputStreamFactory.Companion, openPgpIn, null, 2, null);
                if (armorIn.isClearText()) {
                    ((MessageMetadata.Message)metadata).setCleartextSigned();
                    openPgpMessageInputStream = new OpenPgpMessageInputStream(Type.cleartext_signed, (InputStream)armorIn, options, metadata, api);
                } else {
                    openPgpMessageInputStream = new OpenPgpMessageInputStream(Type.standard, (InputStream)armorIn, options, metadata, api);
                }
            } else {
                throw new AssertionError((Object)"Cannot deduce type of data.");
            }
            return openPgpMessageInputStream;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\tR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\t\u00a8\u0006\u0018"}, d2={"Lorg/pgpainless/decryption_verification/OpenPgpMessageInputStream$ESKsAndData;", "", "esks", "Lorg/bouncycastle/openpgp/PGPEncryptedDataList;", "(Lorg/bouncycastle/openpgp/PGPEncryptedDataList;)V", "all", "", "Lorg/bouncycastle/openpgp/PGPEncryptedData;", "getAll", "()Ljava/util/List;", "anonPkesks", "Lorg/bouncycastle/openpgp/PGPPublicKeyEncryptedData;", "getAnonPkesks", "pkesks", "getPkesks", "skesks", "Lorg/bouncycastle/openpgp/PGPPBEEncryptedData;", "getSkesks", "toEncryptedData", "Lorg/pgpainless/decryption_verification/MessageMetadata$EncryptedData;", "sk", "Lorg/pgpainless/util/SessionKey;", "depth", "", "pgpainless-core"})
    @SourceDebugExtension(value={"SMAP\nOpenPgpMessageInputStream.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenPgpMessageInputStream.kt\norg/pgpainless/decryption_verification/OpenPgpMessageInputStream$ESKsAndData\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1147:1\n1#2:1148\n*E\n"})
    private static final class ESKsAndData {
        @NotNull
        private final PGPEncryptedDataList esks;
        @NotNull
        private final List<PGPPBEEncryptedData> skesks;
        @NotNull
        private final List<PGPPublicKeyEncryptedData> pkesks;
        @NotNull
        private final List<PGPPublicKeyEncryptedData> anonPkesks;

        public ESKsAndData(@NotNull PGPEncryptedDataList esks) {
            Intrinsics.checkNotNullParameter((Object)esks, (String)"esks");
            this.esks = esks;
            this.skesks = new ArrayList();
            this.pkesks = new ArrayList();
            this.anonPkesks = new ArrayList();
            for (PGPEncryptedData esk : this.esks) {
                if (esk instanceof PGPPBEEncryptedData) {
                    this.skesks.add((PGPPBEEncryptedData)esk);
                    continue;
                }
                if (esk instanceof PGPPublicKeyEncryptedData) {
                    if (((PGPPublicKeyEncryptedData)esk).getKeyIdentifier().isWildcard()) {
                        this.anonPkesks.add((PGPPublicKeyEncryptedData)esk);
                        continue;
                    }
                    this.pkesks.add((PGPPublicKeyEncryptedData)esk);
                    continue;
                }
                throw new IllegalArgumentException("Unknown ESK class type " + esk.getClass());
            }
        }

        @NotNull
        public final MessageMetadata.EncryptedData toEncryptedData(@NotNull SessionKey sk, int depth) {
            MessageMetadata.EncryptedData encryptedData;
            MessageMetadata.EncryptedData encryptedData2;
            Intrinsics.checkNotNullParameter((Object)sk, (String)"sk");
            EncryptedDataPacketType encryptedDataPacketType = EncryptedDataPacketType.of((PGPEncryptedDataList)this.esks);
            Intrinsics.checkNotNull((Object)encryptedDataPacketType);
            switch (WhenMappings.$EnumSwitchMapping$0[encryptedDataPacketType.ordinal()]) {
                case 1: {
                    MessageEncryptionMechanism messageEncryptionMechanism = MessageEncryptionMechanism.legacyEncryptedNonIntegrityProtected((int)sk.getAlgorithm().getAlgorithmId());
                    Intrinsics.checkNotNullExpressionValue((Object)messageEncryptionMechanism, (String)"legacyEncryptedNonIntegrityProtected(...)");
                    encryptedData2 = new MessageMetadata.EncryptedData(messageEncryptionMechanism, depth);
                    break;
                }
                case 2: {
                    MessageEncryptionMechanism messageEncryptionMechanism = MessageEncryptionMechanism.integrityProtected((int)sk.getAlgorithm().getAlgorithmId());
                    Intrinsics.checkNotNullExpressionValue((Object)messageEncryptionMechanism, (String)"integrityProtected(...)");
                    encryptedData2 = new MessageMetadata.EncryptedData(messageEncryptionMechanism, depth);
                    break;
                }
                case 3: {
                    InputStreamPacket inputStreamPacket = this.esks.getEncryptedData();
                    Intrinsics.checkNotNull((Object)inputStreamPacket, (String)"null cannot be cast to non-null type org.bouncycastle.bcpg.SymmetricEncIntegrityPacket");
                    SymmetricEncIntegrityPacket seipd2 = (SymmetricEncIntegrityPacket)inputStreamPacket;
                    MessageEncryptionMechanism messageEncryptionMechanism = MessageEncryptionMechanism.aead((int)seipd2.getCipherAlgorithm(), (int)seipd2.getAeadAlgorithm());
                    Intrinsics.checkNotNullExpressionValue((Object)messageEncryptionMechanism, (String)"aead(...)");
                    encryptedData2 = new MessageMetadata.EncryptedData(messageEncryptionMechanism, depth);
                    break;
                }
                case 4: {
                    InputStreamPacket inputStreamPacket = this.esks.getEncryptedData();
                    Intrinsics.checkNotNull((Object)inputStreamPacket, (String)"null cannot be cast to non-null type org.bouncycastle.bcpg.AEADEncDataPacket");
                    AEADEncDataPacket oed = (AEADEncDataPacket)inputStreamPacket;
                    MessageEncryptionMechanism messageEncryptionMechanism = MessageEncryptionMechanism.librePgp((int)oed.getAlgorithm());
                    Intrinsics.checkNotNullExpressionValue((Object)messageEncryptionMechanism, (String)"librePgp(...)");
                    encryptedData2 = new MessageMetadata.EncryptedData(messageEncryptionMechanism, depth);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            MessageMetadata.EncryptedData it = encryptedData = encryptedData2;
            boolean bl = false;
            it.setSessionKey(sk);
            return encryptedData;
        }

        @NotNull
        public final List<PGPPBEEncryptedData> getSkesks() {
            return this.skesks;
        }

        @NotNull
        public final List<PGPPublicKeyEncryptedData> getPkesks() {
            return this.pkesks;
        }

        @NotNull
        public final List<PGPPublicKeyEncryptedData> getAnonPkesks() {
            return this.anonPkesks;
        }

        @NotNull
        public final List<PGPEncryptedData> getAll() {
            return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)this.skesks, (Iterable)this.pkesks), (Iterable)this.anonPkesks);
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[EncryptedDataPacketType.values().length];
                try {
                    nArray[EncryptedDataPacketType.SED.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[EncryptedDataPacketType.SEIPDv1.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[EncryptedDataPacketType.SEIPDv2.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[EncryptedDataPacketType.LIBREPGP_OED.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u000b2\u0006\u0010/\u001a\u000200J\u000e\u00101\u001a\u00020-2\u0006\u0010.\u001a\u00020\u000bJ\u0014\u00102\u001a\u00020-2\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u000b04J\u000e\u00105\u001a\u00020-2\u0006\u0010.\u001a\u000206J\u000e\u00107\u001a\u00020-2\u0006\u0010.\u001a\u00020\u000bJ\u0006\u00108\u001a\u00020-J\u0012\u00109\u001a\u0004\u0018\u00010:2\u0006\u0010.\u001a\u000206H\u0002J\u0012\u00109\u001a\u0004\u0018\u00010:2\u0006\u0010.\u001a\u00020\u000bH\u0002J\u000e\u0010;\u001a\u00020-2\u0006\u0010/\u001a\u000200J\u0018\u0010<\u001a\u00020-2\u0006\u0010=\u001a\u0002062\u0006\u0010>\u001a\u00020?H\u0002J\u0018\u0010<\u001a\u00020-2\u0006\u0010.\u001a\u00020\u000b2\u0006\u0010>\u001a\u00020?H\u0002J\u000e\u0010@\u001a\u00020\u000f2\u0006\u0010.\u001a\u00020\u000bJ\u0006\u0010A\u001a\u00020-J\u000e\u0010B\u001a\u00020-2\u0006\u0010B\u001a\u00020CJ\u000e\u0010D\u001a\u00020-2\u0006\u0010E\u001a\u00020FJ\u001e\u0010D\u001a\u00020-2\u0006\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020JJ\u000e\u0010L\u001a\u00020-2\u0006\u0010E\u001a\u00020FJ\u001e\u0010L\u001a\u00020-2\u0006\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020JJ \u0010M\u001a\u00020-2\u0006\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020JH\u0016J\u0010\u0010M\u001a\u00020-2\u0006\u0010E\u001a\u00020JH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\rR\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00120\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\rR\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0018\"\u0004\b\u0019\u0010\u001aR \u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\r\"\u0004\b\u001e\u0010\u001fR\u0017\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001c0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\rR\u001d\u0010\"\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\n0#\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0017\u0010(\u001a\b\u0012\u0004\u0012\u00020\u000f0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\rR\u0017\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00120\n\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\r\u00a8\u0006N"}, d2={"Lorg/pgpainless/decryption_verification/OpenPgpMessageInputStream$Signatures;", "Ljava/io/OutputStream;", "options", "Lorg/pgpainless/decryption_verification/ConsumerOptions;", "api", "Lorg/pgpainless/PGPainless;", "(Lorg/pgpainless/decryption_verification/ConsumerOptions;Lorg/pgpainless/PGPainless;)V", "getApi", "()Lorg/pgpainless/PGPainless;", "correspondingSignatures", "", "Lorg/bouncycastle/openpgp/PGPSignature;", "getCorrespondingSignatures", "()Ljava/util/List;", "detachedSignatures", "Lorg/bouncycastle/openpgp/api/OpenPGPSignature$OpenPGPDocumentSignature;", "getDetachedSignatures", "detachedSignaturesWithMissingCert", "Lorg/pgpainless/decryption_verification/SignatureVerification$Failure;", "getDetachedSignaturesWithMissingCert", "inbandSignaturesWithMissingCert", "getInbandSignaturesWithMissingCert", "isLiteral", "", "()Z", "setLiteral", "(Z)V", "literalOPS", "Lorg/pgpainless/signature/consumer/OnePassSignatureCheck;", "getLiteralOPS", "setLiteralOPS", "(Ljava/util/List;)V", "onePassSignatures", "getOnePassSignatures", "opsUpdateStack", "Lkotlin/collections/ArrayDeque;", "getOpsUpdateStack", "()Lkotlin/collections/ArrayDeque;", "getOptions", "()Lorg/pgpainless/decryption_verification/ConsumerOptions;", "prependedSignatures", "getPrependedSignatures", "prependedSignaturesWithMissingCert", "getPrependedSignaturesWithMissingCert", "addCorrespondingOnePassSignature", "", "signature", "layer", "Lorg/pgpainless/decryption_verification/MessageMetadata$Layer;", "addDetachedSignature", "addDetachedSignatures", "signatures", "", "addOnePassSignature", "Lorg/bouncycastle/openpgp/PGPOnePassSignature;", "addPrependedSignature", "enterNesting", "findCertificate", "Lorg/bouncycastle/openpgp/api/OpenPGPCertificate;", "finish", "initialize", "ops", "publicKey", "Lorg/bouncycastle/openpgp/PGPPublicKey;", "initializeSignature", "leaveNesting", "nextPacket", "Lorg/pgpainless/algorithm/OpenPgpPacket;", "updateLiteral", "b", "", "buf", "", "off", "", "len", "updatePacket", "write", "pgpainless-core"})
    private static final class Signatures
    extends OutputStream {
        @NotNull
        private final ConsumerOptions options;
        @NotNull
        private final PGPainless api;
        @NotNull
        private final List<OpenPGPSignature.OpenPGPDocumentSignature> detachedSignatures;
        @NotNull
        private final List<OpenPGPSignature.OpenPGPDocumentSignature> prependedSignatures;
        @NotNull
        private final List<OnePassSignatureCheck> onePassSignatures;
        @NotNull
        private final ArrayDeque<List<OnePassSignatureCheck>> opsUpdateStack;
        @NotNull
        private List<OnePassSignatureCheck> literalOPS;
        @NotNull
        private final List<PGPSignature> correspondingSignatures;
        @NotNull
        private final List<SignatureVerification.Failure> prependedSignaturesWithMissingCert;
        @NotNull
        private final List<SignatureVerification.Failure> inbandSignaturesWithMissingCert;
        @NotNull
        private final List<SignatureVerification.Failure> detachedSignaturesWithMissingCert;
        private boolean isLiteral;

        public Signatures(@NotNull ConsumerOptions options, @NotNull PGPainless api) {
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            Intrinsics.checkNotNullParameter((Object)api, (String)"api");
            this.options = options;
            this.api = api;
            this.detachedSignatures = new ArrayList();
            this.prependedSignatures = new ArrayList();
            this.onePassSignatures = new ArrayList();
            this.opsUpdateStack = new ArrayDeque();
            this.literalOPS = new ArrayList();
            this.correspondingSignatures = new ArrayList();
            this.prependedSignaturesWithMissingCert = new ArrayList();
            this.inbandSignaturesWithMissingCert = new ArrayList();
            this.detachedSignaturesWithMissingCert = new ArrayList();
            this.isLiteral = true;
        }

        @NotNull
        public final ConsumerOptions getOptions() {
            return this.options;
        }

        @NotNull
        public final PGPainless getApi() {
            return this.api;
        }

        @NotNull
        public final List<OpenPGPSignature.OpenPGPDocumentSignature> getDetachedSignatures() {
            return this.detachedSignatures;
        }

        @NotNull
        public final List<OpenPGPSignature.OpenPGPDocumentSignature> getPrependedSignatures() {
            return this.prependedSignatures;
        }

        @NotNull
        public final List<OnePassSignatureCheck> getOnePassSignatures() {
            return this.onePassSignatures;
        }

        @NotNull
        public final ArrayDeque<List<OnePassSignatureCheck>> getOpsUpdateStack() {
            return this.opsUpdateStack;
        }

        @NotNull
        public final List<OnePassSignatureCheck> getLiteralOPS() {
            return this.literalOPS;
        }

        public final void setLiteralOPS(@NotNull List<OnePassSignatureCheck> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.literalOPS = list;
        }

        @NotNull
        public final List<PGPSignature> getCorrespondingSignatures() {
            return this.correspondingSignatures;
        }

        @NotNull
        public final List<SignatureVerification.Failure> getPrependedSignaturesWithMissingCert() {
            return this.prependedSignaturesWithMissingCert;
        }

        @NotNull
        public final List<SignatureVerification.Failure> getInbandSignaturesWithMissingCert() {
            return this.inbandSignaturesWithMissingCert;
        }

        @NotNull
        public final List<SignatureVerification.Failure> getDetachedSignaturesWithMissingCert() {
            return this.detachedSignaturesWithMissingCert;
        }

        public final boolean isLiteral() {
            return this.isLiteral;
        }

        public final void setLiteral(boolean bl) {
            this.isLiteral = bl;
        }

        public final void addDetachedSignatures(@NotNull Collection<? extends PGPSignature> signatures) {
            Intrinsics.checkNotNullParameter(signatures, (String)"signatures");
            for (PGPSignature pGPSignature : signatures) {
                this.addDetachedSignature(pGPSignature);
            }
        }

        public final void addDetachedSignature(@NotNull PGPSignature signature) {
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            OpenPGPSignature.OpenPGPDocumentSignature check = this.initializeSignature(signature);
            long keyId = PGPSignatureExtensionsKt.getIssuerKeyId(signature);
            if (check.getIssuer() != null) {
                this.detachedSignatures.add(check);
            } else {
                LOGGER.debug("No suitable certificate for verification of signature by key " + LongExtensionsKt.openPgpKeyId(keyId) + " found.");
                this.detachedSignaturesWithMissingCert.add(new SignatureVerification.Failure(check, new SignatureValidationException("Missing verification key.")));
            }
        }

        public final void addPrependedSignature(@NotNull PGPSignature signature) {
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            OpenPGPSignature.OpenPGPDocumentSignature check = this.initializeSignature(signature);
            long keyId = PGPSignatureExtensionsKt.getIssuerKeyId(signature);
            if (check.getIssuer() != null) {
                this.prependedSignatures.add(check);
            } else {
                LOGGER.debug("No suitable certificate for verification of signature by key " + LongExtensionsKt.openPgpKeyId(keyId) + " found.");
                this.prependedSignaturesWithMissingCert.add(new SignatureVerification.Failure(check, new SignatureValidationException("Missing verification key")));
            }
        }

        @NotNull
        public final OpenPGPSignature.OpenPGPDocumentSignature initializeSignature(@NotNull PGPSignature signature) {
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            OpenPGPCertificate openPGPCertificate = this.findCertificate(signature);
            if (openPGPCertificate == null) {
                return new OpenPGPSignature.OpenPGPDocumentSignature(signature, null);
            }
            OpenPGPCertificate certificate = openPGPCertificate;
            OpenPGPCertificate.OpenPGPComponentKey openPGPComponentKey = certificate.getSigningKeyFor(signature);
            if (openPGPComponentKey == null) {
                return new OpenPGPSignature.OpenPGPDocumentSignature(signature, null);
            }
            OpenPGPCertificate.OpenPGPComponentKey publicKey = openPGPComponentKey;
            PGPPublicKey pGPPublicKey = publicKey.getPGPPublicKey();
            Intrinsics.checkNotNullExpressionValue((Object)pGPPublicKey, (String)"getPGPPublicKey(...)");
            this.initialize(signature, pGPPublicKey);
            return new OpenPGPSignature.OpenPGPDocumentSignature(signature, publicKey);
        }

        public final void addOnePassSignature(@NotNull PGPOnePassSignature signature) {
            OpenPGPCertificate.OpenPGPComponentKey publicKey;
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            OpenPGPCertificate certificate = this.findCertificate(signature);
            if (certificate != null && (publicKey = OpenPGPCertificateExtensionsKt.getSigningKeyFor(certificate, signature)) != null) {
                OnePassSignatureCheck ops = new OnePassSignatureCheck(signature, certificate);
                PGPPublicKey pGPPublicKey = publicKey.getPGPPublicKey();
                Intrinsics.checkNotNullExpressionValue((Object)pGPPublicKey, (String)"getPGPPublicKey(...)");
                this.initialize(signature, pGPPublicKey);
                this.onePassSignatures.add(ops);
                this.literalOPS.add(ops);
            }
            if (signature.isContaining()) {
                this.enterNesting();
            }
        }

        public final void addCorrespondingOnePassSignature(@NotNull PGPSignature signature, @NotNull MessageMetadata.Layer layer) {
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
            boolean found = false;
            for (OnePassSignatureCheck check : CollectionsKt.reversed((Iterable)this.onePassSignatures)) {
                if (!KeyIdentifier.matches((List)signature.getKeyIdentifiers(), (KeyIdentifier)check.getOnePassSignature().getKeyIdentifier(), (boolean)true)) continue;
                found = true;
                if (check.getSignature() != null) continue;
                check.setSignature(signature);
                OpenPGPSignature.OpenPGPDocumentSignature documentSignature = new OpenPGPSignature.OpenPGPDocumentSignature(signature, check.getVerificationKeys().getSigningKeyFor(signature));
                SignatureVerification verification = new SignatureVerification(documentSignature);
                try {
                    PGPSignatureExtensionsKt.assertCreatedInBounds(signature, this.options.getVerifyNotBefore(), this.options.getVerifyNotAfter());
                    if (!documentSignature.verify(check.getOnePassSignature()) || !documentSignature.isValid(this.api.getImplementation().policy())) {
                        throw new SignatureValidationException("Incorrect OnePassSignature.");
                    }
                    layer.addVerifiedOnePassSignature(verification);
                    break;
                }
                catch (MalformedOpenPGPSignatureException e) {
                    throw new SignatureValidationException("Malformed OnePassSignature.", (Exception)((Object)e));
                }
                catch (SignatureValidationException e) {
                    layer.addRejectedOnePassSignature(new SignatureVerification.Failure(verification, e));
                    break;
                }
                catch (PGPSignatureException e) {
                    layer.addRejectedOnePassSignature(new SignatureVerification.Failure(verification, new SignatureValidationException(e.getMessage(), (Exception)((Object)e))));
                    break;
                }
            }
            if (!found) {
                LOGGER.debug("No suitable certificate for verification of signature by key " + LongExtensionsKt.openPgpKeyId(PGPSignatureExtensionsKt.getIssuerKeyId(signature)) + " found.");
                this.inbandSignaturesWithMissingCert.add(new SignatureVerification.Failure(new OpenPGPSignature.OpenPGPDocumentSignature(signature, null), new SignatureValidationException("Missing verification key.")));
            }
        }

        public final void enterNesting() {
            this.opsUpdateStack.addFirst(this.literalOPS);
            this.literalOPS = new ArrayList();
        }

        public final void leaveNesting() {
            if (this.opsUpdateStack.isEmpty()) {
                return;
            }
            this.opsUpdateStack.removeFirst();
        }

        private final OpenPGPCertificate findCertificate(PGPSignature signature) {
            OpenPGPCertificate cert = this.options.getCertificateSource().getCertificate(signature);
            if (cert != null) {
                return cert;
            }
            if (this.options.getMissingCertificateCallback() != null) {
                OpenPGPKeyMaterialProvider.OpenPGPCertificateProvider openPGPCertificateProvider = this.options.getMissingCertificateCallback();
                Intrinsics.checkNotNull((Object)openPGPCertificateProvider);
                List list = signature.getKeyIdentifiers();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getKeyIdentifiers(...)");
                return openPGPCertificateProvider.provide((KeyIdentifier)CollectionsKt.first((List)list));
            }
            return null;
        }

        private final OpenPGPCertificate findCertificate(PGPOnePassSignature signature) {
            ConsumerOptions.CertificateSource certificateSource = this.options.getCertificateSource();
            KeyIdentifier keyIdentifier = signature.getKeyIdentifier();
            Intrinsics.checkNotNullExpressionValue((Object)keyIdentifier, (String)"getKeyIdentifier(...)");
            OpenPGPCertificate cert = certificateSource.getCertificate(keyIdentifier);
            if (cert != null) {
                return cert;
            }
            if (this.options.getMissingCertificateCallback() != null) {
                OpenPGPKeyMaterialProvider.OpenPGPCertificateProvider openPGPCertificateProvider = this.options.getMissingCertificateCallback();
                Intrinsics.checkNotNull((Object)openPGPCertificateProvider);
                return openPGPCertificateProvider.provide(signature.getKeyIdentifier());
            }
            return null;
        }

        public final void updateLiteral(byte b) {
            for (OnePassSignatureCheck ops : this.literalOPS) {
                ops.getOnePassSignature().update(b);
            }
            for (OpenPGPSignature.OpenPGPDocumentSignature detached : this.detachedSignatures) {
                detached.getSignature().update(b);
            }
            for (OpenPGPSignature.OpenPGPDocumentSignature prepended : this.prependedSignatures) {
                prepended.getSignature().update(b);
            }
        }

        public final void updateLiteral(@NotNull byte[] buf, int off, int len) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            for (OnePassSignatureCheck ops : this.literalOPS) {
                ops.getOnePassSignature().update(buf, off, len);
            }
            for (OpenPGPSignature.OpenPGPDocumentSignature detached : this.detachedSignatures) {
                detached.getSignature().update(buf, off, len);
            }
            for (OpenPGPSignature.OpenPGPDocumentSignature prepended : this.prependedSignatures) {
                prepended.getSignature().update(buf, off, len);
            }
        }

        public final void updatePacket(byte b) {
            for (List nestedOPSs : CollectionsKt.reversed((Iterable)((Iterable)this.opsUpdateStack))) {
                for (OnePassSignatureCheck ops : nestedOPSs) {
                    ops.getOnePassSignature().update(b);
                }
            }
        }

        public final void updatePacket(@NotNull byte[] buf, int off, int len) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            for (List nestedOPSs : CollectionsKt.reversed((Iterable)((Iterable)this.opsUpdateStack))) {
                for (OnePassSignatureCheck ops : nestedOPSs) {
                    ops.getOnePassSignature().update(buf, off, len);
                }
            }
        }

        public final void finish(@NotNull MessageMetadata.Layer layer) {
            SignatureVerification verification;
            Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
            for (OpenPGPSignature.OpenPGPDocumentSignature detached : this.detachedSignatures) {
                verification = new SignatureVerification(detached);
                try {
                    PGPSignature pGPSignature = detached.getSignature();
                    Intrinsics.checkNotNullExpressionValue((Object)pGPSignature, (String)"getSignature(...)");
                    PGPSignatureExtensionsKt.assertCreatedInBounds(pGPSignature, this.options.getVerifyNotBefore(), this.options.getVerifyNotAfter());
                    if (!detached.verify()) {
                        throw new SignatureValidationException("Incorrect detached signature.");
                    }
                    if (!detached.isValid(this.api.getImplementation().policy())) {
                        throw new SignatureValidationException("Detached signature is not valid.");
                    }
                    layer.addVerifiedDetachedSignature(verification);
                }
                catch (MalformedOpenPGPSignatureException e) {
                    throw new SignatureValidationException("Malformed detached signature.", (Exception)((Object)e));
                }
                catch (SignatureValidationException e) {
                    layer.addRejectedDetachedSignature(new SignatureVerification.Failure(verification, e));
                }
            }
            for (OpenPGPSignature.OpenPGPDocumentSignature prepended : this.prependedSignatures) {
                verification = new SignatureVerification(prepended);
                try {
                    PGPSignature pGPSignature = prepended.getSignature();
                    Intrinsics.checkNotNullExpressionValue((Object)pGPSignature, (String)"getSignature(...)");
                    PGPSignatureExtensionsKt.assertCreatedInBounds(pGPSignature, this.options.getVerifyNotBefore(), this.options.getVerifyNotAfter());
                    if (prepended.verify() && prepended.isValid(this.api.getImplementation().policy())) {
                        layer.addVerifiedPrependedSignature(verification);
                        continue;
                    }
                    throw new SignatureValidationException("Incorrect prepended signature.");
                }
                catch (MalformedOpenPGPSignatureException e) {
                    throw new SignatureValidationException("Malformed prepended signature.", (Exception)((Object)e));
                }
                catch (SignatureValidationException e) {
                    LOGGER.debug("Rejected signature by key " + verification.getSigningKey(), (Throwable)((Object)e));
                    layer.addRejectedPrependedSignature(new SignatureVerification.Failure(verification, e));
                }
            }
            for (SignatureVerification.Failure rejected : this.inbandSignaturesWithMissingCert) {
                layer.addRejectedOnePassSignature(rejected);
            }
            for (SignatureVerification.Failure rejected : this.prependedSignaturesWithMissingCert) {
                layer.addRejectedPrependedSignature(rejected);
            }
            for (SignatureVerification.Failure rejected : this.detachedSignaturesWithMissingCert) {
                layer.addRejectedDetachedSignature(rejected);
            }
        }

        @Override
        public void write(int b) {
            this.updatePacket((byte)b);
        }

        @Override
        public void write(@NotNull byte[] buf, int off, int len) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            this.updatePacket(buf, off, len);
        }

        public final void nextPacket(@NotNull OpenPgpPacket nextPacket) {
            Intrinsics.checkNotNullParameter((Object)((Object)nextPacket), (String)"nextPacket");
            if (nextPacket == OpenPgpPacket.LIT) {
                this.isLiteral = true;
                if (this.literalOPS.isEmpty() && !((Collection)this.opsUpdateStack).isEmpty()) {
                    this.literalOPS = (List)this.opsUpdateStack.removeFirst();
                }
            } else {
                this.isLiteral = false;
            }
        }

        private final void initialize(PGPSignature signature, PGPPublicKey publicKey) {
            PGPContentVerifierBuilderProvider verifierProvider = this.api.getImplementation().pgpContentVerifierBuilderProvider();
            try {
                signature.init(verifierProvider, publicKey);
            }
            catch (PGPException e) {
                throw new RuntimeException(e);
            }
        }

        private final void initialize(PGPOnePassSignature ops, PGPPublicKey publicKey) {
            PGPContentVerifierBuilderProvider verifierProvider = this.api.getImplementation().pgpContentVerifierBuilderProvider();
            try {
                ops.init(verifierProvider, publicKey);
            }
            catch (PGPException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/pgpainless/decryption_verification/OpenPgpMessageInputStream$Type;", "", "(Ljava/lang/String;I)V", "standard", "cleartext_signed", "non_openpgp", "pgpainless-core"})
    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type standard = new Type();
        public static final /* enum */ Type cleartext_signed = new Type();
        public static final /* enum */ Type non_openpgp = new Type();
        private static final /* synthetic */ Type[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String value) {
            return Enum.valueOf(Type.class, value);
        }

        @NotNull
        public static EnumEntries<Type> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = typeArray = new Type[]{Type.standard, Type.cleartext_signed, Type.non_openpgp};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[Type.values().length];
            try {
                nArray[Type.standard.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Type.cleartext_signed.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Type.non_openpgp.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[OpenPgpPacket.values().length];
            try {
                nArray[OpenPgpPacket.LIT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OpenPgpPacket.COMP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OpenPgpPacket.OPS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OpenPgpPacket.SIG.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OpenPgpPacket.PKESK.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OpenPgpPacket.SKESK.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OpenPgpPacket.SED.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OpenPgpPacket.SEIPD.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OpenPgpPacket.OED.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OpenPgpPacket.MARKER.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OpenPgpPacket.PADDING.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OpenPgpPacket.SK.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OpenPgpPacket.PK.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OpenPgpPacket.SSK.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OpenPgpPacket.PSK.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OpenPgpPacket.TRUST.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OpenPgpPacket.UID.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OpenPgpPacket.UATTR.ordinal()] = 18;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OpenPgpPacket.EXP_1.ordinal()] = 19;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OpenPgpPacket.EXP_2.ordinal()] = 20;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OpenPgpPacket.EXP_3.ordinal()] = 21;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OpenPgpPacket.EXP_4.ordinal()] = 22;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[EncryptedDataPacketType.values().length];
            try {
                nArray[EncryptedDataPacketType.SEIPDv2.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EncryptedDataPacketType.SEIPDv1.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EncryptedDataPacketType.LIBREPGP_OED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EncryptedDataPacketType.SED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

