/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.decryption_verification;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.bouncycastle.bcpg.KeyIdentifier;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPEncryptedData;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPOnePassSignatureList;
import org.bouncycastle.openpgp.PGPPBEEncryptedData;
import org.bouncycastle.openpgp.PGPPublicKeyEncryptedData;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.api.OpenPGPImplementation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.PGPainless;
import org.pgpainless.util.ArmorUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u000eB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lorg/pgpainless/decryption_verification/MessageInspector;", "", "api", "Lorg/pgpainless/PGPainless;", "(Lorg/pgpainless/PGPainless;)V", "getApi", "()Lorg/pgpainless/PGPainless;", "determineEncryptionInfoForMessage", "Lorg/pgpainless/decryption_verification/MessageInspector$EncryptionInfo;", "inputStream", "Ljava/io/InputStream;", "message", "", "processMessage", "EncryptionInfo", "pgpainless-core"})
@SourceDebugExtension(value={"SMAP\nMessageInspector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MessageInspector.kt\norg/pgpainless/decryption_verification/MessageInspector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,109:1\n1#2:110\n*E\n"})
public final class MessageInspector {
    @NotNull
    private final PGPainless api;

    public MessageInspector(@NotNull PGPainless api) {
        Intrinsics.checkNotNullParameter((Object)api, (String)"api");
        this.api = api;
    }

    public /* synthetic */ MessageInspector(PGPainless pGPainless, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            pGPainless = PGPainless.Companion.getInstance();
        }
        this(pGPainless);
    }

    @NotNull
    public final PGPainless getApi() {
        return this.api;
    }

    @NotNull
    public final EncryptionInfo determineEncryptionInfoForMessage(@NotNull String message) throws PGPException, IOException {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        String string = message;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return this.determineEncryptionInfoForMessage(new ByteArrayInputStream(byArray));
    }

    @NotNull
    public final EncryptionInfo determineEncryptionInfoForMessage(@NotNull InputStream inputStream) throws PGPException, IOException {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        return this.processMessage(ArmorUtils.Companion.getDecoderStream(inputStream));
    }

    private final EncryptionInfo processMessage(InputStream inputStream) throws PGPException, IOException {
        PGPObjectFactory objectFactory = this.api.getImplementation().pgpObjectFactory(inputStream);
        Object n = null;
        while (true) {
            Object next;
            Object object;
            Object it = object = objectFactory.nextObject();
            boolean bl = false;
            n = it;
            if (object == null) break;
            Intrinsics.checkNotNull((Object)n);
            if (next instanceof PGPOnePassSignatureList) {
                if (((PGPOnePassSignatureList)next).isEmpty()) continue;
                return new EncryptionInfo(CollectionsKt.emptyList(), false, true);
            }
            if (next instanceof PGPEncryptedDataList) {
                boolean isPassphraseEncrypted = false;
                List keyIdentifiers = new ArrayList();
                for (PGPEncryptedData encryptedData : (PGPEncryptedDataList)next) {
                    if (encryptedData instanceof PGPPublicKeyEncryptedData) {
                        KeyIdentifier keyIdentifier = ((PGPPublicKeyEncryptedData)encryptedData).getKeyIdentifier();
                        Intrinsics.checkNotNullExpressionValue((Object)keyIdentifier, (String)"getKeyIdentifier(...)");
                        keyIdentifiers.add(keyIdentifier);
                        continue;
                    }
                    if (!(encryptedData instanceof PGPPBEEncryptedData)) continue;
                    isPassphraseEncrypted = true;
                }
                return new EncryptionInfo(keyIdentifiers, isPassphraseEncrypted, false);
            }
            if (next instanceof PGPCompressedData) {
                objectFactory = OpenPGPImplementation.getInstance().pgpObjectFactory(PGPUtil.getDecoderStream((InputStream)((PGPCompressedData)next).getDataStream()));
                continue;
            }
            if (next instanceof PGPLiteralData) break;
        }
        return new EncryptionInfo(CollectionsKt.emptyList(), false, false);
    }

    public MessageInspector() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0006H\u00c6\u0003J-\u0010\u0013\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00062\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\t\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\nR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\nR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\f\u00a8\u0006\u001a"}, d2={"Lorg/pgpainless/decryption_verification/MessageInspector$EncryptionInfo;", "", "keyIdentifiers", "", "Lorg/bouncycastle/bcpg/KeyIdentifier;", "isPassphraseEncrypted", "", "isSignedOnly", "(Ljava/util/List;ZZ)V", "isEncrypted", "()Z", "getKeyIdentifiers", "()Ljava/util/List;", "keyIds", "", "getKeyIds", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "pgpainless-core"})
    @SourceDebugExtension(value={"SMAP\nMessageInspector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MessageInspector.kt\norg/pgpainless/decryption_verification/MessageInspector$EncryptionInfo\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,109:1\n1549#2:110\n1620#2,3:111\n*S KotlinDebug\n*F\n+ 1 MessageInspector.kt\norg/pgpainless/decryption_verification/MessageInspector$EncryptionInfo\n*L\n38#1:110\n38#1:111,3\n*E\n"})
    public static final class EncryptionInfo {
        @NotNull
        private final List<KeyIdentifier> keyIdentifiers;
        private final boolean isPassphraseEncrypted;
        private final boolean isSignedOnly;
        @NotNull
        private final List<Long> keyIds;

        /*
         * WARNING - void declaration
         */
        public EncryptionInfo(@NotNull List<? extends KeyIdentifier> keyIdentifiers, boolean isPassphraseEncrypted, boolean isSignedOnly) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter(keyIdentifiers, (String)"keyIdentifiers");
            this.keyIdentifiers = keyIdentifiers;
            this.isPassphraseEncrypted = isPassphraseEncrypted;
            this.isSignedOnly = isSignedOnly;
            Iterable iterable = this.keyIdentifiers;
            EncryptionInfo encryptionInfo = this;
            boolean $i$f$map = false;
            void var6_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                KeyIdentifier keyIdentifier = (KeyIdentifier)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getKeyId());
            }
            encryptionInfo.keyIds = (List)destination$iv$iv;
        }

        @NotNull
        public final List<KeyIdentifier> getKeyIdentifiers() {
            return this.keyIdentifiers;
        }

        public final boolean isPassphraseEncrypted() {
            return this.isPassphraseEncrypted;
        }

        public final boolean isSignedOnly() {
            return this.isSignedOnly;
        }

        public final boolean isEncrypted() {
            return this.isPassphraseEncrypted || !((Collection)this.keyIds).isEmpty();
        }

        @NotNull
        public final List<Long> getKeyIds() {
            return this.keyIds;
        }

        @NotNull
        public final List<KeyIdentifier> component1() {
            return this.keyIdentifiers;
        }

        public final boolean component2() {
            return this.isPassphraseEncrypted;
        }

        public final boolean component3() {
            return this.isSignedOnly;
        }

        @NotNull
        public final EncryptionInfo copy(@NotNull List<? extends KeyIdentifier> keyIdentifiers, boolean isPassphraseEncrypted, boolean isSignedOnly) {
            Intrinsics.checkNotNullParameter(keyIdentifiers, (String)"keyIdentifiers");
            return new EncryptionInfo(keyIdentifiers, isPassphraseEncrypted, isSignedOnly);
        }

        public static /* synthetic */ EncryptionInfo copy$default(EncryptionInfo encryptionInfo, List list, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                list = encryptionInfo.keyIdentifiers;
            }
            if ((n & 2) != 0) {
                bl = encryptionInfo.isPassphraseEncrypted;
            }
            if ((n & 4) != 0) {
                bl2 = encryptionInfo.isSignedOnly;
            }
            return encryptionInfo.copy(list, bl, bl2);
        }

        @NotNull
        public String toString() {
            return "EncryptionInfo(keyIdentifiers=" + this.keyIdentifiers + ", isPassphraseEncrypted=" + this.isPassphraseEncrypted + ", isSignedOnly=" + this.isSignedOnly + ")";
        }

        public int hashCode() {
            int result = ((Object)this.keyIdentifiers).hashCode();
            result = result * 31 + Boolean.hashCode(this.isPassphraseEncrypted);
            result = result * 31 + Boolean.hashCode(this.isSignedOnly);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof EncryptionInfo)) {
                return false;
            }
            EncryptionInfo encryptionInfo = (EncryptionInfo)other;
            if (!Intrinsics.areEqual(this.keyIdentifiers, encryptionInfo.keyIdentifiers)) {
                return false;
            }
            if (this.isPassphraseEncrypted != encryptionInfo.isPassphraseEncrypted) {
                return false;
            }
            return this.isSignedOnly == encryptionInfo.isSignedOnly;
        }
    }
}

