/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.algorithm;

import java.util.NoSuchElementException;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bouncycastle.bcpg.PublicKeyUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0018\b\u0086\u0081\u0002\u0018\u0000 \u001f2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u001fB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\r\u001a\u00020\bJ\u0006\u0010\u000e\u001a\u00020\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nj\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001cj\u0002\b\u001dj\u0002\b\u001e\u00a8\u0006 "}, d2={"Lorg/pgpainless/algorithm/PublicKeyAlgorithm;", "", "algorithmId", "", "(Ljava/lang/String;II)V", "getAlgorithmId", "()I", "encryptionCapable", "", "getEncryptionCapable", "()Z", "signingCapable", "getSigningCapable", "isEncryptionCapable", "isSigningCapable", "RSA_GENERAL", "RSA_ENCRYPT", "RSA_SIGN", "ELGAMAL_ENCRYPT", "DSA", "ECDH", "ECDSA", "ELGAMAL_GENERAL", "DIFFIE_HELLMAN", "EDDSA_LEGACY", "X25519", "X448", "ED25519", "ED448", "AEAD", "HMAC", "Companion", "pgpainless-core"})
public class PublicKeyAlgorithm
extends Enum<PublicKeyAlgorithm> {
    @NotNull
    public static final Companion Companion;
    private final int algorithmId;
    private final boolean signingCapable;
    private final boolean encryptionCapable;
    public static final /* enum */ PublicKeyAlgorithm RSA_GENERAL;
    @Deprecated(message="RSA_ENCRYPT is deprecated in favor of RSA_GENERAL", replaceWith=@ReplaceWith(expression="RSA_GENERAL", imports={}))
    public static final /* enum */ PublicKeyAlgorithm RSA_ENCRYPT;
    @Deprecated(message="RSA_SIGN is deprecated in favor of RSA_GENERAL", replaceWith=@ReplaceWith(expression="RSA_GENERAL", imports={}))
    public static final /* enum */ PublicKeyAlgorithm RSA_SIGN;
    public static final /* enum */ PublicKeyAlgorithm ELGAMAL_ENCRYPT;
    public static final /* enum */ PublicKeyAlgorithm DSA;
    public static final /* enum */ PublicKeyAlgorithm ECDH;
    public static final /* enum */ PublicKeyAlgorithm ECDSA;
    @Deprecated(message="ElGamal is deprecated")
    public static final /* enum */ PublicKeyAlgorithm ELGAMAL_GENERAL;
    public static final /* enum */ PublicKeyAlgorithm DIFFIE_HELLMAN;
    public static final /* enum */ PublicKeyAlgorithm EDDSA_LEGACY;
    public static final /* enum */ PublicKeyAlgorithm X25519;
    public static final /* enum */ PublicKeyAlgorithm X448;
    public static final /* enum */ PublicKeyAlgorithm ED25519;
    public static final /* enum */ PublicKeyAlgorithm ED448;
    public static final /* enum */ PublicKeyAlgorithm AEAD;
    public static final /* enum */ PublicKeyAlgorithm HMAC;
    private static final /* synthetic */ PublicKeyAlgorithm[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private PublicKeyAlgorithm(int algorithmId) {
        this.algorithmId = algorithmId;
        this.signingCapable = PublicKeyUtils.isSigningAlgorithm((int)this.algorithmId);
        this.encryptionCapable = PublicKeyUtils.isEncryptionAlgorithm((int)this.algorithmId);
    }

    public final int getAlgorithmId() {
        return this.algorithmId;
    }

    public boolean getSigningCapable() {
        return this.signingCapable;
    }

    public boolean getEncryptionCapable() {
        return this.encryptionCapable;
    }

    public final boolean isSigningCapable() {
        return this.getSigningCapable();
    }

    public final boolean isEncryptionCapable() {
        return this.getEncryptionCapable();
    }

    public static PublicKeyAlgorithm[] values() {
        return (PublicKeyAlgorithm[])$VALUES.clone();
    }

    public static PublicKeyAlgorithm valueOf(String value) {
        return Enum.valueOf(PublicKeyAlgorithm.class, value);
    }

    @NotNull
    public static EnumEntries<PublicKeyAlgorithm> getEntries() {
        return $ENTRIES;
    }

    @JvmStatic
    @Nullable
    public static final PublicKeyAlgorithm fromId(int id) {
        return Companion.fromId(id);
    }

    @JvmStatic
    @NotNull
    public static final PublicKeyAlgorithm requireFromId(int id) {
        return Companion.requireFromId(id);
    }

    public /* synthetic */ PublicKeyAlgorithm(String $enum$name, int $enum$ordinal, int algorithmId, DefaultConstructorMarker $constructor_marker) {
        this(algorithmId);
    }

    static {
        RSA_GENERAL = new PublicKeyAlgorithm(1);
        RSA_ENCRYPT = new PublicKeyAlgorithm(2);
        RSA_SIGN = new PublicKeyAlgorithm(3);
        ELGAMAL_ENCRYPT = new PublicKeyAlgorithm(16);
        DSA = new PublicKeyAlgorithm(17);
        ECDH = new PublicKeyAlgorithm(18);
        ECDSA = new PublicKeyAlgorithm(19);
        ELGAMAL_GENERAL = new PublicKeyAlgorithm(20);
        DIFFIE_HELLMAN = new PublicKeyAlgorithm(21);
        EDDSA_LEGACY = new PublicKeyAlgorithm(22);
        X25519 = new PublicKeyAlgorithm(25);
        X448 = new PublicKeyAlgorithm(26);
        ED25519 = new PublicKeyAlgorithm(27);
        ED448 = new PublicKeyAlgorithm(28);
        AEAD = new AEAD("AEAD", 14);
        HMAC = new HMAC("HMAC", 15);
        $VALUES = publicKeyAlgorithmArray = new PublicKeyAlgorithm[]{PublicKeyAlgorithm.RSA_GENERAL, PublicKeyAlgorithm.RSA_ENCRYPT, PublicKeyAlgorithm.RSA_SIGN, PublicKeyAlgorithm.ELGAMAL_ENCRYPT, PublicKeyAlgorithm.DSA, PublicKeyAlgorithm.ECDH, PublicKeyAlgorithm.ECDSA, PublicKeyAlgorithm.ELGAMAL_GENERAL, PublicKeyAlgorithm.DIFFIE_HELLMAN, PublicKeyAlgorithm.EDDSA_LEGACY, PublicKeyAlgorithm.X25519, PublicKeyAlgorithm.X448, PublicKeyAlgorithm.ED25519, PublicKeyAlgorithm.ED448, PublicKeyAlgorithm.AEAD, PublicKeyAlgorithm.HMAC};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c6\u0001\u0018\u00002\u00020\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0005\u00a8\u0006\b"}, d2={"Lorg/pgpainless/algorithm/PublicKeyAlgorithm$AEAD;", "Lorg/pgpainless/algorithm/PublicKeyAlgorithm;", "encryptionCapable", "", "getEncryptionCapable", "()Z", "signingCapable", "getSigningCapable", "pgpainless-core"})
    static final class AEAD
    extends PublicKeyAlgorithm {
        private final boolean signingCapable;
        private final boolean encryptionCapable;

        /*
         * WARNING - void declaration
         */
        AEAD() {
            void var1_1;
            this.encryptionCapable = true;
        }

        @Override
        public boolean getSigningCapable() {
            return this.signingCapable;
        }

        @Override
        public boolean getEncryptionCapable() {
            return this.encryptionCapable;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\b"}, d2={"Lorg/pgpainless/algorithm/PublicKeyAlgorithm$Companion;", "", "()V", "fromId", "Lorg/pgpainless/algorithm/PublicKeyAlgorithm;", "id", "", "requireFromId", "pgpainless-core"})
    @SourceDebugExtension(value={"SMAP\nPublicKeyAlgorithm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PublicKeyAlgorithm.kt\norg/pgpainless/algorithm/PublicKeyAlgorithm$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,124:1\n1282#2,2:125\n*S KotlinDebug\n*F\n+ 1 PublicKeyAlgorithm.kt\norg/pgpainless/algorithm/PublicKeyAlgorithm$Companion\n*L\n114#1:125,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final PublicKeyAlgorithm fromId(int id) {
            PublicKeyAlgorithm publicKeyAlgorithm;
            block1: {
                PublicKeyAlgorithm[] $this$firstOrNull$iv = PublicKeyAlgorithm.values();
                boolean $i$f$firstOrNull = false;
                int n = $this$firstOrNull$iv.length;
                for (int i = 0; i < n; ++i) {
                    PublicKeyAlgorithm element$iv;
                    PublicKeyAlgorithm it = element$iv = $this$firstOrNull$iv[i];
                    boolean bl = false;
                    if (!(it.getAlgorithmId() == id)) continue;
                    publicKeyAlgorithm = element$iv;
                    break block1;
                }
                publicKeyAlgorithm = null;
            }
            return publicKeyAlgorithm;
        }

        @JvmStatic
        @NotNull
        public final PublicKeyAlgorithm requireFromId(int id) {
            PublicKeyAlgorithm publicKeyAlgorithm = this.fromId(id);
            if (publicKeyAlgorithm == null) {
                throw new NoSuchElementException("No PublicKeyAlgorithm found for id " + id);
            }
            return publicKeyAlgorithm;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c6\u0001\u0018\u00002\u00020\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0005\u00a8\u0006\b"}, d2={"Lorg/pgpainless/algorithm/PublicKeyAlgorithm$HMAC;", "Lorg/pgpainless/algorithm/PublicKeyAlgorithm;", "encryptionCapable", "", "getEncryptionCapable", "()Z", "signingCapable", "getSigningCapable", "pgpainless-core"})
    static final class HMAC
    extends PublicKeyAlgorithm {
        private final boolean signingCapable;
        private final boolean encryptionCapable;

        /*
         * WARNING - void declaration
         */
        HMAC() {
            void var1_1;
            this.signingCapable = true;
        }

        @Override
        public boolean getSigningCapable() {
            return this.signingCapable;
        }

        @Override
        public boolean getEncryptionCapable() {
            return this.encryptionCapable;
        }
    }
}

